/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.mixin.meteor;

import dev.stardust.config.StardustConfig;
import dev.stardust.mixin.accessor.DisconnectS2CPacketAccessor;
import dev.stardust.util.LogUtil;
import dev.stardust.util.StardustUtil;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Category;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.misc.AutoLog;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AutoLog.class}, remap=false)
public abstract class AutoLogMixin
extends Module {
    @Shadow
    @Final
    private SettingGroup sgGeneral;
    @Shadow
    @Final
    private Setting<Boolean> toggleOff;
    @Shadow
    @Final
    private Setting<Boolean> smartToggle;
    @Unique
    private boolean didLog = false;
    @Unique
    private long requestedDcAt = 0L;
    @Unique
    @Nullable
    private class_2561 disconnectReason = null;
    @Unique
    @Nullable
    private Setting<Boolean> forceKick = null;

    public AutoLogMixin(Category category, String name, String description) {
        super(category, name, description);
    }

    public void onDeactivate() {
        if (((Boolean)this.toggleOff.get()).booleanValue() || ((Boolean)this.smartToggle.get()).booleanValue() && this.didLog) {
            MeteorClient.EVENT_BUS.subscribe((Object)this);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="FIELD", target="Lmeteordevelopment/meteorclient/systems/modules/misc/AutoLog;entities:Lmeteordevelopment/meteorclient/settings/Setting;")})
    private void addIllegalDisconnectSetting(CallbackInfo ci) {
        this.forceKick = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("illegal-disconnect")).description("Tip: Change the illegal disconnect method in your Meteor config settings (Stardust category.)")).defaultValue((Object)false)).build());
    }

    @Inject(method={"onTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void mixinOnTick(CallbackInfo ci) {
        if (!Utils.canUpdate() || !this.isActive()) {
            ci.cancel();
        }
        if (this.didLog && System.currentTimeMillis() - this.requestedDcAt >= 1337L) {
            LogUtil.warn("Detected illegal disconnect failure, falling back on regular disconnect (try adjusting your illegal disconnect method config setting).");
            if (this.mc.method_1562() != null) {
                this.mc.method_1562().method_52781(new class_2661(this.disconnectReason));
            }
            this.disconnectReason = null;
            this.didLog = false;
            this.requestedDcAt = 0L;
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/text/Text;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void maybeIllegalDisconnect(class_2561 reason, CallbackInfo ci) {
        if (this.forceKick != null && ((Boolean)this.forceKick.get()).booleanValue()) {
            ci.cancel();
            this.didLog = true;
            this.requestedDcAt = System.currentTimeMillis();
            this.disconnectReason = class_2561.method_43470((String)("\u00a78[\u00a7a\u00a7oAutoLog\u00a78] \u00a7f" + reason.getString()));
            StardustUtil.illegalDisconnect(true, (StardustUtil.IllegalDisconnectMethod)((Object)StardustConfig.illegalDisconnectMethodSetting.get()));
        }
    }

    @Unique
    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        class_2596 class_25962;
        if (this.disconnectReason == null || !((class_25962 = event.packet) instanceof class_2661)) {
            return;
        }
        class_2661 packet = (class_2661)class_25962;
        if (this.didLog) {
            ((DisconnectS2CPacketAccessor)packet).setReason(this.disconnectReason);
            if (!this.isActive()) {
                MeteorClient.EVENT_BUS.unsubscribe((Object)this);
            }
            this.disconnectReason = null;
            this.didLog = false;
        }
    }
}

