/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.mixin.meteor;

import dev.stardust.util.MsgUtil;
import java.time.Duration;
import java.time.Instant;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.pathing.BaritoneUtils;
import meteordevelopment.meteorclient.pathing.PathManagers;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.Freecam;
import meteordevelopment.meteorclient.utils.misc.input.Input;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import net.minecraft.class_10;
import net.minecraft.class_2189;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5498;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Freecam.class}, remap=false)
public abstract class FreecamMixin {
    @Shadow
    @Final
    private SettingGroup sgGeneral;
    @Shadow
    private class_5498 perspective;
    @Shadow
    private double speedValue;
    @Shadow
    @Final
    public Vector3d prevPos;
    @Shadow
    @Final
    public Vector3d pos;
    @Shadow
    private boolean up;
    @Shadow
    private boolean down;
    @Unique
    private int timer = 0;
    @Unique
    private int clicks = 0;
    @Unique
    @Nullable
    private Instant clickedAt = null;
    @Unique
    @Nullable
    private Setting<Boolean> clickToCome = null;
    @Unique
    @Nullable
    private Setting<Boolean> useBaritoneChat = null;
    @Unique
    @Nullable
    private Setting<String> baritoneChatPrefix = null;
    @Unique
    @Nullable
    private Setting<Boolean> doubleClickToCome = null;
    @Unique
    @Nullable
    private Setting<Boolean> satelliteCameraMode = null;
    @Unique
    @Nullable
    private Setting<Double> orbitHeight = null;

    @Shadow
    protected abstract boolean checkGuiMove();

    @Inject(method={"<init>"}, at={@At(value="FIELD", target="Lmeteordevelopment/meteorclient/systems/modules/render/Freecam;rotate:Lmeteordevelopment/meteorclient/settings/Setting;")})
    private void addClickToComeSettings(CallbackInfo ci) {
        this.clickToCome = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("click-to-come")).description("Click on a block while in freecam to path there with Baritone.")).defaultValue((Object)false)).build());
        this.doubleClickToCome = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("double-click-only")).description("Require a double-click to Baritone path to your crosshair target.")).defaultValue((Object)false)).visible(() -> this.clickToCome != null && (Boolean)this.clickToCome.get() != false)).build());
        this.useBaritoneChat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("use-baritone-chat")).description("Use Baritone chat commands instead of the internal API. For compatibility with standalone Baritone versions.")).defaultValue((Object)false)).visible(() -> this.clickToCome != null && (Boolean)this.clickToCome.get() != false)).build());
        this.baritoneChatPrefix = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("baritone-command-prefix")).description("What prefix to use for Baritone chat commands.")).defaultValue((Object)"#")).visible(() -> this.clickToCome != null && (Boolean)this.clickToCome.get() != false && this.useBaritoneChat != null && (Boolean)this.useBaritoneChat.get() != false)).build());
        this.satelliteCameraMode = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("satellite-camera")).description("Lock Freecam to the player's position sans the y-value, which you'll set yourself.")).defaultValue((Object)false)).build());
        this.orbitHeight = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("orbit-height")).description("Height for the satellite camera to orbit at.")).defaultValue(169.0).min(-69.0).sliderMax(420.0).build());
    }

    @Inject(method={"onTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleClickToCome(CallbackInfo ci) {
        if (MeteorClient.mc.field_1724 == null || MeteorClient.mc.field_1687 == null) {
            return;
        }
        if (MeteorClient.mc.field_1755 == null && (this.doubleClickToCome != null && !((Boolean)this.doubleClickToCome.get()).booleanValue() && this.clicks >= 1 || this.clicks >= 2)) {
            class_2338 crosshairPos;
            this.clicks = 0;
            class_2350 side = null;
            if (MeteorClient.mc.field_1765 instanceof class_3966) {
                crosshairPos = ((class_3966)MeteorClient.mc.field_1765).method_17782().method_24515();
            } else {
                class_3965 result = (class_3965)MeteorClient.mc.field_1765;
                if (MeteorClient.mc.field_1687.method_8320(result.method_17777()).method_26204() instanceof class_2189) {
                    float yaw;
                    float pitch;
                    class_243 direction;
                    class_243 cameraPos = MeteorClient.mc.field_1773.method_19418().method_19326();
                    class_3959 context = new class_3959(cameraPos, cameraPos.method_1019((direction = this.getRotationVector(pitch = MeteorClient.mc.field_1773.method_19418().method_19329(), yaw = MeteorClient.mc.field_1773.method_19418().method_19330())).method_1021(256.0)), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, MeteorClient.mc.method_1560());
                    class_3965 rayCast = MeteorClient.mc.field_1687.method_17742(context);
                    if (rayCast != null && !(MeteorClient.mc.field_1687.method_8320(rayCast.method_17777()).method_26204() instanceof class_2189)) {
                        crosshairPos = rayCast.method_17777();
                        side = rayCast.method_17780();
                    } else {
                        crosshairPos = result.method_17777();
                        side = result.method_17780();
                    }
                } else {
                    crosshairPos = result.method_17777();
                    side = result.method_17780();
                }
            }
            if (side != null) {
                if (side == class_2350.field_11033) {
                    crosshairPos = crosshairPos.method_10079(side, 2);
                } else if (side == class_2350.field_11036) {
                    crosshairPos = crosshairPos.method_10093(side);
                } else if (MeteorClient.mc.field_1687.method_8320((crosshairPos = crosshairPos.method_10093(side)).method_10093(class_2350.field_11033)).method_26171(class_10.field_50)) {
                    crosshairPos = crosshairPos.method_10093(class_2350.field_11033);
                }
            }
            if (this.useBaritoneChat != null && ((Boolean)this.useBaritoneChat.get()).booleanValue() && this.baritoneChatPrefix != null && !((String)this.baritoneChatPrefix.get()).isBlank()) {
                MeteorClient.mc.method_1562().method_45729((String)this.baritoneChatPrefix.get() + "goto " + crosshairPos.method_10263() + " " + crosshairPos.method_10264() + " " + crosshairPos.method_10260());
            } else if (BaritoneUtils.IS_AVAILABLE) {
                PathManagers.get().stop();
                PathManagers.get().moveTo(crosshairPos);
                if (((Freecam)Modules.get().get(Freecam.class)).chatFeedback) {
                    MsgUtil.sendModuleMsg("Baritone pathing to destination\u00a7a..!", "freecam");
                }
            } else {
                MsgUtil.sendMsg("Baritone was not found to be installed. If this is a mistake, please enable the \"Use Baritone Chat\" setting and try again.");
            }
        }
        if (MeteorClient.mc.field_1755 == null && this.clicks > 0) {
            ++this.timer;
            if (this.timer >= 10) {
                this.timer = 0;
                this.clicks = 0;
                this.clickedAt = null;
            }
        }
        if (this.satelliteCameraMode == null || !((Boolean)this.satelliteCameraMode.get()).booleanValue()) {
            return;
        }
        if (MeteorClient.mc.field_1719 == null || MeteorClient.mc.method_1560() == null) {
            return;
        }
        ci.cancel();
        if (MeteorClient.mc.field_1719.method_5757()) {
            MeteorClient.mc.method_1560().field_5960 = true;
        }
        if (!this.perspective.method_31034()) {
            MeteorClient.mc.field_1690.method_31043(class_5498.field_26664);
        }
        double s = 0.5;
        double velY = 0.0;
        if (MeteorClient.mc.field_1690.field_1867.method_1434()) {
            s = 1.0;
        }
        if (this.up) {
            velY += s * this.speedValue;
        }
        if (this.down) {
            velY -= s * this.speedValue;
        }
        class_243 orbitPos = this.getOrbitPos(velY);
        this.prevPos.set((Vector3dc)this.pos);
        this.pos.set(orbitPos.field_1352, orbitPos.field_1351, orbitPos.field_1350);
    }

    @Inject(method={"onKey"}, at={@At(value="HEAD")}, cancellable=true)
    private void hijackOnKey(KeyEvent event, CallbackInfo ci) {
        if (Input.isKeyPressed((int)292)) {
            return;
        }
        if (this.checkGuiMove()) {
            return;
        }
        if (this.satelliteCameraMode == null || !((Boolean)this.satelliteCameraMode.get()).booleanValue()) {
            return;
        }
        ci.cancel();
        boolean cancel = true;
        if (MeteorClient.mc.field_1690.field_1903.method_1417(event.key, 0)) {
            this.up = event.action != KeyAction.Release;
            MeteorClient.mc.field_1690.field_1903.method_23481(false);
        } else if (MeteorClient.mc.field_1690.field_1832.method_1417(event.key, 0)) {
            this.down = event.action != KeyAction.Release;
            MeteorClient.mc.field_1690.field_1832.method_23481(false);
        } else {
            cancel = false;
        }
        if (cancel) {
            event.cancel();
        }
    }

    @Inject(method={"onMouseButton"}, at={@At(value="TAIL")})
    private void handleMouseClicks(MouseButtonEvent event, CallbackInfo ci) {
        if (MeteorClient.mc.field_1755 != null) {
            return;
        }
        if (this.clickToCome == null || !((Boolean)this.clickToCome.get()).booleanValue()) {
            return;
        }
        if (MeteorClient.mc.field_1690.field_1886.method_1433(event.button)) {
            Instant now = Instant.now();
            if (this.clickedAt == null || Duration.between(this.clickedAt, now).toMillis() > 100L) {
                ++this.clicks;
                this.clickedAt = now;
            }
        }
    }

    @Inject(method={"onDeactivate"}, at={@At(value="TAIL")})
    private void resetCounters(CallbackInfo ci) {
        this.timer = 0;
        this.clicks = 0;
        this.clickedAt = null;
    }

    @Unique
    private class_243 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    @Unique
    private class_243 getOrbitPos(double velY) {
        if (this.orbitHeight != null) {
            this.orbitHeight.set((Object)((Double)this.orbitHeight.get() + velY));
        }
        if (MeteorClient.mc.field_1724 == null || this.orbitHeight == null) {
            return new class_243(0.0, this.orbitHeight == null ? velY : (Double)this.orbitHeight.get(), 0.0);
        }
        return new class_243(MeteorClient.mc.field_1724.method_23317(), ((Double)this.orbitHeight.get()).doubleValue(), MeteorClient.mc.field_1724.method_23321());
    }
}

