/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.mixin.meteor;

import java.util.Arrays;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.screens.ModuleScreen;
import meteordevelopment.meteorclient.gui.utils.Cell;
import meteordevelopment.meteorclient.gui.widgets.WKeybind;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WSection;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WCheckbox;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.prompts.OkPrompt;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModuleScreen.class}, remap=false)
public abstract class ModuleScreenMixin
extends WindowScreen {
    @Shadow
    @Final
    private Module module;
    @Shadow
    private WCheckbox active;
    @Shadow
    private WKeybind keybind;
    @Shadow
    private WContainer settingsContainer;
    @Unique
    private final String[] mods = new String[]{"auto-mend", "auto-log", "better-tooltips", "exp-thrower", "freecam", "nametags", "no-render", "notifier", "packet-canceller"};

    public ModuleScreenMixin(GuiTheme theme, WWidget icon, String title) {
        super(theme, icon, title);
    }

    @Inject(method={"initWidgets"}, at={@At(value="HEAD")}, cancellable=true)
    private void maybeHijackInitWidgets(CallbackInfo ci) {
        if (this.module.addon != null && this.module.addon != MeteorClient.ADDON) {
            return;
        }
        if (Arrays.stream(this.mods).anyMatch(mod -> this.module.name.equalsIgnoreCase((String)mod))) {
            WWidget widget;
            ci.cancel();
            this.add((WWidget)this.theme.label(this.module.description, (double)Utils.getWindowWidth() / 2.0));
            WHorizontalList addon = (WHorizontalList)this.add((WWidget)this.theme.horizontalList()).expandX().widget();
            addon.add((WWidget)this.theme.label("Modified by: ").color(this.theme.textSecondaryColor())).widget();
            addon.add((WWidget)this.theme.label("Stardust").color(new Color(147, 233, 190))).widget();
            if (!this.module.settings.groups.isEmpty()) {
                this.settingsContainer = (WContainer)this.add((WWidget)this.theme.verticalList()).expandX().widget();
                this.settingsContainer.add(this.theme.settings(this.module.settings)).expandX();
            }
            if ((widget = this.module.getWidget(this.theme)) != null) {
                this.add((WWidget)this.theme.horizontalSeparator()).expandX();
                Cell cell = this.add(widget);
                if (widget instanceof WContainer) {
                    cell.expandX();
                }
            }
            WSection section = (WSection)this.add((WWidget)this.theme.section("Bind", true)).expandX().widget();
            WHorizontalList bind = (WHorizontalList)section.add((WWidget)this.theme.horizontalList()).expandX().widget();
            bind.add((WWidget)this.theme.label("Bind: "));
            this.keybind = (WKeybind)bind.add((WWidget)this.theme.keybind(this.module.keybind)).expandX().widget();
            this.keybind.actionOnSet = () -> Modules.get().setModuleToBind(this.module);
            WButton reset = (WButton)bind.add((WWidget)this.theme.button(GuiRenderer.RESET)).expandCellX().right().widget();
            reset.action = () -> ((WKeybind)this.keybind).resetBind();
            WHorizontalList tobr = (WHorizontalList)section.add((WWidget)this.theme.horizontalList()).widget();
            tobr.add((WWidget)this.theme.label("Toggle on bind release: "));
            WCheckbox tobrC = (WCheckbox)tobr.add((WWidget)this.theme.checkbox(this.module.toggleOnBindRelease)).widget();
            tobrC.action = () -> {
                this.module.toggleOnBindRelease = tobrC.checked;
            };
            WHorizontalList cf = (WHorizontalList)section.add((WWidget)this.theme.horizontalList()).widget();
            cf.add((WWidget)this.theme.label("Chat Feedback: "));
            WCheckbox cfC = (WCheckbox)cf.add((WWidget)this.theme.checkbox(this.module.chatFeedback)).widget();
            cfC.action = () -> {
                this.module.chatFeedback = cfC.checked;
            };
            this.add((WWidget)this.theme.horizontalSeparator()).expandX();
            WHorizontalList bottom = (WHorizontalList)this.add((WWidget)this.theme.horizontalList()).expandX().widget();
            bottom.add((WWidget)this.theme.label("Active: "));
            this.active = (WCheckbox)bottom.add((WWidget)this.theme.checkbox(this.module.isActive())).expandCellX().widget();
            this.active.action = () -> {
                if (this.module.isActive() != this.active.checked) {
                    this.module.toggle();
                }
            };
            WHorizontalList sharing = (WHorizontalList)bottom.add((WWidget)this.theme.horizontalList()).right().widget();
            WButton copy = (WButton)sharing.add((WWidget)this.theme.button(GuiRenderer.COPY)).widget();
            copy.action = () -> {
                if (this.toClipboard()) {
                    ((OkPrompt)((OkPrompt)((OkPrompt)((OkPrompt)((OkPrompt)OkPrompt.create().title("Module copied!")).message("The settings for this module are now in your clipboard.")).message("You can also copy settings using Ctrl+C.")).message("Settings can be imported using Ctrl+V or the paste button.")).id("config-sharing-guide")).show();
                }
            };
            copy.tooltip = "Copy config";
            WButton paste = (WButton)sharing.add((WWidget)this.theme.button(GuiRenderer.PASTE)).widget();
            paste.action = () -> ((ModuleScreenMixin)this).fromClipboard();
            paste.tooltip = "Paste config";
        }
    }
}

