/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.mixin.meteor;

import dev.stardust.mixin.meteor.accessor.CategoryAccessor;
import dev.stardust.util.StardustUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.screens.ModulesScreen;
import meteordevelopment.meteorclient.gui.tabs.Tab;
import meteordevelopment.meteorclient.gui.tabs.TabScreen;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WWindow;
import meteordevelopment.meteorclient.systems.modules.Category;
import meteordevelopment.meteorclient.systems.modules.Module;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModulesScreen.class}, remap=false)
public abstract class ModulesScreenMixin
extends TabScreen {
    @Unique
    @Nullable
    private Instant createdAt = null;

    public ModulesScreenMixin(GuiTheme theme, Tab tab) {
        super(theme, tab);
    }

    @Inject(method={"createCategory"}, at={@At(value="HEAD")})
    private void cycleCategoryIcons(WContainer c, Category category, List<Module> moduleList, CallbackInfoReturnable<WWindow> cir) {
        if (category.name.equals("Stardust")) {
            if (!this.theme.categoryIcons()) {
                ((CategoryAccessor)category).setIcon(StardustUtil.chooseMenuIcon());
            } else if (this.createdAt == null) {
                this.createdAt = Instant.now();
            } else {
                Instant now = Instant.now();
                if (Duration.between(this.createdAt, now).toSeconds() > 1800L) {
                    this.createdAt = now;
                    ((CategoryAccessor)category).setIcon(StardustUtil.chooseMenuIcon());
                }
            }
        }
    }
}

