/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import com.mojang.authlib.GameProfile;
import dev.stardust.Stardust;
import dev.stardust.mixin.accessor.EntityTrackerUpdateS2CPacketAccessor;
import dev.stardust.mixin.accessor.GameProfileAccessor;
import dev.stardust.mixin.accessor.PlayerListS2CPacketAccessor;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_2739;
import net.minecraft.class_2945;
import net.minecraft.class_8242;

public class AntiToS
extends Module {
    private final String BLACKLIST_FILE = "meteor-client/anti-tos.txt";
    private final SettingGroup sgSources = this.settings.createGroup("Source Settings");
    private final SettingGroup sgBlacklist = this.settings.createGroup("Content Settings");
    public final Setting<ChatMode> chatMode = this.sgSources.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("chat-mode")).description("Censor or completely replace text in chat that matches the filter.")).defaultValue((Object)ChatMode.Censor)).build());
    public final Setting<SignMode> signMode = this.sgSources.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sign-mode")).description("Censor or completely replace SignText that matches the filter.")).defaultValue((Object)SignMode.Censor)).build());
    private final Setting<String> familyFriendlyLine1 = this.sgSources.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("replacement-line-1")).defaultValue((Object)"Original text")).visible(() -> this.signMode.get() == SignMode.Replace)).build());
    private final Setting<String> familyFriendlyLine2 = this.sgSources.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("replacement-line-2")).defaultValue((Object)"was replaced by")).visible(() -> this.signMode.get() == SignMode.Replace)).build());
    private final Setting<String> familyFriendlyLine3 = this.sgSources.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("replacement-line-3")).defaultValue((Object)"Stardust AntiToS")).visible(() -> this.signMode.get() == SignMode.Replace)).build());
    private final Setting<String> familyFriendlyLine4 = this.sgSources.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("replacement-line-4")).defaultValue((Object)"plz no ban \u263a")).visible(() -> this.signMode.get() == SignMode.Replace)).build());
    private final Setting<class_1767> familyFriendlyColor = this.sgSources.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("replacement-color")).description("Render replacement SignText with the selected dye color.")).defaultValue((Object)class_1767.field_7964)).visible(() -> this.signMode.get() == SignMode.Replace)).build());
    private final Setting<Boolean> familyFriendlyGlowing = this.sgSources.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("replacement-glowing")).description("Render replacement SignText with glowing text.")).defaultValue((Object)true)).visible(() -> this.signMode.get() == SignMode.Replace)).build());
    private final Setting<Boolean> openBlacklistFile = this.sgBlacklist.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("open-blacklist-file")).description("Open the anti-tos.txt file.")).defaultValue((Object)false)).onChanged(it -> {
        if (it.booleanValue()) {
            if (StardustUtil.checkOrCreateFile(this.mc, "meteor-client/anti-tos.txt")) {
                StardustUtil.openFile("meteor-client/anti-tos.txt");
            }
            this.resetBlacklistFileSetting();
        }
    })).build());
    private final HashSet<String> blacklisted = new HashSet();

    public AntiToS() {
        super(Stardust.CATEGORY, "AntiToS", "Censor player-generated text sources according to a content blacklist.");
    }

    private void resetBlacklistFileSetting() {
        this.openBlacklistFile.set((Object)false);
    }

    private void initBlacklistText() {
        File blackListFile = FabricLoader.getInstance().getGameDir().resolve("meteor-client/anti-tos.txt").toFile();
        try (Stream<String> lineStream = Files.lines(blackListFile.toPath());){
            this.blacklisted.addAll(lineStream.toList());
            if (this.blacklisted.isEmpty()) {
                MsgUtil.sendMsg("meteor-client/anti-tos.txt \u00a74 was empty\u00a78..!");
                MsgUtil.sendMsg("Please write one blacklisted item for each line of the file.");
                MsgUtil.sendMsg("Spaces and other punctuation will be treated literally.");
                MsgUtil.sendMsg("You must toggle this setting or the AntiToS module after updating the file's contents.");
            }
        }
        catch (Exception err) {
            LogUtil.error("Failed to read from " + blackListFile.getAbsolutePath() + "! - Why:\n" + String.valueOf(err), this.name);
        }
    }

    public boolean containsBlacklistedText(String text) {
        return this.blacklisted.stream().anyMatch(line -> text.trim().toLowerCase().contains(line.trim().toLowerCase()));
    }

    public String censorText(String text) {
        for (String filter : this.blacklisted) {
            text = text.replaceAll("(?i)" + Pattern.quote(filter), "*".repeat(filter.length()));
        }
        return text;
    }

    public class_8242 familyFriendlySignText(class_8242 original) {
        if (this.signMode.get() == SignMode.Censor) {
            class_2561[] lines = new class_2561[]{class_2561.method_30163((String)this.censorText(original.method_49859(0, false).getString())), class_2561.method_30163((String)this.censorText(original.method_49859(1, false).getString())), class_2561.method_30163((String)this.censorText(original.method_49859(2, false).getString())), class_2561.method_30163((String)this.censorText(original.method_49859(3, false).getString()))};
            return new class_8242(lines, lines, original.method_49872(), original.method_49856());
        }
        class_2561[] lines = new class_2561[]{class_2561.method_30163((String)((String)this.familyFriendlyLine1.get())), class_2561.method_30163((String)((String)this.familyFriendlyLine2.get())), class_2561.method_30163((String)((String)this.familyFriendlyLine3.get())), class_2561.method_30163((String)((String)this.familyFriendlyLine4.get()))};
        return new class_8242(lines, lines, (class_1767)this.familyFriendlyColor.get(), ((Boolean)this.familyFriendlyGlowing.get()).booleanValue());
    }

    public void onActivate() {
        if (StardustUtil.checkOrCreateFile(this.mc, "meteor-client/anti-tos.txt")) {
            this.initBlacklistText();
        } else {
            this.toggle();
            MsgUtil.sendModuleMsg("\u00a74\u00a7lFailed to create anti-tos.txt in your meteor-client folder\u00a78..!", this.name);
            MsgUtil.sendModuleMsg("\u00a74\u00a7lThis issue is fatal\u00a78. \u00a74\u00a7lPlease check latest.log for more info\u00a78\u00a7l.", this.name);
        }
    }

    public void onDeactivate() {
        this.blacklisted.clear();
    }

    @EventHandler(priority=200)
    private void onReceivePacket(PacketEvent.Receive event) {
        if (!Utils.canUpdate()) {
            return;
        }
        Object object = event.packet;
        if (object instanceof class_2739) {
            class_2739 packet = (class_2739)object;
            boolean modified = false;
            ArrayList entries = new ArrayList();
            for (class_2945.class_7834 entry : packet.comp_1128()) {
                if (entry.comp_1115() == 2) {
                    class_2945.class_2946 e = new class_2945.class_2946(entry.comp_1116().method_12717(entry.comp_1115()), (Object)((Optional)entry.comp_1117()));
                    if (((Optional)e.method_12794()).isPresent()) {
                        class_2561 data = (class_2561)((Optional)e.method_12794()).get();
                        if (this.containsBlacklistedText(data.getString())) {
                            e.method_12799(Optional.of(class_2561.method_43470((String)this.censorText(data.getString())).method_10862(data.method_10866())));
                            modified = true;
                            entries.add(e.method_46359());
                            continue;
                        }
                        entries.add(entry);
                        continue;
                    }
                    entries.add(entry);
                    continue;
                }
                entries.add(entry);
            }
            if (modified) {
                ((EntityTrackerUpdateS2CPacketAccessor)packet).setTrackedValues(entries);
            }
        } else {
            object = event.packet;
            if (object instanceof class_2703) {
                class_2703 packet = (class_2703)object;
                for (class_2703.class_2705 entry : packet.method_46329()) {
                    GameProfile profile;
                    if (entry.comp_1107() == null || !this.containsBlacklistedText((profile = entry.comp_1107()).getName())) continue;
                    ((GameProfileAccessor)profile).setName(this.censorText(profile.getName()));
                    ((PlayerListS2CPacketAccessor)entry).setProfile(profile);
                }
            }
        }
    }

    public static enum ChatMode {
        Censor,
        Remove;

    }

    public static enum SignMode {
        Censor,
        Replace,
        NoRender;

    }
}

