/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MapUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.RenderUtil;
import dev.stardust.util.StardustUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.events.entity.player.StartBreakingBlockEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.GenericSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.render.blockesp.ESPBlockData;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_8174;
import org.jetbrains.annotations.Nullable;

public class Archaeology
extends Module {
    private static final ReferenceSet<class_1792> ARCHAEOLOGY_LOOT_TABLE = ReferenceSet.of((Object[])new class_1792[]{class_1802.field_43217, class_1802.field_43218, class_1802.field_43201, class_1802.field_43202, class_1802.field_43203, class_1802.field_43204, class_1802.field_43205, class_1802.field_43207, class_1802.field_43206, class_1802.field_43208, class_1802.field_43209, class_1802.field_43210, class_1802.field_43211, class_1802.field_43212, class_1802.field_43213, class_1802.field_43214, class_1802.field_43215, class_1802.field_43216, class_1802.field_43219, class_1802.field_43220, class_1802.field_43193, class_1802.field_44705, class_1802.field_43199, class_1802.field_43196, class_1802.field_43197, class_1802.field_43200, class_1802.field_8687, class_1802.field_8713, class_1802.field_8626, class_1802.field_8861, class_1802.field_8621, class_1802.field_8600, class_1802.field_8766, class_1802.field_8477, class_1802.field_8054, class_1802.field_8167, class_1802.field_8475, class_1802.field_8397, class_1802.field_8345, class_1802.field_8446, class_1802.field_8192, class_1802.field_8689, class_1802.field_8074, class_1802.field_8719, class_1802.field_8317, class_1802.field_8276, class_1802.field_40230, class_1802.field_19060, class_1802.field_8273, class_1802.field_8492, class_1802.field_27059, class_1802.field_27060, class_1802.field_27061, class_1802.field_27057, class_1802.field_8309, class_1802.field_8747, class_1802.field_8196, class_1802.field_8119, class_1802.field_8703, class_1802.field_40229, class_1802.field_8500, class_1802.field_8739, class_1802.field_8879});
    private final SettingGroup sgDig;
    private final SettingGroup sgSurvey;
    private final Setting<List<class_1792>> targetItems;
    private final Setting<Boolean> breakBad;
    private final Setting<Boolean> chat;
    private final Setting<Boolean> preventBreak;
    private final Setting<Boolean> chatNotify;
    private final Setting<Boolean> chatCoords;
    private final Setting<SuspiciousBlocks> chatFor;
    private final Setting<Boolean> waypoints;
    private final Setting<Boolean> tempWaypoints;
    private final Setting<SuspiciousBlocks> waypointsFor;
    private final Setting<Boolean> soundPing;
    private final Setting<SuspiciousBlocks> soundFor;
    private final Setting<Double> pingVolume;
    private final Setting<Boolean> render;
    private final Setting<ESPBlockData> sandESP;
    private final Setting<ESPBlockData> gravelESP;
    private int timer;
    private long lastPing;
    private int ticksBrushing;
    private long lastNotified;
    @Nullable
    private class_2338 lastFoundPos;
    private final List<Long> toIgnore;
    private final Set<class_2338> goodBlocks;
    private final class_2338.class_2339 testPos;
    private final class_2338.class_2339 testPos2;
    private final Set<class_2338> safeBlocksToBreak;
    private final Set<class_2338> safeBlocksToBrush;
    private final Set<class_2338> preventingBreakageBlocks;
    private final List<class_2338> suspiciousSandBlocks;
    private final List<class_2338> suspiciousGravelBlocks;

    public Archaeology() {
        super(Stardust.CATEGORY, "Archaeology", "Tools to assist in your archaeological endeavors.");
        this.sgDig = this.settings.createGroup("Dig Settings");
        this.sgSurvey = this.settings.createGroup("Survey Settings");
        this.targetItems = this.sgDig.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("target-items")).description("Which items to follow through with brushing. All others will be ignored or broken.")).defaultValue(List.of(class_1802.field_43217, class_1802.field_43218, class_1802.field_43201, class_1802.field_43202, class_1802.field_43203, class_1802.field_43204, class_1802.field_43205, class_1802.field_43207, class_1802.field_43206, class_1802.field_43208, class_1802.field_43209, class_1802.field_43210, class_1802.field_43211, class_1802.field_43212, class_1802.field_43213, class_1802.field_43214, class_1802.field_43215, class_1802.field_43216, class_1802.field_43219, class_1802.field_43220, class_1802.field_43217, class_1802.field_43193, class_1802.field_44705, class_1802.field_43199, class_1802.field_43196, class_1802.field_43197, class_1802.field_43200))).filter(this::isLootItem).build());
        this.breakBad = this.sgDig.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("break-bad")).description("Break suspicious blocks which don't contain target items.")).defaultValue((Object)true)).build());
        this.chat = this.sgDig.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("break-notify")).description("Notifies you about the contents of bad suspicious blocks when breaking them.")).defaultValue((Object)true)).visible(() -> this.breakBad.get())).build());
        this.preventBreak = this.sgDig.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("prevent-accidental-breakage")).description("Attempts to prevent you from accidentally breaking suspicious sand or gravel blocks.")).defaultValue((Object)true)).build());
        this.chatNotify = this.sgSurvey.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-notify")).description("Notifies you in chat when a cluster of suspicious blocks is found.")).defaultValue((Object)false)).build());
        this.chatCoords = this.sgSurvey.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-coordinates")).description("Whether to add coordinates to the chat notification messages.")).visible(() -> this.chatNotify.get())).defaultValue((Object)false)).build());
        this.chatFor = this.sgSurvey.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("chats-for")).description("Whether to send chat notifications for suspicious sand, gravel, or both.")).defaultValue((Object)SuspiciousBlocks.Both)).visible(() -> this.chatNotify.get())).build());
        this.waypoints = this.sgSurvey.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("add-waypoints")).description("Adds waypoints to your Xaeros map on clusters of suspicious blocks.")).defaultValue((Object)false)).visible(() -> StardustUtil.XAERO_AVAILABLE)).build());
        this.tempWaypoints = this.sgSurvey.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("temporary-waypoints")).description("Temporary waypoints are removed when you disconnect from the server or close the game.")).defaultValue((Object)true)).visible(() -> StardustUtil.XAERO_AVAILABLE && (Boolean)this.waypoints.get() != false)).build());
        this.waypointsFor = this.sgSurvey.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("waypoints-for")).description("Whether to add waypoints for suspicious sand, gravel, or both.")).defaultValue((Object)SuspiciousBlocks.Both)).visible(() -> StardustUtil.XAERO_AVAILABLE && (Boolean)this.waypoints.get() != false)).build());
        this.soundPing = this.sgSurvey.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sound-notification")).description("Play an audible notification when discovering an archaeological dig site.")).defaultValue((Object)false)).build());
        this.soundFor = this.sgSurvey.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("ping-for")).description("Whether to play sound notifications for suspicious sand, gravel, or both.")).defaultValue((Object)SuspiciousBlocks.Both)).visible(() -> this.soundPing.get())).build());
        this.pingVolume = this.sgSurvey.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("notification-volume")).description("Volume for the sound notification.")).range(0.0, 400.0).sliderRange(0.0, 100.0).defaultValue(50.0).visible(() -> this.soundPing.get())).build());
        this.render = this.sgSurvey.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-suspicious-blocks")).description("Whether to render suspicious blocks.")).defaultValue((Object)true)).build());
        this.sandESP = this.sgSurvey.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("suspicious-sand-ESP")).description("Render settings for suspicious sand blocks.")).visible(() -> this.render.get())).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(169, 169, 13, 255), new SettingColor(169, 169, 13, 7), true, new SettingColor(169, 169, 13, 137)))).build());
        this.gravelESP = this.sgSurvey.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("suspicious-gravel-ESP")).description("Render settings for suspicious gravel blocks.")).visible(() -> this.render.get())).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(69, 69, 69, 255), new SettingColor(69, 69, 69, 25), true, new SettingColor(69, 69, 69, 137)))).build());
        this.timer = 0;
        this.lastPing = 0L;
        this.ticksBrushing = 0;
        this.lastNotified = 0L;
        this.lastFoundPos = null;
        this.toIgnore = new LongArrayList();
        this.goodBlocks = new HashSet<class_2338>();
        this.testPos = new class_2338.class_2339();
        this.testPos2 = new class_2338.class_2339();
        this.safeBlocksToBreak = new HashSet<class_2338>();
        this.safeBlocksToBrush = new HashSet<class_2338>();
        this.preventingBreakageBlocks = new HashSet<class_2338>();
        this.suspiciousSandBlocks = new ObjectArrayList();
        this.suspiciousGravelBlocks = new ObjectArrayList();
    }

    private boolean isOutOfRange(class_2338 pos1, class_2338 pos2, int range) {
        if (pos1 == null || pos2 == null) {
            return true;
        }
        this.testPos2.method_10103(pos2.method_10263(), pos1.method_10264(), pos2.method_10260());
        return !pos1.method_19771((class_2382)this.testPos2, (double)range);
    }

    private boolean isSafeToBrush(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return false;
        }
        if (this.safeBlocksToBrush.contains(pos)) {
            return true;
        }
        if (this.mc.field_1687.method_8320(pos.method_10074()).method_26215() || this.mc.field_1687.method_8320(pos.method_10074()).method_45474()) {
            this.preventingBreakageBlocks.add(pos.method_10074());
            MsgUtil.updateModuleMsg("It is not yet safe to brush this suspicious block, because it is \u00a7cfloating..! \u00a78[\u00a7aTry placing a solid block underneath it\u00a78]", this.name, "directBrushPrevent".hashCode());
            return false;
        }
        class_2338.class_2339 pos2 = new class_2338.class_2339();
        for (class_2350 dir : class_2350.values()) {
            pos2.method_10101((class_2382)pos.method_10093(dir));
            if (this.toIgnore.contains(pos2.method_10063()) || !this.mc.field_1687.method_8320((class_2338)pos2).method_27852(class_2246.field_42728) && !this.mc.field_1687.method_8320((class_2338)pos2).method_27852(class_2246.field_43227) || !this.mc.field_1687.method_8320(pos2.method_10074()).method_26215() && !this.mc.field_1687.method_8320(pos2.method_10074()).method_45474()) continue;
            this.preventingBreakageBlocks.add((class_2338)pos2);
            MsgUtil.updateModuleMsg("It is not yet safe to brush this suspicious block, as doing so will update an adjacent floating one\u00a7e..!", this.name, "preventBreakageBrush".hashCode());
            return false;
        }
        this.safeBlocksToBrush.add(pos);
        return true;
    }

    private boolean isSafeToBreak(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return false;
        }
        if (this.safeBlocksToBreak.contains(pos)) {
            return true;
        }
        if (!this.toIgnore.contains(pos.method_10063()) && (this.mc.field_1687.method_8320(pos).method_27852(class_2246.field_42728) || this.mc.field_1687.method_8320(pos).method_27852(class_2246.field_43227))) {
            return false;
        }
        class_2338.class_2339 checkPos = new class_2338.class_2339();
        for (class_2350 dir : class_2350.values()) {
            checkPos.method_10101((class_2382)pos.method_10093(dir));
            if ((this.toIgnore.contains(checkPos.method_10063()) || !this.mc.field_1687.method_8320((class_2338)checkPos).method_27852(class_2246.field_42728)) && !this.mc.field_1687.method_8320((class_2338)checkPos).method_27852(class_2246.field_43227) || !this.mc.field_1687.method_8320(checkPos.method_10074()).method_26215() && !this.mc.field_1687.method_8320(checkPos.method_10074()).method_45474()) continue;
            this.preventingBreakageBlocks.add(new class_2338((class_2382)checkPos));
            MsgUtil.updateModuleMsg("\u00a7aPreventing accidental breakage from indirect block update for floating suspicious block\u00a7c..!", this.name, "indirectBreakPrevent".hashCode());
            return false;
        }
        checkPos.method_10101((class_2382)pos.method_10084());
        while (checkPos.method_10264() < this.mc.field_1687.method_31605()) {
            class_2680 checkState = this.mc.field_1687.method_8320((class_2338)checkPos);
            if (!this.toIgnore.contains(checkPos.method_10063()) && (checkState.method_27852(class_2246.field_43227) || checkState.method_27852(class_2246.field_42728))) {
                this.preventingBreakageBlocks.add(new class_2338((class_2382)checkPos));
                return false;
            }
            if (!(checkState.method_26204() instanceof class_2346)) break;
            for (class_2350 dir : class_2350.values()) {
                if (dir.equals((Object)class_2350.field_11036) || dir.equals((Object)class_2350.field_11033)) continue;
                class_2338.class_2339 indirectPos = new class_2338.class_2339();
                indirectPos.method_10101((class_2382)checkPos.method_10093(dir));
                if (this.toIgnore.contains(indirectPos.method_10063()) || !this.mc.field_1687.method_8320((class_2338)indirectPos).method_27852(class_2246.field_43227) && !this.mc.field_1687.method_8320((class_2338)indirectPos).method_27852(class_2246.field_42728) || !this.mc.field_1687.method_8320(indirectPos.method_10074()).method_26215() && !this.mc.field_1687.method_8320(indirectPos.method_10074()).method_45474()) continue;
                this.preventingBreakageBlocks.add(new class_2338((class_2382)indirectPos));
                MsgUtil.updateModuleMsg("\u00a7ePreventing accidental breakage from indirect block update for floating suspicious block\u00a7c..!", this.name, "indirectBreakPrevent".hashCode());
                return false;
            }
            checkPos.method_10101((class_2382)checkPos.method_10084());
        }
        this.safeBlocksToBreak.add(pos);
        return true;
    }

    public void onDeactivate() {
        this.timer = 0;
        this.lastPing = 0L;
        this.toIgnore.clear();
        this.ticksBrushing = 0;
        this.goodBlocks.clear();
        this.lastFoundPos = null;
        this.safeBlocksToBreak.clear();
        this.suspiciousSandBlocks.clear();
        this.suspiciousGravelBlocks.clear();
        this.preventingBreakageBlocks.clear();
    }

    @EventHandler(priority=200)
    private void onStartBlockBreak(StartBreakingBlockEvent event) {
        if (!Utils.canUpdate() || !((Boolean)this.preventBreak.get()).booleanValue()) {
            return;
        }
        if (!this.isSafeToBreak(event.blockPos)) {
            event.cancel();
            MsgUtil.updateModuleMsg("Preventing accidental breakage\u00a7c..!", this.name, "blockBreakPrevent".hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onTick(TickEvent.Pre event) {
        class_239 target;
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        ++this.timer;
        if (this.timer >= 5) {
            this.timer = 0;
            Object object = this.suspiciousSandBlocks;
            synchronized (object) {
                this.suspiciousSandBlocks.removeIf(pos -> this.isOutOfRange((class_2338)pos, this.mc.field_1724.method_24515(), 256) || !(this.mc.field_1687.method_8321(pos) instanceof class_8174));
            }
            object = this.suspiciousGravelBlocks;
            synchronized (object) {
                this.suspiciousGravelBlocks.removeIf(pos -> this.isOutOfRange((class_2338)pos, this.mc.field_1724.method_24515(), 256) || !(this.mc.field_1687.method_8321(pos) instanceof class_8174));
            }
            object = this.preventingBreakageBlocks;
            synchronized (object) {
                this.preventingBreakageBlocks.removeIf(pos -> !(this.mc.field_1687.method_8321(pos) instanceof class_8174));
            }
            this.safeBlocksToBreak.removeIf(pos -> !(this.mc.field_1687.method_8321(pos) instanceof class_8174) || this.isOutOfRange((class_2338)pos, this.mc.field_1724.method_24515(), 256));
            this.safeBlocksToBrush.removeIf(pos -> !(this.mc.field_1687.method_8321(pos) instanceof class_8174) || this.isOutOfRange((class_2338)pos, this.mc.field_1724.method_24515(), 256));
            block21: for (class_2586 be : Utils.blockEntities()) {
                if (this.suspiciousSandBlocks.contains(be.method_11016()) || this.suspiciousGravelBlocks.contains(be.method_11016()) || !(be instanceof class_8174) || this.toIgnore.contains(be.method_11016().method_10063())) continue;
                if (this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_43227)) {
                    this.suspiciousGravelBlocks.add(be.method_11016());
                } else {
                    this.suspiciousSandBlocks.add(be.method_11016());
                }
                this.testPos.method_10103(be.method_11016().method_10263(), this.lastFoundPos == null ? be.method_11016().method_10264() : this.lastFoundPos.method_10264(), be.method_11016().method_10260());
                if (this.lastFoundPos != null && !this.isOutOfRange(this.lastFoundPos, (class_2338)this.testPos, 69)) continue;
                this.lastFoundPos = be.method_11016();
                if (StardustUtil.XAERO_AVAILABLE && ((Boolean)this.waypoints.get()).booleanValue()) {
                    switch (((SuspiciousBlocks)((Object)this.waypointsFor.get())).ordinal()) {
                        case 1: {
                            if (!this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_42728)) break;
                            MapUtil.addWaypoint(be.method_11016(), "Archaeology Dig Site", "\u16e9", MapUtil.Purpose.Normal, MapUtil.WpColor.Random, (Boolean)this.tempWaypoints.get());
                            break;
                        }
                        case 2: {
                            if (!this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_43227)) break;
                            MapUtil.addWaypoint(be.method_11016(), "Archaeology Dig Site", "\u16e9", MapUtil.Purpose.Normal, MapUtil.WpColor.Random, (Boolean)this.tempWaypoints.get());
                            break;
                        }
                        default: {
                            MapUtil.addWaypoint(be.method_11016(), "Archaeology Dig Site", "\u16e9", MapUtil.Purpose.Normal, MapUtil.WpColor.Random, (Boolean)this.tempWaypoints.get());
                        }
                    }
                }
                if (((Boolean)this.soundPing.get()).booleanValue()) {
                    switch (((SuspiciousBlocks)((Object)this.soundFor.get())).ordinal()) {
                        case 1: {
                            long now;
                            if (!this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_42728) || (now = System.currentTimeMillis()) - this.lastPing < 1337L) break;
                            this.lastPing = now;
                            this.mc.field_1724.method_5783(ThreadLocalRandom.current().nextInt(2) == 0 ? class_3417.field_43156 : class_3417.field_43158, ((Double)this.pingVolume.get()).floatValue(), ThreadLocalRandom.current().nextFloat(0.42f, 1.337f));
                            break;
                        }
                        case 2: {
                            long now;
                            if (!this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_43227) || (now = System.currentTimeMillis()) - this.lastPing < 1337L) break;
                            this.lastPing = now;
                            this.mc.field_1724.method_5783(ThreadLocalRandom.current().nextInt(2) == 0 ? class_3417.field_43157 : class_3417.field_43159, ((Double)this.pingVolume.get()).floatValue(), ThreadLocalRandom.current().nextFloat(0.42f, 1.337f));
                            break;
                        }
                        default: {
                            long now = System.currentTimeMillis();
                            if (now - this.lastPing < 1337L) break;
                            this.lastPing = now;
                            this.mc.field_1724.method_5783(this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_42728) ? (ThreadLocalRandom.current().nextInt(2) == 0 ? class_3417.field_43156 : class_3417.field_43158) : (ThreadLocalRandom.current().nextInt(2) == 0 ? class_3417.field_43157 : class_3417.field_43159), ((Double)this.pingVolume.get()).floatValue(), ThreadLocalRandom.current().nextFloat(0.42f, 1.337f));
                        }
                    }
                }
                if (!((Boolean)this.chatNotify.get()).booleanValue()) continue;
                switch (((SuspiciousBlocks)((Object)this.chatFor.get())).ordinal()) {
                    case 1: {
                        if (!this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_43227)) break;
                        continue block21;
                    }
                    case 2: {
                        if (!this.mc.field_1687.method_8320(be.method_11016()).method_27852(class_2246.field_42728)) break;
                        continue block21;
                    }
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Located an Archaeological Dig Site");
                if (((Boolean)this.chatCoords.get()).booleanValue()) {
                    sb.append(" at \u00a78[\u00a75").append(be.method_11016().method_10263()).append("\u00a78, \u00a75").append(be.method_11016().method_10264()).append("\u00a78, \u00a75").append(be.method_11016().method_10260()).append("\u00a78]");
                }
                sb.append(StardustUtil.rCC()).append("..!");
                MsgUtil.sendModuleMsg(sb.toString(), this.name);
            }
        }
        if (!((target = this.mc.field_1765) instanceof class_3965)) {
            return;
        }
        class_3965 blockHit = (class_3965)target;
        class_2338 hitPos = blockHit.method_17777();
        if (this.mc.field_1687.method_8321(hitPos) instanceof class_8174) {
            if (this.toIgnore.contains(hitPos.method_10063())) {
                this.mc.field_1690.field_1904.method_23481(false);
                if (((Boolean)this.breakBad.get()).booleanValue()) {
                    FindItemResult result = InvUtils.findInHotbar(stack -> stack.method_7909() instanceof class_1821);
                    if (result.found() && result.slot() != this.mc.field_1724.method_31548().field_7545 && !(this.mc.field_1724.method_6079().method_7909() instanceof class_1821)) {
                        InvUtils.swap((int)result.slot(), (boolean)false);
                    }
                    if (this.isSafeToBreak(hitPos)) {
                        BlockUtils.breakBlock((class_2338)hitPos, (boolean)true);
                    } else {
                        MsgUtil.updateModuleMsg("Preventing accidental breakage\u00a7c..!", this.name, "blockBreakPrevent".hashCode());
                    }
                }
                return;
            }
            FindItemResult result = InvUtils.findInHotbar((class_1792[])new class_1792[]{class_1802.field_42716});
            if (result.found()) {
                boolean offHand = this.mc.field_1724.method_6079().method_31574(class_1802.field_42716);
                if (this.mc.field_1724.method_31548().field_7545 == result.slot() || offHand) {
                    if (this.isSafeToBrush(hitPos)) {
                        if (!this.mc.field_1724.method_6115() && this.mc.field_1761 != null) {
                            this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, offHand ? class_1268.field_5810 : class_1268.field_5808);
                        }
                        this.mc.field_1690.field_1904.method_23481(true);
                    }
                } else {
                    InvUtils.swap((int)result.slot(), (boolean)false);
                    if (this.isSafeToBrush(hitPos)) {
                        if (!this.mc.field_1724.method_6115() && this.mc.field_1761 != null) {
                            this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808);
                        }
                        this.mc.field_1690.field_1904.method_23481(true);
                    }
                }
            } else {
                long now = System.currentTimeMillis();
                if (now - this.lastNotified >= 7777L) {
                    this.lastNotified = now;
                    MsgUtil.sendModuleMsg("\u00a74No brush found in hotbar\u00a77..!", this.name);
                }
            }
        } else if (this.mc.field_1724.method_6047().method_31574(class_1802.field_42716) || this.mc.field_1724.method_6079().method_31574(class_1802.field_42716)) {
            this.mc.field_1690.field_1904.method_23481(false);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null || this.mc.field_1761 == null) {
            return;
        }
        class_239 target = this.mc.field_1765;
        if (!(target instanceof class_3965)) {
            return;
        }
        class_3965 blockHit = (class_3965)target;
        class_2338 hitPos = blockHit.method_17777();
        if (this.toIgnore.contains(hitPos.method_10063())) {
            return;
        }
        class_2586 class_25862 = this.mc.field_1687.method_8321(hitPos);
        if (class_25862 instanceof class_8174) {
            class_1799 stack;
            class_8174 brushableBlock = (class_8174)class_25862;
            if (StardustUtil.XAERO_AVAILABLE && ((Boolean)this.waypoints.get()).booleanValue() && (this.suspiciousGravelBlocks.contains(hitPos) || this.suspiciousSandBlocks.contains(hitPos))) {
                MapUtil.removeWaypoints("Archaeology", pos -> pos.method_19771((class_2382)hitPos, 64.0), Optional.of(hitPos.method_10264()));
            }
            if ((stack = brushableBlock.method_49225()) == class_1799.field_8037 || stack.method_7909() == class_1802.field_8162) {
                this.preventingBreakageBlocks.add(hitPos);
                if (this.mc.field_1724.method_6115()) {
                    ++this.ticksBrushing;
                }
                if (this.ticksBrushing > 20) {
                    this.ticksBrushing = 0;
                    LogUtil.warn("Retrying brush packet after response timeout...", this.name);
                    this.mc.field_1724.method_6075();
                    this.mc.field_1690.field_1904.method_23481(false);
                }
                return;
            }
            this.ticksBrushing = 0;
            if (!((List)this.targetItems.get()).contains(stack.method_7909())) {
                this.toIgnore.add(hitPos.method_10063());
                if (((Boolean)this.chat.get()).booleanValue() && ((Boolean)this.breakBad.get()).booleanValue()) {
                    MsgUtil.sendModuleMsg("Breaking suspicious block containing \u00a7c" + stack.method_7964().getString() + "\u00a78.", this.name);
                }
                this.preventingBreakageBlocks.add(hitPos);
            } else {
                this.goodBlocks.add(hitPos);
                this.preventingBreakageBlocks.add(hitPos);
            }
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        Color sideColor;
        int distance;
        if (!((Boolean)this.render.get()).booleanValue()) {
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        for (class_2338 pos : this.preventingBreakageBlocks) {
            if (this.toIgnore.contains(pos.method_10063())) {
                RenderUtil.renderBlock(event, pos, (Color)new SettingColor(169, 13, 13, 255, true), (Color)new SettingColor(169, 13, 13, 13, true), ShapeMode.Both);
                continue;
            }
            if (this.goodBlocks.contains(pos)) {
                RenderUtil.renderBlock(event, pos, (Color)new SettingColor(13, 169, 69, 255, true), (Color)new SettingColor(13, 169, 69, 13, true), ShapeMode.Both);
                continue;
            }
            RenderUtil.renderBlock(event, pos, (Color)new SettingColor(137, 169, 4, 255, true), (Color)new SettingColor(137, 169, 4, 13, true), ShapeMode.Both);
        }
        ESPBlockData sand = (ESPBlockData)this.sandESP.get();
        ESPBlockData gravel = (ESPBlockData)this.gravelESP.get();
        for (class_2338 pos : this.suspiciousSandBlocks) {
            if (this.preventingBreakageBlocks.contains(pos)) continue;
            if (RenderUtil.shouldRenderBox(sand)) {
                distance = pos.method_19455((class_2382)this.mc.field_1724.method_24515());
                if (distance <= 128) {
                    sideColor = new Color(sand.sideColor.r, sand.sideColor.g, sand.sideColor.b, class_3532.method_15340((int)((int)Math.floor((double)sand.sideColor.a * ((double)(128 - distance) * 0.333))), (int)sand.sideColor.a, (int)Math.max(sand.sideColor.a, 69)));
                    RenderUtil.renderBlock(event, pos, (Color)sand.lineColor, sideColor, sand.shapeMode);
                } else {
                    RenderUtil.renderBlock(event, pos, (Color)sand.lineColor, (Color)sand.sideColor, sand.shapeMode);
                }
            }
            if (!RenderUtil.shouldRenderTracer(sand)) continue;
            RenderUtil.renderTracerTo(event, pos, (Color)sand.tracerColor);
        }
        for (class_2338 pos : this.suspiciousGravelBlocks) {
            if (this.preventingBreakageBlocks.contains(pos)) continue;
            if (RenderUtil.shouldRenderBox(gravel)) {
                distance = pos.method_19455((class_2382)this.mc.field_1724.method_24515());
                if (distance <= 128) {
                    sideColor = new Color(gravel.sideColor.r, gravel.sideColor.g, gravel.sideColor.b, class_3532.method_15340((int)((int)Math.floor((double)gravel.sideColor.a * ((double)(128 - distance) * 0.333))), (int)gravel.sideColor.a, (int)Math.max(gravel.sideColor.a, 69)));
                    RenderUtil.renderBlock(event, pos, (Color)gravel.lineColor, sideColor, gravel.shapeMode);
                } else {
                    RenderUtil.renderBlock(event, pos, (Color)gravel.lineColor, (Color)gravel.sideColor, gravel.shapeMode);
                }
            }
            if (!RenderUtil.shouldRenderTracer(gravel)) continue;
            RenderUtil.renderTracerTo(event, pos, (Color)gravel.tracerColor);
        }
    }

    public boolean isLootItem(class_1792 item) {
        return ARCHAEOLOGY_LOOT_TABLE.contains((Object)item);
    }

    public static enum SuspiciousBlocks {
        Both,
        SuspiciousSand,
        SuspiciousGravel;

    }
}

