/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import meteordevelopment.meteorclient.events.entity.player.PlayerMoveEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2440;
import net.minecraft.class_2533;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2879;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class AutoDoors
extends Module {
    private final Setting<DoorModes> modeSetting;
    private final Setting<MuteModes> muteSetting;
    private final Setting<Integer> spamRange;
    private final Setting<Integer> spamRate;
    private final Setting<Integer> interactDelay;
    private final Setting<Boolean> autoOpen;
    private final Setting<Boolean> silentSwing;
    private final Setting<Boolean> ninjaSwing;
    private final Setting<Boolean> useIronDoors;
    private final Setting<Boolean> useTrapdoors;
    private final Setting<Boolean> useFenceGates;
    private int tickCounter;
    private int ticksSinceInteracted;
    private class_243 lastBlock;

    public AutoDoors() {
        super(Stardust.CATEGORY, "AutoDoors", "Automatically interact with doors.");
        this.modeSetting = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Which mode to operate in.")).defaultValue((Object)DoorModes.Classic)).build());
        this.muteSetting = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mute-doors")).description("Whether to mute door sounds when the module is active.")).defaultValue((Object)MuteModes.Never)).build());
        this.spamRange = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("spam-range")).description("Range of blocks to look for doors in.")).range(1, 5).sliderRange(1, 5).defaultValue((Object)5)).visible(() -> this.modeSetting.get() == DoorModes.Spammer)).build());
        this.spamRate = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("spam-delay")).description("Delay (in ticks) between each interaction.")).range(2, 20).sliderRange(2, 20).defaultValue((Object)2)).visible(() -> this.modeSetting.get() == DoorModes.Spammer)).build());
        this.interactDelay = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("lever-delay")).description("Increase this if iron doors controlled by levers are acting scuffed.")).range(0, 100).sliderRange(2, 60).defaultValue((Object)5)).build());
        this.autoOpen = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-open")).description("Automatically open doors as you move towards them.")).defaultValue((Object)true)).visible(() -> this.modeSetting.get() == DoorModes.Classic)).build());
        this.silentSwing = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("silent-swing")).description("No client-side hand swing.")).defaultValue((Object)false)).build());
        this.ninjaSwing = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ninja-swing")).description("No server-side hand swing.")).defaultValue((Object)false)).build());
        this.useIronDoors = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("iron-doors")).description("Interact with iron doors using nearby buttons or levers.")).defaultValue((Object)true)).build());
        this.useTrapdoors = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("trapdoors")).description("Interact with trapdoors (only works when not on ladders.)")).defaultValue((Object)false)).build());
        this.useFenceGates = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fence-gates")).description("Interact with fence gates.")).defaultValue((Object)false)).build());
        this.tickCounter = 0;
        this.ticksSinceInteracted = 0;
        this.lastBlock = new class_243(0.0, 0.0, 0.0);
    }

    public boolean shouldMute() {
        return this.isActive() && (this.muteSetting.get() == MuteModes.Always || this.modeSetting.get() == DoorModes.Spammer && this.muteSetting.get() == MuteModes.Spammer);
    }

    private void interactDoor(class_2338 pos, class_2350 direction) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.mc.field_1761 == null) {
            return;
        }
        class_2350 side = this.getDirection(pos, direction);
        this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, new class_3965(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), side, pos, true));
        if (((Boolean)this.silentSwing.get()).booleanValue() && ((Boolean)this.ninjaSwing.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)this.silentSwing.get()).booleanValue() && ((Boolean)this.ninjaSwing.get()).booleanValue()) {
            this.mc.field_1724.method_6104(class_1268.field_5808);
        } else if (((Boolean)this.silentSwing.get()).booleanValue() && !((Boolean)this.ninjaSwing.get()).booleanValue()) {
            if (this.mc.method_1562() != null) {
                this.mc.method_1562().method_52787((class_2596)new class_2879(class_1268.field_5808));
            }
        } else {
            this.mc.field_1724.method_6104(class_1268.field_5808);
        }
    }

    @NotNull
    private class_2350 getDirection(class_2338 pos, class_2350 direction) {
        class_243 pPos = this.mc.field_1724.method_19538();
        return switch (direction) {
            case class_2350.field_11034 -> {
                if (pPos.field_1352 < (double)pos.method_10263()) {
                    yield class_2350.field_11039;
                }
                yield class_2350.field_11034;
            }
            case class_2350.field_11039 -> {
                if (pPos.field_1352 > (double)pos.method_10263()) {
                    yield class_2350.field_11034;
                }
                yield class_2350.field_11039;
            }
            case class_2350.field_11043 -> {
                if (pPos.field_1350 > (double)pos.method_10260()) {
                    yield class_2350.field_11035;
                }
                yield class_2350.field_11043;
            }
            case class_2350.field_11035 -> {
                if (pPos.field_1350 < (double)pos.method_10260()) {
                    yield class_2350.field_11043;
                }
                yield class_2350.field_11035;
            }
            case class_2350.field_11036 -> {
                if (pPos.field_1351 < (double)pos.method_10264()) {
                    yield class_2350.field_11033;
                }
                yield class_2350.field_11036;
            }
            case class_2350.field_11033 -> {
                if (pPos.field_1351 > (double)pos.method_10264()) {
                    yield class_2350.field_11033;
                }
                yield class_2350.field_11036;
            }
            default -> class_2350.field_11033;
        };
    }

    @NotNull
    private static class_2350 getMovementDirection(PlayerMoveEvent event) {
        double velocityX = event.movement.field_1352;
        double velocityY = event.movement.field_1351;
        double velocityZ = event.movement.field_1350;
        double directionRadians = Math.atan2(-velocityZ, velocityX);
        double directionDegrees = Math.toDegrees(directionRadians);
        double normalizedDegrees = (directionDegrees + 360.0) % 360.0;
        class_2350 movementDirection = normalizedDegrees >= 45.0 && normalizedDegrees < 135.0 ? class_2350.field_11043 : (normalizedDegrees >= 135.0 && normalizedDegrees < 225.0 ? class_2350.field_11039 : (normalizedDegrees >= 225.0 && normalizedDegrees < 315.0 ? class_2350.field_11035 : (normalizedDegrees >= 315.0 || normalizedDegrees < 45.0 ? class_2350.field_11034 : (velocityY > 0.0 ? class_2350.field_11036 : class_2350.field_11033))));
        return movementDirection;
    }

    private boolean scanForSwitches(class_2338 pos, class_2248 block, Boolean open, class_2350 moving, class_2350 side, int n) {
        if (this.mc.field_1687 == null) {
            return true;
        }
        if (block instanceof class_2269 || block instanceof class_2401) {
            class_2680 state = this.mc.field_1687.method_8320(pos);
            try {
                if (open.booleanValue() && block instanceof class_2269 && ((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
                    return false;
                }
                if (open.booleanValue() && block instanceof class_2401 && ((Boolean)state.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                    return false;
                }
                if (!open.booleanValue() && block instanceof class_2401 && !((Boolean)state.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!open.booleanValue() && block instanceof class_2269) {
                return true;
            }
            this.interactDoor(pos.method_10079(side, n), moving);
            return true;
        }
        class_2680 upState = this.mc.field_1687.method_8320(pos.method_10093(moving.method_10153()).method_10079(side, n).method_10084());
        class_2680 downState = this.mc.field_1687.method_8320(pos.method_10093(moving.method_10153()).method_10079(side, n).method_10074());
        class_2248 upBlock = upState.method_26204();
        class_2248 downBlock = downState.method_26204();
        if (upBlock instanceof class_2269 || upBlock instanceof class_2401) {
            try {
                if (open.booleanValue() && upBlock instanceof class_2269 && ((Boolean)upState.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
                    return false;
                }
                if (open.booleanValue() && upBlock instanceof class_2401 && ((Boolean)upState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                    return false;
                }
                if (!open.booleanValue() && upBlock instanceof class_2401 && !((Boolean)upState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!open.booleanValue() && upBlock instanceof class_2269) {
                return true;
            }
            this.interactDoor(pos.method_10093(moving.method_10153()).method_10079(side, n).method_10084(), moving);
            return true;
        }
        if (downBlock instanceof class_2269 || downBlock instanceof class_2401) {
            try {
                if (open.booleanValue() && downBlock instanceof class_2269 && ((Boolean)downState.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
                    return false;
                }
                if (open.booleanValue() && downBlock instanceof class_2401 && ((Boolean)downState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                    return false;
                }
                if (!open.booleanValue() && downBlock instanceof class_2401 && !((Boolean)downState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!open.booleanValue() && downBlock instanceof class_2269) {
                return true;
            }
            this.interactDoor(pos.method_10093(moving).method_10079(side, n).method_10074(), moving);
            return true;
        }
        return false;
    }

    private void tryInteractIronDoor(class_2338 pos, class_2680 state, class_2350 direction, boolean open) {
        if (this.mc.field_1687 == null || this.mc.field_1761 == null) {
            return;
        }
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof class_2323)) {
            return;
        }
        class_2323 ironDoor = (class_2323)class_22482;
        if (open == ironDoor.method_30841(state)) {
            return;
        }
        this.ticksSinceInteracted = 0;
        for (int n = 0; n < 4; ++n) {
            for (class_2350 side : class_2350.values()) {
                class_2248 offset = this.mc.field_1687.method_8320(pos.method_10093(direction.method_10153()).method_10079(side, n)).method_26204();
                class_2248 offset2 = this.mc.field_1687.method_8320(pos.method_10079(side, n)).method_26204();
                class_2248 offset3 = this.mc.field_1687.method_8320(pos.method_10093(direction).method_10079(side, n)).method_26204();
                if (this.scanForSwitches(pos, offset, open, direction, side, n)) {
                    return;
                }
                if (this.scanForSwitches(pos, offset2, open, direction, side, n)) {
                    return;
                }
                if (!this.scanForSwitches(pos, offset3, open, direction, side, n)) continue;
                return;
            }
        }
    }

    private LongArrayList getSurroundingDoors() {
        LongArrayList doors = new LongArrayList();
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return doors;
        }
        int range = (Integer)this.spamRange.get();
        class_2338 bPos = this.mc.field_1724.method_24515();
        class_2338.class_2339 doorPos = new class_2338.class_2339();
        for (int x = bPos.method_10263() - range; x < bPos.method_10263() + range; ++x) {
            for (int y = bPos.method_10264() - range; y < bPos.method_10264() + range; ++y) {
                for (int z = bPos.method_10260() - range; z < bPos.method_10260() + range; ++z) {
                    doorPos.method_10103(x, y, z);
                    if (!(this.mc.field_1687.method_8320((class_2338)doorPos).method_26204() instanceof class_2323)) continue;
                    doors.add(doorPos.method_10063());
                }
            }
        }
        return doors;
    }

    public void onDeactivate() {
        this.tickCounter = 0;
    }

    @EventHandler
    private void onPlayerMove(PlayerMoveEvent event) {
        class_2680 southState;
        class_2680 northState;
        class_2323 nextDoor;
        class_2323 nextDoor2;
        class_2248 class_22482;
        class_2680 westState;
        class_2680 eastState;
        class_2338 frontPos;
        if (this.modeSetting.get() == DoorModes.Spammer || this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (this.mc.field_1687.method_8320(this.mc.field_1724.method_24515()).method_26204() instanceof class_2440) {
            return;
        }
        ++this.ticksSinceInteracted;
        class_243 pPos = this.mc.field_1724.method_19538();
        if (pPos.field_1352 <= this.lastBlock.field_1352 + 0.1337 && pPos.field_1352 >= this.lastBlock.field_1352 - 0.1337 && pPos.field_1350 <= this.lastBlock.field_1350 + 0.1337 && pPos.field_1350 >= this.lastBlock.field_1350 - 0.1337) {
            return;
        }
        this.lastBlock = pPos;
        class_2350 movementDirection = AutoDoors.getMovementDirection(event);
        class_2338 pbPos = this.mc.field_1724.method_24515();
        class_2338 behindPos = switch (movementDirection) {
            case class_2350.field_11043 -> {
                frontPos = pbPos.method_10095();
                yield pbPos.method_10072();
            }
            case class_2350.field_11035 -> {
                frontPos = pbPos.method_10072();
                yield pbPos.method_10095();
            }
            case class_2350.field_11034 -> {
                frontPos = pbPos.method_10078();
                yield pbPos.method_10067();
            }
            case class_2350.field_11039 -> {
                frontPos = pbPos.method_10067();
                yield pbPos.method_10078();
            }
            case class_2350.field_11036 -> {
                frontPos = pbPos.method_10084();
                yield pbPos.method_10074();
            }
            default -> {
                frontPos = pbPos.method_10074();
                yield pbPos.method_10084();
            }
        };
        String yString = String.valueOf(pPos.field_1351);
        String sunk = yString.substring(yString.indexOf(".") + 1, yString.indexOf(".") + 2);
        if (this.mc.field_1724.method_24828() && Integer.parseInt(sunk) >= 5) {
            frontPos = frontPos.method_10084();
            behindPos = behindPos.method_10084();
        }
        class_2680 frontState = this.mc.field_1687.method_8320(frontPos);
        class_2680 behindState = this.mc.field_1687.method_8320(behindPos);
        class_2248 doorInFront = frontState.method_26204();
        class_2248 doorBehind = behindState.method_26204();
        if (((Boolean)this.useTrapdoors.get()).booleanValue() && doorInFront instanceof class_2533 && ((Boolean)this.autoOpen.get()).booleanValue()) {
            try {
                if (!((Boolean)frontState.method_11654((class_2769)class_2533.field_11631)).booleanValue()) {
                    this.interactDoor(frontPos, movementDirection);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (((Boolean)this.useTrapdoors.get()).booleanValue() && this.mc.field_1687.method_8320(frontPos.method_10074()).method_26204() instanceof class_2533 && ((Boolean)this.autoOpen.get()).booleanValue()) {
            try {
                if (!((Boolean)this.mc.field_1687.method_8320(frontPos.method_10074()).method_11654((class_2769)class_2533.field_11631)).booleanValue()) {
                    this.interactDoor(frontPos.method_10074(), class_2350.field_11033);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        class_2248 doorAboveFront = this.mc.field_1687.method_8320(frontPos.method_10084()).method_26204();
        class_2248 doorAboveBack = this.mc.field_1687.method_8320(behindPos.method_10084()).method_26204();
        if (((Boolean)this.useFenceGates.get()).booleanValue() && doorInFront instanceof class_2349 || doorAboveFront instanceof class_2349 && ((Boolean)this.autoOpen.get()).booleanValue()) {
            try {
                if (!((Boolean)frontState.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                    this.interactDoor(frontPos, movementDirection);
                    if (doorAboveFront instanceof class_2349 && !((Boolean)this.mc.field_1687.method_8320(frontPos.method_10084()).method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                        this.interactDoor(frontPos.method_10084(), movementDirection);
                    }
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (doorInFront instanceof class_2323) {
            class_2323 frontDoor = (class_2323)doorInFront;
            if (((Boolean)this.autoOpen.get()).booleanValue()) {
                if (((Boolean)this.useIronDoors.get()).booleanValue() && frontDoor == class_2246.field_9973) {
                    if (this.ticksSinceInteracted >= (Integer)this.interactDelay.get()) {
                        this.tryInteractIronDoor(frontPos, frontState, movementDirection, true);
                    }
                    return;
                }
                if (frontDoor == class_2246.field_9973) {
                    return;
                }
                if (!frontDoor.method_30841(frontState)) {
                    this.interactDoor(frontPos, movementDirection);
                }
                switch (movementDirection) {
                    case field_11043: 
                    case field_11035: {
                        eastState = this.mc.field_1687.method_8320(frontPos.method_10078());
                        westState = this.mc.field_1687.method_8320(frontPos.method_10067());
                        class_22482 = eastState.method_26204();
                        if (class_22482 instanceof class_2323) {
                            nextDoor2 = (class_2323)class_22482;
                            if (nextDoor2 == class_2246.field_9973) {
                                return;
                            }
                            if (nextDoor2.method_30841(eastState)) break;
                            this.interactDoor(frontPos.method_10078(), movementDirection);
                            break;
                        }
                        class_22482 = westState.method_26204();
                        if (!(class_22482 instanceof class_2323)) break;
                        nextDoor = (class_2323)class_22482;
                        if (nextDoor == class_2246.field_9973) {
                            return;
                        }
                        if (nextDoor.method_30841(westState)) break;
                        this.interactDoor(frontPos.method_10067(), movementDirection);
                        break;
                    }
                    case field_11034: 
                    case field_11039: {
                        northState = this.mc.field_1687.method_8320(frontPos.method_10095());
                        southState = this.mc.field_1687.method_8320(frontPos.method_10072());
                        class_22482 = northState.method_26204();
                        if (class_22482 instanceof class_2323) {
                            nextDoor2 = (class_2323)class_22482;
                            if (nextDoor2 == class_2246.field_9973) {
                                return;
                            }
                            if (nextDoor2.method_30841(northState)) break;
                            this.interactDoor(frontPos.method_10095(), movementDirection);
                            break;
                        }
                        class_22482 = southState.method_26204();
                        if (!(class_22482 instanceof class_2323)) break;
                        nextDoor = (class_2323)class_22482;
                        if (nextDoor == class_2246.field_9973) {
                            return;
                        }
                        if (nextDoor.method_30841(southState)) break;
                        this.interactDoor(frontPos.method_10072(), movementDirection);
                        break;
                    }
                }
            }
        }
        if (((Boolean)this.useTrapdoors.get()).booleanValue() && doorBehind instanceof class_2533) {
            try {
                if (((Boolean)behindState.method_11654((class_2769)class_2533.field_11631)).booleanValue()) {
                    this.interactDoor(behindPos, movementDirection);
                    return;
                }
            }
            catch (IllegalArgumentException frontDoor) {}
        } else if (((Boolean)this.useTrapdoors.get()).booleanValue() && this.mc.field_1687.method_8320(behindPos.method_10074()).method_26204() instanceof class_2533) {
            try {
                if (((Boolean)this.mc.field_1687.method_8320(behindPos.method_10074()).method_11654((class_2769)class_2533.field_11631)).booleanValue()) {
                    this.interactDoor(behindPos.method_10074(), class_2350.field_11033);
                    return;
                }
            }
            catch (IllegalArgumentException frontDoor) {
                // empty catch block
            }
        }
        if (((Boolean)this.useFenceGates.get()).booleanValue() && doorBehind instanceof class_2349 || doorAboveBack instanceof class_2349) {
            try {
                if (((Boolean)behindState.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                    this.interactDoor(behindPos, movementDirection);
                    if (doorAboveBack instanceof class_2349 && ((Boolean)this.mc.field_1687.method_8320(behindPos.method_10084()).method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                        this.interactDoor(behindPos.method_10084(), movementDirection);
                    }
                    return;
                }
            }
            catch (IllegalArgumentException frontDoor) {
                // empty catch block
            }
        }
        if (doorBehind instanceof class_2323) {
            class_2323 behindDoor = (class_2323)doorBehind;
            if (((Boolean)this.useIronDoors.get()).booleanValue() && behindDoor == class_2246.field_9973) {
                if (this.ticksSinceInteracted >= (Integer)this.interactDelay.get()) {
                    this.tryInteractIronDoor(behindPos, behindState, movementDirection, false);
                }
                return;
            }
            if (behindDoor == class_2246.field_9973) {
                return;
            }
            if (behindDoor.method_30841(behindState)) {
                this.interactDoor(behindPos, movementDirection);
            }
            switch (movementDirection) {
                case field_11043: 
                case field_11035: {
                    eastState = this.mc.field_1687.method_8320(behindPos.method_10078());
                    westState = this.mc.field_1687.method_8320(behindPos.method_10067());
                    class_22482 = eastState.method_26204();
                    if (class_22482 instanceof class_2323) {
                        nextDoor2 = (class_2323)class_22482;
                        if (nextDoor2 == class_2246.field_9973) {
                            return;
                        }
                        if (!nextDoor2.method_30841(eastState)) break;
                        this.interactDoor(behindPos.method_10078(), movementDirection);
                        break;
                    }
                    class_22482 = westState.method_26204();
                    if (!(class_22482 instanceof class_2323)) break;
                    nextDoor = (class_2323)class_22482;
                    if (nextDoor == class_2246.field_9973) {
                        return;
                    }
                    if (!nextDoor.method_30841(westState)) break;
                    this.interactDoor(behindPos.method_10067(), movementDirection);
                    break;
                }
                case field_11034: 
                case field_11039: {
                    northState = this.mc.field_1687.method_8320(behindPos.method_10095());
                    southState = this.mc.field_1687.method_8320(behindPos.method_10072());
                    class_22482 = northState.method_26204();
                    if (class_22482 instanceof class_2323) {
                        nextDoor2 = (class_2323)class_22482;
                        if (nextDoor2 == class_2246.field_9973) {
                            return;
                        }
                        if (!nextDoor2.method_30841(northState)) break;
                        this.interactDoor(behindPos.method_10095(), movementDirection);
                        break;
                    }
                    class_22482 = southState.method_26204();
                    if (!(class_22482 instanceof class_2323)) break;
                    nextDoor = (class_2323)class_22482;
                    if (nextDoor == class_2246.field_9973) {
                        return;
                    }
                    if (!nextDoor.method_30841(southState)) break;
                    this.interactDoor(behindPos.method_10072(), movementDirection);
                    break;
                }
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.modeSetting.get() == DoorModes.Classic) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= (Integer)this.spamRate.get()) {
            this.tickCounter = 0;
            if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
                return;
            }
            class_243 pPos = this.mc.field_1724.method_19538();
            LongArrayList doors = this.getSurroundingDoors();
            LongListIterator longListIterator = doors.iterator();
            while (longListIterator.hasNext()) {
                long door = (Long)longListIterator.next();
                class_2338 doorPos = class_2338.method_10092((long)door);
                if (this.mc.field_1687.method_8320(doorPos).method_26204() == class_2246.field_9973) continue;
                class_2350 side = pPos.field_1352 > (double)doorPos.method_10263() ? class_2350.field_11034 : (pPos.field_1352 < (double)doorPos.method_10263() ? class_2350.field_11039 : (pPos.field_1350 > (double)doorPos.method_10260() ? class_2350.field_11035 : (pPos.field_1350 < (double)doorPos.method_10260() ? class_2350.field_11043 : (pPos.field_1351 > (double)doorPos.method_10264() ? class_2350.field_11036 : class_2350.field_11033))));
                this.interactDoor(doorPos, side);
            }
        }
    }

    public static enum DoorModes {
        Classic,
        Spammer;

    }

    public static enum MuteModes {
        Never,
        Always,
        Spammer;

    }
}

