/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.mixin.accessor.GameOptionsAccessor;
import dev.stardust.util.MsgUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_7172;

public class AutoDrawDistance
extends Module {
    private final Setting<Integer> fpsTarget;
    private final Setting<Integer> minDistance;
    private final Setting<Integer> maxDistance;
    private final Setting<Integer> sweetSpotDelay;
    private final Setting<Boolean> verbose;
    private final Setting<Boolean> reportFPS;
    private int timer;
    private int justIncreased;
    private int sweetSpotCounter;
    private boolean sweetSpot;
    private final IntArrayList fpsData;

    public AutoDrawDistance() {
        super(Stardust.CATEGORY, "AutoDrawDistance", "Automatically adjusts your render distance to maintain an FPS target.");
        this.fpsTarget = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("FPS-target")).description("Best if you cap your FPS to your monitor's refresh rate (or lower) and use that value.")).range(30, 240).sliderRange(30, 240).defaultValue((Object)60)).build());
        this.minDistance = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("minimum-render-distance")).description("The minimum desired draw distance.")).range(2, 8).sliderRange(2, 8).defaultValue((Object)4)).build());
        this.maxDistance = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("maximum-render-distance")).description("The maximum desired draw distance.")).range(10, 64).sliderRange(10, 32).defaultValue((Object)12)).build());
        this.sweetSpotDelay = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("increase-delay")).description("Delay before trying to increase render distance when FPS target is satisfied.")).range(20, 1000).sliderRange(100, 1000).defaultValue((Object)420)).build());
        this.verbose = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("debug")).description("Output to chat whenever view distance adjustments are made.")).defaultValue((Object)false)).build());
        this.reportFPS = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("report-FPS")).description("Report average FPS numbers along with debug messages.")).defaultValue((Object)false)).visible(() -> this.verbose.get())).build());
        this.timer = 0;
        this.justIncreased = 0;
        this.sweetSpotCounter = 0;
        this.sweetSpot = false;
        this.fpsData = new IntArrayList();
    }

    private void updateDrawDistance(int distance) {
        boolean bl = Runtime.getRuntime().maxMemory() >= 1000000000L;
        class_7172 viewDistance = new class_7172("options.renderDistance", class_7172.method_42399(), (optionText, value) -> class_315.method_41783((class_2561)optionText, (class_2561)class_2561.method_43469((String)"options.chunks", (Object[])new Object[]{value})), (class_7172.class_7178)new class_7172.class_7174(2, bl ? 32 : 16), (Object)distance, value -> class_310.method_1551().field_1769.method_3292());
        ((GameOptionsAccessor)this.mc.field_1690).setViewDistance((class_7172<Integer>)viewDistance);
        this.mc.field_1690.method_1643();
        if (((Boolean)this.verbose.get()).booleanValue() && this.mc.field_1724 != null) {
            MsgUtil.updateModuleMsg("Updated view distance to\u00a78: \u00a72" + distance + "\u00a77.", this.name, "viewDistDebugUpdate".hashCode());
        }
    }

    private void tryLowerDrawDistanceDynamic(int drawDistance, int reduceAmount) {
        if (reduceAmount <= 0) {
            return;
        }
        if (drawDistance - reduceAmount < (Integer)this.minDistance.get()) {
            this.tryLowerDrawDistanceDynamic(drawDistance, reduceAmount - 1);
        } else {
            this.updateDrawDistance(drawDistance - reduceAmount);
        }
    }

    public void onDeactivate() {
        this.sweetSpotCounter = 0;
        this.timer = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.fpsData.size() > 500) {
            this.fpsData.clear();
        }
        if (this.timer >= 65535) {
            this.timer = 0;
        }
        this.sweetSpotCounter = this.sweetSpot ? ++this.sweetSpotCounter : 0;
        if (this.sweetSpotCounter >= (Integer)this.sweetSpotDelay.get()) {
            this.sweetSpot = false;
            this.sweetSpotCounter = 0;
        }
        int currentFps = this.mc.method_47599();
        this.fpsData.add(currentFps);
        ++this.timer;
        if (this.timer % 10 == 0) {
            int drawDistance = (Integer)this.mc.field_1690.method_42503().method_41753();
            int averageFps = 0;
            IntListIterator intListIterator = this.fpsData.iterator();
            while (intListIterator.hasNext()) {
                int point = (Integer)intListIterator.next();
                averageFps += point;
            }
            averageFps /= this.fpsData.size();
            int closeEnough = 5;
            if (this.justIncreased > 0) {
                if (this.justIncreased >= 3 && averageFps >= (Integer)this.fpsTarget.get() - closeEnough) {
                    this.sweetSpot = true;
                    this.justIncreased = 0;
                    this.sweetSpotCounter = 0;
                    if (((Boolean)this.verbose.get()).booleanValue() && this.mc.field_1724 != null) {
                        if (((Boolean)this.reportFPS.get()).booleanValue()) {
                            MsgUtil.updateMsg("Average FPS\u00a78: \u00a72" + averageFps, "averageFPSUpdate".hashCode());
                        }
                        MsgUtil.updateModuleMsg("Entered a \u00a72sweet spot\u00a78..!", this.name, "sweetSpotUpdate".hashCode());
                    }
                } else {
                    ++this.justIncreased;
                }
                return;
            }
            if (this.sweetSpot && averageFps >= (Integer)this.fpsTarget.get() - closeEnough) {
                return;
            }
            if (averageFps >= (Integer)this.fpsTarget.get() - closeEnough) {
                if (drawDistance >= (Integer)this.maxDistance.get()) {
                    return;
                }
                ++this.justIncreased;
                this.fpsData.clear();
                if (((Boolean)this.verbose.get()).booleanValue() && ((Boolean)this.reportFPS.get()).booleanValue() && this.mc.field_1724 != null) {
                    MsgUtil.updateMsg("Average FPS\u00a78: \u00a72" + averageFps, "averageFPSUpdate".hashCode());
                }
                this.updateDrawDistance(drawDistance + 1);
            } else {
                int targetFps = (Integer)this.fpsTarget.get();
                if (targetFps - averageFps <= closeEnough) {
                    return;
                }
                if (drawDistance <= (Integer)this.minDistance.get()) {
                    return;
                }
                if (((Boolean)this.verbose.get()).booleanValue() && ((Boolean)this.reportFPS.get()).booleanValue() && this.mc.field_1724 != null) {
                    MsgUtil.updateMsg("Average FPS\u00a78: \u00a72" + averageFps, "averageFPSUpdate".hashCode());
                }
                this.fpsData.clear();
                if (this.timer < 250) {
                    return;
                }
                int diff = targetFps - averageFps;
                if (diff <= 15) {
                    this.tryLowerDrawDistanceDynamic(drawDistance, 2);
                } else if (diff <= 30) {
                    this.tryLowerDrawDistanceDynamic(drawDistance, 4);
                } else if (diff <= 40) {
                    this.tryLowerDrawDistanceDynamic(drawDistance, 6);
                } else if (diff <= 50) {
                    this.tryLowerDrawDistanceDynamic(drawDistance, 8);
                } else if (diff <= 60) {
                    this.tryLowerDrawDistanceDynamic(drawDistance, 10);
                }
            }
        }
    }
}

