/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.util.MsgUtil;
import io.netty.util.internal.ThreadLocalRandom;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1729;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3417;
import net.minecraft.class_479;
import net.minecraft.class_490;

public class AutoDyeShulkers
extends Module {
    private final Setting<DyeMode> dyeMode;
    private final Setting<OperatingMode> operatingMode;
    private final Setting<class_1767> dyeColor;
    private final Setting<Boolean> reDyeColored;
    private final Setting<Boolean> closeOnDone;
    private final Setting<Boolean> disableOnDone;
    private final Setting<Boolean> pingOnDone;
    private final Setting<Double> pingVolume;
    private final Setting<Integer> tickRate;
    private int timer;
    private boolean notified;

    public AutoDyeShulkers() {
        super(Stardust.CATEGORY, "AutoDyeShulkers", "Automatically dye shulker boxes and/or bundles in crafting grids.");
        this.dyeMode = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("dye-mode")).description("Whether to dye shulker boxes, bundles, or both.")).defaultValue((Object)DyeMode.Both)).build());
        this.operatingMode = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("operating-mode")).description("Whether to dye in crafting tables, the inventory grid, or both.")).defaultValue((Object)OperatingMode.Both)).build());
        this.dyeColor = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("color")).defaultValue((Object)class_1767.field_7951)).build());
        this.reDyeColored = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("recolor-colored")).description("Re-color shulker boxes which already have a different dye color applied.")).defaultValue((Object)false)).build());
        this.closeOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("close-screen")).description("Automatically close the crafting table screen when no more shulkers can be dyed.")).defaultValue((Object)true)).build());
        this.disableOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-on-done")).description("Automatically disable the module when no more shulkers can be dyed.")).defaultValue((Object)false)).build());
        this.pingOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sound-ping")).description("Play a sound cue when no more shulkers can be dyed.")).defaultValue((Object)true)).build());
        this.pingVolume = this.settings.getDefaultGroup().add((Setting)((DoubleSetting.Builder)new DoubleSetting.Builder().name("ping-volume")).sliderMin(0.0).sliderMax(5.0).defaultValue(1.0).build());
        this.tickRate = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("tick-rate")).description("You may need to increase this if you have high ping.")).range(1, 100).sliderRange(2, 20).defaultValue((Object)3)).build());
        this.timer = 0;
        this.notified = false;
    }

    public static boolean isColoredShulker(class_1792 box) {
        return box == class_1802.field_8268 || box == class_1802.field_8627 || box == class_1802.field_8451 || box == class_1802.field_8722 || box == class_1802.field_8676 || box == class_1802.field_8380 || box == class_1802.field_8271 || box == class_1802.field_8548 || box == class_1802.field_8461 || box == class_1802.field_8213 || box == class_1802.field_8829 || box == class_1802.field_8350 || box == class_1802.field_8816 || box == class_1802.field_8050 || box == class_1802.field_8520 || box == class_1802.field_8584;
    }

    private boolean isValidShulker(class_1792 box) {
        if (!((Boolean)this.reDyeColored.get()).booleanValue()) {
            return box == class_1802.field_8545;
        }
        return switch ((class_1767)this.dyeColor.get()) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7963 -> {
                if (box != class_1802.field_8268 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7944 -> {
                if (box != class_1802.field_8627 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7967 -> {
                if (box != class_1802.field_8451 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7952 -> {
                if (box != class_1802.field_8722 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7964 -> {
                if (box != class_1802.field_8676 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7946 -> {
                if (box != class_1802.field_8380 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7947 -> {
                if (box != class_1802.field_8271 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7961 -> {
                if (box != class_1802.field_8548 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7942 -> {
                if (box != class_1802.field_8461 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7955 -> {
                if (box != class_1802.field_8213 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7951 -> {
                if (box != class_1802.field_8829 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7966 -> {
                if (box != class_1802.field_8350 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7958 -> {
                if (box != class_1802.field_8050 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7945 -> {
                if (box != class_1802.field_8816 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7954 -> {
                if (box != class_1802.field_8520 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7957 -> box != class_1802.field_8584 && (AutoDyeShulkers.isColoredShulker(box) || box == class_1802.field_8545);
        };
    }

    public static boolean isColoredBundle(class_1792 sack) {
        return sack == class_1802.field_54317 || sack == class_1802.field_54309 || sack == class_1802.field_54310 || sack == class_1802.field_54302 || sack == class_1802.field_54316 || sack == class_1802.field_54303 || sack == class_1802.field_54306 || sack == class_1802.field_54307 || sack == class_1802.field_54315 || sack == class_1802.field_54311 || sack == class_1802.field_54305 || sack == class_1802.field_54313 || sack == class_1802.field_54312 || sack == class_1802.field_54304 || sack == class_1802.field_54308 || sack == class_1802.field_54314;
    }

    private boolean isValidBundle(class_1792 sack) {
        if (!((Boolean)this.reDyeColored.get()).booleanValue()) {
            return sack == class_1802.field_27023;
        }
        return switch ((class_1767)this.dyeColor.get()) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7963 -> {
                if (sack != class_1802.field_54317 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7944 -> {
                if (sack != class_1802.field_54309 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7967 -> {
                if (sack != class_1802.field_54310 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7952 -> {
                if (sack != class_1802.field_54302 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7964 -> {
                if (sack != class_1802.field_54316 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7946 -> {
                if (sack != class_1802.field_54303 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7947 -> {
                if (sack != class_1802.field_54306 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7961 -> {
                if (sack != class_1802.field_54307 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7942 -> {
                if (sack != class_1802.field_54315 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7955 -> {
                if (sack != class_1802.field_54311 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7951 -> {
                if (sack != class_1802.field_54305 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7966 -> {
                if (sack != class_1802.field_54313 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7958 -> {
                if (sack != class_1802.field_54304 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7945 -> {
                if (sack != class_1802.field_54312 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7954 -> {
                if (sack != class_1802.field_54308 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023)) {
                    yield true;
                }
                yield false;
            }
            case class_1767.field_7957 -> sack != class_1802.field_54314 && (AutoDyeShulkers.isColoredBundle(sack) || sack == class_1802.field_27023);
        };
    }

    private int getUnoccupiedSlot(int occupied, int inputEnd) {
        int slot;
        while ((slot = ThreadLocalRandom.current().nextInt(1, inputEnd)) == occupied) {
        }
        return slot;
    }

    private <T extends class_1729> int getItemSlot(class_1792 wanted, T cs, int invStart, int invEnd) {
        for (int n = invStart; n < invEnd; ++n) {
            class_1799 stack = cs.method_7611(n).method_7677();
            if (!(wanted == class_1802.field_8545 ? this.isValidShulker(stack.method_7909()) : (wanted == class_1802.field_27023 ? this.isValidBundle(stack.method_7909()) : wanted == stack.method_7909()))) continue;
            return n;
        }
        return -1;
    }

    private <T extends class_1729> void dyeShulker(T cs, int inputEnd, int invStart, int invEnd) {
        class_1799 output = cs.method_7611(0).method_7677();
        switch (((DyeMode)((Object)this.dyeMode.get())).ordinal()) {
            case 2: {
                int bundleSlot;
                int shulkSlot;
                int dyeSlot;
                if (AutoDyeShulkers.isColoredShulker(output.method_7909()) || AutoDyeShulkers.isColoredBundle(output.method_7909())) {
                    InvUtils.shiftClick().slotId(0);
                    break;
                }
                boolean hasDye = false;
                boolean hasShulk = false;
                boolean hasBundle = false;
                int occupiedSlotDye = -1;
                int occupiedSlotShulk = -1;
                int occupiedSlotBundle = -1;
                for (int n = 1; n < inputEnd; ++n) {
                    class_1799 stack = cs.method_7611(n).method_7677();
                    if (stack.method_7909() == class_1769.method_7803((class_1767)((class_1767)this.dyeColor.get()))) {
                        if (!hasDye) {
                            hasDye = true;
                            occupiedSlotDye = n;
                            continue;
                        }
                        InvUtils.shiftClick().slotId(n);
                        continue;
                    }
                    if (this.isValidShulker(stack.method_7909())) {
                        if (!hasShulk) {
                            hasShulk = true;
                            occupiedSlotShulk = n;
                            continue;
                        }
                        InvUtils.shiftClick().slotId(n);
                        continue;
                    }
                    if (!this.isValidBundle(stack.method_7909()) || hasBundle) continue;
                    hasBundle = true;
                    occupiedSlotBundle = n;
                }
                if (!hasDye && (dyeSlot = this.getItemSlot((class_1792)class_1769.method_7803((class_1767)((class_1767)this.dyeColor.get())), cs, invStart, invEnd)) != -1) {
                    if (occupiedSlotShulk != -1) {
                        InvUtils.move().fromId(dyeSlot).toId(this.getUnoccupiedSlot(occupiedSlotShulk, inputEnd));
                    } else if (occupiedSlotBundle != -1) {
                        InvUtils.move().fromId(dyeSlot).toId(this.getUnoccupiedSlot(occupiedSlotBundle, inputEnd));
                    } else {
                        InvUtils.move().fromId(dyeSlot).toId(1);
                    }
                    return;
                }
                if (!hasShulk && (shulkSlot = this.getItemSlot(class_1802.field_8545, cs, invStart, invEnd)) != -1) {
                    if (occupiedSlotDye != -1) {
                        InvUtils.move().fromId(shulkSlot).toId(this.getUnoccupiedSlot(occupiedSlotShulk, inputEnd));
                    } else {
                        InvUtils.move().fromId(shulkSlot).toId(1);
                    }
                    return;
                }
                if (!hasBundle && (bundleSlot = this.getItemSlot(class_1802.field_27023, cs, invStart, invEnd)) != -1) {
                    if (occupiedSlotDye != -1) {
                        InvUtils.move().fromId(bundleSlot).toId(this.getUnoccupiedSlot(occupiedSlotBundle, inputEnd));
                    } else {
                        InvUtils.move().fromId(bundleSlot).toId(1);
                    }
                    return;
                }
                if (hasDye && hasShulk && output.method_7960()) {
                    this.timer = (Integer)this.tickRate.get() - 1;
                    break;
                }
                if (hasDye && hasBundle && output.method_7960()) {
                    this.timer = (Integer)this.tickRate.get() - 1;
                    break;
                }
                if (hasShulk && hasDye && hasBundle || this.notified) break;
                this.notified = true;
                if (((Boolean)this.disableOnDone.get()).booleanValue()) {
                    this.toggle();
                }
                if (((Boolean)this.closeOnDone.get()).booleanValue() && cs instanceof class_1714) {
                    this.mc.field_1724.method_7346();
                }
                if (((Boolean)this.pingOnDone.get()).booleanValue()) {
                    this.mc.field_1724.method_5783(class_3417.field_14627, ((Double)this.pingVolume.get()).floatValue(), 1.0f);
                }
                MsgUtil.sendModuleMsg("Finished dyeing items\u00a7a..!", this.name);
                break;
            }
            case 0: {
                int shulkSlot;
                int dyeSlot;
                if (AutoDyeShulkers.isColoredShulker(output.method_7909())) {
                    InvUtils.shiftClick().slotId(0);
                    break;
                }
                boolean hasDye = false;
                boolean hasShulk = false;
                int occupiedSlotDye = -1;
                int occupiedSlotShulk = -1;
                for (int n = 1; n < inputEnd; ++n) {
                    class_1799 stack = cs.method_7611(n).method_7677();
                    if (stack.method_7909() == class_1769.method_7803((class_1767)((class_1767)this.dyeColor.get()))) {
                        if (!hasDye) {
                            hasDye = true;
                            occupiedSlotDye = n;
                            continue;
                        }
                        InvUtils.shiftClick().slotId(n);
                        continue;
                    }
                    if (!this.isValidShulker(stack.method_7909())) continue;
                    if (!hasShulk) {
                        hasShulk = true;
                        occupiedSlotShulk = n;
                        continue;
                    }
                    InvUtils.shiftClick().slotId(n);
                }
                if (!hasDye && (dyeSlot = this.getItemSlot((class_1792)class_1769.method_7803((class_1767)((class_1767)this.dyeColor.get())), cs, invStart, invEnd)) != -1) {
                    if (occupiedSlotShulk != -1) {
                        InvUtils.move().fromId(dyeSlot).toId(this.getUnoccupiedSlot(occupiedSlotShulk, inputEnd));
                    } else {
                        InvUtils.move().fromId(dyeSlot).toId(1);
                    }
                    return;
                }
                if (!hasShulk && (shulkSlot = this.getItemSlot(class_1802.field_8545, cs, invStart, invEnd)) != -1) {
                    if (occupiedSlotDye != -1) {
                        InvUtils.move().fromId(shulkSlot).toId(this.getUnoccupiedSlot(occupiedSlotShulk, inputEnd));
                    } else {
                        InvUtils.move().fromId(shulkSlot).toId(1);
                    }
                    return;
                }
                if (hasDye && hasShulk && output.method_7960()) {
                    this.timer = (Integer)this.tickRate.get() - 1;
                    break;
                }
                if (hasShulk && hasDye || this.notified) break;
                this.notified = true;
                if (((Boolean)this.disableOnDone.get()).booleanValue()) {
                    this.toggle();
                }
                if (((Boolean)this.closeOnDone.get()).booleanValue() && cs instanceof class_1714) {
                    this.mc.field_1724.method_7346();
                }
                if (((Boolean)this.pingOnDone.get()).booleanValue()) {
                    this.mc.field_1724.method_5783(class_3417.field_14627, ((Double)this.pingVolume.get()).floatValue(), 1.0f);
                }
                MsgUtil.sendModuleMsg("Finished dyeing shulkers\u00a7a..!", this.name);
                break;
            }
            case 1: {
                int bundleSlot;
                int dyeSlot;
                if (AutoDyeShulkers.isColoredBundle(output.method_7909())) {
                    InvUtils.shiftClick().slotId(0);
                    break;
                }
                boolean hasDye = false;
                boolean hasBundle = false;
                int occupiedSlotDye = -1;
                int occupiedSlotBundle = -1;
                for (int n = 1; n < inputEnd; ++n) {
                    class_1799 stack = cs.method_7611(n).method_7677();
                    if (stack.method_7909() == class_1769.method_7803((class_1767)((class_1767)this.dyeColor.get()))) {
                        if (!hasDye) {
                            hasDye = true;
                            occupiedSlotDye = n;
                            continue;
                        }
                        InvUtils.shiftClick().slotId(n);
                        continue;
                    }
                    if (!this.isValidBundle(stack.method_7909())) continue;
                    if (!hasBundle) {
                        hasBundle = true;
                        occupiedSlotBundle = n;
                        continue;
                    }
                    InvUtils.shiftClick().slotId(n);
                }
                if (!hasDye && (dyeSlot = this.getItemSlot((class_1792)class_1769.method_7803((class_1767)((class_1767)this.dyeColor.get())), cs, invStart, invEnd)) != -1) {
                    if (occupiedSlotBundle != -1) {
                        InvUtils.move().fromId(dyeSlot).toId(this.getUnoccupiedSlot(occupiedSlotBundle, inputEnd));
                    } else {
                        InvUtils.move().fromId(dyeSlot).toId(1);
                    }
                    return;
                }
                if (!hasBundle && (bundleSlot = this.getItemSlot(class_1802.field_27023, cs, invStart, invEnd)) != -1) {
                    if (occupiedSlotDye != -1) {
                        InvUtils.move().fromId(bundleSlot).toId(this.getUnoccupiedSlot(occupiedSlotBundle, inputEnd));
                    } else {
                        InvUtils.move().fromId(bundleSlot).toId(1);
                    }
                    return;
                }
                if (hasDye && hasBundle && output.method_7960()) {
                    this.timer = (Integer)this.tickRate.get() - 1;
                    break;
                }
                if (hasBundle && hasDye || this.notified) break;
                this.notified = true;
                if (((Boolean)this.disableOnDone.get()).booleanValue()) {
                    this.toggle();
                }
                if (((Boolean)this.closeOnDone.get()).booleanValue() && cs instanceof class_1714) {
                    this.mc.field_1724.method_7346();
                }
                if (((Boolean)this.pingOnDone.get()).booleanValue()) {
                    this.mc.field_1724.method_5783(class_3417.field_14627, ((Double)this.pingVolume.get()).floatValue(), 1.0f);
                }
                MsgUtil.sendModuleMsg("Finished dyeing bundles\u00a7a..!", this.name);
            }
        }
    }

    public void onDeactivate() {
        this.timer = 0;
        this.notified = false;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        class_1703 class_17032;
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.mc.field_1755 == null) {
            this.onDeactivate();
            return;
        }
        if (((OperatingMode)((Object)this.operatingMode.get())).equals((Object)OperatingMode.Table) && this.mc.field_1724.field_7512 instanceof class_1723) {
            this.onDeactivate();
            return;
        }
        if (((OperatingMode)((Object)this.operatingMode.get())).equals((Object)OperatingMode.Inventory) && this.mc.field_1724.field_7512 instanceof class_1714) {
            this.onDeactivate();
            return;
        }
        if (this.mc.field_1755 instanceof class_479 && (class_17032 = this.mc.field_1724.field_7512) instanceof class_1714) {
            class_1714 cs = (class_1714)class_17032;
            ++this.timer;
            if (this.timer >= (Integer)this.tickRate.get()) {
                this.timer = 0;
                this.dyeShulker(cs, 10, 10, 46);
            }
        } else if (this.mc.field_1755 instanceof class_490 && (class_17032 = this.mc.field_1724.field_7512) instanceof class_1723) {
            class_1723 ps = (class_1723)class_17032;
            ++this.timer;
            if (this.timer >= (Integer)this.tickRate.get()) {
                this.timer = 0;
                this.dyeShulker(ps, 5, 9, 45);
            }
        }
    }

    public static enum DyeMode {
        Shulkers,
        Bundles,
        Both;

    }

    public static enum OperatingMode {
        Table,
        Inventory,
        Both;

    }
}

