/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.mixin.accessor.ClientConnectionAccessor;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StonecutterUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.world.PlaySoundEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10291;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2811;
import net.minecraft.class_2813;
import net.minecraft.class_3417;
import net.minecraft.class_3971;
import net.minecraft.class_3979;
import org.jetbrains.annotations.Nullable;

public class AutoMason
extends Module {
    private final Setting<Mode> moduleMode;
    private final Setting<Integer> batchDelay;
    private final Setting<Integer> tickRate;
    private final Setting<List<class_1792>> itemList;
    private final Setting<Boolean> muteCutter;
    private final Setting<Boolean> closeOnDone;
    private final Setting<Boolean> disableOnDone;
    private final Setting<Boolean> pingOnDone;
    private final Setting<Double> pingVolume;
    private int timer;
    private boolean notified;
    @Nullable
    private class_1799 targetStack;
    @Nullable
    private class_1799 outputStack;
    private final IntArrayList projectedEmpty;
    private final IntArrayList processedSlots;
    private final ArrayDeque<class_2596<?>> packetQueue;

    public AutoMason() {
        super(Stardust.CATEGORY, "AutoMason", "Automates masonry interactions with the stonecutter.");
        this.moduleMode = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Packet is faster but might also get you kicked in some scenarios.")).defaultValue((Object)Mode.Packet)).build());
        this.batchDelay = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("packet-delay")).description("Increase this if the server is kicking you.")).min(0).max(1000).sliderRange(0, 50).defaultValue((Object)1)).visible(() -> ((Mode)((Object)((Object)this.moduleMode.get()))).equals((Object)Mode.Packet))).build());
        this.tickRate = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("tick-rate")).description("Increase this if the server is kicking you.")).min(0).max(1000).sliderRange(0, 100).defaultValue((Object)4)).visible(() -> ((Mode)((Object)((Object)this.moduleMode.get()))).equals((Object)Mode.Interact))).build());
        this.itemList = this.settings.getDefaultGroup().add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("target-items")).description("Which target items you wish to craft in the Stonecutter.")).filter(item -> StonecutterUtil.STONECUTTER_BLOCKS.values().stream().anyMatch(v -> v.contains(item))).build());
        this.muteCutter = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mute-stonecutter")).description("Mute the stonecutter sounds.")).defaultValue((Object)false)).build());
        this.closeOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("close-stonecutter")).description("Automatically close the stonecutter screen when no more blocks can be crafted.")).defaultValue((Object)false)).build());
        this.disableOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-when-done")).description("Automatically disable the module when no more blocks can be crafted.")).defaultValue((Object)false)).build());
        this.pingOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sound-ping")).description("Play a sound cue when there are no more blocks to be crafted.")).defaultValue((Object)false)).build());
        this.pingVolume = this.settings.getDefaultGroup().add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("ping-volume")).sliderMin(0.0).sliderMax(5.0).defaultValue(0.5).visible(() -> this.pingOnDone.get())).build());
        this.timer = 0;
        this.notified = false;
        this.targetStack = null;
        this.outputStack = null;
        this.projectedEmpty = new IntArrayList();
        this.processedSlots = new IntArrayList();
        this.packetQueue = new ArrayDeque();
    }

    public void onDeactivate() {
        this.timer = 0;
        this.notified = false;
        this.targetStack = null;
        this.outputStack = null;
        this.packetQueue.clear();
        this.processedSlots.clear();
        this.projectedEmpty.clear();
    }

    @EventHandler
    private void onScreenOpen(OpenScreenEvent event) {
        if (event.screen instanceof class_3979) {
            this.notified = false;
        }
    }

    @EventHandler
    private void onSoundPlay(PlaySoundEvent event) {
        if (!((Boolean)this.muteCutter.get()).booleanValue()) {
            return;
        }
        if (event.sound.method_4775().equals((Object)class_3417.field_17710.comp_3319())) {
            event.cancel();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.method_1562() == null) {
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_1703 class_17032 = this.mc.field_1724.field_7512;
        if (!(class_17032 instanceof class_3971)) {
            return;
        }
        class_3971 cutter = (class_3971)class_17032;
        if (!this.packetQueue.isEmpty()) {
            if ((Integer)this.batchDelay.get() <= 0) {
                while (!this.packetQueue.isEmpty()) {
                    ((ClientConnectionAccessor)this.mc.method_1562().method_48296()).invokeSendImmediately(this.packetQueue.removeFirst(), null, true);
                }
            } else {
                ++this.timer;
                if (this.timer >= (Integer)this.batchDelay.get()) {
                    this.timer = 0;
                    ((ClientConnectionAccessor)this.mc.method_1562().method_48296()).invokeSendImmediately(this.packetQueue.removeFirst(), null, true);
                }
            }
            if (this.packetQueue.isEmpty()) {
                this.finished();
            }
            return;
        }
        switch (((Mode)((Object)this.moduleMode.get())).ordinal()) {
            case 0: {
                if (this.notified) {
                    return;
                }
                if (((List)this.itemList.get()).isEmpty()) {
                    this.notified = true;
                    MsgUtil.sendModuleMsg("No target items selected\u00a7c..!", this.name);
                    this.finished();
                    return;
                }
                boolean exhausted = false;
                while (!exhausted) {
                    class_2596<?> packet = this.generatePacket(cutter);
                    if (packet == null) {
                        exhausted = true;
                        continue;
                    }
                    this.packetQueue.addLast(packet);
                }
                if (!this.packetQueue.isEmpty()) break;
                this.finished();
                break;
            }
            case 1: {
                if (this.timer < (Integer)this.tickRate.get()) {
                    ++this.timer;
                    return;
                }
                this.timer = 0;
                if (((List)this.itemList.get()).isEmpty()) {
                    if (!this.notified) {
                        MsgUtil.sendModuleMsg("No target items selected\u00a7c..!", this.name);
                        if (((Boolean)this.pingOnDone.get()).booleanValue()) {
                            this.mc.field_1724.method_5783(class_3417.field_14627, ((Double)this.pingVolume.get()).floatValue(), ThreadLocalRandom.current().nextFloat(0.69f, 1.337f));
                        }
                    }
                    this.notified = true;
                    this.finished();
                    return;
                }
                class_1799 input = cutter.method_7611(0).method_7677();
                class_1799 output = cutter.method_7611(1).method_7677();
                if (!this.hasValidItems(cutter)) {
                    this.finished();
                    break;
                }
                if (input.method_7960() && output.method_7960()) {
                    for (int n = 2; n < this.mc.field_1724.method_31548().field_7547.size() + 2; ++n) {
                        class_1799 stack = cutter.method_7611(n).method_7677();
                        if (!this.isValidItem(stack)) continue;
                        InvUtils.shiftClick().slotId(n);
                    }
                    break;
                }
                if (output.method_7960()) {
                    class_10291.class_10293 available = this.mc.field_1687.method_8433().method_64677().method_64714(input);
                    class_10352 contextParameterMap = class_10363.method_65008((class_1937)this.mc.field_1687);
                    boolean found = false;
                    for (int n = 0; n < available.comp_3255().size(); ++n) {
                        class_10291.class_10292 entry = (class_10291.class_10292)available.comp_3255().get(n);
                        class_1799 recipeStack = entry.comp_3254().comp_3251().method_64742(contextParameterMap);
                        if (recipeStack.method_7960() || !((List)this.itemList.get()).contains(recipeStack.method_7909())) continue;
                        found = true;
                        cutter.method_7604((class_1657)this.mc.field_1724, n);
                        ((ClientConnectionAccessor)this.mc.method_1562().method_48296()).invokeSendImmediately((class_2596<?>)new class_2811(cutter.field_7763, n), null, true);
                        break;
                    }
                    if (found) break;
                    if (!this.notified) {
                        this.notified = true;
                        MsgUtil.sendModuleMsg("Desired recipe not found\u00a7c..!", this.name);
                        if (((Boolean)this.pingOnDone.get()).booleanValue()) {
                            this.mc.field_1724.method_5783(class_3417.field_14627, ((Double)this.pingVolume.get()).floatValue(), ThreadLocalRandom.current().nextFloat(0.69f, 1.337f));
                        }
                    }
                    this.finished();
                    break;
                }
                InvUtils.shiftClick().slotId(1);
            }
        }
    }

    private void finished() {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (!this.notified) {
            if (this.chatFeedback) {
                MsgUtil.sendModuleMsg("No more items to craft\u00a7a..!", this.name);
            }
            if (((Boolean)this.pingOnDone.get()).booleanValue()) {
                this.mc.field_1724.method_5783(class_3417.field_14627, ((Double)this.pingVolume.get()).floatValue(), ThreadLocalRandom.current().nextFloat(0.69f, 1.337f));
            }
        }
        this.notified = true;
        this.processedSlots.clear();
        this.projectedEmpty.clear();
        if (((Boolean)this.closeOnDone.get()).booleanValue()) {
            this.mc.field_1724.method_7346();
        }
        if (((Boolean)this.disableOnDone.get()).booleanValue()) {
            this.toggle();
        }
    }

    @Nullable
    private class_2596<?> generatePacket(class_3971 handler) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return null;
        }
        Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap();
        if (this.targetStack != null && this.outputStack != null) {
            changedSlots.put(0, (Object)class_1799.field_8037);
            changedSlots.put(1, (Object)class_1799.field_8037);
            int shiftClickTargetSlot = this.predictEmptySlot(handler);
            if (shiftClickTargetSlot == -1) {
                MsgUtil.sendModuleMsg("Failed to predict empty target slot \u00a78[\u00a77Is your inventory full\u00a73..?\u00a78]\u00a7c..!", this.name);
                return null;
            }
            changedSlots.put(shiftClickTargetSlot, (Object)new class_1799((class_1935)this.outputStack.method_7909(), this.targetStack.method_7947()));
            this.targetStack = null;
            this.outputStack = null;
            return new class_2813(handler.field_7763, handler.method_37421(), 1, 0, class_1713.field_7794, class_1799.field_8037, (Int2ObjectMap)changedSlots);
        }
        if (this.targetStack != null) {
            class_10291.class_10293 available = this.mc.field_1687.method_8433().method_64677().method_64714(this.targetStack);
            class_10352 contextParameterMap = class_10363.method_65008((class_1937)this.mc.field_1687);
            for (int n = 0; n < available.comp_3255().size(); ++n) {
                class_10291.class_10292 entry = (class_10291.class_10292)available.comp_3255().get(n);
                class_1799 recipeStack = entry.comp_3254().comp_3251().method_64742(contextParameterMap);
                if (recipeStack.method_7960() || !((List)this.itemList.get()).contains(recipeStack.method_7909())) continue;
                this.outputStack = recipeStack;
                return new class_2811(handler.field_7763, n);
            }
        } else {
            for (int n = 2; n < this.mc.field_1724.method_31548().field_7547.size() + 2; ++n) {
                class_1799 stack;
                if (this.processedSlots.contains(n) || !this.isValidItem(stack = handler.method_7611(n).method_7677())) continue;
                this.targetStack = stack;
                this.processedSlots.add(0);
                this.processedSlots.add(n);
                this.projectedEmpty.add(n);
                changedSlots.put(0, (Object)stack);
                changedSlots.put(n, (Object)class_1799.field_8037);
                return new class_2813(handler.field_7763, handler.method_37421(), n, 0, class_1713.field_7794, class_1799.field_8037, (Int2ObjectMap)changedSlots);
            }
        }
        return null;
    }

    private int predictEmptySlot(class_3971 handler) {
        if (this.mc.field_1724 == null) {
            return -1;
        }
        for (int n = this.mc.field_1724.method_31548().field_7547.size() + 1; n >= 2; --n) {
            if (this.processedSlots.contains(n) && !this.projectedEmpty.contains(n)) continue;
            if (this.projectedEmpty.contains(n)) {
                this.projectedEmpty.rem(n);
                return n;
            }
            if (!handler.method_7611(n).method_7677().method_7960()) continue;
            this.processedSlots.add(n);
            return n;
        }
        return -1;
    }

    private boolean hasValidItems(class_3971 handler) {
        if (this.mc.field_1724 == null) {
            return false;
        }
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size() + 2; ++n) {
            if (n == 1 || !this.isValidItem(handler.method_7611(n).method_7677())) continue;
            return true;
        }
        return false;
    }

    private boolean isValidItem(class_1799 stack) {
        if (((List)this.itemList.get()).isEmpty()) {
            return false;
        }
        if (stack.method_7960() || stack.method_31574(class_1802.field_8162)) {
            return false;
        }
        if (!StonecutterUtil.STONECUTTER_BLOCKS.containsKey((Object)stack.method_7909())) {
            return false;
        }
        return ((ReferenceSet)StonecutterUtil.STONECUTTER_BLOCKS.get((Object)stack.method_7909())).stream().anyMatch(item -> ((List)this.itemList.get()).contains(item));
    }

    public static enum Mode {
        Packet,
        Interact;

    }
}

