/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.util.MsgUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.entity.Target;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.WireframeEntityRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1474;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5762;
import net.minecraft.class_9334;

public class AxolotlTools
extends Module {
    private final SettingGroup sgEsp;
    private final SettingGroup sgAuto;
    private final SettingGroup sgVariantChoices;
    private final Setting<Boolean> espVariants;
    private final Setting<Boolean> espTracers;
    private final Setting<EspMode> espMode;
    private final Setting<Integer> sidesAlpha;
    private final Setting<Integer> linesAlpha;
    private final Setting<AxolotlMode> axolotlMode;
    private final Setting<Boolean> catchBabies;
    private final Setting<Boolean> onlyCatchBabies;
    private final Setting<Boolean> feedBabies;
    private final Setting<Boolean> onlyFeedBabies;
    private final Setting<InteractionMode> interactionMode;
    private final Setting<Boolean> fillBuckets;
    private final Setting<Boolean> emptyBuckets;
    private final Setting<Boolean> catchFish;
    private final Setting<Boolean> fishFarm;
    private final Setting<Integer> tickRate;
    private final Setting<VariantBehavior> interactPink;
    private final Setting<VariantBehavior> interactWild;
    private final Setting<VariantBehavior> interactGold;
    private final Setting<VariantBehavior> interactCyan;
    private final Setting<VariantBehavior> interactBlue;
    private int timer;
    private int rotPriority;
    private final Set<String> interactVariants;

    public AxolotlTools() {
        super(Stardust.CATEGORY, "AxolotlTools", "Extrasensory perception for axolotl variants, auto-collector & auto-breeder.");
        this.sgEsp = this.settings.createGroup("Esp Settings");
        this.sgAuto = this.settings.createGroup("AutoCatch/Breed Settings");
        this.sgVariantChoices = this.settings.createGroup("Variant Settings");
        this.espVariants = this.sgEsp.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ESP")).description("Extrasensory perception for axolotl variants.")).defaultValue((Object)true)).build());
        this.espTracers = this.sgEsp.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).defaultValue((Object)true)).visible(() -> this.espVariants.get())).build());
        this.espMode = this.sgEsp.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("wireframe-mode")).defaultValue((Object)EspMode.Both)).visible(() -> this.espVariants.get())).build());
        this.sidesAlpha = this.sgEsp.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("sides-alpha")).range(0, 255).sliderRange(0, 255).defaultValue((Object)69)).visible(() -> this.espVariants.get())).build());
        this.linesAlpha = this.sgEsp.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("lines-alpha")).range(0, 255).sliderRange(0, 255).defaultValue((Object)137)).visible(() -> this.espVariants.get())).build());
        this.axolotlMode = this.sgAuto.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("axolotl-mode")).description("Axolotl interaction mode. Catch them, breed them, or do nothing (which allows catching fish instead.)")).defaultValue((Object)AxolotlMode.None)).onChanged(it -> {
            if (it != AxolotlMode.None) {
                this.disableFishModes();
            }
        })).build());
        this.catchBabies = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("catch-baby-axolotls")).description("Automatically catch nearby baby axolotls in water buckets (works in catch mode.)")).defaultValue((Object)false)).visible(() -> ((AxolotlMode)((Object)((Object)this.axolotlMode.get()))).equals((Object)AxolotlMode.Catch))).build());
        this.onlyCatchBabies = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-catch-babies")).defaultValue((Object)false)).visible(() -> (Boolean)this.catchBabies.get() != false && this.catchBabies.isVisible())).build());
        this.feedBabies = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("feed-baby-axolotls")).description("Feed baby axolotls buckets of tropical fish to make them grow up faster (works in breed mode.)")).defaultValue((Object)false)).visible(() -> ((AxolotlMode)((Object)((Object)this.axolotlMode.get()))).equals((Object)AxolotlMode.Breed))).build());
        this.onlyFeedBabies = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-feed-babies")).description("Feed baby axolotls buckets of tropical fish to make them grow up faster (works in breed mode.)")).defaultValue((Object)false)).visible(() -> (Boolean)this.feedBabies.get() != false && this.feedBabies.isVisible())).build());
        this.interactionMode = this.sgAuto.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("interaction-mode")).description("Full uses spoofed rotations while Trigger handles the interaction when you look at a valid entity.")).defaultValue((Object)InteractionMode.Trigger)).build());
        this.fillBuckets = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fill-buckets")).description("Automatically fill empty buckets before catching axolotls or tropical fish.")).defaultValue((Object)false)).visible(() -> ((InteractionMode)((Object)((Object)this.interactionMode.get()))).equals((Object)InteractionMode.Full))).build());
        this.emptyBuckets = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("empty-buckets")).description("Automatically empty buckets of water after feeding axolotls the fish they contained.")).defaultValue((Object)false)).visible(() -> ((InteractionMode)((Object)((Object)this.interactionMode.get()))).equals((Object)InteractionMode.Full))).build());
        this.catchFish = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("catch-tropical-fish")).description("Automatically catch nearby tropical fish in water buckets.")).defaultValue((Object)true)).visible(() -> ((AxolotlMode)((Object)((Object)this.axolotlMode.get()))).equals((Object)AxolotlMode.None))).build());
        this.fishFarm = this.sgAuto.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("farm-tropical-fish")).description("Automatically afk-farm buckets of tropical fish (requires a farming setup.)")).defaultValue((Object)false)).visible(() -> this.catchFish.isVisible() && (Boolean)this.catchFish.get() != false)).build());
        this.tickRate = this.sgAuto.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("tick-rate")).description("Lower values have a higher chance of rejecting & desyncing your interactions. 10+ recommended for Full mode.")).range(2, 10000).sliderRange(5, 100).defaultValue((Object)10)).build());
        this.interactPink = this.sgVariantChoices.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("pink-variant")).description("Esp and/or automatically interact with nearby pink axolotl variants.")).defaultValue((Object)VariantBehavior.Both)).onChanged(it -> {
            if (it == VariantBehavior.Both || it == VariantBehavior.Interact) {
                this.interactVariants.add(class_5762.class_5767.field_28341.toString());
            } else {
                this.interactVariants.remove(class_5762.class_5767.field_28341.toString());
            }
        })).build());
        this.interactWild = this.sgVariantChoices.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("brown-variant")).description("Esp and/or automatically interact with nearby brown axolotl variants.")).defaultValue((Object)VariantBehavior.Both)).onChanged(it -> {
            if (it == VariantBehavior.Both || it == VariantBehavior.Interact) {
                this.interactVariants.add(class_5762.class_5767.field_28342.toString());
            } else {
                this.interactVariants.remove(class_5762.class_5767.field_28342.toString());
            }
        })).build());
        this.interactGold = this.sgVariantChoices.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("gold-variant")).description("Esp and/or automatically interact with nearby gold axolotl variants.")).defaultValue((Object)VariantBehavior.Both)).onChanged(it -> {
            if (it == VariantBehavior.Both || it == VariantBehavior.Interact) {
                this.interactVariants.add(class_5762.class_5767.field_28343.toString());
            } else {
                this.interactVariants.remove(class_5762.class_5767.field_28343.toString());
            }
        })).build());
        this.interactCyan = this.sgVariantChoices.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("cyan-variant")).description("Esp and/or automatically interact with nearby cyan axolotl variants.")).defaultValue((Object)VariantBehavior.Both)).onChanged(it -> {
            if (it == VariantBehavior.Both || it == VariantBehavior.Interact) {
                this.interactVariants.add(class_5762.class_5767.field_28344.toString());
            } else {
                this.interactVariants.remove(class_5762.class_5767.field_28344.toString());
            }
        })).build());
        this.interactBlue = this.sgVariantChoices.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("blue-variant")).description("Esp and/or automatically interact with nearby blue axolotl variants.")).defaultValue((Object)VariantBehavior.Both)).onChanged(it -> {
            if (it == VariantBehavior.Both || it == VariantBehavior.Interact) {
                this.interactVariants.add(class_5762.class_5767.field_28345.toString());
            } else {
                this.interactVariants.remove(class_5762.class_5767.field_28345.toString());
            }
        })).build());
        this.timer = 0;
        this.rotPriority = 69420;
        this.interactVariants = new HashSet<String>();
    }

    private void disableFishModes() {
        this.fishFarm.set((Object)false);
        this.catchFish.set((Object)false);
    }

    private boolean hasEmptySlots() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
            if (!this.mc.field_1724.method_31548().method_5438(n).method_7960()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNoValidBucket(class_1792 bucketType) {
        if (this.mc.field_1724 == null) {
            return true;
        }
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
            if (this.mc.field_1724.method_31548().method_5438(n).method_7909() != bucketType) continue;
            return false;
        }
        return true;
    }

    private boolean trySwapValidBucket(class_1792 bucketType) {
        if (this.mc.field_1724 == null) {
            return false;
        }
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
            if (stack.method_7909() != bucketType) continue;
            if (n < 9) {
                InvUtils.swap((int)n, (boolean)false);
            } else {
                InvUtils.move().from(n).to(this.mc.field_1724.method_31548().field_7545);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private class_2338 getNearbyWaterSource(boolean toEmpty) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return null;
        }
        for (class_2338 pos : class_2338.method_25996((class_2338)this.mc.field_1724.method_24515(), (int)4, (int)(toEmpty ? 1 : 4), (int)4)) {
            if (this.mc.field_1687.method_8316(pos).method_15772() != class_3612.field_15910) continue;
            return pos;
        }
        return null;
    }

    private <T extends class_1309> boolean tryInteractMobFull(T entity, class_1792 bucketType) {
        if (this.mc.field_1761 == null) {
            return true;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return true;
        }
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
            if (stack.method_7909() != bucketType) continue;
            if (n != this.mc.field_1724.method_31548().field_7545) {
                if (n < 9) {
                    InvUtils.swap((int)n, (boolean)false);
                } else {
                    InvUtils.move().from(n).to(this.mc.field_1724.method_31548().field_7545);
                }
            }
            AtomicReference result = new AtomicReference();
            Rotations.rotate((double)Rotations.getYaw(entity), (double)Rotations.getPitch(entity, (Target)Target.Body), (int)this.rotPriority, () -> result.set(this.mc.field_1761.method_2905((class_1657)this.mc.field_1724, (class_1297)entity, class_1268.field_5808)));
            ++this.rotPriority;
            return result.get() == class_1269.field_5812 || result.get() == class_1269.field_21466;
        }
        MsgUtil.updateModuleMsg("No valid bucket types found in inventory\u00a7c..!", this.name, "noBucketFound".hashCode());
        return false;
    }

    private <T extends class_1309> boolean tryInteractMobTrigger(T entity, class_1792 bucketType) {
        class_1269 result;
        if (this.mc.field_1761 == null) {
            return true;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return true;
        }
        class_1799 currentStack = this.mc.field_1724.method_6047();
        if (currentStack.method_7909() != bucketType) {
            boolean foundBucket = false;
            for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
                class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
                if (stack.method_7909() != bucketType) continue;
                foundBucket = true;
                if (n < 9) {
                    InvUtils.swap((int)n, (boolean)false);
                    break;
                }
                InvUtils.move().from(n).to(this.mc.field_1724.method_31548().field_7545);
                break;
            }
            if (!foundBucket) {
                if (!((Boolean)this.fishFarm.get()).booleanValue()) {
                    MsgUtil.updateModuleMsg("No valid bucket types found in inventory\u00a7c..!", this.name, "noBucketFound".hashCode());
                }
                return false;
            }
        }
        return (result = this.mc.field_1761.method_2905((class_1657)this.mc.field_1724, entity, class_1268.field_5808)) == class_1269.field_5812 || result == class_1269.field_21466;
    }

    public void onActivate() {
        switch (((VariantBehavior)((Object)this.interactPink.get())).ordinal()) {
            case 1: 
            case 2: {
                this.interactVariants.add(class_5762.class_5767.field_28341.toString());
            }
        }
        switch (((VariantBehavior)((Object)this.interactWild.get())).ordinal()) {
            case 1: 
            case 2: {
                this.interactVariants.add(class_5762.class_5767.field_28342.toString());
            }
        }
        switch (((VariantBehavior)((Object)this.interactGold.get())).ordinal()) {
            case 1: 
            case 2: {
                this.interactVariants.add(class_5762.class_5767.field_28343.toString());
            }
        }
        switch (((VariantBehavior)((Object)this.interactCyan.get())).ordinal()) {
            case 1: 
            case 2: {
                this.interactVariants.add(class_5762.class_5767.field_28344.toString());
            }
        }
        switch (((VariantBehavior)((Object)this.interactBlue.get())).ordinal()) {
            case 1: 
            case 2: {
                this.interactVariants.add(class_5762.class_5767.field_28345.toString());
            }
        }
    }

    public void onDeactivate() {
        this.timer = 0;
        this.rotPriority = 69420;
        this.interactVariants.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1761 == null) {
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (this.axolotlMode.get() == AxolotlMode.None && !((Boolean)this.catchFish.get()).booleanValue()) {
            return;
        }
        class_1799 current = this.mc.field_1724.method_31548().method_7391();
        if ((current.method_57826(class_9334.field_50075) || Utils.isThrowable((class_1792)current.method_7909())) && this.mc.field_1724.method_6048() > 0) {
            ++this.timer;
            return;
        }
        if (this.timer >= (Integer)this.tickRate.get()) {
            class_1297 class_12972;
            class_5762 target;
            double d;
            List nearby;
            this.timer = 0;
            if (this.axolotlMode.get() != AxolotlMode.None) {
                switch (((InteractionMode)((Object)this.interactionMode.get())).ordinal()) {
                    case 0: {
                        class_2338 source;
                        if (this.axolotlMode.get() == AxolotlMode.Release) {
                            class_2338 source2 = this.getNearbyWaterSource(true);
                            if (current.method_7909() != class_1802.field_28354) {
                                if (this.trySwapValidBucket(class_1802.field_28354)) {
                                    this.timer = (Integer)this.tickRate.get() - 1;
                                    return;
                                }
                            } else if (source2 != null) {
                                Rotations.rotate((double)Rotations.getYaw((class_2338)source2), (double)Rotations.getPitch((class_2338)source2), (int)69420, () -> this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808));
                                ++this.timer;
                                return;
                            }
                        }
                        nearby = this.mc.field_1687.method_8390(class_5762.class, this.mc.field_1724.method_5829().method_1014(this.mc.field_1724.method_55755() * this.mc.field_1724.method_55755()), ax -> {
                            if (this.interactVariants.contains(ax.method_33225().toString()) && this.axolotlMode.get() == AxolotlMode.Catch) {
                                if (((Boolean)this.catchBabies.get()).booleanValue()) {
                                    if ((Boolean)this.onlyCatchBabies.get() == false) return true;
                                    if (ax.method_6109()) {
                                        return true;
                                    }
                                } else if (!ax.method_6109()) return true;
                            }
                            if (this.axolotlMode.get() != AxolotlMode.Breed) return false;
                            if (((Boolean)this.feedBabies.get()).booleanValue()) {
                                if ((Boolean)this.onlyFeedBabies.get() == false) return true;
                                if (!ax.method_6109()) return false;
                                return true;
                            } else if (ax.method_6109()) return false;
                            return true;
                        });
                        d = Double.MAX_VALUE;
                        target = null;
                        for (class_5762 ax2 : nearby) {
                            if (!(this.mc.field_1724.method_33571().method_1025(ax2.method_19538()) < d)) continue;
                            target = ax2;
                            d = this.mc.field_1724.method_33571().method_1025(ax2.method_19538());
                        }
                        if (target == null) break;
                        if (this.axolotlMode.get() == AxolotlMode.Catch) {
                            if (((Boolean)this.fillBuckets.get()).booleanValue() && this.hasNoValidBucket(class_1802.field_8705) && current.method_7909() != class_1802.field_8550) {
                                if (this.trySwapValidBucket(class_1802.field_8550)) {
                                    this.timer = (Integer)this.tickRate.get() - 1;
                                    return;
                                }
                            } else if (((Boolean)this.fillBuckets.get()).booleanValue() && this.hasNoValidBucket(class_1802.field_8705) && current.method_7909() == class_1802.field_8550) {
                                source = this.getNearbyWaterSource(false);
                                if (source != null && (this.hasEmptySlots() || current.method_7947() == 1)) {
                                    Rotations.rotate((double)Rotations.getYaw((class_2338)source), (double)Rotations.getPitch((class_2338)source), (int)69420, () -> this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808));
                                    ++this.timer;
                                    return;
                                }
                                MsgUtil.updateModuleMsg("Full inventory prevents auto-filling buckets\u00a7c..!", this.name, "fullInventoryWarning".hashCode());
                            }
                            if (!this.tryInteractMobFull(target, class_1802.field_8705)) break;
                            return;
                        }
                        if (this.axolotlMode.get() != AxolotlMode.Breed) break;
                        if (this.tryInteractMobFull(target, class_1802.field_8478)) {
                            return;
                        }
                        if (!((Boolean)this.emptyBuckets.get()).booleanValue() || !this.hasNoValidBucket(class_1802.field_8478)) break;
                        if (current.method_7909() != class_1802.field_8705) {
                            if (!this.trySwapValidBucket(class_1802.field_8705)) break;
                            this.timer = (Integer)this.tickRate.get() - 1;
                            return;
                        }
                        source = this.getNearbyWaterSource(true);
                        if (source == null) break;
                        Rotations.rotate((double)Rotations.getYaw((class_2338)source), (double)Rotations.getPitch((class_2338)source), (int)69420, () -> this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808));
                        ++this.timer;
                        return;
                    }
                    case 1: {
                        class_3965 hit;
                        if (this.mc.field_1765 != null && this.mc.field_1765.method_17783() == class_239.class_240.field_1331) {
                            class_3966 hit2 = (class_3966)this.mc.field_1765;
                            class_12972 = hit2.method_17782();
                            if (!(class_12972 instanceof class_5762)) break;
                            class_5762 axolotl = (class_5762)class_12972;
                            if (this.axolotlMode.get() == AxolotlMode.Catch) {
                                if (!((Boolean)this.catchBabies.get()).booleanValue() && axolotl.method_6109()) {
                                    return;
                                }
                                if (((Boolean)this.catchBabies.get()).booleanValue() && ((Boolean)this.onlyCatchBabies.get()).booleanValue() && !axolotl.method_6109()) {
                                    return;
                                }
                                if (!this.interactVariants.contains(axolotl.method_33225().toString())) {
                                    return;
                                }
                                if (!this.tryInteractMobTrigger(axolotl, class_1802.field_8705)) break;
                                return;
                            }
                            if (this.axolotlMode.get() != AxolotlMode.Breed) break;
                            if (!((Boolean)this.feedBabies.get()).booleanValue() && axolotl.method_6109()) {
                                return;
                            }
                            if (((Boolean)this.feedBabies.get()).booleanValue() && ((Boolean)this.onlyFeedBabies.get()).booleanValue() && !axolotl.method_6109()) {
                                return;
                            }
                            if (!this.interactVariants.contains(axolotl.method_33225().toString())) {
                                return;
                            }
                            if (this.tryInteractMobTrigger(axolotl, class_1802.field_8478)) {
                                return;
                            }
                            MsgUtil.updateModuleMsg("That axolotl isn't ready to eat yet\u00a7c..!", this.name, "breedingCooldownUpdate".hashCode());
                            break;
                        }
                        if (this.axolotlMode.get() != AxolotlMode.Release) break;
                        class_1297 camera = this.mc.field_1719;
                        if (camera == null) {
                            return;
                        }
                        class_239 result = camera.method_5745(3.0, 0.0f, true);
                        if (result.method_17783() != class_239.class_240.field_1332 || this.mc.field_1687.method_8316((hit = (class_3965)result).method_17777()).method_15772() != class_3612.field_15910) break;
                        if (current.method_7909() != class_1802.field_28354) {
                            if (!this.trySwapValidBucket(class_1802.field_28354)) break;
                            this.timer = (Integer)this.tickRate.get() - 1;
                            return;
                        }
                        this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808);
                    }
                }
            }
            if (((Boolean)this.catchFish.get()).booleanValue()) {
                switch (((InteractionMode)((Object)this.interactionMode.get())).ordinal()) {
                    case 0: {
                        nearby = this.mc.field_1687.method_8390(class_1474.class, this.mc.field_1724.method_5829().method_1014(this.mc.field_1724.method_55755() * this.mc.field_1724.method_55755()), fishy -> fishy.method_24515().method_19771((class_2382)this.mc.field_1724.method_24515(), 3.0));
                        d = Double.MAX_VALUE;
                        target = null;
                        for (class_1474 fish : nearby) {
                            if (!(this.mc.field_1724.method_33571().method_1025(fish.method_19538()) < d)) continue;
                            target = fish;
                            d = this.mc.field_1724.method_33571().method_1025(fish.method_19538());
                        }
                        if (target == null || !this.tryInteractMobFull(target, class_1802.field_8705)) break;
                        return;
                    }
                    case 1: {
                        class_1474 fishy2;
                        class_3966 hit;
                        if (((Boolean)this.fishFarm.get()).booleanValue()) {
                            if (current.method_7909() != class_1802.field_8550 && this.hasNoValidBucket(class_1802.field_8705)) {
                                this.trySwapValidBucket(class_1802.field_8550);
                            }
                            if (current.method_7909() == class_1802.field_8550 && this.hasNoValidBucket(class_1802.field_8705)) {
                                if (this.hasEmptySlots() || current.method_7947() == 1) {
                                    this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808);
                                } else {
                                    MsgUtil.updateModuleMsg("Full inventory prevents auto-filling buckets\u00a7c..!", this.name, "fullInventoryWarning".hashCode());
                                }
                                ++this.timer;
                                return;
                            }
                            if (!this.hasNoValidBucket(class_1802.field_8478)) {
                                for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
                                    if (this.mc.field_1724.method_31548().method_5438(n).method_7909() != class_1802.field_8478) continue;
                                    InvUtils.drop().slot(n);
                                    ++this.timer;
                                    return;
                                }
                            }
                        }
                        if (this.mc.field_1765 == null || this.mc.field_1765.method_17783() != class_239.class_240.field_1331 || !((class_12972 = (hit = (class_3966)this.mc.field_1765).method_17782()) instanceof class_1474) || !this.tryInteractMobTrigger(fishy2 = (class_1474)class_12972, class_1802.field_8705)) break;
                        return;
                    }
                }
            }
        }
        ++this.timer;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (!((Boolean)this.espVariants.get()).booleanValue()) {
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        List<Object> axolotls = new ArrayList();
        for (class_1297 class_12972 : this.mc.field_1687.method_18112()) {
            if (!(class_12972 instanceof class_5762)) continue;
            class_5762 axolotl = (class_5762)class_12972;
            axolotls.add(axolotl);
        }
        axolotls = axolotls.stream().filter(ax -> ax.method_24515().method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.mc.field_1690.method_42503().method_41753() * 16))).toList();
        block28: for (class_5762 class_57622 : axolotls) {
            SettingColor sideColor;
            SettingColor lineColor = switch (class_57622.method_33225()) {
                case class_5762.class_5767.field_28341 -> {
                    switch (((VariantBehavior)((Object)this.interactPink.get())).ordinal()) {
                        case 1: 
                        case 3: {
                            continue block28;
                        }
                    }
                    sideColor = new SettingColor(224, 173, 203, ((Integer)this.sidesAlpha.get()).intValue());
                    yield new SettingColor(147, 81, 110, ((Integer)this.linesAlpha.get()).intValue());
                }
                case class_5762.class_5767.field_28342 -> {
                    switch (((VariantBehavior)((Object)this.interactWild.get())).ordinal()) {
                        case 1: 
                        case 3: {
                            continue block28;
                        }
                    }
                    sideColor = new SettingColor(136, 100, 69, ((Integer)this.sidesAlpha.get()).intValue());
                    yield new SettingColor(75, 57, 40, ((Integer)this.linesAlpha.get()).intValue());
                }
                case class_5762.class_5767.field_28343 -> {
                    switch (((VariantBehavior)((Object)this.interactGold.get())).ordinal()) {
                        case 1: 
                        case 3: {
                            continue block28;
                        }
                    }
                    sideColor = new SettingColor(241, 198, 26, ((Integer)this.sidesAlpha.get()).intValue());
                    yield new SettingColor(197, 150, 19, ((Integer)this.linesAlpha.get()).intValue());
                }
                case class_5762.class_5767.field_28344 -> {
                    switch (((VariantBehavior)((Object)this.interactCyan.get())).ordinal()) {
                        case 1: 
                        case 3: {
                            continue block28;
                        }
                    }
                    sideColor = new SettingColor(198, 209, 224, ((Integer)this.sidesAlpha.get()).intValue());
                    yield new SettingColor(77, 138, 174, ((Integer)this.linesAlpha.get()).intValue());
                }
                case class_5762.class_5767.field_28345 -> {
                    switch (((VariantBehavior)((Object)this.interactBlue.get())).ordinal()) {
                        case 1: 
                        case 3: {
                            continue block28;
                        }
                    }
                    sideColor = new SettingColor(52, 40, 121, ((Integer)this.sidesAlpha.get()).intValue());
                    yield new SettingColor(188, 114, 34, ((Integer)this.linesAlpha.get()).intValue());
                }
                default -> {
                    sideColor = new SettingColor(109, 181, 148, ((Integer)this.sidesAlpha.get()).intValue());
                    yield new SettingColor(77, 124, 103, ((Integer)this.linesAlpha.get()).intValue());
                }
            };
            switch (((EspMode)((Object)this.espMode.get())).ordinal()) {
                case 1: {
                    WireframeEntityRenderer.render((Render3DEvent)event, (class_1297)class_57622, (double)1.0, (Color)sideColor, (Color)lineColor, (ShapeMode)ShapeMode.Lines);
                    break;
                }
                case 0: {
                    WireframeEntityRenderer.render((Render3DEvent)event, (class_1297)class_57622, (double)1.0, (Color)sideColor, (Color)lineColor, (ShapeMode)ShapeMode.Sides);
                    break;
                }
                case 2: {
                    WireframeEntityRenderer.render((Render3DEvent)event, (class_1297)class_57622, (double)1.0, (Color)sideColor, (Color)lineColor, (ShapeMode)ShapeMode.Both);
                    break;
                }
            }
            if (!((Boolean)this.espTracers.get()).booleanValue()) continue;
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, class_57622.method_5829().method_1005().field_1352, class_57622.method_5829().method_1005().field_1351, class_57622.method_5829().method_1005().field_1350, (Color)lineColor);
        }
    }

    public static enum EspMode {
        Sides,
        Lines,
        Both,
        None;

    }

    public static enum AxolotlMode {
        None,
        Breed,
        Catch,
        Release;

    }

    public static enum InteractionMode {
        Full,
        Trigger;

    }

    public static enum VariantBehavior {
        Esp,
        Interact,
        Both,
        None;

    }
}

