/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.util.Optional;
import meteordevelopment.meteorclient.events.entity.player.InteractBlockEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_9307;

public class BannerData
extends Module {
    private final Setting<StardustUtil.TextFormat> textFormatSetting;
    private final Setting<StardustUtil.TextColor> flairColor;
    private final Setting<Boolean> bannerNameOnly;
    private final Setting<Boolean> signData;
    private final Setting<Boolean> copyToClipboard;
    private int timer;
    private class_2338 lastEventPos;

    public BannerData() {
        super(Stardust.CATEGORY, "BannerData", "View fancy-formatted NBT data for banners.");
        this.textFormatSetting = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("text-formatting")).description("Apply formatting to displayed NBT text.")).defaultValue((Object)StardustUtil.TextFormat.Italic)).build());
        this.flairColor = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("accent-color")).defaultValue((Object)StardustUtil.TextColor.Random)).build());
        this.bannerNameOnly = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("names-only")).description("Display banner names on right click only.")).defaultValue((Object)false)).build());
        this.signData = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sign-data")).description("Display NBT data when right clicking signs.")).defaultValue((Object)false)).build());
        this.copyToClipboard = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("copy-to-clipboard")).description("Copy NBT data to your clipboard.")).defaultValue((Object)false)).build());
        this.timer = 0;
        this.lastEventPos = new class_2338(0, 0, 0);
    }

    private String patternNameFromAssetID(String id) {
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        for (char c : id.toCharArray()) {
            if (capitalize) {
                sb.append(Character.toUpperCase(c));
                capitalize = false;
                continue;
            }
            if (c == '_') {
                sb.append(' ');
                capitalize = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void onDeactivate() {
        this.timer = 0;
    }

    @EventHandler
    private void onRightClickBlock(InteractBlockEvent event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        class_3965 result = event.result;
        if (this.isActive() && result.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = result.method_17777();
            class_2586 blockEntity = this.mc.field_1687.method_8321(pos);
            if (blockEntity == null) {
                return;
            }
            if (this.lastEventPos == pos) {
                return;
            }
            if (blockEntity instanceof class_2573) {
                class_2573 banner = (class_2573)blockEntity;
                StringBuilder customName = new StringBuilder();
                if (banner.method_5797() != null) {
                    banner.method_5797().method_27657(it -> {
                        customName.append(it);
                        return Optional.empty();
                    });
                }
                String bannerName = customName.toString();
                Object baseColor = banner.method_10908().name();
                baseColor = ((String)baseColor).charAt(0) + ((String)baseColor).substring(1).toLowerCase();
                class_9307 patterns = banner.method_58122();
                String txtFormat = ((StardustUtil.TextFormat)((Object)this.textFormatSetting.get())).label;
                StringBuilder patternsList = new StringBuilder();
                String cc = ((StardustUtil.TextColor)((Object)this.flairColor.get())).label;
                if (cc.equals(StardustUtil.TextColor.Random.label)) {
                    cc = StardustUtil.rCC();
                }
                if (!bannerName.trim().isEmpty()) {
                    patternsList.append("\u00a78<").append(cc).append("\u00a7o\u2728\u00a7r\u00a78> ").append(cc).append(txtFormat).append(bannerName);
                } else {
                    patternsList.append("\u00a78<").append(cc).append("\u00a7o\u2728\u00a7r\u00a78> ").append(cc).append(txtFormat).append((String)baseColor).append(" Banner");
                }
                if (!((Boolean)this.bannerNameOnly.get()).booleanValue()) {
                    patternsList.append("\n\u00a7r");
                    patternsList.append(cc).append("   \u25e6 ").append("\u00a77").append(txtFormat).append((String)baseColor).append(" ").append("Base").append("\n");
                    for (class_9307.class_9308 layer : patterns.comp_2428()) {
                        String patternColor = layer.comp_2430().name().charAt(0) + layer.comp_2430().name().substring(1).toLowerCase();
                        if (patternColor.contains("_")) {
                            int i = patternColor.indexOf("_");
                            patternColor = patternColor.substring(0, i) + " " + patternColor.substring(i + 1, i + 2).toUpperCase() + patternColor.substring(i + 2);
                        }
                        patternsList.append(cc).append("   \u25e6 ").append("\u00a77").append(txtFormat).append(patternColor).append(" ").append(this.patternNameFromAssetID(((class_2582)layer.comp_2429().comp_349()).comp_2456().method_12832())).append("\n");
                    }
                }
                String bannerData = patternsList.toString().trim();
                MsgUtil.sendRawMsg(bannerData);
                if (((Boolean)this.copyToClipboard.get()).booleanValue()) {
                    this.mc.field_1774.method_1455(patterns.toString());
                    MsgUtil.updateModuleMsg(txtFormat + "Copied NBT data to clipboard\u00a78.", this.name, "clipboardUpdate".hashCode());
                }
                this.lastEventPos = pos;
            } else if (blockEntity instanceof class_2625) {
                class_2625 sign = (class_2625)blockEntity;
                if (!((Boolean)this.signData.get()).booleanValue()) {
                    return;
                }
                class_2487 metadata = sign.method_38244((class_7225.class_7874)this.mc.field_1687.method_30349());
                if (((Boolean)this.copyToClipboard.get()).booleanValue()) {
                    this.mc.field_1774.method_1455(metadata.toString());
                    MsgUtil.updateModuleMsg("\u00a7oCopied NBT data to clipboard\u00a78\u00a7o..!", this.name, "bdclipboardUpdate".hashCode());
                } else {
                    MsgUtil.sendMsg(metadata.toString());
                }
                this.lastEventPos = pos;
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        ++this.timer;
        if (this.timer >= 20) {
            this.timer = 0;
            this.lastEventPos = this.lastEventPos.method_10069(2000000, 2000000, 2000000);
        }
    }
}

