/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.config.StardustConfig;
import dev.stardust.mixin.accessor.DisconnectS2CPacketAccessor;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MapUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.File;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.mixininterface.IChatHud;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.GenericSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.render.blockesp.ESPBlockData;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_265;
import net.minecraft.class_2661;
import net.minecraft.class_2680;
import net.minecraft.class_2724;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4719;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_746;

public class ChatSigns
extends Module {
    private final String BLACKLIST_FILE = "meteor-client/chatsigns-blacklist.txt";
    private final SettingGroup modesGroup = this.settings.createGroup("Modes", true);
    private final SettingGroup formatGroup = this.settings.createGroup("Formatting", true);
    private final SettingGroup oldSignGroup = this.settings.createGroup("OldSigns Settings", true);
    private final SettingGroup blacklistGroup = this.settings.createGroup("SignText Blacklist", true);
    private final SettingGroup signBoardGroup = this.settings.createGroup("Sign Cluster Settings", true);
    private final Setting<ChatMode> chatMode = this.modesGroup.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("chat-mode")).description("ESP = nearby only, Targeted = looking at only")).defaultValue((Object)ChatMode.Both)).build());
    private final Setting<RepeatMode> repeatMode = this.modesGroup.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("repeat-mode")).description("How to handle repeating signs you're actively looking at.")).defaultValue((Object)RepeatMode.Cooldown)).visible(() -> this.chatMode.get() != ChatMode.ESP)).build());
    private final Setting<Integer> repeatSeconds = this.modesGroup.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("repeat-cooldown")).description("Value in seconds to wait before repeating looked-at signs.")).visible(() -> this.repeatMode.get() == RepeatMode.Cooldown && this.repeatMode.isVisible())).range(1, 3600).sliderRange(1, 120).defaultValue((Object)10)).build());
    private final Setting<Integer> chatSpeed = this.modesGroup.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("chat-speed")).description("How many ticks to wait before printing the next encountered sign into chat.")).range(0, 500).sliderRange(0, 100).defaultValue((Object)0)).build());
    private final Setting<Boolean> showOldSigns = this.oldSignGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-old-signs*")).description("*will show signs placed before 1.8, AND after 1.19. Use your best judgment to determine what's legit.")).defaultValue((Object)false)).build());
    private final Setting<Boolean> onlyOldSigns = this.oldSignGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-show-old-signs")).description("Only display text from signs that are either really old, or really new.")).defaultValue((Object)false)).visible(() -> this.showOldSigns.get())).build());
    private final Setting<Boolean> ignoreNether = this.oldSignGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-nether")).description("Ignore potentially-old signs in the nether (near highways they're all certainly new.)")).visible(() -> this.showOldSigns.get())).defaultValue((Object)true)).build());
    private final Setting<Boolean> ignoreDuplicates = this.modesGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-duplicates")).description("Ignore duplicate signs instead of displaying them with a counter.")).defaultValue((Object)false)).build());
    private final Setting<StardustUtil.TextColor> signColor = this.formatGroup.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sign-color")).description("The color of displayed sign text.")).defaultValue((Object)StardustUtil.TextColor.Light_Gray)).build());
    private final Setting<StardustUtil.TextFormat> textFormat = this.formatGroup.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("text-formatting")).description("Apply formatting to displayed sign text.")).defaultValue((Object)StardustUtil.TextFormat.Italic)).build());
    private final Setting<StardustUtil.TextColor> oldSignColor = this.oldSignGroup.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("old-sign-color")).description("Text color for signs that might be old.")).defaultValue((Object)StardustUtil.TextColor.Yellow)).visible(() -> this.showOldSigns.get())).build());
    private final Setting<StardustUtil.TextFormat> oldSignFormat = this.oldSignGroup.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("old-text-format")).description("Apply formatting to text displayed from (maybe) old signs.")).defaultValue((Object)StardustUtil.TextFormat.Italic)).visible(() -> this.showOldSigns.get())).build());
    private final Setting<Boolean> chatFormat = this.formatGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fancy-display")).description("Displays each line of the sign on separate lines in chat.")).defaultValue((Object)false)).build());
    private final Setting<Boolean> showCoords = this.formatGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-coordinates")).description("Display sign coordinates in chat.")).defaultValue((Object)false)).build());
    private final Setting<Boolean> renderOldSigns = this.oldSignGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("oldSign-ESP")).description("Render signs which could be old through walls.")).defaultValue((Object)false)).build());
    private final Setting<ESPBlockData> espSettings = this.oldSignGroup.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("ESP-settings")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(147, 233, 190, 255), new SettingColor(147, 233, 190, 25), true, new SettingColor(147, 233, 190, 125)))).build());
    private final Setting<ESPBlockData> clickESPSettings = this.formatGroup.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("clickESP-settings")).description("Click on a chat entry to ESP the sign it belongs to. Click again or toggle the module to disable.")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(51, 102, 102, 255), new SettingColor(51, 102, 102, 25), true, new SettingColor(51, 102, 102, 137)))).build());
    private final Setting<Integer> clickESPTimeout = this.formatGroup.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("clickESP-timeout-seconds")).description("Automatic timeout for active ClickESP entries. Set to 0 in order to disable timeout.")).range(0, 1200).sliderRange(0, 120).defaultValue((Object)30)).build());
    private final Setting<Boolean> signBoardWaypoints = this.signBoardGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("signBoard-waypoints")).description("Adds waypoints to your Xaeros map when a cluster of signs is rendered.")).defaultValue((Object)false)).visible(() -> StardustUtil.XAERO_AVAILABLE)).build());
    private final Setting<Boolean> temporaryWaypoints = this.signBoardGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("temporary-waypoints")).description("Temporary waypoints are cleared when you disconnect from the server or close the game.")).defaultValue((Object)true)).visible(() -> StardustUtil.XAERO_AVAILABLE && (Boolean)this.signBoardWaypoints.get() != false)).build());
    private final Setting<Boolean> waypointsIgnoreEmpty = this.signBoardGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("waypoints-ignore-empty")).description("If enabled, empty signs will not count towards a cluster waypoint.")).defaultValue((Object)true)).visible(() -> StardustUtil.XAERO_AVAILABLE && (Boolean)this.signBoardWaypoints.get() != false)).build());
    private final Setting<Boolean> waypointsIgnoreBlacklist = this.signBoardGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("waypoints-ignore-blacklist")).description("If enabled, signs containing blocked text will still count towards the waypoint cluster.")).defaultValue((Object)false)).visible(() -> StardustUtil.XAERO_AVAILABLE && (Boolean)this.signBoardWaypoints.get() != false)).build());
    private final Setting<Integer> signBoardWaypointsAmount = this.signBoardGroup.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("signBoard-waypoints-amount")).description("The amount of signs to trigger adding a waypoint.")).range(1, 1200).sliderRange(1, 120).defaultValue((Object)3)).visible(() -> StardustUtil.XAERO_AVAILABLE && (Boolean)this.signBoardWaypoints.get() != false)).build());
    private final Setting<Boolean> signBoardAutoLog = this.signBoardGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("signBoard-autoDisconnect")).description("Disconnect from the server when you render a cluster of signs.")).defaultValue((Object)false)).build());
    private final Setting<Boolean> forceKick = this.signBoardGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("force-kick")).description("Forces the server to kick you by sending an illegal packet.")).defaultValue((Object)false)).build());
    private final Setting<Integer> signBoardAutoLogAmount = this.signBoardGroup.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("signBoard-autoLog-threshold")).description("The amount of signs to trigger a disconnect.")).range(1, 1200).sliderRange(1, 120).defaultValue((Object)5)).build());
    private final Setting<Boolean> signBlacklist = this.blacklistGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("signText-blacklist")).description("Ignore signs that contain specific text (line-separated list in chatsigns-blacklist.txt)")).defaultValue((Object)false)).onChanged(it -> {
        if (it.booleanValue() && this.isActive() && StardustUtil.checkOrCreateFile(this.mc, "meteor-client/chatsigns-blacklist.txt")) {
            this.blacklisted.clear();
            this.initBlacklistText();
            if (this.mc.field_1724 != null) {
                MsgUtil.sendMsg("Please write one blacklisted item for each line of the file.");
                MsgUtil.sendMsg("Spaces and other punctuation will be treated literally.");
                MsgUtil.sendMsg("Toggle the ChatSigns module after updating the file's contents.");
            }
        }
    })).build());
    private final Setting<Boolean> caseSensitive = this.blacklistGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("case-sensitive-blacklist")).description("Force matches in the blacklist file to be case-sensitive.")).defaultValue((Object)false)).visible(() -> this.signBlacklist.get())).build());
    private final Setting<Boolean> openBlacklistFile = this.blacklistGroup.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("open-blacklist-file")).description("Open the chatsigns-blacklist.txt file.")).defaultValue((Object)false)).visible(() -> this.signBlacklist.get())).onChanged(it -> {
        if (it.booleanValue()) {
            if (StardustUtil.checkOrCreateFile(this.mc, "meteor-client/chatsigns-blacklist.txt")) {
                this.openBlacklistFile();
            } else {
                this.resetBlacklistFileSetting();
            }
        }
    })).build());
    private int timer = 0;
    private int chatTimer = 0;
    private int clusterAmount = 0;
    private int fullClusterAmount = 0;
    private int emptyClusterAmount = 0;
    @Nullable
    private class_2561 disconnectReason = null;
    @Nullable
    private class_2338 lastFocusedSign = null;
    @Nullable
    private class_2338 lastFullClusterPos = null;
    @Nullable
    private class_2338 lastEmptyClusterPos = null;
    private final HashSet<class_2338> posSet = new HashSet();
    private final HashSet<class_2338> oldSet = new HashSet();
    private final ArrayList<String> blacklisted = new ArrayList();
    private final ArrayDeque<ChatSignsJob> jobQueue = new ArrayDeque();
    private final HashMap<class_2338, Instant> cooldowns = new HashMap();
    private final HashMap<String, Integer> signMessages = new HashMap();
    private final HashMap<class_1923, Boolean> chunkCache = new HashMap();
    private final HashMap<class_2338, Long> signsToHighlight = new HashMap();
    private final Pattern fullYearsPattern = Pattern.compile("202[0-9]");
    private final Pattern fullDatesPattern = Pattern.compile("\\b(\\d{1,2}[-/\\. _,'+]\\d{1,2}[-/\\. _,'+]\\d{2,4}|\\d{4}[-/\\. _,'+]\\d{1,2}[-/\\. _,'+]\\d{1,2})\\b");

    public ChatSigns() {
        super(Stardust.CATEGORY, "ChatSigns", "Read nearby signs in your chat.");
    }

    @Nullable
    private class_2338 getTargetedSign() {
        class_2338 pos;
        class_746 player = this.mc.field_1724;
        if (player == null || this.mc.field_1687 == null) {
            return null;
        }
        int viewDistance = (Integer)this.mc.field_1690.method_42503().method_41753();
        double maxRangeBlocks = viewDistance * 16;
        class_239 trace = this.mc.method_1560().method_5745(maxRangeBlocks, 0.0f, false);
        if (trace != null && this.mc.field_1687.method_8321(pos = ((class_3965)trace).method_17777()) instanceof class_2625) {
            return pos;
        }
        return null;
    }

    private ArrayList<class_2625> getNearbySigns(class_2818 chunk) {
        ArrayList<class_2625> signs = new ArrayList<class_2625>();
        Map blockEntities = chunk.method_12214();
        if (blockEntities == null) {
            return signs;
        }
        blockEntities.forEach((pos, entity) -> {
            if (entity instanceof class_2625) {
                class_2625 sbe = (class_2625)entity;
                signs.add(sbe);
            }
        });
        return signs;
    }

    private boolean isSignEmpty(class_2625 sbe) {
        return !sbe.method_49853().method_49861((class_1657)this.mc.field_1724) && !sbe.method_49854().method_49861((class_1657)this.mc.field_1724);
    }

    @Nullable
    private LocalDate parseDate(String dateStr) {
        String[] formats;
        String[] delimiters = new String[]{".", "-", "_", ",", "'", "+", "\\"};
        for (String format : formats = new String[]{"M/d/yy", "M/dd/yy", "MM/d/yy", "MM/dd/yy", "M/d/yyyy", "M/dd/yyyy", "MM/d/yyyy", "MM/dd/yyyy", "d/M/yy", "d/MM/yy", "dd/M/yy", "dd/MM/yy", "d/M/yyyy", "d/MM/yyyy", "dd/M/yyyy", "dd/MM/yyyy", "yyyy/M/d", "yyyy/MM/d", "yyyy/M/dd", "yyyy/MM/dd", "yyyy/d/M", "yyyy/dd/M", "yyyy/d/MM", "yyyy/dd/MM"}) {
            LocalDate date = null;
            try {
                date = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(format));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (date != null) {
                return date;
            }
            for (String delimiter : delimiters) {
                String fmt = format.replace("/", delimiter);
                try {
                    date = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(fmt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (date == null) continue;
                return date;
            }
        }
        return null;
    }

    private String formatSignText(class_2625 sign, class_2818 chunk) {
        String signText;
        if (this.mc.field_1687 == null || this.isSignEmpty(sign)) {
            return "";
        }
        ArrayList lines = new ArrayList();
        String color = ((StardustUtil.TextColor)((Object)this.signColor.get())).label;
        String format = ((StardustUtil.TextFormat)((Object)this.textFormat.get())).label;
        for (class_2561 line : sign.method_49853().method_49877(false)) {
            line.method_27657(msg -> {
                if (((Boolean)this.chatFormat.get()).booleanValue()) {
                    lines.add(msg);
                } else {
                    lines.add(msg.trim());
                }
                return Optional.empty();
            });
        }
        boolean couldBeOld = false;
        class_5321 dimension = this.mc.field_1687.method_27983();
        if (!(dimension == class_1937.field_25180 && ((Boolean)this.ignoreNether.get()).booleanValue() || String.join((CharSequence)" ", lines).contains("**Pre-1.19 Sign restored by 0xTas' SignHistorian**"))) {
            String testString;
            Matcher fullYearsMatcher;
            class_2487 metadata;
            class_4719 woodType = class_4719.field_40350;
            class_2248 block = sign.method_11010().method_26204();
            if (block instanceof class_2508) {
                class_2508 signBlock = (class_2508)block;
                woodType = signBlock.method_24025();
            } else if (block instanceof class_2551) {
                class_2551 wallSignBlock = (class_2551)block;
                woodType = wallSignBlock.method_24025();
            }
            if (!(woodType != class_4719.field_21676 || (metadata = sign.method_38244((class_7225.class_7874)this.mc.field_1687.method_30349())).toString().contains("{\"extra\":[") || lines.isEmpty() || (fullYearsMatcher = this.fullYearsPattern.matcher(testString = String.join((CharSequence)" ", lines))).find())) {
                boolean invalidDate = false;
                Matcher dateMatcher = this.fullDatesPattern.matcher(testString);
                while (dateMatcher.find()) {
                    String dateStr = dateMatcher.group();
                    LocalDate date = this.parseDate(dateStr);
                    if (date == null || date.getYear() <= 2015) continue;
                    invalidDate = true;
                }
                if (!invalidDate) {
                    boolean bl = couldBeOld = !this.inNewChunk(chunk, this.mc, (class_5321<class_1937>)dimension);
                }
            }
        }
        if (!couldBeOld && ((Boolean)this.showOldSigns.get()).booleanValue() && ((Boolean)this.onlyOldSigns.get()).booleanValue()) {
            return "";
        }
        if (couldBeOld && ((Boolean)this.showOldSigns.get()).booleanValue()) {
            color = ((StardustUtil.TextColor)((Object)this.oldSignColor.get())).label;
            this.oldSet.add(sign.method_11016());
        }
        String string = signText = (Boolean)this.chatFormat.get() != false ? String.join((CharSequence)("\n" + color + format), lines) : String.join((CharSequence)" ", lines);
        if (signText.trim().isEmpty()) {
            return "";
        }
        StringBuilder txt = new StringBuilder();
        if (((Boolean)this.showOldSigns.get()).booleanValue() && couldBeOld) {
            txt.append("\u00a78<\u00a7o").append(StardustUtil.rCC()).append("\u2728\u00a7r\u00a78> ");
            txt.append("\u00a78[\u00a74Old\u00a77..\u00a7a?\u00a78] ");
            if (((Boolean)this.chatFormat.get()).booleanValue()) {
                txt.append("\n     ");
            }
            txt.append(((StardustUtil.TextColor)((Object)this.oldSignColor.get())).label).append(((StardustUtil.TextFormat)((Object)this.oldSignFormat.get())).label).append((Boolean)this.chatFormat.get() != false ? signText.replace("\n", "\n     ") : signText.trim());
        } else {
            txt.append("\u00a78<\u00a7o").append(StardustUtil.rCC()).append((Boolean)this.chatFormat.get() != false ? "\u2728\u00a7r\u00a78>\n      " : "\u2728\u00a7r\u00a78> ");
            txt.append(color).append(format).append((Boolean)this.chatFormat.get() != false ? signText.replace("\n", "\n     ") : signText.trim());
        }
        if (((Boolean)this.showCoords.get()).booleanValue()) {
            class_2338 pos = sign.method_11016();
            txt.append((Boolean)this.chatFormat.get() != false ? "\n\u00a78[" : " \u00a78[").append(color).append(pos.method_10263()).append("\u00a78, ").append(color).append(pos.method_10264()).append("\u00a78, ").append(color).append(pos.method_10260()).append("\u00a7r\u00a78]");
        }
        return txt.toString();
    }

    private boolean inNewChunk(class_2818 chunk, class_310 mc, class_5321<class_1937> dimension) {
        if (mc.field_1687 == null) {
            return false;
        }
        class_1923 chunkPos = chunk.method_12004();
        if (this.chunkCache.containsKey(chunkPos)) {
            return this.chunkCache.get(chunkPos);
        }
        if (dimension == class_1937.field_25180) {
            class_2338 startPosDebris = chunkPos.method_35231(0, 0, 0);
            class_2338 endPosDebris = chunkPos.method_35231(15, 118, 15);
            int newBlocks = 0;
            for (class_2338 pos : class_2338.method_10097((class_2338)startPosDebris, (class_2338)endPosDebris)) {
                if (newBlocks >= 13) {
                    this.chunkCache.put(chunkPos, true);
                    return true;
                }
                class_2248 block = mc.field_1687.method_8320(pos).method_26204();
                if (block != class_2246.field_22109 && block != class_2246.field_23869 && block != class_2246.field_22091 && block != class_2246.field_22113 && block != class_2246.field_22120 && block != class_2246.field_22090) continue;
                ++newBlocks;
            }
            this.chunkCache.put(chunkPos, newBlocks >= 13);
            return newBlocks >= 13;
        }
        if (dimension == class_1937.field_25179) {
            class_2338 startPosAltStones = chunkPos.method_35231(0, 0, 0);
            class_2338 endPosAltStones = chunkPos.method_35231(15, 128, 15);
            int newBlocks = 0;
            for (class_2338 pos : class_2338.method_10097((class_2338)startPosAltStones, (class_2338)endPosAltStones)) {
                if (newBlocks >= 33) {
                    this.chunkCache.put(chunkPos, true);
                    return true;
                }
                class_2248 block = mc.field_1687.method_8320(pos).method_26204();
                if (block != class_2246.field_10115 && block != class_2246.field_10474 && block != class_2246.field_10508) continue;
                ++newBlocks;
            }
            this.chunkCache.put(chunkPos, newBlocks >= 33);
            return newBlocks >= 33;
        }
        if (dimension == class_1937.field_25181) {
            class_5321 biome = mc.field_1687.method_23753(new class_2338(chunkPos.method_33940(), 64, chunkPos.method_33942())).method_40230().orElse(class_1972.field_34471);
            boolean bl = biome != class_1972.field_9411 && biome != class_1972.field_9451;
            this.chunkCache.put(chunkPos, bl);
            return bl;
        }
        this.chunkCache.put(chunkPos, true);
        return true;
    }

    private void chatSigns(List<class_2625> signs, class_2818 chunk, class_310 mc) {
        if (mc.field_1687 == null || signs.isEmpty()) {
            return;
        }
        signs.forEach(sign -> {
            ++this.clusterAmount;
            String textOnSign = Arrays.stream(sign.method_49853().method_49877(false)).map(class_2561::getString).collect(Collectors.joining(" ")).trim();
            if (this.signMessages.containsKey(textOnSign) && ((Boolean)this.ignoreDuplicates.get()).booleanValue()) {
                ++this.fullClusterAmount;
                this.lastFullClusterPos = sign.method_11016();
                return;
            }
            if (this.chatMode.get() == ChatMode.ESP && this.posSet.contains(sign.method_11016())) {
                return;
            }
            if (this.chatMode.get() == ChatMode.Both && this.posSet.contains(sign.method_11016()) && !sign.method_11016().equals((Object)this.lastFocusedSign)) {
                return;
            }
            Object msg = this.formatSignText((class_2625)sign, chunk);
            this.posSet.add(sign.method_11016());
            if (((String)msg).isBlank()) {
                ++this.emptyClusterAmount;
                this.lastEmptyClusterPos = sign.method_11016();
                return;
            }
            if (((Boolean)this.signBlacklist.get()).booleanValue() && !this.blacklisted.isEmpty()) {
                if (((Boolean)this.caseSensitive.get()).booleanValue()) {
                    if (this.blacklisted.stream().anyMatch(line -> textOnSign.contains(line.trim()))) {
                        if (((Boolean)this.waypointsIgnoreBlacklist.get()).booleanValue()) {
                            ++this.fullClusterAmount;
                            this.lastFullClusterPos = sign.method_11016();
                        }
                        return;
                    }
                } else if (this.blacklisted.stream().anyMatch(line -> textOnSign.toLowerCase().contains(line.trim().toLowerCase()))) {
                    if (((Boolean)this.waypointsIgnoreBlacklist.get()).booleanValue()) {
                        ++this.fullClusterAmount;
                        this.lastFullClusterPos = sign.method_11016();
                    }
                    return;
                }
            }
            ++this.fullClusterAmount;
            this.lastFullClusterPos = sign.method_11016();
            class_2583 clickESP = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "clickESP~chatSigns~" + sign.method_11016().method_10063())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(this.signsToHighlight.containsKey(sign.method_11016()) ? "\u00a74\u00a7oDisable \u00a77\u00a7oESP for this sign." : "\u00a72\u00a7oEnable \u00a77\u00a7oESP for this sign."))));
            if (this.signMessages.containsKey(textOnSign) && !sign.method_11016().equals((Object)this.lastFocusedSign)) {
                int timesSeen = this.signMessages.get(textOnSign) + 1;
                this.signMessages.put(textOnSign, timesSeen);
                msg = (String)msg + " \u00a78[\u00a77\u00a7ox\u00a74\u00a7o" + timesSeen + "\u00a7r\u00a78]";
                this.jobQueue.removeIf(job -> job.hashcode == textOnSign.hashCode());
            } else {
                this.signMessages.put(textOnSign, 1);
            }
            if ((Integer)this.chatSpeed.get() > 0) {
                this.jobQueue.add(new ChatSignsJob((class_2561)class_2561.method_43470((String)msg).method_10862(clickESP), textOnSign.hashCode()));
            } else {
                ((IChatHud)mc.field_1705.method_1743()).meteor$add((class_2561)class_2561.method_43470((String)msg).method_10862(clickESP), textOnSign.hashCode());
            }
        });
    }

    private void initBlacklistText() {
        File blackListFile = FabricLoader.getInstance().getGameDir().resolve("meteor-client/chatsigns-blacklist.txt").toFile();
        try (Stream<String> lineStream = Files.lines(blackListFile.toPath());){
            this.blacklisted.addAll(lineStream.toList());
        }
        catch (Exception err) {
            LogUtil.error("Failed to read from " + blackListFile.getAbsolutePath() + "! - Why: " + String.valueOf(err), this.name);
        }
    }

    private void openBlacklistFile() {
        this.resetBlacklistFileSetting();
        StardustUtil.openFile("meteor-client/chatsigns-blacklist.txt");
    }

    private void resetBlacklistFileSetting() {
        this.openBlacklistFile.set((Object)false);
    }

    public boolean toggleClickESP(class_2338 pos, long timestamp) {
        if (this.signsToHighlight.containsKey(pos)) {
            this.signsToHighlight.remove(pos);
            return false;
        }
        this.signsToHighlight.put(pos, timestamp);
        return true;
    }

    private class_243 getTracerOffset(class_2680 state, class_2338 pos) {
        double offsetZ;
        double offsetY;
        double offsetX;
        block9: {
            try {
                if (state.method_26204() instanceof class_2551) {
                    class_2350 facing = (class_2350)state.method_11654((class_2769)class_2551.field_11726);
                    switch (facing) {
                        case field_11043: {
                            offsetX = (double)pos.method_10263() + 0.5;
                            offsetY = (double)pos.method_10264() + 0.5;
                            offsetZ = (double)pos.method_10260() + 0.937;
                            break;
                        }
                        case field_11034: {
                            offsetX = (double)pos.method_10263() + 0.1337;
                            offsetY = (double)pos.method_10264() + 0.5;
                            offsetZ = (double)pos.method_10260() + 0.5;
                            break;
                        }
                        case field_11035: {
                            offsetX = (double)pos.method_10263() + 0.5;
                            offsetY = (double)pos.method_10264() + 0.5;
                            offsetZ = (double)pos.method_10260() + 0.1337;
                            break;
                        }
                        case field_11039: {
                            offsetX = (double)pos.method_10263() + 0.937;
                            offsetY = (double)pos.method_10264() + 0.5;
                            offsetZ = (double)pos.method_10260() + 0.5;
                            break;
                        }
                        default: {
                            offsetX = (double)pos.method_10263() + 0.5;
                            offsetY = (double)pos.method_10264() + 0.5;
                            offsetZ = (double)pos.method_10260() + 0.5;
                            break;
                        }
                    }
                    break block9;
                }
                return class_243.method_24953((class_2382)pos);
            }
            catch (Exception err) {
                LogUtil.error("Failed to get tracer offset. Why: " + String.valueOf(err), this.name);
                return class_243.method_24953((class_2382)pos);
            }
        }
        return new class_243(offsetX, offsetY, offsetZ);
    }

    private void doForceKick(class_2561 reason) {
        this.disconnectReason = reason;
        StardustUtil.illegalDisconnect(true, (StardustUtil.IllegalDisconnectMethod)((Object)StardustConfig.illegalDisconnectMethodSetting.get()));
    }

    public void onActivate() {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.signBlacklist.get()).booleanValue() && StardustUtil.checkOrCreateFile(this.mc, "meteor-client/chatsigns-blacklist.txt")) {
            this.initBlacklistText();
        }
        class_2338 pos = this.mc.field_1724.method_24515();
        if (this.chatMode.get() == ChatMode.ESP || this.chatMode.get() == ChatMode.Both) {
            int viewDistance = (Integer)this.mc.field_1690.method_42503().method_41753();
            int startChunkX = pos.method_10263() - viewDistance * 16 >> 4;
            int endChunkX = pos.method_10263() + viewDistance * 16 >> 4;
            int startChunkZ = pos.method_10260() - viewDistance * 16 >> 4;
            int endChunkZ = pos.method_10260() + viewDistance * 16 >> 4;
            for (int x = startChunkX; x < endChunkX; ++x) {
                for (int z = startChunkZ; z < endChunkZ; ++z) {
                    if (!this.mc.field_1687.method_8393(x, z)) continue;
                    class_2818 chunk = this.mc.field_1687.method_8497(x, z);
                    ArrayList<class_2625> signs = this.getNearbySigns(chunk);
                    this.chatSigns(signs, chunk, this.mc);
                }
            }
        }
    }

    public void onDeactivate() {
        this.timer = 0;
        this.chatTimer = 0;
        this.clusterAmount = 0;
        this.fullClusterAmount = 0;
        this.emptyClusterAmount = 0;
        this.posSet.clear();
        this.oldSet.clear();
        this.jobQueue.clear();
        this.cooldowns.clear();
        this.chunkCache.clear();
        this.blacklisted.clear();
        this.signMessages.clear();
        this.lastFocusedSign = null;
        this.disconnectReason = null;
        this.signsToHighlight.clear();
        this.lastFullClusterPos = null;
        this.lastEmptyClusterPos = null;
    }

    @EventHandler
    private void onPacketReceived(PacketEvent.Receive event) {
        class_2596 class_25962;
        if (this.disconnectReason != null && (class_25962 = event.packet) instanceof class_2661) {
            class_2661 packet = (class_2661)class_25962;
            ((DisconnectS2CPacketAccessor)packet).setReason(this.disconnectReason);
            this.signBoardAutoLog.set((Object)false);
            return;
        }
        if (!(event.packet instanceof class_2724)) {
            return;
        }
        this.posSet.clear();
        this.oldSet.clear();
        this.chunkCache.clear();
        this.signsToHighlight.clear();
    }

    @EventHandler
    private void onReceiveChunkData(ChunkDataEvent event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        if (this.chatMode.get() != ChatMode.Targeted) {
            ArrayList<class_2625> signs = this.getNearbySigns(event.chunk());
            this.chatSigns(signs, event.chunk(), this.mc);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (StardustUtil.XAERO_AVAILABLE && ((Boolean)this.signBoardWaypoints.get()).booleanValue()) {
            if (!((Boolean)this.waypointsIgnoreEmpty.get()).booleanValue() && this.emptyClusterAmount >= (Integer)this.signBoardWaypointsAmount.get() && this.lastEmptyClusterPos != null) {
                MapUtil.addWaypoint(this.lastEmptyClusterPos, "ChatSigns: Cluster of " + this.emptyClusterAmount + " Empty Signs (Likely Farm)", "\u26e8", MapUtil.Purpose.Normal, MapUtil.WpColor.Random, (Boolean)this.temporaryWaypoints.get());
                this.emptyClusterAmount = 0;
            }
            if (this.fullClusterAmount >= (Integer)this.signBoardWaypointsAmount.get() && this.lastFullClusterPos != null) {
                MapUtil.addWaypoint(this.lastFullClusterPos, "ChatSigns: Cluster of " + this.fullClusterAmount + " Signs", "\u2709", MapUtil.Purpose.Normal, MapUtil.WpColor.Random, (Boolean)this.temporaryWaypoints.get());
                this.fullClusterAmount = 0;
            }
        }
        if (((Boolean)this.signBoardAutoLog.get()).booleanValue() && this.clusterAmount >= (Integer)this.signBoardAutoLogAmount.get()) {
            class_5250 reason = class_2561.method_43470((String)("\u00a78[\u00a7a\u00a7oChatSigns\u00a78] \u00a77Disconnected you because you rendered a cluster of \u00a7a\u00a7o" + this.clusterAmount + " \u00a77signs\u00a7a!"));
            if (((Boolean)this.forceKick.get()).booleanValue()) {
                this.doForceKick((class_2561)reason);
            } else {
                this.signBoardAutoLog.set((Object)false);
                StardustUtil.disableAutoReconnect();
                this.mc.method_1562().method_52781(new class_2661((class_2561)reason));
            }
            this.toggle();
            return;
        }
        if (this.chatMode.get() == ChatMode.ESP) {
            return;
        }
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        if (this.timer >= 65535) {
            this.timer = 0;
        } else if (this.timer % 6000 == 0) {
            this.signMessages.clear();
        }
        ++this.timer;
        ++this.chatTimer;
        if (this.timer % 5 == 0) {
            this.timer = 0;
            this.clusterAmount = 0;
            this.fullClusterAmount = 0;
            this.emptyClusterAmount = 0;
            class_2338 targetedSign = this.getTargetedSign();
            if (targetedSign == null) {
                this.lastFocusedSign = null;
                return;
            }
            if (targetedSign.equals((Object)this.lastFocusedSign) && this.repeatMode.get() == RepeatMode.Focus) {
                return;
            }
            if (!targetedSign.equals((Object)this.lastFocusedSign)) {
                this.lastFocusedSign = targetedSign;
            }
            class_2818 chunk = this.mc.field_1687.method_8497(targetedSign.method_10263() >> 4, targetedSign.method_10260() >> 4);
            if (this.repeatMode.get() == RepeatMode.Cooldown) {
                if (this.cooldowns.containsKey(targetedSign)) {
                    now = Instant.now();
                    Instant stamp = this.cooldowns.get(targetedSign);
                    if (Duration.between(stamp, now).toSeconds() < (long)((Integer)this.repeatSeconds.get()).intValue()) {
                        return;
                    }
                    class_2586 class_25862 = this.mc.field_1687.method_8321(targetedSign);
                    if (class_25862 instanceof class_2625) {
                        class_2625 sign = (class_2625)class_25862;
                        this.chatSigns(List.of(sign), chunk, this.mc);
                    }
                } else {
                    now = this.mc.field_1687.method_8321(targetedSign);
                    if (now instanceof class_2625) {
                        sign = (class_2625)now;
                        this.chatSigns(List.of(sign), chunk, this.mc);
                    }
                }
            } else {
                sign = this.mc.field_1687.method_8321(targetedSign);
                if (sign instanceof class_2625) {
                    class_2625 sign = (class_2625)sign;
                    this.chatSigns(List.of(sign), chunk, this.mc);
                }
            }
            this.cooldowns.put(targetedSign, Instant.now());
            for (class_2586 be : Utils.blockEntities()) {
                class_2625 sbe;
                if (!(be instanceof class_2625) || this.posSet.contains((sbe = (class_2625)be).method_11016())) continue;
                class_2818 sbeChunk = this.mc.field_1687.method_8497(sbe.method_11016().method_10263() >> 4, sbe.method_11016().method_10260() >> 4);
                this.chatSigns(List.of(sbe), sbeChunk, this.mc);
            }
        }
        if (this.chatTimer >= (Integer)this.chatSpeed.get() && !this.jobQueue.isEmpty()) {
            this.chatTimer = 0;
            if ((Integer)this.chatSpeed.get() <= 0) {
                for (int n = 0; n < this.jobQueue.size(); ++n) {
                    ChatSignsJob job = this.jobQueue.removeFirst();
                    ((IChatHud)this.mc.field_1705.method_1743()).meteor$add(job.getMessage(), job.getHashcode());
                }
            } else {
                ChatSignsJob job = this.jobQueue.removeFirst();
                ((IChatHud)this.mc.field_1705.method_1743()).meteor$add(job.getMessage(), job.getHashcode());
            }
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        ESPBlockData highlight = (ESPBlockData)this.clickESPSettings.get();
        ArrayList<class_2338> signsToRemove = new ArrayList<class_2338>();
        if (!this.signsToHighlight.isEmpty()) {
            for (class_2338 p : this.signsToHighlight.keySet()) {
                long now;
                if ((Integer)this.clickESPTimeout.get() > 0 && (now = System.currentTimeMillis()) - this.signsToHighlight.get(p) >= (long)((Integer)this.clickESPTimeout.get() * 1000)) {
                    signsToRemove.add(p);
                    continue;
                }
                class_2680 state = this.mc.field_1687.method_8320(p);
                class_2586 sbe = this.mc.field_1687.method_8321(p);
                if (highlight.tracer && highlight.tracerColor.a > 0) {
                    class_243 offset = this.getTracerOffset(state, p);
                    event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, offset.method_10216(), offset.method_10214(), offset.method_10215(), (Color)highlight.tracerColor);
                }
                if (state == null || sbe == null || !(sbe instanceof class_2625)) continue;
                class_265 shape = state.method_26218((class_1922)this.mc.field_1687, p);
                double x1 = (double)p.method_10263() + shape.method_1091(class_2350.class_2351.field_11048);
                double y1 = (double)p.method_10264() + shape.method_1091(class_2350.class_2351.field_11052);
                double z1 = (double)p.method_10260() + shape.method_1091(class_2350.class_2351.field_11051);
                double x2 = (double)p.method_10263() + shape.method_1105(class_2350.class_2351.field_11048);
                double y2 = (double)p.method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
                double z2 = (double)p.method_10260() + shape.method_1105(class_2350.class_2351.field_11051);
                event.renderer.box(x1, y1, z1, x2, y2, z2, (Color)highlight.sideColor, (Color)highlight.lineColor, highlight.shapeMode, 0);
            }
            for (class_2338 p : signsToRemove) {
                this.signsToHighlight.remove(p);
            }
        }
        if (!((Boolean)this.renderOldSigns.get()).booleanValue()) {
            return;
        }
        List<class_2338> inRange = this.oldSet.stream().filter(pos -> pos.method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.mc.field_1690.method_42503().method_41753() * 16 + 32))).toList();
        ESPBlockData esp = (ESPBlockData)this.espSettings.get();
        for (class_2338 pos2 : inRange) {
            class_2680 state = this.mc.field_1687.method_8320(pos2);
            if (!(state.method_26204() instanceof class_2508) && !(state.method_26204() instanceof class_2551)) continue;
            class_265 shape = state.method_26218((class_1922)this.mc.field_1687, pos2);
            double x1 = (double)pos2.method_10263() + shape.method_1091(class_2350.class_2351.field_11048);
            double y1 = (double)pos2.method_10264() + shape.method_1091(class_2350.class_2351.field_11052);
            double z1 = (double)pos2.method_10260() + shape.method_1091(class_2350.class_2351.field_11051);
            double x2 = (double)pos2.method_10263() + shape.method_1105(class_2350.class_2351.field_11048);
            double y2 = (double)pos2.method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
            double z2 = (double)pos2.method_10260() + shape.method_1105(class_2350.class_2351.field_11051);
            event.renderer.box(x1, y1, z1, x2, y2, z2, (Color)esp.sideColor, (Color)esp.lineColor, esp.shapeMode, 0);
            if (!esp.tracer) continue;
            class_243 offsetVec = this.getTracerOffset(state, pos2);
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350, (Color)esp.tracerColor);
        }
    }

    public static enum ChatMode {
        ESP,
        Targeted,
        Both;

    }

    public static enum RepeatMode {
        Cooldown,
        Focus;

    }

    private record ChatSignsJob(class_2561 message, int hashcode) {
        public class_2561 getMessage() {
            return this.message;
        }

        public int getHashcode() {
            return this.hashcode;
        }
    }
}

