/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.mixin.accessor.ClientConnectionAccessor;
import dev.stardust.mixin.accessor.GrindstoneScreenHandlerAccessor;
import dev.stardust.util.MsgUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2813;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3802;
import net.minecraft.class_3803;
import net.minecraft.class_5321;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Grinder
extends Module {
    private final Setting<ModuleMode> moduleMode;
    private final Setting<List<class_1792>> itemList;
    private final Setting<Boolean> grindNamed;
    private final Setting<Boolean> combine;
    private final Setting<Boolean> muteGrindstone;
    private final Setting<Boolean> closeOnDone;
    private final Setting<Boolean> disableOnDone;
    private final Setting<Boolean> pingOnDone;
    private final Setting<Double> pingVolume;
    private final Setting<Integer> tickRate;
    private int timer;
    private boolean notified;
    @Nullable
    private class_1799 combinedItem;
    @Nullable
    private class_1799 currentTarget;
    private final IntArrayList projectedEmpty;
    private final IntArrayList processedSlots;

    public Grinder() {
        super(Stardust.CATEGORY, "Grinder", "Automatically grinds enchantments off of select items in the grindstone.");
        this.moduleMode = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Packet is faster but might also get you kicked in some scenarios.")).defaultValue((Object)ModuleMode.Packet)).build());
        this.itemList = this.settings.getDefaultGroup().add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("Items")).description("Items to automatically grind enchantments from.")).filter(item -> item.method_7854().method_7923()).build());
        this.grindNamed = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("grind-named-items")).description("Grind enchantments off of items which have a custom name applied to them.")).defaultValue((Object)false)).build());
        this.combine = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("combine-items")).description("Combines alike items in the grindstone in order to process them quicker. DESTROYS A PORTION OF THE INPUT ITEMS.")).defaultValue((Object)true)).build());
        this.muteGrindstone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mute-grindstone")).description("Mutes the grindstone sounds.")).defaultValue((Object)true)).build());
        this.closeOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("close-grindstone")).description("Automatically close the grindstone screen when no more enchantments can be removed.")).defaultValue((Object)true)).build());
        this.disableOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-on-done")).description("Automatically disable the module when no more enchantments can be removed.")).defaultValue((Object)false)).build());
        this.pingOnDone = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sound-ping")).description("Play a sound cue when there are no more enchantments to remove.")).defaultValue((Object)false)).build());
        this.pingVolume = this.settings.getDefaultGroup().add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("ping-volume")).sliderMin(0.0).sliderMax(5.0).defaultValue(0.5).visible(() -> this.pingOnDone.get())).build());
        this.tickRate = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("tick-rate")).description("Increase this if the server is kicking you.")).min(0).max(1000).sliderRange(0, 100).defaultValue((Object)2)).visible(() -> ((ModuleMode)((Object)((Object)this.moduleMode.get()))).equals((Object)ModuleMode.Interact))).build());
        this.timer = 0;
        this.notified = false;
        this.combinedItem = null;
        this.currentTarget = null;
        this.projectedEmpty = new IntArrayList();
        this.processedSlots = new IntArrayList();
    }

    private boolean hasValidItems(class_3803 handler) {
        if (this.mc.field_1724 == null) {
            return false;
        }
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size() + 3; ++n) {
            if (n == 2 || !this.isValidItem(handler.method_7611(n).method_7677())) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidEnchantments(class_1799 stack) {
        if (!stack.method_7942()) {
            return false;
        }
        Object2IntArrayMap enchants = new Object2IntArrayMap();
        Utils.getEnchantments((class_1799)stack, (Object2IntMap)enchants);
        if (enchants.size() == 1 && Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9113)) {
            return false;
        }
        if (enchants.size() == 1 && Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9109)) {
            return false;
        }
        if (enchants.size() == 2 && Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9113) && Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9109)) {
            return false;
        }
        return !enchants.isEmpty();
    }

    private boolean isValidItem(class_1799 item) {
        return ((List)this.itemList.get()).contains(item.method_7909()) && this.hasValidEnchantments(item) && ((Boolean)this.grindNamed.get() != false || !item.method_57826(class_9334.field_49631));
    }

    private int predictEmptySlot(class_3803 handler) {
        if (this.mc.field_1724 == null) {
            return -1;
        }
        for (int n = this.mc.field_1724.method_31548().field_7547.size() + 2; n >= 3; --n) {
            if (this.processedSlots.contains(n) && !this.projectedEmpty.contains(n)) continue;
            if (this.projectedEmpty.contains(n)) {
                this.projectedEmpty.rem(n);
                return n;
            }
            if (!handler.method_7611(n).method_7677().method_7960()) continue;
            this.processedSlots.add(n);
            return n;
        }
        return -1;
    }

    private void finished() {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (!this.notified) {
            if (this.chatFeedback) {
                MsgUtil.sendModuleMsg("No more enchantments to grind away\u00a7a..!", this.name);
            }
            if (((Boolean)this.pingOnDone.get()).booleanValue()) {
                this.mc.field_1724.method_5783(class_3417.field_14627, ((Double)this.pingVolume.get()).floatValue(), ThreadLocalRandom.current().nextFloat(0.69f, 1.337f));
            }
        }
        this.notified = true;
        this.processedSlots.clear();
        this.projectedEmpty.clear();
        if (((Boolean)this.closeOnDone.get()).booleanValue()) {
            this.mc.field_1724.method_7346();
        }
        if (((Boolean)this.disableOnDone.get()).booleanValue()) {
            this.toggle();
        }
    }

    @Nullable
    private class_2813 generatePacket(class_3803 handler) {
        if (this.mc.field_1724 == null) {
            return null;
        }
        Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap();
        if (this.currentTarget != null && this.combinedItem != null) {
            changedSlots.put(0, (Object)class_1799.field_8037);
            changedSlots.put(1, (Object)class_1799.field_8037);
            changedSlots.put(2, (Object)class_1799.field_8037);
            int shiftClickTargetSlot = this.predictEmptySlot(handler);
            if (shiftClickTargetSlot == -1) {
                MsgUtil.sendModuleMsg("Failed to predict empty target slot\u00a7c..!", this.name);
                return null;
            }
            if (this.combinedItem.method_7960()) {
                this.combinedItem = ((GrindstoneScreenHandlerAccessor)handler).invokeGrind(this.currentTarget);
            }
            changedSlots.put(shiftClickTargetSlot, (Object)this.combinedItem.method_7972());
            this.combinedItem = null;
            this.currentTarget = null;
            return new class_2813(handler.field_7763, handler.method_37421(), 2, 0, class_1713.field_7794, class_1799.field_8037, (Int2ObjectMap)changedSlots);
        }
        if (this.currentTarget != null) {
            for (int n = 3; n < this.mc.field_1724.method_31548().field_7547.size() + 3; ++n) {
                class_1799 stack;
                if (this.processedSlots.contains(n) || !this.isValidItem(stack = handler.method_7611(n).method_7677()) || !stack.method_31574(this.currentTarget.method_7909())) continue;
                class_3545<class_1799, Integer> combinedStackPlusDamage = this.combineStacks(handler, this.currentTarget, stack);
                this.combinedItem = (class_1799)combinedStackPlusDamage.method_15442();
                this.processedSlots.add(1);
                this.processedSlots.add(n);
                this.projectedEmpty.add(n);
                changedSlots.put(1, (Object)stack);
                changedSlots.put(n, (Object)class_1799.field_8037);
                changedSlots.put(2, (Object)((GrindstoneScreenHandlerAccessor)handler).invokeGrind(this.combinedItem));
                return new class_2813(handler.field_7763, handler.method_37421(), n, 0, class_1713.field_7794, class_1799.field_8037, (Int2ObjectMap)changedSlots);
            }
            this.combinedItem = class_1799.field_8037;
            return this.generatePacket(handler);
        }
        for (int n = 3; n < this.mc.field_1724.method_31548().field_7547.size() + 3; ++n) {
            class_1799 stack;
            if (this.processedSlots.contains(n) || !this.isValidItem(stack = handler.method_7611(n).method_7677())) continue;
            this.currentTarget = stack;
            this.processedSlots.add(0);
            this.processedSlots.add(n);
            this.projectedEmpty.add(n);
            changedSlots.put(0, (Object)stack);
            changedSlots.put(n, (Object)class_1799.field_8037);
            changedSlots.put(2, (Object)((GrindstoneScreenHandlerAccessor)handler).invokeGrind(stack));
            if (!((Boolean)this.combine.get()).booleanValue()) {
                this.combinedItem = class_1799.field_8037;
            }
            return new class_2813(handler.field_7763, handler.method_37421(), n, 0, class_1713.field_7794, class_1799.field_8037, (Int2ObjectMap)changedSlots);
        }
        return null;
    }

    private class_3545<class_1799, Integer> combineStacks(class_3803 handler, class_1799 stack1, class_1799 stack2) {
        if (!stack1.method_31574(stack2.method_7909())) {
            return new class_3545((Object)class_1799.field_8037, (Object)0);
        }
        int j = stack1.method_7936() - stack1.method_7919();
        int k = stack1.method_7936() - stack2.method_7919();
        int l = j + k + stack1.method_7936() * 5 / 100;
        int m = Math.max(stack1.method_7936() - l, 0);
        ((GrindstoneScreenHandlerAccessor)handler).invokeTransferEnchantments(stack1, stack2);
        return new class_3545((Object)stack1, (Object)m);
    }

    public void onDeactivate() {
        this.timer = 0;
        this.notified = false;
        this.combinedItem = null;
        this.currentTarget = null;
        this.projectedEmpty.clear();
        this.processedSlots.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.mc.field_1755 == null) {
            this.notified = false;
            return;
        }
        if (!(this.mc.field_1755 instanceof class_3802)) {
            return;
        }
        class_1703 class_17032 = this.mc.field_1724.field_7512;
        if (!(class_17032 instanceof class_3803)) {
            return;
        }
        class_3803 grindstone = (class_3803)class_17032;
        switch (((ModuleMode)((Object)this.moduleMode.get())).ordinal()) {
            case 0: {
                if (this.mc.method_1562() == null || this.notified) {
                    return;
                }
                ArrayDeque<class_2813> packets = new ArrayDeque<class_2813>();
                boolean exhausted = false;
                while (!exhausted) {
                    class_2813 packet = this.generatePacket(grindstone);
                    if (packet == null) {
                        exhausted = true;
                        continue;
                    }
                    packets.addLast(packet);
                }
                while (!packets.isEmpty()) {
                    ((ClientConnectionAccessor)this.mc.method_1562().method_48296()).invokeSendImmediately((class_2596)packets.removeFirst(), null, true);
                }
                this.finished();
                break;
            }
            case 1: {
                if (this.timer < (Integer)this.tickRate.get()) {
                    ++this.timer;
                    return;
                }
                this.timer = 0;
                class_1799 input1 = grindstone.method_7611(0).method_7677();
                class_1799 input2 = grindstone.method_7611(1).method_7677();
                class_1799 output = grindstone.method_7611(2).method_7677();
                if (!this.hasValidItems(grindstone)) {
                    this.finished();
                    break;
                }
                if (input1.method_7960() && input2.method_7960()) {
                    class_1792 turboItem = null;
                    for (int n = 3; n < this.mc.field_1724.method_31548().field_7547.size() + 3; ++n) {
                        class_1799 stack = grindstone.method_7611(n).method_7677();
                        if (!this.hasValidEnchantments(stack) || !((List)this.itemList.get()).contains(stack.method_7909()) || stack.method_57826(class_9334.field_49631) && !((Boolean)this.grindNamed.get()).booleanValue() || ((Boolean)this.combine.get()).booleanValue() && turboItem != null && stack.method_7909() != turboItem) continue;
                        if (!((Boolean)this.combine.get()).booleanValue()) {
                            InvUtils.shiftClick().slotId(n);
                            return;
                        }
                        if (turboItem != null) {
                            InvUtils.shiftClick().slotId(n);
                            return;
                        }
                        InvUtils.shiftClick().slotId(n);
                        turboItem = stack.method_7909();
                    }
                    if (((Boolean)this.combine.get()).booleanValue()) break;
                    this.finished();
                    break;
                }
                if (!output.method_7960() && (((List)this.itemList.get()).contains(input1.method_7909()) || ((List)this.itemList.get()).contains(input2.method_7909()))) {
                    if (!input1.method_7960()) {
                        if (input1.method_57826(class_9334.field_49631) && !((Boolean)this.grindNamed.get()).booleanValue()) break;
                        InvUtils.shiftClick().slotId(2);
                        break;
                    }
                    if (input2.method_7960() || input2.method_57826(class_9334.field_49631) && !((Boolean)this.grindNamed.get()).booleanValue()) break;
                    InvUtils.shiftClick().slotId(2);
                    break;
                }
                if (input1.method_7960() || input2.method_7960()) break;
                InvUtils.shiftClick().slotId(0);
                InvUtils.shiftClick().slotId(1);
            }
        }
    }

    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        class_2596 class_25962;
        if (!((Boolean)this.muteGrindstone.get()).booleanValue() || !((class_25962 = event.packet) instanceof class_2767)) {
            return;
        }
        class_2767 packet = (class_2767)class_25962;
        if (((class_3414)packet.method_11894().comp_349()).equals((Object)class_3417.field_16865)) {
            event.cancel();
        }
    }

    public static enum ModuleMode {
        Packet,
        Interact;

    }
}

