/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import dev.stardust.Stardust;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import oshi.util.tuples.Pair;

public class Loadouts
extends Module {
    public static final String LOADOUTS_FILE = "meteor-client/loadouts.json";
    public final Setting<Boolean> quickLoadout;
    private final Setting<Boolean> chatNotify;
    private final Setting<Boolean> debug;
    private final Setting<Integer> tickRateSetting;
    private int ticks;
    public boolean isSorted;
    private boolean doubleTap;
    private String activeLoadoutKey;
    private final ArrayDeque<Pair<Integer, Integer>> jobs;
    private final HashMap<String, HashMap<Integer, class_1792>> loadouts;

    public Loadouts() {
        super(Stardust.CATEGORY, "Loadouts", "Save and load inventory configurations.");
        this.quickLoadout = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("quick-loadout-buttons")).description("Adds quicksave loadout buttons to the inventory screen.")).defaultValue((Object)true)).build());
        this.chatNotify = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-notify")).description("Notify you in chat when your loadout is saved or loaded.")).defaultValue((Object)false)).build());
        this.debug = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("debug")).defaultValue((Object)false)).visible(() -> false)).build());
        this.tickRateSetting = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("tick-rate")).range(1, 50).sliderRange(1, 20).defaultValue((Object)3)).build());
        this.ticks = 0;
        this.isSorted = true;
        this.doubleTap = false;
        this.activeLoadoutKey = "quicksave";
        this.jobs = new ArrayDeque();
        this.loadouts = new HashMap();
    }

    public void onActivate() {
        this.loadLoadoutsFromFile();
    }

    public void onDeactivate() {
        this.ticks = 0;
        this.jobs.clear();
        this.isSorted = true;
        this.doubleTap = false;
        this.saveLoadoutsToFile();
        this.activeLoadoutKey = "quicksave";
    }

    public void clearLoadouts() {
        this.loadouts.clear();
        this.saveLoadoutsToFile();
    }

    public void deleteLoadout(String name) {
        this.loadouts.remove(name);
        this.saveLoadoutsToFile();
    }

    public boolean noLoadout(String name) {
        return !this.loadouts.containsKey(name);
    }

    private void loadLoadoutsFromFile() {
        if (!StardustUtil.checkOrCreateFile(this.mc, LOADOUTS_FILE)) {
            LogUtil.error("Error checking loadouts file for loading..!", this.name);
        }
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(LOADOUTS_FILE);){
            Type type = new TypeToken<HashMap<String, HashMap<Integer, String>>>(){}.getType();
            HashMap loaded = (HashMap)gson.fromJson((Reader)reader, type);
            this.loadouts.clear();
            for (Map.Entry entry : loaded.entrySet()) {
                HashMap<Integer, class_1792> itemMap = new HashMap<Integer, class_1792>();
                for (Map.Entry itemId : ((HashMap)entry.getValue()).entrySet()) {
                    itemMap.put((Integer)itemId.getKey(), (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)((String)itemId.getValue()))));
                }
                this.loadouts.put((String)entry.getKey(), itemMap);
                LogUtil.info("Successfully loaded loadouts from file..!", this.name);
            }
        }
        catch (Exception err) {
            LogUtil.error("Error loading loadouts from file..! - Why: " + String.valueOf(err), this.name);
        }
    }

    private void saveLoadoutsToFile() {
        if (!StardustUtil.checkOrCreateFile(this.mc, LOADOUTS_FILE)) {
            LogUtil.error("Error checking loadouts file for saving..!", this.name);
        }
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(LOADOUTS_FILE);){
            HashMap itemNameMap = new HashMap();
            for (Map.Entry<String, HashMap<Integer, class_1792>> entry : this.loadouts.entrySet()) {
                HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
                for (Map.Entry<Integer, class_1792> itemEntry : entry.getValue().entrySet()) {
                    nameMap.put(itemEntry.getKey(), class_7923.field_41178.method_10221((Object)itemEntry.getValue()).toString());
                }
                itemNameMap.put(entry.getKey(), nameMap);
            }
            gson.toJson(itemNameMap, (Appendable)writer);
            LogUtil.info("Successfully saved loadouts to file..!", this.name);
        }
        catch (Exception err) {
            LogUtil.error("Error saving loadouts to file..! - Why: " + String.valueOf(err), this.name);
        }
    }

    private boolean isLoaded(String loadoutKey) {
        if (this.loadouts.isEmpty()) {
            return true;
        }
        if (this.mc.field_1724 == null) {
            return true;
        }
        if (!this.loadouts.containsKey(loadoutKey)) {
            return true;
        }
        class_1703 class_17032 = this.mc.field_1724.field_7512;
        if (!(class_17032 instanceof class_1723)) {
            return true;
        }
        class_1723 handler = (class_1723)class_17032;
        HashMap<Integer, class_1792> loadout = this.loadouts.get(loadoutKey);
        for (int n = 5; n < handler.field_7761.size(); ++n) {
            class_1799 stack;
            if (!loadout.containsKey(n) || (stack = handler.method_7611(n).method_7677()).method_31574(loadout.get(n))) continue;
            return false;
        }
        return true;
    }

    public void saveLoadout(String name) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_1703 class_17032 = this.mc.field_1724.field_7512;
        if (!(class_17032 instanceof class_1723)) {
            return;
        }
        class_1723 handler = (class_1723)class_17032;
        HashMap<Integer, class_1792> loadout = new HashMap<Integer, class_1792>();
        for (int n = 5; n < handler.field_7761.size(); ++n) {
            class_1799 stack = handler.method_7611(n).method_7677();
            if (stack.method_7960() || stack.method_31574(class_1802.field_8162)) continue;
            loadout.put(n, stack.method_7909());
        }
        this.loadouts.put(name, loadout);
        this.saveLoadoutsToFile();
        if (((Boolean)this.chatNotify.get()).booleanValue()) {
            MsgUtil.sendModuleMsg("\u00a7oLoadout \"\u00a7a\u00a7o" + name + "\u00a77\u00a7o\" saved successfully\u00a78\u00a7o.", this.name);
        }
    }

    public void loadLoadout(String name) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_1703 class_17032 = this.mc.field_1724.field_7512;
        if (!(class_17032 instanceof class_1723)) {
            return;
        }
        class_1723 handler = (class_1723)class_17032;
        if (this.loadouts.isEmpty() || !this.loadouts.containsKey(name) || this.loadouts.get(name).isEmpty()) {
            MsgUtil.sendModuleMsg("\u00a7oNo loadout \"\u00a73\u00a7o" + name + "\u00a77\u00a7o\" saved\u00a7c\u00a7o..!", this.name);
            return;
        }
        this.jobs.clear();
        this.activeLoadoutKey = name;
        ArrayList<Integer> sorted = new ArrayList<Integer>();
        HashMap<Integer, class_1792> loadout = this.loadouts.get(name);
        HashMap<Integer, class_1799> changedSlots = new HashMap<Integer, class_1799>();
        block0: for (int to = 5; to < handler.field_7761.size(); ++to) {
            class_1792 assigned = loadout.get(to);
            if (assigned == null) continue;
            class_1799 current = handler.method_7611(to).method_7677();
            if (((Boolean)this.debug.get()).booleanValue()) {
                LogUtil.info("Assigned: " + assigned.method_63680().getString() + " | Current: " + current.method_7964().getString(), this.name);
            }
            if (current.method_31574(assigned)) {
                if (((Boolean)this.debug.get()).booleanValue()) {
                    LogUtil.info("Slot already sorted..!", this.name);
                }
                sorted.add(to);
                continue;
            }
            for (int from = 5; from < handler.field_7761.size(); ++from) {
                if (to == from || sorted.contains(from)) continue;
                class_1799 occupiedBy = changedSlots.containsKey(from) ? (class_1799)changedSlots.get(from) : handler.method_7611(from).method_7677();
                if (((Boolean)this.debug.get()).booleanValue()) {
                    LogUtil.info("Looking for: " + assigned.method_63680().getString() + " | found: " + occupiedBy.method_7964().getString(), this.name);
                }
                if (!occupiedBy.method_31574(assigned)) continue;
                if (loadout.get(from) != null && occupiedBy.method_31574(loadout.get(from))) {
                    sorted.add(from);
                    continue;
                }
                if (!current.method_7960()) {
                    sorted.add(to);
                    changedSlots.put(from, current);
                    this.jobs.addLast((Pair<Integer, Integer>)new Pair((Object)from, (Object)to));
                } else {
                    sorted.add(to);
                    sorted.add(from);
                    changedSlots.remove(from);
                    this.jobs.addLast((Pair<Integer, Integer>)new Pair((Object)from, (Object)to));
                }
                if (!((Boolean)this.debug.get()).booleanValue()) continue block0;
                LogUtil.info("Moving stack: " + occupiedBy.method_7964().getString() + " from slot " + from + " to slot " + to + "..!", this.name);
                continue block0;
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (!(this.mc.field_1724.field_7512 instanceof class_1723)) {
            return;
        }
        ++this.ticks;
        if (this.ticks >= (Integer)this.tickRateSetting.get()) {
            this.ticks = 0;
            if (!this.jobs.isEmpty()) {
                this.isSorted = false;
                Pair<Integer, Integer> entry = this.jobs.removeFirst();
                InvUtils.move().fromId(((Integer)entry.getA()).intValue()).toId(((Integer)entry.getB()).intValue());
            }
            if (this.jobs.isEmpty() && !this.isSorted) {
                if (!this.doubleTap && !this.isLoaded(this.activeLoadoutKey)) {
                    this.doubleTap = true;
                    this.loadLoadout(this.activeLoadoutKey);
                } else {
                    this.isSorted = true;
                    this.doubleTap = false;
                }
                if (this.isSorted && ((Boolean)this.chatNotify.get()).booleanValue()) {
                    MsgUtil.sendModuleMsg("\u00a7oInventory sorted according to the loadout \"\u00a7a\u00a7o" + this.activeLoadoutKey + "\"\u00a7e\u00a7o..!", this.name);
                }
            }
        }
    }
}

