/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import com.mojang.serialization.MapDecoder;
import dev.stardust.Stardust;
import dev.stardust.modules.AutoDyeShulkers;
import java.util.Arrays;
import java.util.Optional;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1474;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1716;
import net.minecraft.class_1720;
import net.minecraft.class_1722;
import net.minecraft.class_1723;
import net.minecraft.class_1724;
import net.minecraft.class_1733;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9284;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class LoreLocator
extends Module {
    private final SettingGroup sgRares;
    private final SettingGroup sgUniques;
    private final Setting<Boolean> illegalEnchants;
    private final Setting<Boolean> onlySilkyShears;
    private final Setting<Boolean> onlyInfinityMending;
    private final Setting<Boolean> negativeDurability;
    private final Setting<Boolean> petrifiedSlabs;
    private final Setting<Boolean> lagRockets;
    private final Setting<Boolean> illegalFish;
    private final Setting<Boolean> renamedItems;
    private final Setting<Boolean> renamedShulks;
    private final Setting<Boolean> writtenBooks;
    private final Setting<String> metadataSearch;
    private final Setting<Boolean> splitQueries;
    public final Setting<SettingColor> color;
    private final Setting<Boolean> ownInventory;

    public LoreLocator() {
        super(Stardust.CATEGORY, "LoreLocator", "Slot highlighter for rare, unique, and anomalous items.");
        this.sgRares = this.settings.createGroup("Rares Settings");
        this.sgUniques = this.settings.createGroup("Uniques Settings");
        this.illegalEnchants = this.sgRares.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("illegal-enchants")).description("Highlight items with illegal enchantments like Mending/Infinity, or stacked Protection.")).defaultValue((Object)true)).build());
        this.onlySilkyShears = this.sgRares.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("exclusive-silky-shears")).description("Highlight silk touch shears only if they have no other enchants.")).defaultValue((Object)false)).visible(() -> this.illegalEnchants.get())).build());
        this.onlyInfinityMending = this.sgRares.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("exclusive-mending/Infinity")).description("Highlight bows & books that have ONLY mending & infinity applied.")).defaultValue((Object)false)).visible(() -> this.illegalEnchants.get())).build());
        this.negativeDurability = this.sgRares.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("negative-durability")).description("Highlight items with negative true durability (all negative durability items show in-game as 0 durability items in 1.21.)")).defaultValue((Object)true)).build());
        this.petrifiedSlabs = this.sgRares.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("alpha-slabs")).description("Highlight alpha slabs (now petrified oak slabs.)")).defaultValue((Object)true)).build());
        this.lagRockets = this.sgRares.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("lag-rockets")).description("Highlight lag rockets.")).defaultValue((Object)false)).build());
        this.illegalFish = this.sgRares.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("illegal-fish")).description("Highlight illegal tropical fish with black as one of their colors. These are no longer obtainable as of 1.21.")).defaultValue((Object)false)).build());
        this.renamedItems = this.sgUniques.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("renamed-items")).description("Highlight renamed items in GUIs.")).defaultValue((Object)true)).build());
        this.renamedShulks = this.sgUniques.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("renamed-shulkers")).description("Highlight renamed shulker boxes, even if they contain no renamed items.")).defaultValue((Object)false)).visible(() -> this.renamedItems.get())).build());
        this.writtenBooks = this.sgUniques.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("written-books")).description("Highlight written books.")).defaultValue((Object)false)).build());
        this.metadataSearch = this.settings.getDefaultGroup().add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("metadata-search")).description("Fuzzy search for item NBT data. Notable usage examples: specific book authors, item names, or enchants.")).defaultValue((Object)"")).build());
        this.splitQueries = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("split-queries")).description("Split search queries into multiple items separated by commas. Disable to treat commas literally in the search instead.")).defaultValue((Object)true)).build());
        this.color = this.settings.getDefaultGroup().add((Setting)((ColorSetting.Builder)new ColorSetting.Builder().name("highlight-color")).defaultValue(new SettingColor(138, 71, 221, 69)).build());
        this.ownInventory = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("inventory-highlight")).description("Highlight items meeting the above criteria on the player inventory screen.")).defaultValue((Object)false)).build());
    }

    private int enchantmentsCount(class_1799 stack) {
        int count = 0;
        if (!stack.method_7960()) {
            count = stack.method_7909() == class_1802.field_8598 ? ((class_9304)stack.method_57824(class_9334.field_49643)).method_57534().size() : stack.method_58657().method_57541();
        }
        return count;
    }

    private boolean shouldIgnoreCurrentScreenHandler(class_746 player) {
        if (this.mc.field_1755 == null) {
            return true;
        }
        if (player.field_7512 == null) {
            return true;
        }
        class_1703 handler = player.field_7512;
        if (handler instanceof class_1723) {
            return (Boolean)this.ownInventory.get() == false;
        }
        return !(handler instanceof class_1720) && !(handler instanceof class_1707) && !(handler instanceof class_1716) && !(handler instanceof class_1733) && !(handler instanceof class_1722) && !(handler instanceof class_1724);
    }

    public boolean shouldHighlightSlot(class_1799 stack) {
        Optional optional;
        class_9279 nbtComponent;
        class_9284 firework;
        if (this.mc.field_1724 == null) {
            return false;
        }
        if (stack.method_7960() || this.shouldIgnoreCurrentScreenHandler(this.mc.field_1724)) {
            return false;
        }
        if (Utils.hasItems((class_1799)stack)) {
            class_1799[] stacks = new class_1799[27];
            Utils.getItemsInContainerItem((class_1799)stack, (class_1799[])stacks);
            for (class_1799 s : stacks) {
                if (!this.shouldHighlightSlot(s)) continue;
                return true;
            }
        }
        if (!((String)this.metadataSearch.get()).trim().isEmpty()) {
            class_9323 metadata = stack.method_57353();
            String query = ((String)this.metadataSearch.get()).toLowerCase();
            if (((Boolean)this.splitQueries.get()).booleanValue() && query.contains(",")) {
                String[] queries = query.split(",");
                if (metadata != null && Arrays.stream(queries).anyMatch(q -> metadata.toString().toLowerCase().contains(q.trim()) || metadata.toString().toLowerCase().contains(q.trim().replace(" ", "_")))) {
                    return true;
                }
                if (Arrays.stream(queries).anyMatch(q -> stack.method_7964().getString().toLowerCase().contains(q.trim()) || stack.method_7909().method_7854().method_7964().getString().toLowerCase().contains(q.trim()))) {
                    return true;
                }
            } else {
                if (metadata != null) {
                    if (metadata.toString().toLowerCase().contains(query.trim())) {
                        return true;
                    }
                    if (metadata.toString().toLowerCase().contains(query.trim().replace(" ", "_"))) {
                        return true;
                    }
                }
                if (stack.method_7964().getString().toLowerCase().contains(query.trim())) {
                    return true;
                }
                if (stack.method_7909().method_7854().method_7964().getString().toLowerCase().contains(query.trim())) {
                    return true;
                }
            }
        }
        if (!((Boolean)this.renamedShulks.get()).booleanValue() && stack.method_57826(class_9334.field_49631) && (stack.method_7909() == class_1802.field_8545 || AutoDyeShulkers.isColoredShulker(stack.method_7909()))) {
            return false;
        }
        if (((Boolean)this.lagRockets.get()).booleanValue() && stack.method_57826(class_9334.field_49616) && (firework = (class_9284)stack.method_57824(class_9334.field_49616)).comp_2392().size() == 7) {
            return true;
        }
        if (((Boolean)this.illegalFish.get()).booleanValue() && stack.method_31574(class_1802.field_8478) && !(nbtComponent = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302)).method_57458() && (optional = nbtComponent.method_57446((MapDecoder)class_1474.class_7992.field_49236.fieldOf("BucketVariantTag")).result()).isPresent()) {
            class_1474.class_7992 variant = (class_1474.class_7992)optional.get();
            String string = "color.minecraft." + String.valueOf(variant.comp_1178());
            String string2 = "color.minecraft." + String.valueOf(variant.comp_1179());
            int i = class_1474.field_41573.indexOf(variant);
            if (i == -1 && (string.contains("black") || string2.contains("black"))) {
                return true;
            }
        }
        if (((Boolean)this.writtenBooks.get()).booleanValue() && stack.method_7909() == class_1802.field_8360) {
            return true;
        }
        if (((Boolean)this.petrifiedSlabs.get()).booleanValue() && stack.method_7909() == class_1802.field_8060) {
            return true;
        }
        if (((Boolean)this.renamedItems.get()).booleanValue() && stack.method_57826(class_9334.field_49631)) {
            return true;
        }
        if (((Boolean)this.negativeDurability.get()).booleanValue() && stack.method_7963() && (Integer)stack.method_57825(class_9334.field_49629, (Object)stack.method_7919()) >= stack.method_7936()) {
            return true;
        }
        if (((Boolean)this.illegalEnchants.get()).booleanValue() && (stack.method_7909() == class_1802.field_8598 || stack.method_7942())) {
            int enchantmentsCount = this.enchantmentsCount(stack);
            if (stack.method_7909() == class_1802.field_8868 && Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9099)) {
                return enchantmentsCount == 1 || (Boolean)this.onlySilkyShears.get() == false;
            }
            if (stack.method_7909() == class_1802.field_8598 && (enchantmentsCount == 0 || enchantmentsCount > 7)) {
                return true;
            }
            boolean hasProtection = Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9111);
            if (Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9095)) {
                if (!hasProtection) {
                    hasProtection = true;
                } else {
                    return true;
                }
            }
            if (Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9107)) {
                if (!hasProtection) {
                    hasProtection = true;
                } else {
                    return true;
                }
            }
            if (Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9096) && hasProtection) {
                return true;
            }
            if (Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9125) && Utils.hasEnchantment((class_1799)stack, (class_5321)class_1893.field_9101)) {
                return enchantmentsCount == 2 || (Boolean)this.onlyInfinityMending.get() == false;
            }
        }
        return false;
    }
}

