/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.stardust.Stardust;
import dev.stardust.gui.screens.MeteoritesScreen;
import dev.stardust.gui.widgets.meteorites.FieldSize;
import dev.stardust.gui.widgets.meteorites.HighScore;
import dev.stardust.gui.widgets.meteorites.SaveData;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.RainbowColors;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class Meteorites
extends Module {
    private static final String GAME_FOLDER = "meteor-client/minigames/meteorites";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String[] GAMEPLAY_TIPS = new String[]{"Press P to pause the game.", "Press M to mute the game audio.", "Every ten waves, a boss appears.", "Hold space or left-click to shoot.", "Each field size tracks its own high score data.", "You can disable these tips in the module settings.", "Every six waves you are granted an extra life, up to 5.", "Some powerups are only available when mouse-aim is enabled.", "Clicking the middle-mouse button toggles mouse-aim on or off.", "Exiting the game will save automatically, if saving is enabled.", "Some powerups display useful info near the top of the game window.", "The rare Stardust powerup comes in multiple different gun variants.", "With mouse-aim disabled, rotate with A, D, Right Arrow, Left Arrow.", "Perform a hyperjump by pressing H or right-click. Costs 1000 points.", "The starfield can be disabled in the settings if you find it distracting.", "Your right-click ability can be used to get you out of sticky situations.", "The Gravity Well can be repositioned as often as you like while deployed.", "Some powerups replace your right-click ability, but can be used for free.", "Every third wave you gain a random powerup if you don't already have one.", "You may want to sacrifice an extra life for a chance at a better powerup.", "Waves get harder as the game goes on, but rare powerups become more common.", "The powerup you earn the most points with is tracked along with high scores."};
    public final Setting<Boolean> debug;
    public final Setting<Boolean> randomizePowerups;
    public final Setting<Boolean> renderStarfield;
    public final Setting<Boolean> gameTips;
    public final Setting<Boolean> mouseAim;
    public final Setting<Boolean> mouseAimOutside;
    public final Setting<Boolean> renderMap;
    public final Setting<Boolean> saveGames;
    public final Setting<Boolean> sounds;
    public final Setting<Double> soundVolume;
    public final Setting<FieldSize> canvasSize;
    public final Setting<SettingColor> shipColor;
    public final Setting<SettingColor> flameColor;
    public final Setting<SettingColor> bulletColor;
    public final Setting<SettingColor> gravityColor;
    private boolean loaded;
    public boolean enteredCheatCode;
    @Nullable
    public SaveData saveData;
    @Nullable
    public HighScore highScore;

    public Meteorites() {
        super(Stardust.CATEGORY, "Meteorites", "Play Meteorites (an Asteroids-style arcade shooter).");
        this.debug = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("debug")).description("cheater cheater pumpkin eater")).defaultValue((Object)false)).visible(() -> false)).onChanged(it -> {
            if (!this.loaded) {
                if (it.booleanValue() && !this.enteredCheatCode) {
                    this.disableDebug();
                } else if (!it.booleanValue() && this.enteredCheatCode) {
                    this.enteredCheatCode = false;
                }
            }
        })).build());
        this.randomizePowerups = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("randomize-powerups")).defaultValue((Object)false)).visible(() -> this.debug.get())).build());
        this.renderStarfield = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-starfield")).description("Renders a background starfield with parallax visual effects.")).defaultValue((Object)true)).build());
        this.gameTips = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("gameplay-tips")).description("Displays random gameplay tips on the pause screen.")).defaultValue((Object)true)).build());
        this.mouseAim = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("allow-mouse-aim")).description("Makes the ship point towards the mouse cursor when inside the play area.")).defaultValue((Object)true)).build());
        this.mouseAimOutside = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("when-outside-area")).description("Follow the mouse even when the cursor is outside of the play area.")).defaultValue((Object)true)).visible(() -> this.mouseAim.get())).build());
        this.renderMap = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("force-render-minimap")).description("Continues rendering the Xaeros minimap while the Meteorites screen is open.")).defaultValue((Object)true)).build());
        this.saveGames = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("save-games")).description("Saves the state of your game when closing the Meteorites screen.")).defaultValue((Object)true)).build());
        this.sounds = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("game-sounds")).description("Plays game sounds.")).defaultValue((Object)true)).build());
        this.soundVolume = this.settings.getDefaultGroup().add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sounds-volume")).min(0.1).max(4.0).defaultValue(0.5).visible(() -> this.sounds.get())).build());
        this.canvasSize = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("field-size")).description("The size preset to use for the game board area.")).defaultValue((Object)FieldSize.Small)).build());
        this.shipColor = this.settings.getDefaultGroup().add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("ship-color")).description("What color to use for the player's ship.")).defaultValue(new SettingColor(48, 61, 84)).build());
        this.flameColor = this.settings.getDefaultGroup().add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("flame-color")).description("What color to use for the ship's thrust flame.")).defaultValue(new SettingColor(255, 160, 32)).build());
        this.bulletColor = this.settings.getDefaultGroup().add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("laser-color")).description("What color to use for the ship's laser bullets.")).defaultValue(new SettingColor(224, 0, 118)).build());
        this.gravityColor = this.settings.getDefaultGroup().add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("gravity-color")).description("What color to use for the gravity well indicator.")).defaultValue(new SettingColor(255, 0, 255, 69)).build());
        this.saveData = null;
        this.highScore = null;
        this.runInMainMenu = true;
        if (((SettingColor)this.shipColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.shipColor.get()));
        }
        if (((SettingColor)this.flameColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.flameColor.get()));
        }
        if (((SettingColor)this.bulletColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.bulletColor.get()));
        }
    }

    public void saveGame(SaveData data) {
        this.saveData = data;
        Path saveFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        saveFolder.toFile().mkdirs();
        Path save = saveFolder.resolve("save.json");
        if (!Files.exists(save, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/meteorites/save.json")) {
            MsgUtil.sendModuleMsg("Failed to create save file\u00a7c..!", this.name);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(save, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
    }

    public void loadGame() {
        this.loaded = true;
        Path saveFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        saveFolder.toFile().mkdirs();
        Path save = saveFolder.resolve("save.json");
        if (!Files.exists(save, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/meteorites/save.json")) {
            MsgUtil.sendModuleMsg("Failed to create save file\u00a7c..!", this.name);
        }
        SaveData data = null;
        try (BufferedReader reader = Files.newBufferedReader(save);){
            data = (SaveData)GSON.fromJson((Reader)reader, SaveData.class);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
        if (data != null) {
            this.saveData = data;
            this.enteredCheatCode = data.cheating();
            this.debug.set((Object)this.enteredCheatCode);
        }
    }

    public void clearSave() {
        this.saveGame(null);
    }

    public void saveHighScore(HighScore score) {
        this.highScore = score;
        Path scoreFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        scoreFolder.toFile().mkdirs();
        Path scores = scoreFolder.resolve("highscores.json");
        if (!Files.exists(scores, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/meteorites/highscores.json")) {
            MsgUtil.sendModuleMsg("Failed to create high score file\u00a7c..!", this.name);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(scores, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)score, (Appendable)writer);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
    }

    public void loadHighScore() {
        Path scoreFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        scoreFolder.toFile().mkdirs();
        Path scores = scoreFolder.resolve("highscores.json");
        if (!Files.exists(scores, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/meteorites/highscores.json")) {
            MsgUtil.sendModuleMsg("Failed to create save file\u00a7c..!", this.name);
        }
        HighScore score = null;
        try (BufferedReader reader = Files.newBufferedReader(scores);){
            score = (HighScore)GSON.fromJson((Reader)reader, HighScore.class);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
        if (score != null) {
            this.highScore = score;
        }
    }

    public void clearHighScore() {
        this.saveHighScore(null);
    }

    private void disableDebug() {
        this.debug.set((Object)false);
    }

    public void onActivate() {
        this.loadGame();
        this.loadHighScore();
        try {
            this.mc.method_1507((class_437)new MeteoritesScreen(this, GuiThemes.get(), "Meteorites"));
        }
        catch (Exception err) {
            LogUtil.error("Failed to open Meteorites screen: " + String.valueOf(err), this.name);
        }
    }

    public void onDeactivate() {
        this.loaded = false;
        if (this.mc.field_1755 instanceof MeteoritesScreen) {
            try {
                this.mc.method_1507(null);
            }
            catch (Exception err) {
                LogUtil.error("Failed to close Meteorites screen: " + String.valueOf(err), this.name);
            }
        }
    }

    public WWidget getWidget(GuiTheme theme) {
        WHorizontalList list = theme.horizontalList();
        WButton clearSave = (WButton)list.add((WWidget)theme.button("Clear Save")).widget();
        WButton clearScore = (WButton)list.add((WWidget)theme.button("Clear High Scores")).widget();
        clearSave.action = this::clearSave;
        clearScore.action = this::clearHighScore;
        return list;
    }
}

