/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.stardust.Stardust;
import dev.stardust.gui.screens.MinesweeperScreen;
import dev.stardust.gui.widgets.minesweeper.WMinesweeper;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.RainbowColors;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class Minesweeper
extends Module {
    private static final String GAME_FOLDER = "meteor-client/minigames/minesweeper";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final SettingGroup sgGeneral;
    public final SettingGroup sgSchemes;
    public final Setting<WMinesweeper.Difficulty> difficulty;
    public final Setting<Integer> rows;
    public final Setting<Integer> columns;
    public final Setting<Integer> mines;
    public final Setting<Integer> cellSize;
    public final Setting<Boolean> shouldSave;
    public final Setting<Boolean> renderMap;
    public final Setting<Boolean> gameSounds;
    public final Setting<Double> soundVolume;
    public final Setting<WMinesweeper.ColorSchemes> colorScheme;
    public final Setting<SettingColor> wonColor;
    public final Setting<SettingColor> lostColor;
    public final Setting<SettingColor> cellBorderColor;
    public final Setting<SettingColor> mineTextColor;
    public final Setting<SettingColor> mineCellColor;
    public final Setting<SettingColor> timerColor;
    public final Setting<SettingColor> resetTextColor;
    public final Setting<SettingColor> statusBarColor;
    public final Setting<SettingColor> backgroundColor;
    public final Setting<SettingColor> mineCountColor;
    public final Setting<SettingColor> hiddenCellColor;
    public final Setting<SettingColor> flaggedCellColor;
    public final Setting<SettingColor> flaggedCellTextColor;
    public final Setting<SettingColor> resetButtonColor;
    public final Setting<SettingColor> resetHoveredColor;
    public final Setting<SettingColor> revealedCellColor;
    public final Setting<SettingColor> textShadowColor;
    @Nullable
    public WMinesweeper.SaveState saveData;

    public Minesweeper() {
        super(Stardust.CATEGORY, "Minesweeper", "Play Minesweeper from the comfort of your Meteor Client.");
        this.sgGeneral = this.settings.createGroup("General");
        this.sgSchemes = this.settings.createGroup("Color Scheme");
        this.difficulty = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("difficulty")).description("What difficulty to use for the Minesweeper game.")).defaultValue((Object)WMinesweeper.Difficulty.Easy)).build());
        this.rows = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("rows")).description("How many rows to have on the board.")).min(4).noSlider().defaultValue((Object)37)).visible(() -> ((WMinesweeper.Difficulty)((Object)((Object)this.difficulty.get()))).equals((Object)WMinesweeper.Difficulty.Custom))).build());
        this.columns = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("columns")).description("How many columns to have on the board.")).min(4).noSlider().defaultValue((Object)37)).visible(() -> ((WMinesweeper.Difficulty)((Object)((Object)this.difficulty.get()))).equals((Object)WMinesweeper.Difficulty.Custom))).build());
        this.mines = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("mines")).description("How many mines to fill the board with.")).min(1).noSlider().defaultValue((Object)169)).visible(() -> ((WMinesweeper.Difficulty)((Object)((Object)this.difficulty.get()))).equals((Object)WMinesweeper.Difficulty.Custom))).build());
        this.cellSize = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cell-size")).description("Size in pixels to use for each of the grid cells.")).min(4).sliderRange(10, 50).defaultValue((Object)32)).build());
        this.shouldSave = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("save-games")).description("Saves your game state when closing the Minesweeper screen.")).defaultValue((Object)true)).build());
        this.renderMap = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("force-render-minimap")).description("Continues rendering the Xaeros minimap while the Minesweeper screen is open.")).defaultValue((Object)true)).build());
        this.gameSounds = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("game-sounds")).description("Plays a sound when you win or lose the game.")).defaultValue((Object)true)).build());
        this.soundVolume = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sounds-volume")).min(0.1).max(4.0).defaultValue(1.0).visible(() -> this.gameSounds.get())).build());
        this.colorScheme = this.sgSchemes.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("color-scheme")).defaultValue((Object)WMinesweeper.ColorSchemes.Themed)).build());
        this.wonColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("won-text-color")).defaultValue(new SettingColor(0, 255, 0)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.lostColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("lost-text-color")).defaultValue(new SettingColor(255, 0, 0)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.cellBorderColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("cell-border-color")).defaultValue(new SettingColor(0, 0, 0)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.mineTextColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("mine-text-color")).defaultValue(new SettingColor(255, 0, 0)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.mineCellColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("mine-cell-color")).defaultValue(new SettingColor(13, 13, 13)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.timerColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("timer-text-color")).defaultValue(new SettingColor(255, 255, 0)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.resetTextColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("reset-text-color")).defaultValue(new SettingColor(20, 20, 20)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.statusBarColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("status-bar-color")).defaultValue(new SettingColor(42, 42, 42)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.backgroundColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).defaultValue(new SettingColor(51, 51, 51)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.mineCountColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("mines-count-color")).defaultValue(new SettingColor(255, 255, 255)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.hiddenCellColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("hidden-cell-color")).defaultValue(new SettingColor(176, 176, 176)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.flaggedCellColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("flagged-cell-color")).defaultValue(new SettingColor(255, 204, 102)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.flaggedCellTextColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("flagged-text-color")).defaultValue(new SettingColor(169, 0, 0)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.resetButtonColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("reset-button-color")).defaultValue(new SettingColor(200, 200, 200)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.resetHoveredColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("reset-button-hovered-color")).defaultValue(new SettingColor(230, 230, 230)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.revealedCellColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("revealed-cell-color")).defaultValue(new SettingColor(248, 248, 248)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.textShadowColor = this.sgSchemes.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("text-shadow-color")).defaultValue(new SettingColor(0, 0, 0)).visible(() -> ((WMinesweeper.ColorSchemes)((Object)((Object)this.colorScheme.get()))).equals((Object)WMinesweeper.ColorSchemes.Custom))).build());
        this.saveData = null;
        this.runInMainMenu = true;
        if (((SettingColor)this.wonColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.wonColor.get()));
        }
        if (((SettingColor)this.lostColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.lostColor.get()));
        }
        if (((SettingColor)this.timerColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.timerColor.get()));
        }
        if (((SettingColor)this.mineTextColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.mineTextColor.get()));
        }
        if (((SettingColor)this.mineCellColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.mineCellColor.get()));
        }
        if (((SettingColor)this.mineCountColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.mineCountColor.get()));
        }
        if (((SettingColor)this.resetTextColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.resetTextColor.get()));
        }
        if (((SettingColor)this.statusBarColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.statusBarColor.get()));
        }
        if (((SettingColor)this.textShadowColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.textShadowColor.get()));
        }
        if (((SettingColor)this.cellBorderColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.cellBorderColor.get()));
        }
        if (((SettingColor)this.backgroundColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.backgroundColor.get()));
        }
        if (((SettingColor)this.hiddenCellColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.hiddenCellColor.get()));
        }
        if (((SettingColor)this.resetButtonColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.resetButtonColor.get()));
        }
        if (((SettingColor)this.flaggedCellColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.flaggedCellColor.get()));
        }
        if (((SettingColor)this.resetHoveredColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.resetHoveredColor.get()));
        }
        if (((SettingColor)this.revealedCellColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.revealedCellColor.get()));
        }
        if (((SettingColor)this.flaggedCellTextColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.flaggedCellTextColor.get()));
        }
    }

    public void saveGame(WMinesweeper.SaveState data) {
        this.saveData = data;
        Path saveFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        saveFolder.toFile().mkdirs();
        Path save = saveFolder.resolve("save.json");
        if (!Files.exists(save, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/minesweeper/save.json")) {
            MsgUtil.sendModuleMsg("Failed to create save file\u00a7c..!", this.name);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(save, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
    }

    public void clearSave() {
        this.saveGame(null);
    }

    public void onActivate() {
        Path saveFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        saveFolder.toFile().mkdirs();
        Path save = saveFolder.resolve("save.json");
        if (!Files.exists(save, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/minesweeper/save.json")) {
            MsgUtil.sendModuleMsg("Failed to create save file\u00a7c..!", this.name);
        }
        WMinesweeper.SaveState data = null;
        try (BufferedReader reader = Files.newBufferedReader(save);){
            data = (WMinesweeper.SaveState)GSON.fromJson((Reader)reader, WMinesweeper.SaveState.class);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
        if (data != null) {
            this.saveData = data;
        }
        try {
            this.mc.method_1507((class_437)new MinesweeperScreen(this, GuiThemes.get(), "Minesweeper"));
        }
        catch (Exception err) {
            LogUtil.error("Failed to open Minesweeper screen: " + String.valueOf(err), this.name);
            this.toggle();
        }
    }

    public void onDeactivate() {
        if (this.mc.field_1755 instanceof MinesweeperScreen) {
            try {
                this.mc.method_1507(null);
            }
            catch (Exception err) {
                LogUtil.error("Failed to close Minesweeper screen: " + String.valueOf(err), this.name);
                this.toggle();
            }
        }
    }
}

