/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.GenericSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.render.blockesp.ESPBlockData;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1840;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2724;
import net.minecraft.class_2820;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_8623;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PagePirate
extends Module {
    private final SettingGroup sgChat;
    private final SettingGroup sgCopy;
    private final SettingGroup sgESP;
    private final Setting<Boolean> chatDisplay;
    private final Setting<Boolean> displayBooksOnGround;
    private final Setting<Boolean> displayBooksInItemFrames;
    private final Setting<Boolean> deobfuscatePages;
    private final Setting<Boolean> localCopy;
    private final Setting<Boolean> finalizeCopy;
    private final Setting<Boolean> writeCoverPage;
    private final Setting<Boolean> copyBooksOnGround;
    private final Setting<Boolean> copyBooksInItemFrames;
    private final Setting<Boolean> overwrite;
    private final Setting<Integer> tickDelay;
    private final Setting<Boolean> espItemFrames;
    private final Setting<Boolean> espBooksOnGround;
    private final Setting<ESPBlockData> bookESP;
    private int timer;
    private final HashSet<String> seenPages;
    private final HashSet<class_1542> booksOnGround;
    private final HashSet<class_1533> booksInItemFrames;
    private final class_8623<PirateTask> jobQueue;
    private final HashMap<String, ArrayList<String>> seenBooks;

    public PagePirate() {
        super(Stardust.CATEGORY, "PagePirate", "Pirates books that are held by other players.");
        this.sgChat = this.settings.createGroup("Chat Display");
        this.sgCopy = this.settings.createGroup("Physical Copy");
        this.sgESP = this.settings.createGroup("ESP Settings");
        this.chatDisplay = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-display")).description("Write nearby books to your chat for inspection.")).defaultValue((Object)true)).build());
        this.displayBooksOnGround = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("display-books-on-ground")).description("Display the contents of books laying on the ground in your chat.")).defaultValue((Object)false)).build());
        this.displayBooksInItemFrames = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("display-books-in-item-frames")).description("Display the contents of books in item frames.")).defaultValue((Object)false)).build());
        this.deobfuscatePages = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("deobfuscate-contents-in-chat")).defaultValue((Object)true)).build());
        this.localCopy = this.sgCopy.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("physical-copy")).description("Write nearby books into a Book & Quill from your inventory for inspection.")).defaultValue((Object)true)).build());
        this.finalizeCopy = this.sgCopy.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sign-local-copy")).description("Sign the local pirated copy with the name of the original book.")).defaultValue((Object)false)).build());
        this.writeCoverPage = this.sgCopy.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("write-cover-page")).description("Writes a cover page with metadata about the pirated book.")).defaultValue((Object)true)).build());
        this.copyBooksOnGround = this.sgCopy.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("copy-books-on-ground")).description("Copy books that are laying on the ground as an item.")).defaultValue((Object)false)).build());
        this.copyBooksInItemFrames = this.sgCopy.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("copy-books-in-item-frames")).description("Copy the contents of books in item frames.")).defaultValue((Object)false)).build());
        this.overwrite = this.sgCopy.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("overwrite-book-&-quill")).description("Overwrite Book & Quills that already contain page content.")).defaultValue((Object)false)).build());
        this.tickDelay = this.sgCopy.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("tick-delay")).description("Required to avoid being kicked when copying multiple books at once.")).range(0, 500).sliderRange(40, 200).defaultValue((Object)40)).build());
        this.espItemFrames = this.sgESP.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ESP-item-frames")).description("Renders item frames containing written books or book & quills.")).defaultValue((Object)true)).build());
        this.espBooksOnGround = this.sgESP.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ESP-books-on-ground")).description("Render books that are laying on the ground as an item.")).defaultValue((Object)true)).build());
        this.bookESP = this.sgESP.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("book-entity-ESP")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(69, 42, 242, 255), new SettingColor(69, 42, 242, 44), true, new SettingColor(69, 42, 242, 137)))).build());
        this.timer = 0;
        this.seenPages = new HashSet();
        this.booksOnGround = new HashSet();
        this.booksInItemFrames = new HashSet();
        this.jobQueue = new class_8623();
        this.seenBooks = new HashMap();
    }

    private String formatPageText(String page) {
        String formattedPage = page.replaceAll("\\\\n", "~pgprte~newline~");
        formattedPage = formattedPage.replace("{\"text\":\"", "").replaceAll("(?m)\"}$", "");
        return formattedPage.trim();
    }

    private String decodeUnicodeChars(String page) {
        Pattern pattern = Pattern.compile("\\\\u[0-9a-fA-F]{4}");
        Matcher matcher = pattern.matcher(page);
        StringBuilder decodedPage = new StringBuilder();
        while (matcher.find()) {
            String unicode = matcher.group();
            char uChar = (char)Integer.parseInt(unicode.substring(2), 16);
            matcher.appendReplacement(decodedPage, Character.toString(uChar));
        }
        matcher.appendTail(decodedPage);
        return decodedPage.toString();
    }

    private String dayOfMonthSuffix(int dom) {
        String day = String.valueOf(dom);
        if (!day.endsWith("11") && day.endsWith("1")) {
            return day + "st";
        }
        if (!day.endsWith("12") && day.endsWith("2")) {
            return day + "nd";
        }
        if (!day.endsWith("13") && day.endsWith("3")) {
            return day + "rd";
        }
        return day + "th";
    }

    private boolean bookAndQuillHasContent(class_1799 book) {
        if (book.method_7909() != class_1802.field_8674) {
            return false;
        }
        class_9301 content = (class_9301)book.method_57824(class_9334.field_49653);
        List<String> pages = content.comp_2422().stream().map(page -> ((String)page.comp_2369()).trim()).toList();
        return pages.stream().anyMatch(page -> !page.isBlank());
    }

    private boolean equipBookAndQuill() {
        FindItemResult result = InvUtils.find(stack -> {
            if (stack.method_7909() instanceof class_1840) {
                class_9301 data = (class_9301)stack.method_57824(class_9334.field_49653);
                List<String> pageList = data.comp_2422().stream().map(class_9262::comp_2369).toList();
                return (Boolean)this.overwrite.get() != false || pageList.stream().map(this::formatPageText).map(this::decodeUnicodeChars).allMatch(page -> page.replace("~pgprte~newline~", " ").trim().isEmpty());
            }
            return false;
        });
        if (result.found()) {
            if (result.slot() < 9) {
                InvUtils.swap((int)result.slot(), (boolean)true);
            } else {
                FindItemResult emptySlot = InvUtils.findEmpty();
                if (emptySlot.found() && emptySlot.slot() < 9) {
                    InvUtils.move().from(result.slot()).to(emptySlot.slot());
                    InvUtils.swap((int)emptySlot.slot(), (boolean)true);
                } else {
                    FindItemResult nonCriticalSlot = InvUtils.find(stack -> !(stack.method_7909() instanceof class_1766) && !stack.method_31573(class_3489.field_48305) && !stack.method_57826(class_9334.field_50075));
                    if (nonCriticalSlot.found() && nonCriticalSlot.slot() < 9) {
                        InvUtils.move().from(result.slot()).to(nonCriticalSlot.slot());
                        InvUtils.swap((int)nonCriticalSlot.slot(), (boolean)true);
                    } else {
                        InvUtils.move().from(result.slot()).to(this.mc.field_1724.method_31548().field_7545);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean itemFrameHasBook(class_1533 itemFrame) {
        class_1799 stack = itemFrame.method_6940();
        return stack.method_7909() == class_1802.field_8360 || this.bookAndQuillHasContent(stack);
    }

    private void handleWrittenBook(class_1799 book, String piratedFrom) {
        if (book.method_57826(class_9334.field_49606)) {
            class_9302 metadata = (class_9302)book.method_57824(class_9334.field_49606);
            String author = metadata.comp_2420();
            String title = (String)metadata.comp_2419().comp_2369();
            List<String> pages = metadata.method_57525(false).stream().map(class_2561::getString).toList();
            String pageText = pages.stream().map(this::formatPageText).map(this::decodeUnicodeChars).collect(Collectors.joining("\n"));
            if (this.seenPages.contains(pageText.replace("~pgprte~newline~", "\n")) && this.seenBooks.containsKey(author) && this.seenBooks.get(author).contains(title)) {
                return;
            }
            this.seenPages.add(pageText.replace("~pgprte~newline~", "\n"));
            if (this.seenBooks.containsKey(author)) {
                ArrayList<String> booksFromAuthor = this.seenBooks.get(author);
                booksFromAuthor.add(title);
                this.seenBooks.put(author, booksFromAuthor);
            } else {
                ArrayList<String> books = new ArrayList<String>();
                books.add(title);
                this.seenBooks.put(author, books);
            }
            if (((Boolean)this.chatDisplay.get()).booleanValue()) {
                if (((Boolean)this.deobfuscatePages.get()).booleanValue()) {
                    pageText = pageText.replace("\u00a7k", "");
                }
                switch (piratedFrom) {
                    case "on ground": {
                        if (!((Boolean)this.displayBooksOnGround.get()).booleanValue()) break;
                        MsgUtil.sendModuleMsg("Author: " + StardustUtil.rCC() + "\u00a7o" + author + " \u00a77Title: " + StardustUtil.rCC() + "\u00a75\u00a7o" + title + " \u00a77Pages: \n\u00a7o" + pageText.replace("~pgprte~newline~", "\n"), this.name);
                        break;
                    }
                    case "item frame": {
                        if (!((Boolean)this.displayBooksInItemFrames.get()).booleanValue()) break;
                        MsgUtil.sendModuleMsg("Author: " + StardustUtil.rCC() + "\u00a7o" + author + " \u00a77Title: " + StardustUtil.rCC() + "\u00a75\u00a7o" + title + " \u00a77Pages: \n\u00a7o" + pageText.replace("~pgprte~newline~", "\n"), this.name);
                        break;
                    }
                    default: {
                        MsgUtil.sendModuleMsg("Author: " + StardustUtil.rCC() + "\u00a7o" + author + " \u00a77Title: " + StardustUtil.rCC() + "\u00a75\u00a7o" + title + " \u00a77Pages: \n\u00a7o" + pageText.replace("~pgprte~newline~", "\n"), this.name);
                    }
                }
            }
            if (((Boolean)this.localCopy.get()).booleanValue()) {
                switch (piratedFrom) {
                    case "on ground": {
                        if (!((Boolean)this.copyBooksOnGround.get()).booleanValue()) break;
                        this.jobQueue.addLast((Object)new PirateTask(metadata, piratedFrom, pages));
                        break;
                    }
                    case "item frame": {
                        if (!((Boolean)this.copyBooksInItemFrames.get()).booleanValue()) break;
                        this.jobQueue.addLast((Object)new PirateTask(metadata, piratedFrom, pages));
                        break;
                    }
                    default: {
                        this.jobQueue.addLast((Object)new PirateTask(metadata, piratedFrom, pages));
                    }
                }
            }
        }
    }

    private void handleBookAndQuill(class_1799 book, String piratedFrom) {
        if (!book.method_57826(class_9334.field_49653)) {
            return;
        }
        class_9301 metadata = (class_9301)book.method_57824(class_9334.field_49653);
        List<String> pages = metadata.comp_2422().stream().map(p -> (String)p.method_57140(false)).toList();
        String pageText = pages.stream().map(this::formatPageText).map(this::decodeUnicodeChars).collect(Collectors.joining("\n"));
        if (this.seenPages.contains(pageText.replace("~pgprte~newline~", "\n"))) {
            return;
        }
        this.seenPages.add(pageText.replace("~pgprte~newline~", "\n"));
        if (((Boolean)this.chatDisplay.get()).booleanValue() && !pageText.replace("~pgprte~newline~", " ").isBlank()) {
            if (((Boolean)this.deobfuscatePages.get()).booleanValue()) {
                pageText = pageText.replace("\u00a7k", "");
            }
            switch (piratedFrom) {
                case "on ground": {
                    if (!((Boolean)this.displayBooksOnGround.get()).booleanValue()) break;
                    MsgUtil.sendModuleMsg("Unsigned Contents from \u00a7a\u00a7o" + piratedFrom + "\u00a77: \n\u00a77\u00a7o" + pageText.replace("~pgprte~newline~", "\n"), this.name);
                    break;
                }
                case "item frame": {
                    if (!((Boolean)this.displayBooksInItemFrames.get()).booleanValue()) break;
                    MsgUtil.sendModuleMsg("Unsigned Contents from \u00a7a\u00a7o" + piratedFrom + "\u00a77: \n\u00a77\u00a7o" + pageText.replace("~pgprte~newline~", "\n"), this.name);
                    break;
                }
                default: {
                    MsgUtil.sendModuleMsg("Unsigned Contents from \u00a7a\u00a7o" + piratedFrom + "\u00a77: \n\u00a77\u00a7o" + pageText.replace("~pgprte~newline~", "\n"), this.name);
                }
            }
        }
        if (((Boolean)this.localCopy.get()).booleanValue()) {
            switch (piratedFrom) {
                case "on ground": {
                    if (!((Boolean)this.copyBooksOnGround.get()).booleanValue()) break;
                    this.jobQueue.addLast((Object)new PirateTask(null, piratedFrom, pages));
                    break;
                }
                case "item frame": {
                    if (!((Boolean)this.copyBooksInItemFrames.get()).booleanValue()) break;
                    this.jobQueue.addLast((Object)new PirateTask(null, piratedFrom, pages));
                    break;
                }
                default: {
                    this.jobQueue.addLast((Object)new PirateTask(null, piratedFrom, pages));
                }
            }
        }
    }

    private void makeLocalCopy(@Nullable class_9302 metadata, List<String> pages, String piratedFrom) {
        ArrayList<String> filtered = new ArrayList<String>(pages.stream().map(this::formatPageText).map(this::decodeUnicodeChars).toList());
        if (filtered.isEmpty()) {
            return;
        }
        if (!this.equipBookAndQuill()) {
            MsgUtil.sendModuleMsg("Failed to copy nearby book because you have no empty Book & Quills\u00a7c..!", this.name);
            return;
        }
        ArrayList<Object> piratedPages = new ArrayList<Object>();
        if (((Boolean)this.writeCoverPage.get()).booleanValue() && metadata != null) {
            String rcc = StardustUtil.rCC();
            LocalDate currentDate = LocalDate.now();
            LocalTime currentTime = LocalTime.now();
            Object paddedMinute = currentTime.getMinute() < 10 ? "0" + currentTime.getMinute() : String.valueOf(currentTime.getMinute());
            Object paddedHour = currentTime.getHour() < 10 ? "0" + currentTime.getHour() : String.valueOf(currentTime.getHour());
            String coverPage = "   " + rcc + "\u00a7o\u2728 PagePirate \u2728 \n\n\u00a70\u00a7lTitle: " + rcc + "\u00a7o" + (String)metadata.comp_2419().comp_2369() + "\n\u00a70\u00a7lAuthor: " + rcc + "\u00a7o" + metadata.comp_2420() + "\n\n\u00a70\u00a7lPirated From: " + rcc + "\u00a7o" + piratedFrom + "\n\u00a70\u00a7oat " + rcc + "\u00a7o" + (String)paddedHour + "\u00a70\u00a7o:" + rcc + "\u00a7o" + (String)paddedMinute + " \u00a70\u00a7oon the " + rcc + "\u00a7o" + this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " \u00a70\u00a7oof " + rcc + "\u00a7o" + currentDate.getMonth().toString().charAt(0) + currentDate.getMonth().toString().substring(1).toLowerCase() + "\u00a70\u00a7o, " + rcc + "\u00a7o" + currentDate.getYear() + "\u00a70\u00a7o.";
            piratedPages.add(coverPage);
        }
        int slot = this.mc.field_1724.method_31548().field_7545;
        boolean shouldSign = (Boolean)this.finalizeCopy.get() != false && metadata != null;
        MsgUtil.sendModuleMsg("Successfully copied nearby book\u00a7a..!", this.name);
        piratedPages.addAll(filtered.stream().map(page -> page.replace("~pgprte~newline~", "\n")).toList());
        this.mc.method_1562().method_52787((class_2596)new class_2820(slot, piratedPages, shouldSign ? Optional.of((String)metadata.comp_2419().comp_2369()) : Optional.empty()));
    }

    public void onDeactivate() {
        this.timer = 0;
        this.jobQueue.clear();
        this.seenBooks.clear();
        this.seenPages.clear();
        this.booksOnGround.clear();
        this.booksInItemFrames.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!Utils.canUpdate()) {
            return;
        }
        this.booksInItemFrames.removeIf(frame -> !this.itemFrameHasBook((class_1533)frame));
        this.booksOnGround.removeIf(book -> book.method_31481() || book.method_33724());
        this.booksInItemFrames.removeIf(frame -> frame.method_31481() || frame.method_33724());
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            class_1533 itemFrame;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (!(entity instanceof class_746)) {
                    String name = player.method_7334().getName();
                    class_1799 mainHand = player.method_5998(class_1268.field_5808);
                    if (mainHand.method_7909() == class_1802.field_8360) {
                        this.handleWrittenBook(mainHand, name);
                    } else if (mainHand.method_7909() == class_1802.field_8674) {
                        this.handleBookAndQuill(mainHand, name);
                    }
                    class_1799 offHand = player.method_5998(class_1268.field_5810);
                    if (offHand.method_7909() == class_1802.field_8360) {
                        this.handleWrittenBook(offHand, name);
                        continue;
                    }
                    if (mainHand.method_7909() != class_1802.field_8674) continue;
                    this.handleBookAndQuill(offHand, name);
                    continue;
                }
            }
            if (entity instanceof class_1542) {
                class_1542 item = (class_1542)entity;
                if (this.booksOnGround.contains(item)) continue;
                String piratedFrom = "on ground";
                if (item.method_6983().method_7909() == class_1802.field_8360) {
                    this.booksOnGround.add(item);
                    this.handleWrittenBook(item.method_6983(), piratedFrom);
                    continue;
                }
                if (!this.bookAndQuillHasContent(item.method_6983())) continue;
                this.booksOnGround.add(item);
                this.handleBookAndQuill(item.method_6983(), piratedFrom);
                continue;
            }
            if (!(entity instanceof class_1533) || this.booksInItemFrames.contains(itemFrame = (class_1533)entity)) continue;
            class_1799 stack = itemFrame.method_6940();
            if (stack.method_7909() == class_1802.field_8360) {
                this.booksInItemFrames.add(itemFrame);
                this.handleWrittenBook(stack, "item frame");
                continue;
            }
            if (stack.method_7909() != class_1802.field_8674) continue;
            this.booksInItemFrames.add(itemFrame);
            this.handleBookAndQuill(stack, "item frame");
        }
        ++this.timer;
        if (this.timer >= (Integer)this.tickDelay.get() && !this.jobQueue.isEmpty()) {
            this.timer = 0;
            PirateTask task = (PirateTask)this.jobQueue.removeFirst();
            this.makeLocalCopy(task.getData(), task.getPages(), task.getPiratedFrom());
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        double z2;
        double y2;
        double x2;
        double z1;
        double y1;
        double x1;
        double z;
        double y;
        double x;
        class_238 box;
        if (!Utils.canUpdate()) {
            return;
        }
        ESPBlockData esp = (ESPBlockData)this.bookESP.get();
        if (((Boolean)this.espItemFrames.get()).booleanValue()) {
            for (class_1533 frame : this.booksInItemFrames) {
                box = frame.method_5829();
                x = class_3532.method_16436((double)event.tickDelta, (double)frame.field_6038, (double)frame.method_23317()) - frame.method_23317();
                y = class_3532.method_16436((double)event.tickDelta, (double)frame.field_5971, (double)frame.method_23318()) - frame.method_23318();
                z = class_3532.method_16436((double)event.tickDelta, (double)frame.field_5989, (double)frame.method_23321()) - frame.method_23321();
                x1 = x + box.field_1323;
                y1 = y + box.field_1322;
                z1 = z + box.field_1321;
                x2 = x + box.field_1320;
                y2 = y + box.field_1325;
                z2 = z + box.field_1324;
                if (esp.sideColor.a > 0 || esp.lineColor.a > 0) {
                    event.renderer.box(x1, y1, z1, x2, y2, z2, (Color)esp.sideColor, (Color)esp.lineColor, esp.shapeMode, 0);
                }
                if (!esp.tracer) continue;
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, (x1 + x2) / 2.0, (y1 + y2) / 2.0, (z1 + z2) / 2.0, (Color)esp.tracerColor);
            }
        }
        if (((Boolean)this.espBooksOnGround.get()).booleanValue()) {
            for (class_1542 book : this.booksOnGround) {
                box = book.method_5829();
                x = class_3532.method_16436((double)event.tickDelta, (double)book.field_6038, (double)book.method_23317()) - book.method_23317();
                y = class_3532.method_16436((double)event.tickDelta, (double)book.field_5971, (double)book.method_23318()) - book.method_23318();
                z = class_3532.method_16436((double)event.tickDelta, (double)book.field_5989, (double)book.method_23321()) - book.method_23321();
                x1 = x + box.field_1323;
                y1 = y + box.field_1322;
                z1 = z + box.field_1321;
                x2 = x + box.field_1320;
                y2 = y + box.field_1325;
                z2 = z + box.field_1324;
                if (esp.sideColor.a > 0 || esp.lineColor.a > 0) {
                    event.renderer.box(x + box.field_1323, y + box.field_1322, z + box.field_1321, x + box.field_1320, y + box.field_1325, z + box.field_1324, (Color)esp.sideColor, (Color)esp.lineColor, esp.shapeMode, 0);
                }
                if (!esp.tracer) continue;
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, (x1 + x2) / 2.0, (y1 + y2) / 2.0, (z1 + z2) / 2.0, (Color)esp.tracerColor);
            }
        }
    }

    @EventHandler
    private void onRespawnOrDimensionChange(PacketEvent.Receive event) {
        if (!(event.packet instanceof class_2724)) {
            return;
        }
        this.booksOnGround.clear();
        this.booksInItemFrames.clear();
    }

    private record PirateTask(@Nullable class_9302 metadata, String piratedFrom, List<String> pages) {
        public List<String> getPages() {
            return this.pages;
        }

        public String getPiratedFrom() {
            return this.piratedFrom;
        }

        public class_9302 getData() {
            return this.metadata;
        }
    }
}

