/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.config.StardustConfig;
import dev.stardust.mixin.accessor.DisconnectS2CPacketAccessor;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.events.entity.EntityAddedEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_9334;

public class RoadTrip
extends Module {
    private final SettingGroup sgETA;
    private final SettingGroup sgAutoLog;
    private final SettingGroup sgNotify;
    private final Setting<Boolean> etaSetting;
    public final Setting<Integer> targetX;
    public final Setting<Integer> targetZ;
    private final Setting<Boolean> speedUpdates;
    private final Setting<Boolean> averageETA;
    private final Setting<Integer> averageSpeedMinutes;
    private final Setting<Boolean> forceKick;
    private final Setting<ToggleModes> autoLogToggle;
    private final Setting<Boolean> antiTrapAutoLog;
    private final Setting<Boolean> etaAutoLog;
    private final Setting<Integer> etaAutoLogThreshold;
    private final Setting<Boolean> timeoutAutoLog;
    private final Setting<Integer> timeoutAutoLogTimer;
    private final Setting<Boolean> lowElytraAutoLog;
    private final Setting<Integer> elytraStock;
    private final Setting<Boolean> lowRocketsAutoLog;
    private final Setting<Integer> rocketStock;
    private final Setting<Boolean> lowFoodAutoLog;
    private final Setting<List<class_1792>> chosenFood;
    private final Setting<Integer> foodStock;
    private final Setting<Boolean> yLevelAutoLog;
    private final Setting<Integer> yLevelThreshold;
    private final Setting<Boolean> elytraNotify;
    private final Setting<Boolean> lagNotify;
    private final Setting<Double> pingVolume;
    private int timer;
    private int ticksNotMoved;
    private int ticksSinceWarned;
    private long logOutTimer;
    private long timerTimestamp;
    @Nullable
    private class_2338 lastPos;
    @Nullable
    private class_2561 disconnectReason;
    private int bufferSize;
    private final ArrayDeque<Double> bpsValues;

    public RoadTrip() {
        super(Stardust.CATEGORY, "RoadTrip", "Tools for AFK-travelling over long distances.");
        this.sgETA = this.settings.createGroup("ETA Settings (Spoiler)", false);
        this.sgAutoLog = this.settings.createGroup("AutoLog Settings");
        this.sgNotify = this.settings.createGroup("Notification Settings");
        this.etaSetting = this.sgETA.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("display-ETA")).description("Display an estimated time of arrival for your target coords.")).defaultValue((Object)false)).build());
        this.targetX = this.sgETA.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-X")).description("Not dimension-translated.")).range(-30000000, 30000000).noSlider().defaultValue((Object)0)).onChanged(it -> this.bpsValues.clear())).build());
        this.targetZ = this.sgETA.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-Z")).description("Not dimension-translated.")).range(-30000000, 30000000).noSlider().defaultValue((Object)0)).onChanged(it -> this.bpsValues.clear())).build());
        this.speedUpdates = this.sgETA.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("average-speed-updates")).description("Display your average speed over a period of time.")).defaultValue((Object)false)).build());
        this.averageETA = this.sgETA.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ETA-average")).description("Display ETA based on your average speed over X minutes.")).defaultValue((Object)false)).build());
        this.averageSpeedMinutes = this.sgETA.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("average-speed-over-X-minutes")).description("Display your average speed over a period of time.")).range(0, 3200).sliderRange(0, 60).defaultValue((Object)10)).onChanged(it -> {
            this.bufferSize = it * 1200;
        })).build());
        this.forceKick = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("illegal-disconnect")).description("Forces the server to kick you immediately by sending an illegal packet.")).defaultValue((Object)true)).build());
        this.autoLogToggle = this.sgAutoLog.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("disable-on-disconnect")).description("Disables either the module or the AutoLog settings on disconnect, to prevent kicks on rejoin.")).defaultValue((Object)ToggleModes.Module)).build());
        this.antiTrapAutoLog = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("anti-trap-autoLog")).description("Illegally disconnects you when any TNT minecarts are rendered, to avoid highway traps.")).defaultValue((Object)false)).build());
        this.etaAutoLog = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ETA-autoLog")).description("Logs you out on arrival at your destination.")).defaultValue((Object)false)).build());
        this.etaAutoLogThreshold = this.sgAutoLog.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("ETA-autoLog-threshold")).description("Logs you out if you come within <threshold> blocks of your ETA.")).range(0, 25000).noSlider().defaultValue((Object)150)).build());
        this.timeoutAutoLog = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("timer-autoLog")).description("Logs you out x minutes after enabling the module, or the setting.")).defaultValue((Object)false)).onChanged(it -> {
            if (it.booleanValue()) {
                this.setLogOutTimer((Integer)this.timeoutAutoLogTimer.get());
            } else {
                this.disableLogOutTimer();
            }
        })).build());
        this.timeoutAutoLogTimer = this.sgAutoLog.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("timer-autoLog-seconds")).description("Logs you out x seconds after enabling the module, or the Timer AutoLog setting.")).min(0).noSlider().defaultValue((Object)3600)).onChanged(it -> {
            if (((Boolean)this.timeoutAutoLog.get()).booleanValue()) {
                this.setLogOutTimer((int)it);
            }
        })).build());
        this.lowElytraAutoLog = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("elytraStock-autoLog")).description("Logs you out if your stock of elytras is running low.")).defaultValue((Object)false)).build());
        this.elytraStock = this.sgAutoLog.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("elytraStock-autoLog-threshold")).description("Logs you out if your stock of elytras is running low.")).range(0, 40).sliderRange(0, 30).defaultValue((Object)1)).build());
        this.lowRocketsAutoLog = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rocketStock-autoLog")).description("Logs you out if your stock of firework rockets is running low.")).defaultValue((Object)false)).build());
        this.rocketStock = this.sgAutoLog.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("rocketStock-autoLog-threshold")).description("Logs you out if your stock of firework rockets is running low.")).range(0, 1024).sliderRange(0, 128).defaultValue((Object)32)).build());
        this.lowFoodAutoLog = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("foodStock-autoLog")).description("Logs you out if your stock of chosen food is running low.")).defaultValue((Object)false)).build());
        this.chosenFood = this.sgAutoLog.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("valid-food")).description("Which food to look for when deciding whether to disconnect you.")).filter(stack -> stack.method_57347().method_57832(class_9334.field_50075)).defaultValue(List.of(class_1802.field_8071, class_1802.field_8176, class_1802.field_8367))).build());
        this.foodStock = this.sgAutoLog.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("foodStock-autoLog-threshold")).description("Logs you out if your stock of chosen food is running low.")).range(0, 1024).sliderRange(0, 128).defaultValue((Object)0)).build());
        this.yLevelAutoLog = this.sgAutoLog.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("y-level-autoLog")).description("Logs you out if your Y level gets too low.")).defaultValue((Object)false)).build());
        this.yLevelThreshold = this.sgAutoLog.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("y-level-threshold")).description("Logs you out if your Y level is lower than the threshold.")).range(-69, 30000000).noSlider().defaultValue((Object)-69)).build());
        this.elytraNotify = this.sgNotify.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("elytra-notify")).description("Notify you with sound pings when your last elytra is below 5% durability.")).defaultValue((Object)false)).build());
        this.lagNotify = this.sgNotify.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("lag-notify")).description("Play a sound notification if you've stopped making progress (excess rubberbanding, hit a roadblock, etc.)")).defaultValue((Object)false)).build());
        this.pingVolume = this.sgNotify.add((Setting)((DoubleSetting.Builder)new DoubleSetting.Builder().name("ping-volume")).range(0.0, 5.0).sliderMin(0.0).sliderMax(5.0).defaultValue(0.5).build());
        this.timer = 0;
        this.ticksNotMoved = 0;
        this.ticksSinceWarned = 0;
        this.logOutTimer = -69L;
        this.timerTimestamp = 0L;
        this.lastPos = null;
        this.disconnectReason = null;
        this.bufferSize = (Integer)this.averageSpeedMinutes.get() * 1200;
        this.bpsValues = new ArrayDeque();
    }

    private void setLogOutTimer(int timer) {
        this.logOutTimer = timer;
        this.timerTimestamp = System.currentTimeMillis();
        if (((Boolean)this.timeoutAutoLog.get()).booleanValue() && this.isActive()) {
            MsgUtil.updateModuleMsg("Set Timer AutoLog to disconnect you \u00a7a\u00a7o" + String.valueOf(this.timeoutAutoLogTimer.get()) + " \u00a77seconds from now.", this.name, "timerAutoLog".hashCode());
        }
    }

    private void disableLogOutTimer() {
        this.logOutTimer = -69L;
    }

    public void onActivate() {
        this.disconnectReason = null;
        this.timerTimestamp = System.currentTimeMillis();
        if (((Boolean)this.timeoutAutoLog.get()).booleanValue()) {
            MsgUtil.updateModuleMsg("Set Timer AutoLog to disconnect you \u00a7a\u00a7o" + String.valueOf(this.timeoutAutoLogTimer.get()) + " \u00a77seconds from now.", this.name, "timerAutoLog".hashCode());
        }
    }

    public void onDeactivate() {
        this.timer = 0;
        this.lastPos = null;
        this.bpsValues.clear();
        this.ticksNotMoved = 0;
        this.logOutTimer = -69L;
        this.timerTimestamp = 0L;
        this.ticksSinceWarned = 0;
        this.bufferSize = (Integer)this.averageSpeedMinutes.get() * 1200;
    }

    private void handleDurabilityChecks() {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.ticksSinceWarned < 100) {
            return;
        }
        boolean reset = false;
        if (((Boolean)this.elytraNotify.get()).booleanValue()) {
            if (this.mc.field_1724.method_6118(class_1304.field_6174).method_7909() != class_1802.field_8833) {
                return;
            }
            class_1799 equippedElytra = this.mc.field_1724.method_6118(class_1304.field_6174);
            int maxDurability = equippedElytra.method_7936();
            int currentDurability = maxDurability - equippedElytra.method_7919();
            double percentDurability = Math.floor((double)currentDurability / (double)maxDurability * 100.0);
            if (percentDurability <= 5.0) {
                this.mc.field_1724.method_5783(class_3417.field_15075, ((Double)this.pingVolume.get()).floatValue(), 1.0f);
                MsgUtil.updateModuleMsg("Elytra durability: \u00a7c" + percentDurability + "\u00a77%", this.name, "roadTripElytraWarn".hashCode());
                reset = true;
            }
        }
        if (((Boolean)this.lagNotify.get()).booleanValue() && this.ticksNotMoved >= 80) {
            reset = true;
            this.ticksNotMoved = 0;
            this.mc.field_1724.method_5783(class_3417.field_15238, ((Double)this.pingVolume.get()).floatValue(), 1.0f);
        }
        if (reset) {
            this.ticksSinceWarned = 0;
        }
    }

    private boolean hasEnoughElytras() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        ArrayList<Integer> goodSlotsLeft = new ArrayList<Integer>();
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
            int max;
            int curr;
            double percent;
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
            if (stack.method_7909() != class_1802.field_8833 || !((percent = Math.floor((double)(curr = (max = stack.method_7936()) - stack.method_7919()) / (double)max * 100.0)) > 5.0)) continue;
            goodSlotsLeft.add(n);
        }
        return goodSlotsLeft.size() > (Integer)this.elytraStock.get();
    }

    private boolean hasEnoughRockets() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        int totalRocketsLeft = 0;
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
            if (stack.method_7909() != class_1802.field_8639) continue;
            totalRocketsLeft += stack.method_7947();
        }
        return totalRocketsLeft > (Integer)this.rocketStock.get();
    }

    private boolean hasEnoughFood() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        int totalFoodLeft = 0;
        for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
            if (!((List)this.chosenFood.get()).contains(stack.method_7909())) continue;
            totalFoodLeft += stack.method_7947();
        }
        return totalFoodLeft > (Integer)this.foodStock.get();
    }

    private void doForceKick(class_2561 disconnectReason) {
        this.disconnectReason = disconnectReason;
        StardustUtil.illegalDisconnect(true, (StardustUtil.IllegalDisconnectMethod)((Object)StardustConfig.illegalDisconnectMethodSetting.get()));
    }

    private void disconnect(class_2561 reason) {
        if (this.mc.method_1562() == null) {
            return;
        }
        StardustUtil.disableAutoReconnect();
        this.mc.method_1562().method_52781(new class_2661(reason));
        switch (((ToggleModes)((Object)this.autoLogToggle.get())).ordinal()) {
            case 0: {
                this.toggle();
                break;
            }
            case 1: {
                this.disableAutoLogSettings();
            }
        }
    }

    private void disableAutoLogSettings() {
        this.etaAutoLog.set((Object)false);
        this.yLevelAutoLog.set((Object)false);
        this.timeoutAutoLog.set((Object)false);
        this.antiTrapAutoLog.set((Object)false);
        this.lowElytraAutoLog.set((Object)false);
        this.lowRocketsAutoLog.set((Object)false);
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        long now;
        if (StardustUtil.isIn2b2tQueue()) {
            return;
        }
        if (this.mc.method_1562() == null) {
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        ++this.timer;
        ++this.ticksSinceWarned;
        this.handleDurabilityChecks();
        if (((Boolean)this.timeoutAutoLog.get()).booleanValue() && this.logOutTimer != -69L && (now = System.currentTimeMillis()) - this.timerTimestamp >= (long)((Integer)this.timeoutAutoLogTimer.get() * 1000)) {
            this.timerTimestamp = now;
            class_5250 reason = class_2561.method_43470((String)("\u00a78[\u00a75RoadTrip\u00a78] \u00a77Disconnected you because your \u00a73" + String.valueOf(this.timeoutAutoLogTimer.get()) + "\u00a77-second timer has elapsed\u00a7a..!"));
            if (((Boolean)this.forceKick.get()).booleanValue()) {
                this.doForceKick((class_2561)reason);
            } else {
                this.disconnect((class_2561)reason);
            }
        }
        if (((Boolean)this.yLevelAutoLog.get()).booleanValue() && this.mc.field_1724.method_23318() < (double)((Integer)this.yLevelThreshold.get()).intValue()) {
            class_5250 reason = class_2561.method_43470((String)("\u00a78[\u00a74RoadTrip\u00a78] \u00a7fDisconnected you because your Y level descended below \u00a7c" + String.valueOf(this.yLevelThreshold.get()) + "\u00a78!"));
            if (((Boolean)this.forceKick.get()).booleanValue()) {
                this.doForceKick((class_2561)reason);
            } else {
                this.disconnect((class_2561)reason);
            }
        }
        if (((Boolean)this.lowElytraAutoLog.get()).booleanValue() && !this.hasEnoughElytras()) {
            class_5250 reason = class_2561.method_43470((String)"\u00a78[\u00a72RoadTrip\u00a78] \u00a7fDisconnected you because you are running low on healthy elytras\u00a7c!");
            if (((Boolean)this.forceKick.get()).booleanValue()) {
                this.doForceKick((class_2561)reason);
            } else {
                this.disconnect((class_2561)reason);
            }
        }
        if (((Boolean)this.lowRocketsAutoLog.get()).booleanValue() && !this.hasEnoughRockets()) {
            class_5250 reason = class_2561.method_43470((String)"\u00a78[\u00a72RoadTrip\u00a78] \u00a7fDisconnected you because you are running low on firework rockets\u00a7c!");
            if (((Boolean)this.forceKick.get()).booleanValue()) {
                this.doForceKick((class_2561)reason);
            } else {
                this.disconnect((class_2561)reason);
            }
        }
        if (((Boolean)this.lowFoodAutoLog.get()).booleanValue() && !this.hasEnoughFood()) {
            class_5250 reason = class_2561.method_43470((String)"\u00a78[\u00a72RoadTrip\u00a78] \u00a7fDisconnected you because you are running low on food\u00a7c!");
            if (((Boolean)this.forceKick.get()).booleanValue()) {
                this.doForceKick((class_2561)reason);
            } else {
                this.disconnect((class_2561)reason);
            }
        }
        class_2338 newPos = this.mc.field_1724.method_24515();
        if (this.lastPos == null) {
            this.lastPos = newPos;
        } else if (this.lastPos.method_19455((class_2382)newPos) <= 1) {
            ++this.ticksNotMoved;
            this.lastPos = newPos;
        }
        class_2338 destination = new class_2338(((Integer)this.targetX.get()).intValue(), this.mc.field_1724.method_31478(), ((Integer)this.targetZ.get()).intValue());
        int totalBlocksLeft = newPos.method_19455((class_2382)destination);
        double blocksPerSecond = Utils.getPlayerSpeed().method_37267();
        if (((Boolean)this.etaAutoLog.get()).booleanValue() && totalBlocksLeft <= (Integer)this.etaAutoLogThreshold.get() && this.mc.method_1562().method_2880().size() > 1) {
            class_5250 reason = class_2561.method_43470((String)"\u00a78[\u00a72RoadTrip\u00a78] \u00a7fDisconnected you because you have reached your destination\u00a72! \u00a75:\u00a73]");
            if (((Boolean)this.forceKick.get()).booleanValue()) {
                this.doForceKick((class_2561)reason);
            } else {
                this.disconnect((class_2561)reason);
            }
        }
        if (((Boolean)this.etaSetting.get()).booleanValue()) {
            if (this.bpsValues.size() > this.bufferSize) {
                int diff = this.bpsValues.size() - this.bufferSize;
                for (int n = 0; n < diff; ++n) {
                    if (this.bpsValues.isEmpty()) continue;
                    this.bpsValues.removeFirst();
                }
            } else if (this.bpsValues.size() == this.bufferSize) {
                if (!this.bpsValues.isEmpty()) {
                    this.bpsValues.removeFirst();
                }
                this.bpsValues.add(blocksPerSecond);
            } else {
                this.bpsValues.add(blocksPerSecond);
            }
            if ((Integer)this.averageSpeedMinutes.get() > 0) {
                double average = 0.0;
                for (double d : this.bpsValues) {
                    average += d;
                }
                if (((Boolean)this.averageETA.get()).booleanValue()) {
                    blocksPerSecond = average / (double)this.bpsValues.size();
                }
                if (((Boolean)this.speedUpdates.get()).booleanValue() && this.timer >= 20) {
                    MsgUtil.updateMsg("Average speed over " + String.valueOf(this.averageSpeedMinutes.get()) + " minute(s): " + Math.floor(average / (double)this.bpsValues.size()) * 3600.0 / 1000.0 + "Km/h", "averageBPSUpdate".hashCode());
                }
            }
            if (this.timer >= 20) {
                this.timer = 0;
                if (blocksPerSecond == 0.0) {
                    double verticalBPS = Utils.getPlayerSpeed().field_1351;
                    if (verticalBPS == 0.0) {
                        return;
                    }
                    MsgUtil.updateMsg("Vertical Speed: \u00a76\u00a7o" + Math.floor(verticalBPS) + "\u00a77\u00a7ob/s. \u00a75\u00a7o" + Math.floor(verticalBPS) * 3600.0 / 1000.0 + "\u00a77\u00a7oKm/h", "verticalSpeedUpdate".hashCode());
                    return;
                }
                double totalSeconds = (double)totalBlocksLeft / blocksPerSecond;
                long days = TimeUnit.SECONDS.toDays((long)totalSeconds);
                long hours = TimeUnit.SECONDS.toHours((long)(totalSeconds -= (double)TimeUnit.DAYS.toSeconds(days)));
                long minutes = TimeUnit.SECONDS.toMinutes((long)(totalSeconds -= (double)TimeUnit.HOURS.toSeconds(hours)));
                long seconds = TimeUnit.SECONDS.toSeconds((long)(totalSeconds -= (double)TimeUnit.MINUTES.toSeconds(minutes)));
                StringBuilder sb = new StringBuilder().append(StardustUtil.rCC()).append("\u00a78<\u00a7a\u00a7o\u2728\u00a7r\u00a78> \u00a77\u00a7oETA: \u00a72\u00a7o");
                if (days == 0L && hours == 0L && minutes == 0L && seconds <= 3L) {
                    if (totalBlocksLeft <= 69) {
                        sb.append("\u00a72\u00a7oYou have arrived at your destination\u00a78\u00a7o. \u00a75:\u00a73]");
                    } else {
                        sb.append("Imminent\u00a78\u00a7o...");
                    }
                } else {
                    if (days != 0L) {
                        sb.append(days).append(" \u00a77\u00a7oDays, \u00a72\u00a7o");
                    }
                    if (hours != 0L) {
                        sb.append(hours).append(" \u00a77\u00a7oHours, \u00a72\u00a7o");
                    }
                    if (minutes != 0L) {
                        sb.append(minutes).append(" \u00a77\u00a7oMinutes, \u00a72\u00a7o");
                    }
                    if (seconds != 0L) {
                        sb.append(seconds).append(" \u00a77\u00a7oSeconds.");
                    }
                }
                MsgUtil.updateMsg(sb.toString(), "RoadTripETAUpdate".hashCode());
            }
            this.lastPos = newPos;
        }
    }

    @EventHandler(priority=200)
    private void onEntityAddHighPriority(EntityAddedEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (!((Boolean)this.antiTrapAutoLog.get()).booleanValue() || event.entity.method_5864() != class_1299.field_6053) {
            return;
        }
        this.doForceKick((class_2561)class_2561.method_43470((String)"\u00a78[\u00a7aRoadTrip\u00a78] \u00a7c\u00a7oDisconnected you to avoid a trap\u00a78\u00a7o! \u00a78\u00a7o(\u00a7c\u00a7oTNT minecarts \u00a77\u00a7owere rendered\u00a7c\u00a7o!\u00a78\u00a7o)"));
    }

    @EventHandler(priority=200)
    private void onPacketReceive(PacketEvent.Receive event) {
        class_2661 packet;
        block7: {
            block6: {
                class_2596 class_25962 = event.packet;
                if (!(class_25962 instanceof class_2661)) break block6;
                packet = (class_2661)class_25962;
                if (this.disconnectReason != null) break block7;
            }
            return;
        }
        ((DisconnectS2CPacketAccessor)packet).setReason(this.disconnectReason);
        switch (((ToggleModes)((Object)this.autoLogToggle.get())).ordinal()) {
            case 0: {
                this.toggle();
                break;
            }
            case 1: {
                this.disableAutoLogSettings();
            }
        }
    }

    public static enum ToggleModes {
        Module,
        Settings,
        None;

    }
}

