/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.stardust.Stardust;
import dev.stardust.mixin.accessor.AbstractSignEditScreenAccessor;
import dev.stardust.mixin.accessor.ClientConnectionAccessor;
import dev.stardust.modules.WaxAura;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.events.entity.player.InteractBlockEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.GenericSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.blockesp.ESPBlockData;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.WireframeEntityRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1822;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2508;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2522;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2846;
import net.minecraft.class_2877;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4719;
import net.minecraft.class_5321;
import net.minecraft.class_642;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7743;
import net.minecraft.class_8242;
import org.jetbrains.annotations.NotNull;

public class SignHistorian
extends Module {
    private final String BLACKLIST_FILE = "meteor-client/sign-historian/content-blacklist.txt";
    private final SettingGroup sgESP = this.settings.createGroup("ESP Settings");
    private final SettingGroup sgSigns = this.settings.createGroup("Signs Settings");
    private final SettingGroup sgBlacklist = this.settings.createGroup("Content Blacklist");
    private final SettingGroup sgPrevention = this.settings.createGroup("Grief Prevention");
    private final Setting<Boolean> espSigns = this.sgESP.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ESP-signs")).description("Quick toggle for broken/modified ESP.")).defaultValue((Object)true)).build());
    private final Setting<Integer> espRange = this.sgESP.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("ESP-range")).description("Range in blocks to render broken or modified signs.")).range(16, 512).sliderRange(16, 256).defaultValue((Object)128)).build());
    private final Setting<Boolean> dynamicColor = this.sgESP.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("dynamic-color")).description("Derive ESP side color from the sign's wood type.")).defaultValue((Object)true)).build());
    private final Setting<ESPBlockData> destroyedSettings = this.sgESP.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("destroyed/Missing-signs-ESP")).description("Tip: left-click on the block a ghost sign is rendered on to view its original text content in your chat.")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(255, 42, 0, 255), new SettingColor(255, 42, 0, 69), true, new SettingColor(255, 42, 0, 137)))).build());
    private final Setting<ESPBlockData> modifiedSettings = this.sgESP.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("modified-signs-ESP")).description("Tip: right-click on a modified sign to view its original text content in your chat.")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(237, 255, 42, 255), new SettingColor(237, 255, 42, 44), true, new SettingColor(237, 255, 42, 137)))).build());
    private final Setting<Boolean> strictSetting = this.sgSigns.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("strict-mode")).description("Only consider signs to be restored if they have the same dye color and glow ink values as the original.")).defaultValue((Object)false)).build());
    private final Setting<Boolean> persistenceSetting = this.sgSigns.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("persistence")).description("Save sign data to a file in order to persist SignHistorian's powers across play-sessions.")).defaultValue((Object)false)).onChanged(it -> {
        if (it.booleanValue()) {
            if (this.serverSigns.isEmpty()) {
                this.initOrLoadFromSignFile();
            } else {
                for (class_3545<class_2625, class_2680> entry : this.serverSigns.values()) {
                    this.saveSignToFile((class_2625)entry.method_15442(), (class_2680)entry.method_15441());
                }
                this.initOrLoadFromSignFile();
            }
        }
    })).build());
    private final Setting<Boolean> ignoreBrokenSetting = this.sgSigns.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-purposefully-broken")).description("Ignores signs you break on purpose (but still tracks them in case you change your mind later.)")).defaultValue((Object)false)).build());
    private final Setting<Boolean> waxRestoration = this.sgSigns.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("wax-restored-signs")).description("Automatically waxes signs that SignHistorian has restored.")).defaultValue((Object)true)).build());
    private final Setting<Integer> packetDelay = this.sgSigns.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("packet-delay")).description("How many ticks to delay before sending the UpdateSign packet. Lower values have a higher chance of being rejected by the AC.")).range(0, 500).sliderRange(0, 50).defaultValue((Object)20)).build());
    private final Setting<Boolean> contentBlacklist = this.sgBlacklist.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("content-blacklist")).description("Ignore signs that contain specific words or phrases (line-separated list in sign-historian/content-blacklist.txt)")).defaultValue((Object)false)).onChanged(it -> {
        if (it.booleanValue() && StardustUtil.checkOrCreateFile(this.mc, "meteor-client/sign-historian/content-blacklist.txt")) {
            this.blacklisted.clear();
            this.initBlacklistText();
            if (this.mc.field_1724 != null) {
                MsgUtil.sendModuleMsg("Please write one blacklisted item for each line of the file.", this.name);
                MsgUtil.sendModuleMsg("Spaces and other punctuation will be treated literally.", this.name);
                MsgUtil.sendModuleMsg("You must toggle this setting or the module after updating the file's contents.", this.name);
            }
        }
    })).build());
    private final Setting<Boolean> openBlacklistFile = this.sgBlacklist.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("open-blacklist-file")).description("Open the content-blacklist.txt file.")).defaultValue((Object)false)).onChanged(it -> {
        if (it.booleanValue()) {
            if (StardustUtil.checkOrCreateFile(this.mc, "meteor-client/sign-historian/content-blacklist.txt")) {
                StardustUtil.openFile("meteor-client/sign-historian/content-blacklist.txt");
            }
            this.resetBlacklistFileSetting();
        }
    })).build());
    private final Setting<Boolean> griefPrevention = this.sgPrevention.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mob-grief-alarm")).description("Warns you when nearby signs are in danger of an approaching creeper or wither.")).defaultValue((Object)true)).build());
    private final Setting<Boolean> chatNotification = this.sgPrevention.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-notification")).description("Warns you in chat when nearby signs are in danger of an approaching creeper.")).defaultValue((Object)true)).build());
    private final Setting<Double> alarmVolume = this.sgPrevention.add((Setting)((DoubleSetting.Builder)new DoubleSetting.Builder().name("volume")).sliderMax(0.0).sliderMax(200.0).defaultValue(0.0).build());
    private final Setting<ESPBlockData> dangerESP = this.sgPrevention.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("grief-prevention-ESP")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(255, 0, 25, 255), new SettingColor(255, 0, 25, 255), true, new SettingColor(255, 0, 25, 255)))).build());
    private int timer = 0;
    private int dyeSlot = -1;
    private int pingTicks = 0;
    private int gracePeriod = 0;
    private int packetTimer = 0;
    private int rotationPriority = 69420;
    private boolean didDisableWaxAura = false;
    @Nullable
    private class_2338 lastTargetedSign = null;
    @Nullable
    private class_5321<class_1937> currentDim = null;
    private final HashSet<String> blacklisted = new HashSet();
    private final Set<class_2338> signsBrokenByPlayer = new HashSet<class_2338>();
    private final Set<class_2625> modifiedSigns = new HashSet<class_2625>();
    private final Set<class_2625> destroyedSigns = new HashSet<class_2625>();
    private final HashSet<class_2625> signsToWax = new HashSet();
    private final HashSet<class_2625> signsToGlowInk = new HashSet();
    private final HashMap<Integer, class_243> trackedGriefers = new HashMap();
    private final HashSet<class_1588> approachingGriefers = new HashSet();
    private final ArrayDeque<class_2877> packetQueue = new ArrayDeque();
    private final HashMap<class_2625, class_4719> woodTypeMap = new HashMap();
    private final HashMap<class_2625, class_1767> signsToColor = new HashMap();
    private final HashMap<Integer, class_3545<Boolean, Long>> grieferHadLineOfSight = new HashMap();
    private final Map<class_2338, class_3545<class_2625, class_2680>> serverSigns = new HashMap<class_2338, class_3545<class_2625, class_2680>>();

    public SignHistorian() {
        super(Stardust.CATEGORY, "SignHistorian", "Records & restores broken or modified signs.");
    }

    private void initBlacklistText() {
        File blackListFile = FabricLoader.getInstance().getGameDir().resolve("meteor-client/sign-historian/content-blacklist.txt").toFile();
        try (Stream<String> lineStream = Files.lines(blackListFile.toPath());){
            this.blacklisted.addAll(lineStream.toList());
        }
        catch (Exception err) {
            LogUtil.error("Failed to read from " + blackListFile.getAbsolutePath() + "! - Why:\n" + String.valueOf(err), this.name);
        }
    }

    private void resetBlacklistFileSetting() {
        this.openBlacklistFile.set((Object)false);
    }

    private void initOrLoadFromSignFile() {
        if (this.mc.field_1687 == null || this.mc.method_1562() == null) {
            return;
        }
        Path historianFolder = FabricLoader.getInstance().getGameDir().resolve("meteor-client/sign-historian");
        try {
            String address;
            historianFolder.toFile().mkdirs();
            class_642 server = this.mc.method_1562().method_45734();
            if (server == null) {
                return;
            }
            String dimKey = this.currentDim != null ? this.currentDim.method_29177().toString().replace("minecraft:", "") : this.mc.field_1687.method_27983().method_29177().toString().replace("minecraft:", "");
            Path signsFile = historianFolder.resolve(dimKey + "." + (address = server.field_3761.replace(":", "_")) + ".signs");
            if (signsFile.toFile().exists()) {
                this.readSignsFromFile(signsFile);
            } else if (signsFile.toFile().createNewFile()) {
                MsgUtil.sendModuleMsg("Sign data will be saved to \u00a72\u00a7o" + String.valueOf(signsFile.getFileName()) + " \u00a77in your \u00a77\u00a7ometeor-client/sign-historian \u00a77folder.", this.name);
                this.readSignsFromFile(signsFile);
            }
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
    }

    private void readSignsFromFile(Path signsFile) {
        try (Stream<String> lineStream = Files.lines(signsFile);){
            List<String> entries = lineStream.toList();
            for (String sign : entries) {
                try {
                    class_2586 be;
                    String[] parts = sign.split(" -\\|- ");
                    if (parts.length != 2) continue;
                    class_2487 reconstructed = class_2522.method_10718((String)parts[0].trim());
                    class_2487 stateReconstructed = class_2522.method_10718((String)parts[1].trim());
                    class_2338 bPos = class_2586.method_38239((class_2487)reconstructed);
                    DataResult result = class_2680.field_24734.parse((DynamicOps)class_2509.field_11560, (Object)stateReconstructed);
                    class_2680 state = result.result().orElse(null);
                    if (state == null || !((be = class_2586.method_11005((class_2338)bPos, (class_2680)state, (class_2487)reconstructed, (class_7225.class_7874)this.mc.field_1687.method_30349())) instanceof class_2625)) continue;
                    class_2625 sbeReconstructed = (class_2625)be;
                    if (this.serverSigns.containsKey(bPos)) continue;
                    class_2248 class_22482 = state.method_26204();
                    if (class_22482 instanceof class_2478) {
                        class_2478 signBlock = (class_2478)class_22482;
                        this.woodTypeMap.put(sbeReconstructed, signBlock.method_24025());
                    }
                    this.serverSigns.put(bPos, (class_3545<class_2625, class_2680>)new class_3545((Object)sbeReconstructed, (Object)sbeReconstructed.method_11010()));
                }
                catch (Exception err) {
                    LogUtil.error("Failed to parse SignBlockEntity Nbt: " + String.valueOf(err), this.name);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error(e.toString(), this.name);
        }
    }

    private void writeSignToFile(class_2487 metadata, class_2487 cachedState, Path signsFile) {
        try {
            Files.writeString(signsFile, (CharSequence)(String.valueOf(metadata) + " -|- " + String.valueOf(cachedState) + "\n"), StandardOpenOption.APPEND);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
    }

    private void saveSignToFile(class_2625 sign, class_2680 state) {
        if (this.mc.field_1687 == null || this.mc.method_1562() == null) {
            return;
        }
        Path historianFolder = FabricLoader.getInstance().getGameDir().resolve("meteor-client/sign-historian");
        try {
            String address;
            class_2487 stateNbt = class_2512.method_10686((class_2680)state);
            class_2487 metadata = sign.method_38242((class_7225.class_7874)this.mc.field_1687.method_30349());
            historianFolder.toFile().mkdirs();
            class_642 server = this.mc.method_1562().method_45734();
            if (server == null) {
                return;
            }
            String dimKey = this.currentDim != null ? this.currentDim.method_29177().toString().replace("minecraft:", "") : this.mc.field_1687.method_27983().method_29177().toString().replace("minecraft:", "");
            Path signsFile = historianFolder.resolve(dimKey + "." + (address = server.field_3761.replace(":", "_")) + ".signs");
            if (signsFile.toFile().exists()) {
                this.writeSignToFile(metadata, stateNbt, signsFile);
            } else if (signsFile.toFile().createNewFile()) {
                this.writeSignToFile(metadata, stateNbt, signsFile);
            }
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
    }

    private class_243 getTracerOffset(class_2338 pos, class_2680 state) {
        double offsetZ;
        double offsetY;
        double offsetX;
        try {
            if (state.method_26204() instanceof class_2508 || state.method_26204() instanceof class_7713) {
                offsetX = (double)pos.method_10263() + 0.5;
                offsetY = (double)pos.method_10264() + 0.5;
                offsetZ = (double)pos.method_10260() + 0.5;
            } else if (state.method_26204() instanceof class_2551 || state.method_26204() instanceof class_7715) {
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2551.field_11726);
                switch (facing) {
                    case field_11043: {
                        offsetX = (double)pos.method_10263() + 0.5;
                        offsetY = (double)pos.method_10264() + 0.5;
                        offsetZ = (double)pos.method_10260() + 0.937;
                        break;
                    }
                    case field_11034: {
                        offsetX = (double)pos.method_10263() + 0.1337;
                        offsetY = (double)pos.method_10264() + 0.5;
                        offsetZ = (double)pos.method_10260() + 0.5;
                        break;
                    }
                    case field_11035: {
                        offsetX = (double)pos.method_10263() + 0.5;
                        offsetY = (double)pos.method_10264() + 0.5;
                        offsetZ = (double)pos.method_10260() + 0.1337;
                        break;
                    }
                    case field_11039: {
                        offsetX = (double)pos.method_10263() + 0.937;
                        offsetY = (double)pos.method_10264() + 0.5;
                        offsetZ = (double)pos.method_10260() + 0.5;
                        break;
                    }
                    default: {
                        offsetX = (double)pos.method_10263() + 0.5;
                        offsetY = (double)pos.method_10264() + 0.5;
                        offsetZ = (double)pos.method_10260() + 0.5;
                        break;
                    }
                }
            } else {
                offsetX = (double)pos.method_10263() + 0.5;
                offsetY = (double)pos.method_10264() + 0.5;
                offsetZ = (double)pos.method_10260() + 0.5;
            }
        }
        catch (Exception err) {
            offsetX = (double)pos.method_10263() + 0.5;
            offsetY = (double)pos.method_10264() + 0.5;
            offsetZ = (double)pos.method_10260() + 0.5;
        }
        return new class_243(offsetX, offsetY, offsetZ);
    }

    private SettingColor colorFromWoodType(@Nullable class_4719 type) {
        if (type == null || !((Boolean)this.dynamicColor.get()).booleanValue()) {
            return ((ESPBlockData)this.dangerESP.get()).sideColor;
        }
        if (type == class_4719.field_21676) {
            return new SettingColor(181, 146, 94, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_21678) {
            return new SettingColor(212, 200, 139, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_21677) {
            return new SettingColor(126, 93, 53, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_21680) {
            return new SettingColor(181, 133, 98, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_21679) {
            return new SettingColor(170, 92, 49, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_40350) {
            return new SettingColor(133, 124, 53, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_42837) {
            return new SettingColor(227, 191, 184, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_22184) {
            return new SettingColor(57, 140, 138, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_22183) {
            return new SettingColor(124, 57, 85, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_37657) {
            return new SettingColor(109, 41, 44, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        if (type == class_4719.field_21681) {
            return new SettingColor(72, 46, 23, ((ESPBlockData)this.dangerESP.get()).sideColor.a);
        }
        return ((ESPBlockData)this.dangerESP.get()).sideColor;
    }

    @Nullable
    private class_2338 getTargetedSign() {
        class_2338 pos;
        class_746 player = this.mc.field_1724;
        if (player == null || this.mc.field_1687 == null) {
            return null;
        }
        class_239 trace = player.method_5745(7.0, 0.0f, false);
        if (trace != null && this.mc.field_1687.method_8321(pos = ((class_3965)trace).method_17777()) instanceof class_2625) {
            return pos;
        }
        return null;
    }

    @Nullable
    public class_8242 getRestoration(class_2625 sign) {
        if (!this.serverSigns.containsKey(sign.method_11016())) {
            return null;
        }
        class_3545<class_2625, class_2680> data = this.serverSigns.get(sign.method_11016());
        if (!this.destroyedSigns.contains(data.method_15442())) {
            return null;
        }
        if (((Boolean)this.contentBlacklist.get()).booleanValue() && this.containsBlacklistedText((class_2625)data.method_15442())) {
            return null;
        }
        if (((Boolean)this.ignoreBrokenSetting.get()).booleanValue() && this.signsBrokenByPlayer.contains(sign.method_11016())) {
            return null;
        }
        class_2625 sbe = (class_2625)data.method_15442();
        class_2561[] restoration = new class_2561[4];
        for (int n = 0; n < ((class_2625)data.method_15442()).method_49853().method_49877(false).length; ++n) {
            if (sbe.method_38244((class_7225.class_7874)this.mc.field_1687.method_30349()).toString().contains("{\"extra\":[") && n == 3) {
                StringBuilder sb = new StringBuilder();
                int lineLen = this.mc.field_1772.method_1727(sbe.method_49853().method_49859(n, false).getString());
                int spaceLeftHalved = (90 - lineLen) / 2;
                while (this.mc.field_1772.method_1727(sb.toString()) < spaceLeftHalved) {
                    sb.append(" ");
                }
                sb.append(sbe.method_49853().method_49859(n, false).getString());
                while (this.mc.field_1772.method_1727(sb.toString()) < 91) {
                    sb.append(" ");
                }
                sb.append("**Pre-1.19 sign restored by 0xTas' SignHistorian**");
                restoration[n] = class_2561.method_30163((String)sb.toString());
                continue;
            }
            restoration[n] = class_2561.method_30163((String)sbe.method_49853().method_49859(n, false).getString());
        }
        if (sbe.method_49853().method_49872() != class_1767.field_7963) {
            this.signsToColor.put(sign, sbe.method_49853().method_49872());
        }
        if (sbe.method_49853().method_49856()) {
            this.signsToGlowInk.add(sign);
        }
        if (((Boolean)this.waxRestoration.get()).booleanValue()) {
            this.signsToWax.add(sign);
        }
        this.destroyedSigns.remove(sbe);
        return new class_8242(restoration, restoration, class_1767.field_7963, false);
    }

    private boolean isSameSign(class_2625 sbe1, class_2625 sbe2) {
        class_8242 front1 = sbe1.method_49853();
        class_8242 front2 = sbe2.method_49853();
        int n = 0;
        for (class_2561 line : front1.method_49877(false)) {
            String compensatedLine = line.getString().replace("**Pre-1.19 sign restored by 0xTas' SignHistorian**", "").trim();
            if (!compensatedLine.equals(front2.method_49859(n, false).getString().trim())) {
                return false;
            }
            ++n;
        }
        if (((Boolean)this.strictSetting.get()).booleanValue()) {
            if (sbe1.method_49853().method_49872() != sbe2.method_49853().method_49872()) {
                return false;
            }
            if (sbe1.method_49853().method_49856() != sbe2.method_49853().method_49856()) {
                return false;
            }
        }
        return ((class_2478)sbe1.method_11010().method_26204()).method_24025() == ((class_2478)sbe2.method_11010().method_26204()).method_24025();
    }

    private boolean containsBlacklistedText(class_2625 sbe) {
        String front = Arrays.stream(sbe.method_49853().method_49877(false)).map(class_2561::getString).collect(Collectors.joining(" ")).trim();
        String back = Arrays.stream(sbe.method_49854().method_49877(false)).map(class_2561::getString).collect(Collectors.joining(" ")).trim();
        return this.blacklisted.stream().anyMatch(line -> front.toLowerCase().contains(line.trim().toLowerCase()) || back.toLowerCase().contains(line.trim().toLowerCase()));
    }

    private boolean hasNearbySigns() {
        if (!Utils.canUpdate()) {
            return false;
        }
        for (class_2338 pos : class_2338.method_25996((class_2338)this.mc.field_1724.method_24515(), (int)6, (int)6, (int)6)) {
            class_2625 sbe;
            class_2586 class_25862 = this.mc.field_1687.method_8321(pos);
            if (!(class_25862 instanceof class_2625) || !(sbe = (class_2625)class_25862).method_49853().method_49861((class_1657)this.mc.field_1724) && !sbe.method_49854().method_49861((class_1657)this.mc.field_1724)) continue;
            return true;
        }
        return false;
    }

    private boolean mobHasLineOfSight(class_1588 mob) {
        class_243 eyePos;
        class_243 mobEyePos = mob.method_33571();
        class_3965 lineOfSightCheck = this.mc.field_1687.method_17742(new class_3959(mobEyePos, eyePos = this.mc.field_1724.method_33571(), class_3959.class_3960.field_17558, class_3959.class_242.field_36338, (class_1297)mob));
        return lineOfSightCheck.method_17783() != class_239.class_240.field_1332;
    }

    private boolean isMobAThreat(class_1588 mob) {
        if (!Utils.canUpdate()) {
            return false;
        }
        class_243 newPos = mob.method_19538();
        class_243 playerPos = this.mc.field_1724.method_19538();
        class_243 lastPos = this.trackedGriefers.get(mob.method_5628());
        if (lastPos == null) {
            return false;
        }
        double newDistance = playerPos.method_1025(newPos);
        double oldDistance = playerPos.method_1025(lastPos);
        long now = System.currentTimeMillis();
        boolean mobHasLoS = this.mobHasLineOfSight(mob);
        if (this.grieferHadLineOfSight.get(mob.method_5628()) == null) {
            this.grieferHadLineOfSight.put(mob.method_5628(), (class_3545<Boolean, Long>)new class_3545((Object)mobHasLoS, (Object)now));
        } else {
            class_3545<Boolean, Long> prevLoSCheck = this.grieferHadLineOfSight.get(mob.method_5628());
            if (mobHasLoS || now - (Long)prevLoSCheck.method_15441() >= 7000L) {
                this.grieferHadLineOfSight.put(mob.method_5628(), (class_3545<Boolean, Long>)new class_3545((Object)mobHasLoS, (Object)now));
            }
        }
        if (mob instanceof class_1548) {
            class_1548 creeper = (class_1548)mob;
            if (newDistance <= (double)class_3532.method_34954((int)10)) {
                return mobHasLoS || newDistance < oldDistance && (Boolean)this.grieferHadLineOfSight.get(creeper.method_5628()).method_15442() != false;
            }
            if (newDistance <= (double)class_3532.method_34954((int)20)) {
                return newDistance < oldDistance && mobHasLoS;
            }
        } else if (mob instanceof class_1528) {
            class_1528 wither = (class_1528)mob;
            if (newDistance <= (double)class_3532.method_34954((int)16)) {
                return true;
            }
            if (newDistance <= (double)class_3532.method_34954((int)32)) {
                return mobHasLoS || newDistance < oldDistance && (Boolean)this.grieferHadLineOfSight.get(wither.method_5628()).method_15442() != false;
            }
            if (newDistance <= (double)class_3532.method_34954((int)48)) {
                return newDistance < oldDistance && mobHasLoS;
            }
        }
        return false;
    }

    private void processSign(@NotNull class_2625 sbe) {
        if (!sbe.method_49853().method_49861((class_1657)this.mc.field_1724) && !sbe.method_49854().method_49861((class_1657)this.mc.field_1724)) {
            return;
        }
        if (((Boolean)this.contentBlacklist.get()).booleanValue() && this.containsBlacklistedText(sbe)) {
            return;
        }
        class_2338 pos = sbe.method_11016();
        if (this.serverSigns.containsKey(pos)) {
            if (this.isSameSign(sbe, (class_2625)this.serverSigns.get(pos).method_15442())) {
                this.modifiedSigns.remove(this.serverSigns.get(pos).method_15442());
            } else {
                this.modifiedSigns.add((class_2625)this.serverSigns.get(pos).method_15442());
            }
            this.destroyedSigns.remove(this.serverSigns.get(pos).method_15442());
        } else {
            class_2248 class_22482 = sbe.method_11010().method_26204();
            if (class_22482 instanceof class_2478) {
                class_2478 signBlock = (class_2478)class_22482;
                this.woodTypeMap.put(sbe, signBlock.method_24025());
            }
            this.serverSigns.put(pos, (class_3545<class_2625, class_2680>)new class_3545((Object)sbe, (Object)sbe.method_11010()));
            if (((Boolean)this.persistenceSetting.get()).booleanValue()) {
                this.saveSignToFile(sbe, sbe.method_11010());
            }
        }
    }

    private void interactSign(class_2625 sbe, class_1792 dye) {
        if (!Utils.canUpdate() || this.mc.field_1761 == null) {
            return;
        }
        class_2338 pos = sbe.method_11016();
        class_243 hitVec = class_243.method_24953((class_2382)pos);
        class_3965 hit = new class_3965(hitVec, this.mc.field_1724.method_5735().method_10153(), pos, false);
        class_1799 current = this.mc.field_1724.method_31548().method_7391();
        if (current.method_7909() != dye) {
            for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
                class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
                if (stack.method_7909() != dye) continue;
                if (current.method_7909() instanceof class_1822 && current.method_7947() > 1) {
                    this.dyeSlot = n;
                }
                if (n < 9) {
                    InvUtils.swap((int)n, (boolean)true);
                } else {
                    InvUtils.move().from(n).to(this.mc.field_1724.method_31548().field_7545);
                }
                this.timer = 3;
                return;
            }
        } else {
            Rotations.rotate((double)Rotations.getYaw((class_2338)pos), (double)Rotations.getPitch((class_2338)pos), (int)this.rotationPriority, () -> this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, hit));
            ++this.rotationPriority;
        }
        if (dye == class_1802.field_28410) {
            this.signsToGlowInk.remove(sbe);
            if (!this.signsToWax.contains(sbe) && !this.signsToColor.containsKey(sbe)) {
                this.timer = -1;
            }
        } else if (dye == class_1802.field_20414) {
            this.signsToWax.remove(sbe);
            if (!this.signsToColor.containsKey(sbe) && !this.signsToGlowInk.contains(sbe)) {
                this.timer = -1;
            }
        } else {
            this.signsToColor.remove(sbe);
            if (!this.signsToGlowInk.contains(sbe) && !this.signsToWax.contains(sbe)) {
                this.timer = -1;
            }
        }
    }

    public void onActivate() {
        if (!Utils.canUpdate()) {
            this.toggle();
            return;
        }
        if (((Boolean)this.persistenceSetting.get()).booleanValue()) {
            this.initOrLoadFromSignFile();
        }
        if (((Boolean)this.contentBlacklist.get()).booleanValue() && StardustUtil.checkOrCreateFile(this.mc, "meteor-client/sign-historian/content-blacklist.txt")) {
            this.initBlacklistText();
        }
    }

    public void onDeactivate() {
        this.timer = 0;
        this.pingTicks = 0;
        this.gracePeriod = 0;
        this.currentDim = null;
        this.signsToWax.clear();
        this.woodTypeMap.clear();
        this.serverSigns.clear();
        this.packetQueue.clear();
        this.signsToColor.clear();
        this.modifiedSigns.clear();
        this.destroyedSigns.clear();
        this.signsToGlowInk.clear();
        this.trackedGriefers.clear();
        this.lastTargetedSign = null;
        this.rotationPriority = 69420;
        this.didDisableWaxAura = false;
        this.approachingGriefers.clear();
        this.signsBrokenByPlayer.clear();
        this.grieferHadLineOfSight.clear();
    }

    @EventHandler
    private void onBlockInteract(InteractBlockEvent event) {
        if (!Utils.canUpdate()) {
            return;
        }
        for (class_2625 sbe : this.modifiedSigns) {
            if (!event.result.method_17777().method_19771((class_2382)sbe.method_11016(), 1.0)) continue;
            MsgUtil.sendModuleMsg("\u00a7e\u00a7lOriginal\u00a77\u00a7l: \u00a77\u00a7o" + Arrays.stream(sbe.method_49853().method_49877(false)).map(class_2561::getString).collect(Collectors.joining(" ")), this.name);
            MsgUtil.sendModuleMsg("\u00a76\u00a7lWoodType\u00a77\u00a7l: " + ((class_2478)sbe.method_11010().method_26204()).method_24025().comp_1299() + " | \u00a73\u00a7lColor\u00a77\u00a7l: " + sbe.method_49843(true).method_49872().name() + " | \u00a7f\u00a7lGlow Ink\u00a77\u00a7l: " + sbe.method_49843(true).method_49856(), this.name);
            return;
        }
    }

    @EventHandler(priority=200)
    private void onBlockAttack(PacketEvent.Send event) {
        if (!Utils.canUpdate()) {
            return;
        }
        class_2596 class_25962 = event.packet;
        if (!(class_25962 instanceof class_2846)) {
            return;
        }
        class_2846 packet = (class_2846)class_25962;
        if (packet.method_12363() != class_2846.class_2847.field_12968) {
            return;
        }
        for (class_2625 ghost : this.destroyedSigns) {
            if (!packet.method_12362().method_19771((class_2382)ghost.method_11016(), 1.5)) continue;
            MsgUtil.sendModuleMsg("\u00a7e\u00a7lOriginal\u00a77\u00a7l: \u00a77\u00a7o" + Arrays.stream(ghost.method_49853().method_49877(false)).map(class_2561::getString).collect(Collectors.joining(" ")), this.name);
            MsgUtil.sendModuleMsg("\u00a76\u00a7lWoodType\u00a77\u00a7l: " + ((class_2478)ghost.method_11010().method_26204()).method_24025().comp_1299() + " | \u00a73\u00a7lColor\u00a77\u00a7l: " + ghost.method_49843(true).method_49872().name() + " | \u00a7f\u00a7lGlow Ink\u00a77\u00a7l: " + ghost.method_49843(true).method_49856(), this.name);
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (event.oldState.method_26204() instanceof class_2508 && !(event.newState.method_26204() instanceof class_2508) || event.oldState.method_26204() instanceof class_7713 && !(event.newState.method_26204() instanceof class_7713) || event.oldState.method_26204() instanceof class_2551 && !(event.newState.method_26204() instanceof class_2551) || event.oldState.method_26204() instanceof class_7715 && !(event.newState.method_26204() instanceof class_7715)) {
            if (this.lastTargetedSign == null) {
                return;
            }
            if (this.lastTargetedSign.method_10263() == event.pos.method_10263() && this.lastTargetedSign.method_10264() == event.pos.method_10264() && this.lastTargetedSign.method_10260() == event.pos.method_10260()) {
                this.signsBrokenByPlayer.add(event.pos);
            }
        }
    }

    @EventHandler
    private void onScreenOpened(OpenScreenEvent event) {
        class_437 class_4372 = event.screen;
        if (!(class_4372 instanceof class_7743)) {
            return;
        }
        class_7743 editScreen = (class_7743)class_4372;
        class_2625 sign = ((AbstractSignEditScreenAccessor)editScreen).getBlockEntity();
        class_8242 restoration = this.getRestoration(sign);
        if (restoration != null) {
            event.cancel();
            List<String> msgs = Arrays.stream(restoration.method_49877(false)).map(class_2561::getString).toList();
            String[] messages = new String[msgs.size()];
            messages = msgs.toArray(messages);
            if (this.packetQueue.isEmpty()) {
                this.packetTimer = 0;
            }
            this.packetQueue.addLast(new class_2877(sign.method_11016(), true, messages[0], messages[1], messages[2], messages[3]));
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (this.currentDim == null) {
            this.currentDim = this.mc.field_1687.method_27983();
        } else if (this.currentDim != this.mc.field_1687.method_27983()) {
            this.serverSigns.clear();
            this.currentDim = this.mc.field_1687.method_27983();
            if (((Boolean)this.persistenceSetting.get()).booleanValue()) {
                this.initOrLoadFromSignFile();
            }
        }
        if (!this.packetQueue.isEmpty() && this.mc.method_1562() != null) {
            ++this.packetTimer;
            if (this.packetTimer >= (Integer)this.packetDelay.get()) {
                this.packetTimer = 0;
                ((ClientConnectionAccessor)this.mc.method_1562().method_48296()).invokeSendImmediately((class_2596)this.packetQueue.removeFirst(), null, true);
            }
        }
        class_2338 targeted = this.getTargetedSign();
        if (this.lastTargetedSign == null) {
            this.lastTargetedSign = targeted;
        } else if (targeted == null) {
            if (this.gracePeriod < 2) {
                ++this.gracePeriod;
            } else {
                this.gracePeriod = 0;
                this.lastTargetedSign = null;
            }
        } else {
            this.lastTargetedSign = targeted;
        }
        if (this.mc.field_1755 instanceof class_7743) {
            return;
        }
        if (this.timer == -1 && this.dyeSlot != -1) {
            if (this.dyeSlot < 9) {
                InvUtils.swapBack();
            } else {
                InvUtils.move().from(this.mc.field_1724.method_31548().field_7545).to(this.dyeSlot);
            }
            this.dyeSlot = -1;
            this.timer = 3;
        }
        WaxAura waxAura = (WaxAura)Modules.get().get(WaxAura.class);
        if (!(this.signsToColor.isEmpty() && this.signsToGlowInk.isEmpty() && this.signsToWax.isEmpty() || !waxAura.isActive())) {
            waxAura.toggle();
            this.didDisableWaxAura = true;
        }
        if (this.timer % 2 == 0) {
            class_2625 sbe2;
            List<class_2338> inRange = this.serverSigns.keySet().stream().filter(pos -> pos.method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.espRange.get()).intValue())).toList();
            Iterator<Object> iterator = inRange.iterator();
            while (iterator.hasNext()) {
                class_2338 pos2 = iterator.next();
                class_2586 class_25862 = this.mc.field_1687.method_8321(pos2);
                if (!(class_25862 instanceof class_2625)) {
                    this.destroyedSigns.add((class_2625)this.serverSigns.get(pos2).method_15442());
                    this.modifiedSigns.remove(this.serverSigns.get(pos2).method_15442());
                    continue;
                }
                sbe2 = (class_2625)class_25862;
                this.processSign(sbe2);
            }
            for (class_2586 be : Utils.blockEntities()) {
                if (!(be instanceof class_2625)) continue;
                sbe2 = (class_2625)be;
                this.processSign(sbe2);
            }
        } else if (((Boolean)this.griefPrevention.get()).booleanValue()) {
            for (Object entity : this.mc.field_1687.method_18112()) {
                class_1548 griefingMob;
                if (entity instanceof class_1548) {
                    class_1548 creeper;
                    griefingMob = creeper = (class_1548)entity;
                } else {
                    if (!(entity instanceof class_1528)) continue;
                    class_1528 wither = (class_1528)entity;
                    griefingMob = wither;
                }
                if (this.trackedGriefers.containsKey(griefingMob.method_5628())) continue;
                this.trackedGriefers.put(griefingMob.method_5628(), griefingMob.method_19538());
            }
            if (!this.hasNearbySigns()) {
                this.approachingGriefers.clear();
            } else {
                Object entity;
                this.approachingGriefers.removeIf(class_1297::method_31481);
                this.approachingGriefers.removeIf(mob -> !this.isMobAThreat((class_1588)mob));
                ++this.pingTicks;
                if (!this.approachingGriefers.isEmpty() && this.pingTicks >= 60) {
                    this.pingTicks = 0;
                    this.mc.field_1724.method_5783(class_3417.field_15149, ((Double)this.alarmVolume.get()).floatValue(), 1.0f);
                    if (((Boolean)this.chatNotification.get()).booleanValue()) {
                        MsgUtil.updateModuleMsg("\u00a7c\u00a7lNEARBY SIGNS IN DANGER OF MOB GRIEFING\u00a78\u00a7L.", this.name, "MobGriefAlarm".hashCode());
                    }
                }
                ArrayList<Integer> toRemove = new ArrayList<Integer>();
                entity = this.trackedGriefers.keySet().iterator();
                while (entity.hasNext()) {
                    int id = (Integer)entity.next();
                    class_1297 griefingEntity = this.mc.field_1687.method_8469(id);
                    if (griefingEntity == null || griefingEntity.method_31481() || !(griefingEntity instanceof class_1548) && !(griefingEntity instanceof class_1528)) {
                        if (griefingEntity != null) {
                            this.grieferHadLineOfSight.remove(griefingEntity.method_5628());
                        }
                        toRemove.add(id);
                        continue;
                    }
                    class_1588 griefer = (class_1588)griefingEntity;
                    if (this.isMobAThreat(griefer)) {
                        this.approachingGriefers.add(griefer);
                    }
                    this.trackedGriefers.put(id, griefer.method_19538());
                }
                entity = toRemove.iterator();
                while (entity.hasNext()) {
                    int id = (Integer)entity.next();
                    this.trackedGriefers.remove(id);
                }
            }
        }
        ++this.timer;
        if (this.timer > 4) {
            List signs;
            this.timer = 0;
            this.signsToWax.removeIf(sbe -> !sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 6.0));
            this.signsToGlowInk.removeIf(sbe -> !sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 6.0));
            List<class_2625> toColor = this.signsToColor.keySet().stream().filter(sbe -> sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 6.0)).toList();
            if (!toColor.isEmpty()) {
                class_2625 sbe3 = toColor.get(0);
                this.interactSign(sbe3, (class_1792)class_1769.method_7803((class_1767)this.signsToColor.get(sbe3)));
                return;
            }
            if (!this.signsToGlowInk.isEmpty() && !(signs = this.signsToGlowInk.stream().toList()).isEmpty()) {
                class_2625 sbe4 = (class_2625)signs.get(0);
                this.interactSign(sbe4, class_1802.field_28410);
                return;
            }
            if (!this.signsToWax.isEmpty()) {
                signs = this.signsToWax.stream().toList();
                if (!signs.isEmpty()) {
                    class_2625 sbe5 = (class_2625)signs.get(0);
                    this.interactSign(sbe5, class_1802.field_20414);
                }
            } else if (this.didDisableWaxAura && !waxAura.isActive()) {
                waxAura.toggle();
                this.didDisableWaxAura = false;
            }
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (!Utils.canUpdate()) {
            return;
        }
        if (this.mc.method_1562().method_2880().size() <= 1) {
            return;
        }
        if (((Boolean)this.espSigns.get()).booleanValue()) {
            class_243 offsetVec;
            class_4719 woodType;
            double z2;
            double y2;
            double x2;
            double z1;
            double y1;
            double x1;
            class_265 shape;
            ESPBlockData mESP = (ESPBlockData)this.modifiedSettings.get();
            ESPBlockData dESP = (ESPBlockData)this.destroyedSettings.get();
            for (class_2625 sign : this.destroyedSigns) {
                if (sign.method_11010() == null) {
                    return;
                }
                if (((Boolean)this.contentBlacklist.get()).booleanValue() && this.containsBlacklistedText(sign) || ((Boolean)this.ignoreBrokenSetting.get()).booleanValue() && this.signsBrokenByPlayer.contains(sign.method_11016()) || !sign.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.espRange.get()).intValue())) continue;
                shape = sign.method_11010().method_26218((class_1922)this.mc.field_1687, sign.method_11016());
                x1 = (double)sign.method_11016().method_10263() + shape.method_1091(class_2350.class_2351.field_11048);
                y1 = (double)sign.method_11016().method_10264() + shape.method_1091(class_2350.class_2351.field_11052);
                z1 = (double)sign.method_11016().method_10260() + shape.method_1091(class_2350.class_2351.field_11051);
                x2 = (double)sign.method_11016().method_10263() + shape.method_1105(class_2350.class_2351.field_11048);
                y2 = (double)sign.method_11016().method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
                z2 = (double)sign.method_11016().method_10260() + shape.method_1105(class_2350.class_2351.field_11051);
                if (dESP.sideColor.a > 0 || dESP.lineColor.a > 0) {
                    woodType = this.woodTypeMap.get(sign);
                    event.renderer.box(x1, y1, z1, x2, y2, z2, (Color)this.colorFromWoodType(woodType), (Color)dESP.lineColor, dESP.shapeMode, 0);
                }
                if (!dESP.tracer || dESP.tracerColor.a <= 0) continue;
                offsetVec = this.getTracerOffset(sign.method_11016(), sign.method_11010());
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350, (Color)dESP.tracerColor);
            }
            for (class_2625 sign : this.modifiedSigns) {
                if (sign.method_11010() == null || ((Boolean)this.contentBlacklist.get()).booleanValue() && this.containsBlacklistedText(sign) || ((Boolean)this.ignoreBrokenSetting.get()).booleanValue() && this.signsBrokenByPlayer.contains(sign.method_11016()) || !sign.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.espRange.get()).intValue())) continue;
                shape = sign.method_11010().method_26218((class_1922)this.mc.field_1687, sign.method_11016());
                x1 = (double)sign.method_11016().method_10263() + shape.method_1091(class_2350.class_2351.field_11048);
                y1 = (double)sign.method_11016().method_10264() + shape.method_1091(class_2350.class_2351.field_11052);
                z1 = (double)sign.method_11016().method_10260() + shape.method_1091(class_2350.class_2351.field_11051);
                x2 = (double)sign.method_11016().method_10263() + shape.method_1105(class_2350.class_2351.field_11048);
                y2 = (double)sign.method_11016().method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
                z2 = (double)sign.method_11016().method_10260() + shape.method_1105(class_2350.class_2351.field_11051);
                if (mESP.sideColor.a > 0 || mESP.lineColor.a > 0) {
                    woodType = this.woodTypeMap.get(sign);
                    event.renderer.box(x1, y1, z1, x2, y2, z2, (Color)this.colorFromWoodType(woodType), (Color)mESP.lineColor, mESP.shapeMode, 0);
                }
                if (!mESP.tracer || mESP.tracerColor.a <= 0) continue;
                offsetVec = this.getTracerOffset(sign.method_11016(), sign.method_11010());
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350, (Color)mESP.tracerColor);
            }
        }
        if (((Boolean)this.griefPrevention.get()).booleanValue() && !this.approachingGriefers.isEmpty()) {
            this.approachingGriefers.removeIf(class_1297::method_31481);
            ESPBlockData dangerColor = (ESPBlockData)this.dangerESP.get();
            for (class_1588 griefingMob : this.approachingGriefers) {
                WireframeEntityRenderer.render((Render3DEvent)event, (class_1297)griefingMob, (double)1.0, (Color)dangerColor.sideColor, (Color)dangerColor.lineColor, (ShapeMode)ShapeMode.Both);
                if (!dangerColor.tracer) continue;
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, griefingMob.method_5829().method_1005().field_1352, griefingMob.method_5829().method_1005().field_1351, griefingMob.method_5829().method_1005().field_1350, (Color)dangerColor.tracerColor);
            }
        }
    }
}

