/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.mixin.accessor.AbstractSignEditScreenAccessor;
import dev.stardust.mixin.accessor.ClientConnectionAccessor;
import dev.stardust.modules.SignHistorian;
import dev.stardust.modules.WaxAura;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ProvidedStringSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1822;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2877;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_7743;
import net.minecraft.class_8242;
import org.apache.commons.codec.binary.Hex;

public class SignatureSign
extends Module {
    public static final String[] lineModes = new String[]{"Custom", "Empty", "File", "Username", "Username was here", "Timestamp", "Stardust", "Oasis", "Base64", "Hex", "0xHex", "ROT13", "Player UUID", "Random UUID", "Hashed UUID"};
    public static final String[] timestampTypes = new String[]{"MM/DD/YY", "MM/DD/YYYY", "DD/MM/YY", "DD/MM/YYYY", "YYYY/MM/DD", "YYYY/DD/MM", "Day Month Year", "Month Day Year", "Month Year", "Year", "Day Month", "Month Day", "Unix Epoch"};
    public static final String[] timestampDelimiters = new String[]{"/", "//", "\\", "\\\\", "|", "||", "-", "_", "~", ".", ",", "x", "\u2022", "\u2728"};
    private final SettingGroup sgMode;
    private final SettingGroup sgSignsOpts;
    private final SettingGroup sgLine1Front;
    private final SettingGroup sgLine2Front;
    private final SettingGroup sgLine3Front;
    private final SettingGroup sgLine4Front;
    private final Setting<Boolean> storyMode;
    private final Setting<Boolean> secretSign;
    private final Setting<Boolean> protectSigns;
    private final Setting<Boolean> glowSigns;
    private final Setting<class_1767> signColor;
    public final Setting<Boolean> signFreedom;
    private final Setting<String> line1ModeFront;
    private final Setting<String> line1TextFront;
    private final Setting<Integer> line1FileLineFront;
    private final Setting<String> line1TimestampTypeFront;
    private final Setting<String> line1TimestampDelimFront;
    private final Setting<String> line2ModeFront;
    private final Setting<String> line2TextFront;
    private final Setting<Integer> line2FileLineFront;
    private final Setting<String> line2TimestampTypeFront;
    private final Setting<String> line2TimestampDelimFront;
    private final Setting<String> line3ModeFront;
    private final Setting<String> line3TextFront;
    private final Setting<Integer> line3FileLineFront;
    private final Setting<String> line3TimestampTypeFront;
    private final Setting<String> line3TimestampDelimFront;
    private final Setting<String> line4ModeFront;
    private final Setting<String> line4TextFront;
    private final Setting<Integer> line4FileLineFront;
    private final Setting<String> line4TimestampTypeFront;
    private final Setting<String> line4TimestampDelimFront;
    private final Setting<Boolean> shortenedMonth;
    private final Setting<Integer> packetDelay;
    private final Setting<Boolean> autoConfirm;
    private final Setting<Boolean> autoDisable;
    private final Setting<Boolean> redo;
    private final Setting<Boolean> openFolder;
    private int timer;
    private int dyeSlot;
    private int storyIndex;
    private int packetTimer;
    private int lastIndexAmount;
    private int rotationPriority;
    private boolean didDisableWaxAura;
    private boolean needDelayedDeactivate;
    private String lastLine1TextFront;
    private String lastLine2TextFront;
    private String lastLine3TextFront;
    private String lastLine4TextFront;
    private final ArrayList<String> lastLines;
    private final ArrayList<String> storyText;
    private final HashSet<class_2625> signsToWax;
    private final HashSet<class_2625> signsToColor;
    private final HashSet<class_2625> signsToGlowInk;
    private final ArrayDeque<class_2877> packetQueue;

    public SignatureSign() {
        super(Stardust.CATEGORY, "SignatureSign", "Autofill signs with custom text.");
        this.sgMode = this.settings.createGroup("Module Mode");
        this.sgSignsOpts = this.settings.createGroup("Sign Options");
        this.sgLine1Front = this.settings.createGroup("Front Line 1");
        this.sgLine2Front = this.settings.createGroup("Front Line 2");
        this.sgLine3Front = this.settings.createGroup("Front Line 3");
        this.sgLine4Front = this.settings.createGroup("Front Line 4");
        this.storyMode = this.sgMode.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("story-mode")).description("Fill signs continuously from .minecraft/meteor-client/storysign.text")).defaultValue((Object)false)).build());
        this.secretSign = this.sgMode.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("secret-signs")).description("Pad each line with spaces to hide your message from being rendered. Will then only be viewable via metadata (ChatSigns etc.)")).defaultValue((Object)false)).build());
        this.protectSigns = this.sgSignsOpts.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("wax-signs")).description("Apply honeycomb wax onto signs if found in inventory.")).defaultValue((Object)true)).build());
        this.glowSigns = this.sgSignsOpts.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("glow-signs")).description("Apply glow squid ink onto signs if found in inventory.")).defaultValue((Object)false)).build());
        this.signColor = this.sgSignsOpts.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sign-color")).description("Apply selected dye color onto signs if found in inventory.")).defaultValue((Object)class_1767.field_7963)).build());
        this.signFreedom = this.sgSignsOpts.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("bypass-length-limits")).description("Bypass client-sided length limits for sign text.")).defaultValue((Object)true)).visible(() -> (Boolean)this.secretSign.get() == false)).build());
        this.line1ModeFront = this.sgLine1Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-1-mode")).description("Line 1 template mode")).defaultValue((Object)"Stardust")).supplier(() -> lineModes).visible(() -> (Boolean)this.storyMode.get() == false)).build());
        this.line1TextFront = this.sgLine1Front.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("line-1-text")).defaultValue((Object)"")).visible(() -> (Boolean)this.storyMode.get() == false && this.textLineVisibility(1))).onChanged(txt -> {
            if (this.signFreedom.isVisible() && !((Boolean)this.signFreedom.get()).booleanValue() && this.inputTooLong((String)txt)) {
                this.restoreValidInput(1);
                MsgUtil.sendModuleMsg("Input too long\u00a7c..!", this.name);
            } else {
                this.lastLine1TextFront = txt;
            }
        })).build());
        this.line1FileLineFront = this.sgLine1Front.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("line-1-file-line")).description("Which line of .minecraft/meteor-client/autosign.txt to use.")).range(1, 1000).sliderRange(1, 420).defaultValue((Object)1)).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line1ModeFront.get()).equals("File"))).build());
        this.line1TimestampTypeFront = this.sgLine1Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-1-timestamp-type")).defaultValue((Object)"Month Day Year")).supplier(() -> timestampTypes).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line1ModeFront.get()).equals("Timestamp"))).build());
        this.line1TimestampDelimFront = this.sgLine1Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-1-timestamp-delimiter")).defaultValue((Object)"/")).supplier(() -> timestampDelimiters).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line1ModeFront.get()).equals("Timestamp") && ((String)this.line1TimestampTypeFront.get()).contains("/"))).build());
        this.line2ModeFront = this.sgLine2Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-2-mode")).description("Line 2 template mode")).defaultValue((Object)"Stardust")).supplier(() -> lineModes).visible(() -> (Boolean)this.storyMode.get() == false)).build());
        this.line2TextFront = this.sgLine2Front.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("line-2-text")).defaultValue((Object)"")).visible(() -> (Boolean)this.storyMode.get() == false && this.textLineVisibility(2))).onChanged(txt -> {
            if (this.signFreedom.isVisible() && !((Boolean)this.signFreedom.get()).booleanValue() && this.inputTooLong((String)txt)) {
                this.restoreValidInput(2);
                MsgUtil.sendModuleMsg("Input too long\u00a7c..!", this.name);
            } else {
                this.lastLine2TextFront = txt;
            }
        })).build());
        this.line2FileLineFront = this.sgLine2Front.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("line-2-file-line")).description("Which line of .minecraft/meteor-client/autosign.txt to use.")).range(1, 1000).sliderRange(1, 420).defaultValue((Object)2)).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line2ModeFront.get()).equals("File"))).build());
        this.line2TimestampTypeFront = this.sgLine2Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-2-timestamp-type")).defaultValue((Object)"Month Day Year")).supplier(() -> timestampTypes).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line2ModeFront.get()).equals("Timestamp"))).build());
        this.line2TimestampDelimFront = this.sgLine2Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-2-timestamp-delimiter")).defaultValue((Object)"/")).supplier(() -> timestampDelimiters).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line2ModeFront.get()).equals("Timestamp") && ((String)this.line2TimestampTypeFront.get()).contains("/"))).build());
        this.line3ModeFront = this.sgLine3Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-3-mode")).defaultValue((Object)"Stardust")).description("Line 3 template mode")).supplier(() -> lineModes).visible(() -> (Boolean)this.storyMode.get() == false)).build());
        this.line3TextFront = this.sgLine3Front.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("line-3-text")).defaultValue((Object)"")).visible(() -> (Boolean)this.storyMode.get() == false && this.textLineVisibility(3))).onChanged(txt -> {
            if (this.signFreedom.isVisible() && !((Boolean)this.signFreedom.get()).booleanValue() && this.inputTooLong((String)txt)) {
                this.restoreValidInput(3);
                MsgUtil.sendModuleMsg("Input too long\u00a7c..!", this.name);
            } else {
                this.lastLine3TextFront = txt;
            }
        })).build());
        this.line3FileLineFront = this.sgLine3Front.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("line-3-file-line")).description("Which line of .minecraft/meteor-client/autosign.txt to use.")).range(1, 1000).sliderRange(1, 420).defaultValue((Object)3)).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line3ModeFront.get()).equals("File"))).build());
        this.line3TimestampTypeFront = this.sgLine3Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-3-timestamp-type")).defaultValue((Object)"Month Day Year")).supplier(() -> timestampTypes).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line3ModeFront.get()).equals("Timestamp"))).build());
        this.line3TimestampDelimFront = this.sgLine3Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-3-timestamp-delimiter")).defaultValue((Object)"/")).supplier(() -> timestampDelimiters).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line3ModeFront.get()).equals("Timestamp") && ((String)this.line3TimestampTypeFront.get()).contains("/"))).build());
        this.line4ModeFront = this.sgLine4Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-4-mode")).defaultValue((Object)"Stardust")).description("Line 4 template mode")).supplier(() -> lineModes).visible(() -> (Boolean)this.storyMode.get() == false)).build());
        this.line4TextFront = this.sgLine4Front.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("line-4-text")).defaultValue((Object)"")).visible(() -> (Boolean)this.storyMode.get() == false && this.textLineVisibility(4))).onChanged(txt -> {
            if (this.signFreedom.isVisible() && !((Boolean)this.signFreedom.get()).booleanValue() && this.inputTooLong((String)txt)) {
                this.restoreValidInput(4);
                MsgUtil.sendModuleMsg("Input too long\u00a7c..!", this.name);
            } else {
                this.lastLine4TextFront = txt;
            }
        })).build());
        this.line4FileLineFront = this.sgLine4Front.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("line-4-file-line")).description("Which line of .minecraft/meteor-client/autosign.txt to use.")).range(1, 1000).sliderRange(1, 420).defaultValue((Object)4)).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line4ModeFront.get()).equals("File"))).build());
        this.line4TimestampTypeFront = this.sgLine4Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-4-timestamp-type")).defaultValue((Object)"Month Day Year")).supplier(() -> timestampTypes).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line4ModeFront.get()).equals("Timestamp"))).build());
        this.line4TimestampDelimFront = this.sgLine4Front.add((Setting)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)((ProvidedStringSetting.Builder)new ProvidedStringSetting.Builder().name("line-4-timestamp-delimiter")).defaultValue((Object)"/")).supplier(() -> timestampDelimiters).visible(() -> (Boolean)this.storyMode.get() == false && ((String)this.line4ModeFront.get()).equals("Timestamp") && ((String)this.line4TimestampTypeFront.get()).contains("/"))).build());
        this.shortenedMonth = this.sgSignsOpts.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shortened-month")).description("Shorten the month to its abbreviation")).defaultValue((Object)false)).build());
        this.packetDelay = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("packet-delay")).description("How many ticks to delay before sending the UpdateSign packet. Lower values have a higher chance of being rejected by the AC.")).range(0, 500).sliderRange(0, 50).defaultValue((Object)20)).build());
        this.autoConfirm = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-confirm")).description("Automatically confirm and close the sign edit screen.")).defaultValue((Object)true)).build());
        this.autoDisable = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-disable")).description("Automatically disable the module after placing a sign.")).defaultValue((Object)false)).visible(() -> (Boolean)this.storyMode.get() == false)).build());
        this.redo = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("redo-last-sign")).description("Click this to redo your last-placed story sign. Useful if you misplaced it.")).defaultValue((Object)false)).visible(() -> this.storyMode.get())).build());
        this.openFolder = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("open-meteor-client-folder")).description("Opens the meteor-client folder where autosign.txt & storysign.txt are kept.")).defaultValue((Object)false)).onChanged(it -> {
            if (it.booleanValue()) {
                this.openMeteorFolder();
            }
        })).build());
        this.timer = 0;
        this.dyeSlot = -1;
        this.storyIndex = 0;
        this.packetTimer = 0;
        this.lastIndexAmount = 0;
        this.rotationPriority = 69420;
        this.didDisableWaxAura = false;
        this.needDelayedDeactivate = false;
        this.lastLine1TextFront = (String)this.line1TextFront.get();
        this.lastLine2TextFront = (String)this.line2TextFront.get();
        this.lastLine3TextFront = (String)this.line3TextFront.get();
        this.lastLine4TextFront = (String)this.line4TextFront.get();
        this.lastLines = new ArrayList();
        this.storyText = new ArrayList();
        this.signsToWax = new HashSet();
        this.signsToColor = new HashSet();
        this.signsToGlowInk = new HashSet();
        this.packetQueue = new ArrayDeque();
    }

    public void onActivate() {
        this.lastLine1TextFront = (String)this.line1TextFront.get();
        this.lastLine2TextFront = (String)this.line2TextFront.get();
        this.lastLine3TextFront = (String)this.line3TextFront.get();
        this.lastLine4TextFront = (String)this.line4TextFront.get();
    }

    public void onDeactivate() {
        this.storyText.clear();
        this.lastLines.clear();
        this.signsToWax.clear();
        this.signsToColor.clear();
        this.signsToGlowInk.clear();
        this.timer = 0;
        this.storyIndex = 0;
        this.packetTimer = 0;
        this.lastIndexAmount = 0;
        this.rotationPriority = 69420;
        this.didDisableWaxAura = false;
        this.needDelayedDeactivate = false;
        if (!this.packetQueue.isEmpty() && Utils.canUpdate()) {
            MeteorClient.EVENT_BUS.subscribe((Object)this);
        }
    }

    public class_8242 getSignature(class_2625 sign) {
        class_2561[] signature = new class_2561[4];
        List<String> lines = this.getSignText();
        for (int i = 0; i < lines.size(); ++i) {
            signature[i] = class_2561.method_30163((String)lines.get(i));
        }
        if (((Boolean)this.protectSigns.get()).booleanValue() && !sign.method_49855()) {
            this.signsToWax.add(sign);
        }
        if (this.signColor.get() != sign.method_49853().method_49872()) {
            this.signsToColor.add(sign);
        }
        if (((Boolean)this.glowSigns.get()).booleanValue() && !sign.method_49853().method_49856()) {
            this.signsToGlowInk.add(sign);
        }
        return new class_8242(signature, signature, class_1767.field_7963, false);
    }

    public void disable() {
        if (this.signsToWax.isEmpty() && this.signsToColor.isEmpty() && this.signsToGlowInk.isEmpty()) {
            this.toggle();
        } else {
            this.needDelayedDeactivate = true;
        }
    }

    public boolean needsDisabling() {
        return (Boolean)this.autoDisable.get() != false && (Boolean)this.storyMode.get() == false;
    }

    public boolean getAutoConfirm() {
        return (Boolean)this.autoConfirm.get();
    }

    private boolean textLineVisibility(int line) {
        String md = switch (line) {
            case 1 -> (String)this.line1ModeFront.get();
            case 2 -> (String)this.line2ModeFront.get();
            case 3 -> (String)this.line3ModeFront.get();
            default -> (String)this.line4ModeFront.get();
        };
        return md.equals("Custom") || md.equals("Base64") || md.equals("Hex") || md.equals("0xHex") || md.equals("ROT13");
    }

    private boolean inputTooLong(String input) {
        return this.mc.field_1772.method_1727(input) > 90;
    }

    private void restoreValidInput(int line) {
        switch (line) {
            case 1: {
                this.line1TextFront.set((Object)this.lastLine1TextFront);
                break;
            }
            case 2: {
                this.line2TextFront.set((Object)this.lastLine2TextFront);
                break;
            }
            case 3: {
                this.line3TextFront.set((Object)this.lastLine3TextFront);
                break;
            }
            default: {
                this.line4TextFront.set((Object)this.lastLine4TextFront);
            }
        }
    }

    private String getUuid(boolean player, boolean hash) {
        String id = player && this.mc.field_1724 != null ? this.mc.field_1724.method_5845() : UUID.randomUUID().toString();
        if (!hash) {
            return id.substring(0, Math.min(8, id.length()));
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hashBytes = digest.digest(id.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.substring(0, Math.min(8, sb.length()));
        }
        catch (Exception err) {
            LogUtil.error("SHA-1 algorithm not available - Why: " + String.valueOf(err), this.name);
            return this.mc.field_1724.method_5845().substring(0, this.mc.field_1724.method_5845().indexOf("-"));
        }
    }

    private List<String> getSignText() {
        List<String> signText = new ArrayList<String>();
        if (this.mc.field_1724 == null) {
            return signText;
        }
        String username = this.mc.field_1724.method_5477().getString();
        if (((Boolean)this.storyMode.get()).booleanValue()) {
            if (this.storyText.isEmpty()) {
                if (((Boolean)this.redo.get()).booleanValue()) {
                    signText.addAll(this.lastLines);
                    this.redo.set((Object)false);
                } else {
                    this.initStoryTextFromFile();
                }
                if (this.storyText.isEmpty()) {
                    return signText;
                }
                signText.addAll(this.getNextLinesOfStory());
            } else {
                signText.addAll(this.getNextLinesOfStory());
            }
        } else {
            switch ((String)this.line1ModeFront.get()) {
                case "Custom": {
                    signText.add((String)this.line1TextFront.get());
                    break;
                }
                case "Empty": {
                    signText.add(" ");
                    break;
                }
                case "File": {
                    signText.add(this.getSignTextFromFile((Integer)this.line1FileLineFront.get() - 1));
                    break;
                }
                case "Timestamp": {
                    signText.add(this.getTimestamp(1));
                    break;
                }
                case "Username": {
                    signText.add(username);
                    break;
                }
                case "Username was here": {
                    signText.add(username + " was here");
                    break;
                }
                case "Stardust": {
                    signText.add("<\u2728>");
                    break;
                }
                case "Oasis": {
                    signText.add("<\u262f>");
                    break;
                }
                case "Base64": {
                    signText.add(Base64.getEncoder().encodeToString(((String)this.line1TextFront.get()).getBytes()));
                    break;
                }
                case "Hex": {
                    signText.add(Hex.encodeHexString((byte[])((String)this.line1TextFront.get()).getBytes()));
                    break;
                }
                case "0xHex": {
                    signText.add("0x" + Hex.encodeHexString((byte[])((String)this.line1TextFront.get()).getBytes()));
                    break;
                }
                case "ROT13": {
                    signText.add(this.rot13((String)this.line1TextFront.get()));
                    break;
                }
                case "Player UUID": {
                    signText.add(this.getUuid(true, false));
                    break;
                }
                case "Random UUID": {
                    signText.add(this.getUuid(false, false));
                    break;
                }
                case "Hashed UUID": {
                    signText.add(this.getUuid(true, true));
                }
            }
            switch ((String)this.line2ModeFront.get()) {
                case "Custom": {
                    signText.add((String)this.line2TextFront.get());
                    break;
                }
                case "Empty": {
                    signText.add(" ");
                    break;
                }
                case "File": {
                    signText.add(this.getSignTextFromFile((Integer)this.line2FileLineFront.get() - 1));
                    break;
                }
                case "Timestamp": {
                    signText.add(this.getTimestamp(2));
                    break;
                }
                case "Username": {
                    signText.add(username);
                    break;
                }
                case "Username was here": {
                    signText.add(username + " was here");
                    break;
                }
                case "Stardust": 
                case "Oasis": {
                    signText.add("<" + username + ">");
                    break;
                }
                case "Base64": {
                    signText.add(Base64.getEncoder().encodeToString(((String)this.line2TextFront.get()).getBytes()));
                    break;
                }
                case "Hex": {
                    signText.add(Hex.encodeHexString((byte[])((String)this.line2TextFront.get()).getBytes()));
                    break;
                }
                case "0xHex": {
                    signText.add("0x" + Hex.encodeHexString((byte[])((String)this.line2TextFront.get()).getBytes()));
                    break;
                }
                case "ROT13": {
                    signText.add(this.rot13((String)this.line2TextFront.get()));
                    break;
                }
                case "Player UUID": {
                    signText.add(this.getUuid(true, false));
                    break;
                }
                case "Random UUID": {
                    signText.add(this.getUuid(false, false));
                    break;
                }
                case "Hashed UUID": {
                    signText.add(this.getUuid(true, true));
                }
            }
            switch ((String)this.line3ModeFront.get()) {
                case "Custom": {
                    signText.add((String)this.line3TextFront.get());
                    break;
                }
                case "Empty": {
                    signText.add(" ");
                    break;
                }
                case "File": {
                    signText.add(this.getSignTextFromFile((Integer)this.line3FileLineFront.get() - 1));
                    break;
                }
                case "Timestamp": {
                    signText.add(this.getTimestamp(3));
                    break;
                }
                case "Username": {
                    signText.add(username);
                    break;
                }
                case "Username was here": {
                    signText.add(username + " was here");
                    break;
                }
                case "Stardust": 
                case "Oasis": {
                    signText.add(System.currentTimeMillis() / 1000L + " UTC");
                    break;
                }
                case "Base64": {
                    signText.add(Base64.getEncoder().encodeToString(((String)this.line3TextFront.get()).getBytes()));
                    break;
                }
                case "Hex": {
                    signText.add(Hex.encodeHexString((byte[])((String)this.line3TextFront.get()).getBytes()));
                    break;
                }
                case "0xHex": {
                    signText.add("0x" + Hex.encodeHexString((byte[])((String)this.line3TextFront.get()).getBytes()));
                    break;
                }
                case "ROT13": {
                    signText.add(this.rot13((String)this.line3TextFront.get()));
                    break;
                }
                case "Player UUID": {
                    signText.add(this.getUuid(true, false));
                    break;
                }
                case "Random UUID": {
                    signText.add(this.getUuid(false, false));
                    break;
                }
                case "Hashed UUID": {
                    signText.add(this.getUuid(true, true));
                }
            }
            switch ((String)this.line4ModeFront.get()) {
                case "Custom": {
                    signText.add((String)this.line4TextFront.get());
                    break;
                }
                case "Empty": {
                    signText.add(" ");
                    break;
                }
                case "File": {
                    signText.add(this.getSignTextFromFile((Integer)this.line4FileLineFront.get() - 1));
                    break;
                }
                case "Timestamp": {
                    signText.add(this.getTimestamp(4));
                    break;
                }
                case "Username": {
                    signText.add(username);
                    break;
                }
                case "Username was here": {
                    signText.add(username + " was here");
                    break;
                }
                case "Stardust": {
                    signText.add("<\u2728>");
                    break;
                }
                case "Oasis": {
                    signText.add("<\u262f>");
                    break;
                }
                case "Base64": {
                    signText.add(Base64.getEncoder().encodeToString(((String)this.line4TextFront.get()).getBytes()));
                    break;
                }
                case "Hex": {
                    signText.add(Hex.encodeHexString((byte[])((String)this.line4TextFront.get()).getBytes()));
                    break;
                }
                case "0xHex": {
                    signText.add("0x" + Hex.encodeHexString((byte[])((String)this.line4TextFront.get()).getBytes()));
                    break;
                }
                case "ROT13": {
                    signText.add(this.rot13((String)this.line4TextFront.get()));
                    break;
                }
                case "Player UUID": {
                    signText.add(this.getUuid(true, false));
                    break;
                }
                case "Random UUID": {
                    signText.add(this.getUuid(false, false));
                    break;
                }
                case "Hashed UUID": {
                    signText.add(this.getUuid(true, true));
                }
            }
        }
        if (((Boolean)this.secretSign.get()).booleanValue()) {
            signText = signText.stream().map(line -> {
                StringBuilder secretSpaces = new StringBuilder();
                secretSpaces.append("              ");
                while (!this.inputTooLong(secretSpaces.toString())) {
                    secretSpaces.append(" ");
                }
                secretSpaces.append((String)line);
                return secretSpaces.toString();
            }).collect(Collectors.toList());
            return signText;
        }
        if (((Boolean)this.signFreedom.get()).booleanValue()) {
            return signText;
        }
        for (int i = 0; i < signText.size(); ++i) {
            if (!this.inputTooLong(signText.get(i))) continue;
            MsgUtil.sendModuleMsg("\u00a7oLine \u00a74\u00a7o" + (i + 1) + " \u00a77\u00a7owon't render fully due to length\u00a7c..!", this.name);
        }
        return signText;
    }

    private String getSignTextFromFile(int line) {
        Path meteorFolder = FabricLoader.getInstance().getGameDir().resolve("meteor-client");
        File file = meteorFolder.resolve("autosign.txt").toFile();
        if (file.exists()) {
            String string;
            block19: {
                Stream<String> lineStream = Files.lines(file.toPath());
                try {
                    List<String> lines = lineStream.toList();
                    String string2 = string = line <= lines.size() ? lines.get(line) : lines.get(lines.size() - 1);
                    if (lineStream == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (lineStream != null) {
                            try {
                                lineStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception err) {
                        LogUtil.error("Failed to read from " + file.getAbsolutePath() + "! - Why: " + String.valueOf(err), this.name);
                    }
                }
                lineStream.close();
            }
            return string;
        } else {
            try {
                if (file.createNewFile() && this.mc.field_1724 != null) {
                    MsgUtil.sendModuleMsg("Created autosign.txt in your meteor-client folder\u00a7a..!", this.name);
                    class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11746, meteorFolder.toFile().getAbsolutePath()));
                    MsgUtil.sendModuleMsg("Click \u00a72\u00a7lhere \u00a7r\u00a77to open the folder.", style, this.name);
                }
            }
            catch (Exception err) {
                LogUtil.error("Failed to create " + file.getAbsolutePath() + "! Why:\n" + String.valueOf(err), this.name);
            }
            switch (line) {
                case 1: {
                    return "File was empty";
                }
                case 2: {
                    return "Please use the";
                }
                case 3: {
                    return "autosign.txt";
                }
                case 4: {
                    return "in /meteor-client";
                }
            }
        }
        return "File not found";
    }

    private void initStoryTextFromFile() {
        Path meteorFolder = FabricLoader.getInstance().getGameDir().resolve("meteor-client");
        File file = meteorFolder.resolve("storysign.txt").toFile();
        if (file.exists()) {
            try (Stream<String> lineStream = Files.lines(file.toPath());){
                this.storyText.addAll(Arrays.stream(lineStream.collect(Collectors.joining(" ")).split(" ")).toList());
            }
            catch (Exception err) {
                LogUtil.error("Failed to read from " + file.getAbsolutePath() + "! - Why:\n" + String.valueOf(err), this.name);
            }
        } else {
            try {
                if (file.createNewFile() && this.mc.field_1724 != null) {
                    MsgUtil.sendModuleMsg("Created storysign.txt in your meteor-client folder\u00a7a..!", this.name);
                    class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11746, meteorFolder.toFile().getAbsolutePath()));
                    MsgUtil.sendModuleMsg("Click \u00a72\u00a7lhere \u00a7r\u00a77to open the folder.", style, this.name);
                }
            }
            catch (Exception err) {
                LogUtil.error("Failed to create " + file.getAbsolutePath() + "! Why:\n" + String.valueOf(err), this.name);
                this.storyText.add("File not found.");
                this.storyText.add("Please create a");
                this.storyText.add("storysign.txt in");
                this.storyText.add("/meteor-client");
                return;
            }
            this.storyText.add("File was empty.");
            this.storyText.add("Please use the");
            this.storyText.add("storysign.txt in");
            this.storyText.add("/meteor-client");
        }
    }

    private List<String> getNextLinesOfStory() {
        ArrayList<String> storyLines = new ArrayList<String>();
        class_327 textRenderer = this.mc.field_1772;
        if (((Boolean)this.redo.get()).booleanValue()) {
            this.storyIndex -= this.lastIndexAmount;
            this.redo.set((Object)false);
        }
        this.lastIndexAmount = 0;
        for (int n = 0; n < 4; ++n) {
            StringBuilder line = new StringBuilder();
            for (int i = this.storyIndex; i < this.storyText.size(); ++i) {
                if (this.storyText.get(i).trim().isEmpty()) {
                    ++this.storyIndex;
                    ++this.lastIndexAmount;
                    continue;
                }
                if (textRenderer.method_1727(line.toString()) >= 87) break;
                if (textRenderer.method_1727(this.storyText.get(i).trim()) > 87) {
                    if (!line.isEmpty()) break;
                    line.append(textRenderer.method_27523(this.storyText.get(i).trim(), 85));
                    ++this.storyIndex;
                    ++this.lastIndexAmount;
                    break;
                }
                if (textRenderer.method_1727(String.valueOf(line) + this.storyText.get(i).trim()) > 87) break;
                if (line.isEmpty()) {
                    line.append(this.storyText.get(i).trim());
                } else {
                    line.append(" ").append(this.storyText.get(i).trim());
                }
                ++this.storyIndex;
                ++this.lastIndexAmount;
            }
            storyLines.add(line.toString());
        }
        if (this.storyIndex >= this.storyText.size() - 1) {
            this.storyText.clear();
            this.storyIndex = 0;
            this.lastIndexAmount = 0;
            this.lastLines.addAll(storyLines);
            if (this.mc.field_1724 != null) {
                MsgUtil.sendModuleMsg("\u00a7oSign story complete\u00a7a\u00a7o..!", this.name);
                this.mc.field_1724.method_5783(class_3417.field_14627, 0.77f, 0.77f);
            }
        }
        return storyLines;
    }

    private String getTimestamp(int line) {
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter mmddyy = DateTimeFormatter.ofPattern("MM/dd/yy");
        DateTimeFormatter mmddyyyy = DateTimeFormatter.ofPattern("MM/dd/yyyy");
        DateTimeFormatter ddmmyy = DateTimeFormatter.ofPattern("dd/MM/yy");
        DateTimeFormatter ddmmyyyy = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        DateTimeFormatter yyyymmdd = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        DateTimeFormatter yyyyddmm = DateTimeFormatter.ofPattern("yyyy/dd/MM");
        String currentMonth = "" + currentDate.getMonth().name().charAt(0);
        currentMonth = (Boolean)this.shortenedMonth.get() != false ? currentMonth + currentDate.getMonth().name().toLowerCase().substring(1, 3) : currentMonth + currentDate.getMonth().name().substring(1).toLowerCase();
        switch (line) {
            case 1: {
                return switch ((String)this.line1TimestampTypeFront.get()) {
                    case "MM/DD/YY" -> currentDate.format(mmddyy).replace("/", (CharSequence)this.line1TimestampDelimFront.get());
                    case "MM/DD/YYYY" -> currentDate.format(mmddyyyy).replace("/", (CharSequence)this.line1TimestampDelimFront.get());
                    case "DD/MM/YY" -> currentDate.format(ddmmyy).replace("/", (CharSequence)this.line1TimestampDelimFront.get());
                    case "DD/MM/YYYY" -> currentDate.format(ddmmyyyy).replace("/", (CharSequence)this.line1TimestampDelimFront.get());
                    case "YYYY/MM/DD" -> currentDate.format(yyyymmdd).replace("/", (CharSequence)this.line1TimestampDelimFront.get());
                    case "YYYY/DD/MM" -> currentDate.format(yyyyddmm).replace("/", (CharSequence)this.line1TimestampDelimFront.get());
                    case "Day Month Year" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentMonth + " " + currentDate.getYear();
                    case "Month Day Year" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentDate.getYear();
                    case "Month Year" -> currentMonth + " " + currentDate.getYear();
                    case "Year" -> String.valueOf(currentDate.getYear());
                    case "Day Month" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " of " + currentMonth;
                    case "Month Day" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth());
                    default -> System.currentTimeMillis() / 1000L + " UTC";
                };
            }
            case 2: {
                return switch ((String)this.line2TimestampTypeFront.get()) {
                    case "MM/DD/YY" -> currentDate.format(mmddyy).replace("/", (CharSequence)this.line2TimestampDelimFront.get());
                    case "MM/DD/YYYY" -> currentDate.format(mmddyyyy).replace("/", (CharSequence)this.line2TimestampDelimFront.get());
                    case "DD/MM/YY" -> currentDate.format(ddmmyy).replace("/", (CharSequence)this.line2TimestampDelimFront.get());
                    case "DD/MM/YYYY" -> currentDate.format(ddmmyyyy).replace("/", (CharSequence)this.line2TimestampDelimFront.get());
                    case "YYYY/MM/DD" -> currentDate.format(yyyymmdd).replace("/", (CharSequence)this.line2TimestampDelimFront.get());
                    case "YYYY/DD/MM" -> currentDate.format(yyyyddmm).replace("/", (CharSequence)this.line2TimestampDelimFront.get());
                    case "Day Month Year" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentMonth + " " + currentDate.getYear();
                    case "Month Day Year" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentDate.getYear();
                    case "Month Year" -> currentMonth + " " + currentDate.getYear();
                    case "Year" -> String.valueOf(currentDate.getYear());
                    case "Day Month" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " of " + currentMonth;
                    case "Month Day" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth());
                    default -> System.currentTimeMillis() / 1000L + " UTC";
                };
            }
            case 3: {
                return switch ((String)this.line3TimestampTypeFront.get()) {
                    case "MM/DD/YY" -> currentDate.format(mmddyy).replace("/", (CharSequence)this.line3TimestampDelimFront.get());
                    case "MM/DD/YYYY" -> currentDate.format(mmddyyyy).replace("/", (CharSequence)this.line3TimestampDelimFront.get());
                    case "DD/MM/YY" -> currentDate.format(ddmmyy).replace("/", (CharSequence)this.line3TimestampDelimFront.get());
                    case "DD/MM/YYYY" -> currentDate.format(ddmmyyyy).replace("/", (CharSequence)this.line3TimestampDelimFront.get());
                    case "YYYY/MM/DD" -> currentDate.format(yyyymmdd).replace("/", (CharSequence)this.line3TimestampDelimFront.get());
                    case "YYYY/DD/MM" -> currentDate.format(yyyyddmm).replace("/", (CharSequence)this.line3TimestampDelimFront.get());
                    case "Day Month Year" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentMonth + " " + currentDate.getYear();
                    case "Month Day Year" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentDate.getYear();
                    case "Month Year" -> currentMonth + " " + currentDate.getYear();
                    case "Year" -> String.valueOf(currentDate.getYear());
                    case "Day Month" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " of " + currentMonth;
                    case "Month Day" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth());
                    default -> System.currentTimeMillis() / 1000L + " UTC";
                };
            }
            case 4: {
                return switch ((String)this.line4TimestampTypeFront.get()) {
                    case "MM/DD/YY" -> currentDate.format(mmddyy).replace("/", (CharSequence)this.line4TimestampDelimFront.get());
                    case "MM/DD/YYYY" -> currentDate.format(mmddyyyy).replace("/", (CharSequence)this.line4TimestampDelimFront.get());
                    case "DD/MM/YY" -> currentDate.format(ddmmyy).replace("/", (CharSequence)this.line4TimestampDelimFront.get());
                    case "DD/MM/YYYY" -> currentDate.format(ddmmyyyy).replace("/", (CharSequence)this.line4TimestampDelimFront.get());
                    case "YYYY/MM/DD" -> currentDate.format(yyyymmdd).replace("/", (CharSequence)this.line4TimestampDelimFront.get());
                    case "YYYY/DD/MM" -> currentDate.format(yyyyddmm).replace("/", (CharSequence)this.line4TimestampDelimFront.get());
                    case "Day Month Year" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentMonth + " " + currentDate.getYear();
                    case "Month Day Year" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " " + currentDate.getYear();
                    case "Month Year" -> currentMonth + " " + currentDate.getYear();
                    case "Year" -> String.valueOf(currentDate.getYear());
                    case "Day Month" -> this.dayOfMonthSuffix(currentDate.getDayOfMonth()) + " of " + currentMonth;
                    case "Month Day" -> currentMonth + " " + this.dayOfMonthSuffix(currentDate.getDayOfMonth());
                    default -> System.currentTimeMillis() / 1000L + " UTC";
                };
            }
        }
        return System.currentTimeMillis() / 1000L + " UTC";
    }

    private void openMeteorFolder() {
        StardustUtil.openFile("meteor-client");
        this.openFolder.set((Object)false);
    }

    private String dayOfMonthSuffix(int dom) {
        String day = String.valueOf(dom);
        if (!day.endsWith("11") && day.endsWith("1")) {
            return day + "st";
        }
        if (!day.endsWith("12") && day.endsWith("2")) {
            return day + "nd";
        }
        if (!day.endsWith("13") && day.endsWith("3")) {
            return day + "rd";
        }
        return day + "th";
    }

    private String rot13(String input) {
        StringBuilder rot = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'z') {
                if ((c = (char)(c + 13)) > 'z') {
                    c = (char)(c - 26);
                }
            } else if (c >= 'A' && c <= 'Z' && (c = (char)(c + 13)) > 'Z') {
                c = (char)(c - 26);
            }
            rot.append(c);
        }
        return rot.toString();
    }

    private void interactSign(class_2625 sbe, class_1792 dye) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        class_2338 pos = sbe.method_11016();
        class_243 hitVec = class_243.method_24953((class_2382)pos);
        class_3965 hit = new class_3965(hitVec, this.mc.field_1724.method_5735().method_10153(), pos, false);
        class_1799 current = this.mc.field_1724.method_31548().method_7391();
        if (current.method_7909() != dye) {
            for (int n = 0; n < this.mc.field_1724.method_31548().field_7547.size(); ++n) {
                class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
                if (stack.method_7909() != dye) continue;
                if (current.method_7909() instanceof class_1822 && current.method_7947() > 1) {
                    this.dyeSlot = n;
                }
                if (n < 9) {
                    InvUtils.swap((int)n, (boolean)true);
                } else {
                    InvUtils.move().from(n).to(this.mc.field_1724.method_31548().field_7545);
                }
                this.timer = 3;
                return;
            }
        } else {
            Rotations.rotate((double)Rotations.getYaw((class_2338)pos), (double)Rotations.getPitch((class_2338)pos), (int)this.rotationPriority, () -> this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, hit));
            ++this.rotationPriority;
        }
        if (dye == class_1802.field_28410) {
            this.signsToGlowInk.remove(sbe);
            if (!this.signsToWax.contains(sbe) && !this.signsToColor.contains(sbe)) {
                this.timer = -1;
            }
        } else if (dye == class_1802.field_20414) {
            this.signsToWax.remove(sbe);
            if (!this.signsToColor.contains(sbe) && !this.signsToGlowInk.contains(sbe)) {
                this.timer = -1;
            }
        } else {
            this.signsToColor.remove(sbe);
            if (!this.signsToGlowInk.contains(sbe) && !this.signsToWax.contains(sbe)) {
                this.timer = -1;
            }
        }
    }

    @EventHandler
    private void onScreenOpened(OpenScreenEvent event) {
        class_437 class_4372 = event.screen;
        if (!(class_4372 instanceof class_7743)) {
            return;
        }
        class_7743 editScreen = (class_7743)class_4372;
        class_2625 sign = ((AbstractSignEditScreenAccessor)editScreen).getBlockEntity();
        Modules mods = Modules.get();
        if (mods == null) {
            return;
        }
        SignHistorian sh = (SignHistorian)mods.get(SignHistorian.class);
        if (sh.isActive() && sh.getRestoration(sign) != null) {
            return;
        }
        if (((Boolean)this.autoConfirm.get()).booleanValue()) {
            event.cancel();
            class_8242 signature = this.getSignature(sign);
            List<String> msgs = Arrays.stream(signature.method_49877(false)).map(class_2561::getString).toList();
            String[] messages = new String[msgs.size()];
            messages = msgs.toArray(messages);
            if (this.packetQueue.isEmpty()) {
                this.packetTimer = 0;
            }
            this.packetQueue.addLast(new class_2877(sign.method_11016(), true, messages[0], messages[1], messages[2], messages[3]));
            if (((Boolean)this.autoDisable.get()).booleanValue()) {
                this.toggle();
                this.sendToggledMsg();
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (!Utils.canUpdate()) {
            return;
        }
        if (this.mc.method_1562() == null) {
            return;
        }
        if (!this.packetQueue.isEmpty()) {
            ++this.packetTimer;
            if (this.packetTimer >= (Integer)this.packetDelay.get()) {
                this.packetTimer = 0;
                ((ClientConnectionAccessor)this.mc.method_1562().method_48296()).invokeSendImmediately((class_2596)this.packetQueue.removeFirst(), null, true);
            }
        } else if (!this.isActive()) {
            MeteorClient.EVENT_BUS.unsubscribe((Object)this);
            return;
        }
        if (this.mc.field_1755 != null) {
            return;
        }
        if (this.timer == -1 && this.dyeSlot != -1) {
            if (this.dyeSlot < 9) {
                InvUtils.swapBack();
            } else {
                InvUtils.move().from(this.mc.field_1724.method_31548().field_7545).to(this.dyeSlot);
            }
            this.dyeSlot = -1;
            this.timer = 3;
        }
        WaxAura waxAura = (WaxAura)Modules.get().get(WaxAura.class);
        if (!(this.signsToColor.isEmpty() && this.signsToGlowInk.isEmpty() && this.signsToWax.isEmpty() || !waxAura.isActive())) {
            waxAura.toggle();
            this.didDisableWaxAura = true;
        }
        ++this.timer;
        if (this.timer >= 5) {
            List<class_2625> signs;
            this.timer = 0;
            this.signsToWax.removeIf(sbe -> !sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 6.0));
            this.signsToColor.removeIf(sbe -> !sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 6.0));
            this.signsToGlowInk.removeIf(sbe -> !sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 6.0));
            if (!this.signsToColor.isEmpty() && !(signs = this.signsToColor.stream().filter(sbe -> sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 5.0)).filter(sbe -> Arrays.stream(sbe.method_49853().method_49877(false)).anyMatch(msg -> !msg.getString().isEmpty()) || Arrays.stream(sbe.method_49854().method_49877(false)).anyMatch(msg -> !msg.getString().isEmpty())).toList()).isEmpty()) {
                class_2625 sbe2 = signs.get(0);
                this.interactSign(sbe2, (class_1792)class_1769.method_7803((class_1767)((class_1767)this.signColor.get())));
                return;
            }
            if (!this.signsToGlowInk.isEmpty() && !(signs = this.signsToGlowInk.stream().filter(sbe -> sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 5.0)).filter(sbe -> Arrays.stream(sbe.method_49853().method_49877(false)).anyMatch(msg -> !msg.getString().isEmpty()) || Arrays.stream(sbe.method_49854().method_49877(false)).anyMatch(msg -> !msg.getString().isEmpty())).toList()).isEmpty()) {
                class_2625 sbe3 = signs.get(0);
                this.interactSign(sbe3, class_1802.field_28410);
                return;
            }
            if (!this.signsToWax.isEmpty()) {
                signs = this.signsToWax.stream().filter(sbe -> sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 5.0)).filter(sbe -> Arrays.stream(sbe.method_49853().method_49877(false)).anyMatch(msg -> !msg.getString().isEmpty()) || Arrays.stream(sbe.method_49854().method_49877(false)).anyMatch(msg -> !msg.getString().isEmpty())).toList();
                if (!signs.isEmpty()) {
                    class_2625 sbe4 = signs.get(0);
                    this.interactSign(sbe4, class_1802.field_20414);
                }
            } else {
                if (this.didDisableWaxAura && !waxAura.isActive()) {
                    waxAura.toggle();
                    this.didDisableWaxAura = false;
                }
                if (this.needDelayedDeactivate) {
                    this.toggle();
                }
            }
        }
    }
}

