/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.stardust.Stardust;
import dev.stardust.gui.screens.SolitaireScreen;
import dev.stardust.gui.widgets.solitaire.model.ColorSchemes;
import dev.stardust.gui.widgets.solitaire.model.DrawMode;
import dev.stardust.gui.widgets.solitaire.model.SaveState;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class Solitaire
extends Module {
    private static final String GAME_FOLDER = "meteor-client/minigames/solitaire";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Setting<DrawMode> drawMode;
    public final Setting<Boolean> shouldSave;
    public final Setting<Boolean> renderMap;
    public final Setting<Boolean> sounds;
    public final Setting<Double> soundVolume;
    public final Setting<ColorSchemes> colorScheme;
    @Nullable
    public SaveState saveData;

    public Solitaire() {
        super(Stardust.CATEGORY, "Solitaire", "What more could you ask for?");
        this.drawMode = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("draw-mode")).defaultValue((Object)DrawMode.Draw_One)).build());
        this.shouldSave = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("save-games")).description("Saves your game state when closing the Minesweeper screen.")).defaultValue((Object)true)).build());
        this.renderMap = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("force-render-minimap")).description("Continues rendering the Xaeros minimap while the Minesweeper screen is open.")).defaultValue((Object)true)).build());
        this.sounds = this.settings.getDefaultGroup().add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("game-sounds")).description("Plays game sounds.")).defaultValue((Object)true)).build());
        this.soundVolume = this.settings.getDefaultGroup().add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sounds-volume")).min(0.1).max(4.0).defaultValue(0.5).visible(() -> this.sounds.get())).build());
        this.colorScheme = this.settings.getDefaultGroup().add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("color-scheme")).defaultValue((Object)ColorSchemes.Themed)).build());
        this.saveData = null;
        this.runInMainMenu = true;
    }

    public void saveGame(SaveState data) {
        this.saveData = data;
        Path saveFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        saveFolder.toFile().mkdirs();
        Path save = saveFolder.resolve("save.json");
        if (!Files.exists(save, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/solitaire/save.json")) {
            MsgUtil.sendModuleMsg("Failed to create save file\u00a7c..!", this.name);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(save, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
    }

    public void clearSave() {
        this.saveGame(null);
    }

    public void onActivate() {
        Path saveFolder = FabricLoader.getInstance().getGameDir().resolve(GAME_FOLDER);
        saveFolder.toFile().mkdirs();
        Path save = saveFolder.resolve("save.json");
        if (!Files.exists(save, new LinkOption[0]) && !StardustUtil.checkOrCreateFile(this.mc, "meteor-client/minigames/solitaire/save.json")) {
            MsgUtil.sendModuleMsg("Failed to create save file\u00a7c..!", this.name);
        }
        SaveState data = null;
        try (BufferedReader reader = Files.newBufferedReader(save);){
            data = (SaveState)GSON.fromJson((Reader)reader, SaveState.class);
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.name);
        }
        if (data != null) {
            this.saveData = data;
        }
        try {
            this.mc.method_1507((class_437)new SolitaireScreen(this, GuiThemes.get(), "Solitaire"));
        }
        catch (Exception err) {
            LogUtil.error("Failed to open the Solitaire screen..!", this.name);
        }
    }

    public void onDeactivate() {
        if (this.mc.field_1755 instanceof SolitaireScreen) {
            try {
                this.mc.method_1507(null);
            }
            catch (Exception err) {
                LogUtil.error("Failed to close the Solitaire screen..!", this.name);
            }
        }
    }

    public WWidget getWidget(GuiTheme theme) {
        WHorizontalList list = theme.horizontalList();
        WButton clearSave = (WButton)list.add((WWidget)theme.button("Clear Save")).widget();
        clearSave.action = this::clearSave;
        return list;
    }
}

