/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.util.MapUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import meteordevelopment.meteorclient.events.entity.player.InteractBlockEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.GenericSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.render.blockesp.ESPBlockData;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2595;
import net.minecraft.class_2818;
import net.minecraft.class_3417;
import net.minecraft.class_4076;

public class TreasureESP
extends Module {
    private final SettingGroup sgNotifications;
    private final SettingGroup sgESP;
    private final Setting<Boolean> chatSetting;
    private final Setting<Boolean> coordsSetting;
    private final Setting<Boolean> waypoints;
    private final Setting<Boolean> tempWaypoints;
    private final Setting<Boolean> soundSetting;
    private final Setting<Double> volumeSetting;
    private final Setting<Boolean> espSetting;
    private final Setting<ESPBlockData> espColorSettings;
    private final Set<class_2338> looted;
    private final List<class_2338> notified;

    public TreasureESP() {
        super(Stardust.CATEGORY, "TreasureESP", "Notifies you when a buried treasure chest is nearby.");
        this.sgNotifications = this.settings.createGroup("Notifications");
        this.sgESP = this.settings.createGroup("ESP");
        this.chatSetting = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat")).description("Notify with a chat message.")).defaultValue((Object)true)).build());
        this.coordsSetting = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("coords")).description("Display chest coordinates in chat notifications.")).defaultValue((Object)false)).visible(() -> this.chatSetting.get())).build());
        this.waypoints = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("add-waypoints")).description("Adds waypoints to your Xaeros map for treasure chests.")).defaultValue((Object)false)).visible(() -> StardustUtil.XAERO_AVAILABLE)).build());
        this.tempWaypoints = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("temporary-waypoints")).description("Temporary waypoints are removed when you disconnect from the server, or close the game.")).defaultValue((Object)true)).visible(() -> StardustUtil.XAERO_AVAILABLE && (Boolean)this.waypoints.get() != false)).build());
        this.soundSetting = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sound")).description("Notify with sound.")).defaultValue((Object)true)).build());
        this.volumeSetting = this.sgNotifications.add((Setting)((DoubleSetting.Builder)new DoubleSetting.Builder().name("volume")).min(0.0).max(10.0).sliderMin(0.0).sliderMax(5.0).defaultValue(1.0).build());
        this.espSetting = this.sgESP.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ESP")).description("Highlight treasure chests through walls with ESP.")).defaultValue((Object)true)).build());
        this.espColorSettings = this.sgESP.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("ESP-settings")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(147, 233, 190), new SettingColor(147, 233, 190, 25), true, new SettingColor(147, 233, 190, 125)))).build());
        this.looted = new HashSet<class_2338>();
        this.notified = new ArrayList<class_2338>();
    }

    private boolean isBuriedNaturally(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return false;
        }
        class_2248 block = this.mc.field_1687.method_8320(pos.method_10084()).method_26204();
        return block == class_2246.field_10102 || block == class_2246.field_10566 || block == class_2246.field_10255 || block == class_2246.field_10340 || block == class_2246.field_10508 || block == class_2246.field_10474 || block == class_2246.field_10115 || block == class_2246.field_9979 || block == class_2246.field_10418;
    }

    public void onDeactivate() {
        this.notified.clear();
    }

    public void onActivate() {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_2338 pos = this.mc.field_1724.method_24515();
        int viewDistance = (Integer)this.mc.field_1690.method_42503().method_41753();
        int startChunkX = pos.method_10263() - viewDistance * 16 >> 4;
        int endChunkX = pos.method_10263() + viewDistance * 16 >> 4;
        int startChunkZ = pos.method_10260() - viewDistance * 16 >> 4;
        int endChunkZ = pos.method_10260() + viewDistance * 16 >> 4;
        for (int x = startChunkX; x < endChunkX; ++x) {
            for (int z = startChunkZ; z < endChunkZ; ++z) {
                if (!this.mc.field_1687.method_8393(x, z)) continue;
                class_2818 chunk = this.mc.field_1687.method_8497(x, z);
                Map blockEntities = chunk.method_12214();
                for (class_2338 blockPos : blockEntities.keySet()) {
                    if (!(blockEntities.get(blockPos) instanceof class_2595)) continue;
                    int localX = class_4076.method_18684((int)blockPos.method_10263());
                    int localZ = class_4076.method_18684((int)blockPos.method_10260());
                    if (localX != 9 || localZ != 9 || !this.isBuriedNaturally(blockPos)) continue;
                    if (StardustUtil.XAERO_AVAILABLE && ((Boolean)this.waypoints.get()).booleanValue()) {
                        MapUtil.addWaypoint(blockPos, "TreasureESP - Buried Treasure", "\u274c", MapUtil.Purpose.Normal, MapUtil.WpColor.Dark_Red, (Boolean)this.tempWaypoints.get());
                    }
                    if (((Boolean)this.soundSetting.get()).booleanValue()) {
                        this.mc.field_1724.method_5783(class_3417.field_43154, ((Double)this.volumeSetting.get()).floatValue(), 1.0f);
                    }
                    if (((Boolean)this.chatSetting.get()).booleanValue()) {
                        Object notification = (Boolean)this.coordsSetting.get() != false ? "\u00a73\u00a7oFound buried treasure at \u00a78[\u00a77\u00a7o" + blockPos.method_10263() + "\u00a78, \u00a77\u00a7o" + blockPos.method_10264() + "\u00a78, \u00a77\u00a7o" + blockPos.method_10260() + "\u00a78]" : "\u00a73\u00a7oFound buried treasure\u00a77\u00a7o!";
                        MsgUtil.sendModuleMsg((String)notification, this.name);
                    }
                    this.notified.add(blockPos);
                }
            }
        }
    }

    @EventHandler
    private void onChunkData(ChunkDataEvent event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        Map blockEntities = event.chunk().method_12214();
        for (class_2338 pos : blockEntities.keySet()) {
            if (this.notified.contains(pos) || !(blockEntities.get(pos) instanceof class_2595)) continue;
            int localX = class_4076.method_18684((int)pos.method_10263());
            int localZ = class_4076.method_18684((int)pos.method_10260());
            if (localX != 9 || localZ != 9 || !this.isBuriedNaturally(pos)) continue;
            if (StardustUtil.XAERO_AVAILABLE && ((Boolean)this.waypoints.get()).booleanValue()) {
                MapUtil.addWaypoint(pos, "TreasureESP - Buried Treasure", "\u274c", MapUtil.Purpose.Normal, MapUtil.WpColor.Dark_Red, (Boolean)this.tempWaypoints.get());
            }
            if (((Boolean)this.soundSetting.get()).booleanValue()) {
                this.mc.field_1724.method_5783(class_3417.field_43154, ((Double)this.volumeSetting.get()).floatValue(), 1.0f);
            }
            if (((Boolean)this.chatSetting.get()).booleanValue()) {
                Object notification = (Boolean)this.coordsSetting.get() != false ? "\u00a73\u00a7oFound buried treasure at \u00a78[\u00a77\u00a7o" + pos.method_10263() + "\u00a78, \u00a77\u00a7o" + pos.method_10264() + "\u00a78, \u00a77\u00a7o" + pos.method_10260() + "\u00a78]" : "\u00a73\u00a7oFound buried treasure\u00a77\u00a7o!";
                MsgUtil.sendModuleMsg((String)notification, this.name);
            }
            this.notified.add(pos);
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (!((Boolean)this.espSetting.get()).booleanValue()) {
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        List<class_2338> inRange = this.notified.stream().filter(pos -> pos.method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.mc.field_1690.method_42503().method_41753() * 16 + 32))).toList();
        ESPBlockData espSettings = (ESPBlockData)this.espColorSettings.get();
        for (class_2338 pos2 : inRange) {
            if (this.looted.contains(pos2)) continue;
            event.renderer.box((double)pos2.method_10263(), (double)pos2.method_10264(), (double)pos2.method_10260(), (double)(pos2.method_10263() + 1), (double)(pos2.method_10264() + 1), (double)(pos2.method_10260() + 1), (Color)espSettings.sideColor, (Color)espSettings.lineColor, espSettings.shapeMode, 0);
            if (!espSettings.tracer) continue;
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, (double)pos2.method_10263() + 0.5, (double)pos2.method_10264() + 0.5, (double)pos2.method_10260() + 0.5, (Color)espSettings.tracerColor);
        }
    }

    @EventHandler
    private void onInteractBlock(InteractBlockEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (this.notified.contains(event.result.method_17777()) && event.result.method_17783() == class_239.class_240.field_1332 && this.mc.field_1687.method_8320(event.result.method_17777()).method_26204() instanceof class_2281) {
            this.looted.add(event.result.method_17777());
            if (StardustUtil.XAERO_AVAILABLE && ((Boolean)this.waypoints.get()).booleanValue()) {
                class_2338 wpPos = event.result.method_17777();
                MapUtil.removeWaypoints("TreasureESP", pos -> pos.method_10263() == wpPos.method_10263() && pos.method_10264() == wpPos.method_10264() && pos.method_10260() == wpPos.method_10260(), Optional.empty());
            }
        }
    }
}

