/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.modules;

import dev.stardust.Stardust;
import dev.stardust.util.LogUtil;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.GenericSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.render.blockesp.ESPBlockData;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7717;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class WaxAura
extends Module {
    private final String BLACKLIST_FILE = "meteor-client/waxaura-blacklist.txt";
    private final SettingGroup sgWax = this.settings.createGroup("Wax Settings");
    private final SettingGroup sgESP = this.settings.createGroup("ESP Settings");
    private final SettingGroup sgBlacklist = this.settings.createGroup("Blacklist Settings");
    private final Setting<Boolean> hotbarOnly = this.sgWax.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("hotbar-only")).description("Only use honeycombs if they're already in your hotbar.")).defaultValue((Object)false)).build());
    private final Setting<Boolean> swapBack = this.sgWax.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swap-back")).description("Swap honeycombs back to where they came from in your inventory after using.")).defaultValue((Object)true)).build());
    private final Setting<Boolean> standingStill = this.sgWax.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("standing-still")).description("Wait until you are standing still to wax signs. Prevents rubberbanding with a low tick-rate value.")).defaultValue((Object)false)).build());
    private final Setting<Boolean> hangingSigns = this.sgWax.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("hanging-signs")).description("Wax hanging signs in addition to other types of signs.")).defaultValue((Object)true)).build());
    private final Setting<Boolean> contentBlacklist = this.sgBlacklist.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("content-blacklist")).description("Ignore waxing signs that contain specific words or phrases (line-separated list in waxaura-blacklist.txt)")).defaultValue((Object)false)).onChanged(it -> {
        if (it.booleanValue() && StardustUtil.checkOrCreateFile(this.mc, "meteor-client/waxaura-blacklist.txt")) {
            this.blacklisted.clear();
            this.initBlacklistText();
            if (this.mc.field_1724 != null) {
                MsgUtil.sendModuleMsg("Please write one blacklisted item for each line fo the file.", this.name);
                MsgUtil.sendModuleMsg("Spaces and other punctuation will be treated literally.", this.name);
                MsgUtil.sendModuleMsg("Toggle the module after updating the file's contents.", this.name);
            }
        }
    })).build());
    private final Setting<Boolean> openBlacklistFile = this.sgBlacklist.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("open-blacklist-file")).description("Open the waxaura-blacklist.txt file.")).defaultValue((Object)false)).onChanged(it -> {
        if (it.booleanValue()) {
            if (StardustUtil.checkOrCreateFile(this.mc, "meteor-client/waxaura-blacklist.txt")) {
                StardustUtil.openFile("meteor-client/waxaura-blacklist.txt");
            }
            this.resetBlacklistFileSetting();
        }
    })).build());
    private final Setting<Boolean> espNonWaxed = this.sgESP.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ESP-unwaxed-signs")).description("Render signs which aren't yet waxed through walls.")).defaultValue((Object)false)).build());
    private final Setting<Integer> espRange = this.sgESP.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("ESP-range")).description("Range in blocks to render unwaxed signs.")).range(6, 512).sliderRange(16, 256).defaultValue((Object)128)).build());
    private final Setting<ESPBlockData> espSettings = this.sgESP.add((Setting)((GenericSetting.Builder)((GenericSetting.Builder)new GenericSetting.Builder().name("ESP-settings")).defaultValue((Object)new ESPBlockData(ShapeMode.Both, new SettingColor(234, 255, 42, 255), new SettingColor(255, 41, 0, 44), true, new SettingColor(239, 255, 59, 200)))).build());
    private final Setting<Integer> tickRate = this.settings.getDefaultGroup().add((Setting)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("tick-rate")).range(2, 200).sliderRange(2, 20).defaultValue((Object)2)).build());
    private int timer = 0;
    private int combSlot = -1;
    private int rotPriority = 69420;
    @Nullable
    private class_2625 currentSign = null;
    private final HashSet<String> blacklisted = new HashSet();
    private final HashSet<class_2338> signsToESP = new HashSet();
    private final HashSet<class_2625> signsToWax = new HashSet();

    public WaxAura() {
        super(Stardust.CATEGORY, "WaxAura", "Automatically waxes signs within your reach.");
    }

    private void initBlacklistText() {
        File blackListFile = FabricLoader.getInstance().getGameDir().resolve("meteor-client/waxaura-blacklist.txt").toFile();
        try (Stream<String> lineStream = Files.lines(blackListFile.toPath());){
            this.blacklisted.addAll(lineStream.toList());
        }
        catch (Exception err) {
            LogUtil.error("Failed to read from " + blackListFile.getAbsolutePath() + "! - Why:\n" + String.valueOf(err), this.name);
        }
    }

    private void resetBlacklistFileSetting() {
        this.openBlacklistFile.set((Object)false);
    }

    private boolean isSignEmpty(class_2625 sbe) {
        return !sbe.method_49853().method_49861((class_1657)this.mc.field_1724) && !sbe.method_49854().method_49861((class_1657)this.mc.field_1724);
    }

    private boolean containsBlacklistedText(class_2625 sbe) {
        String front = Arrays.stream(sbe.method_49853().method_49877(false)).map(class_2561::getString).collect(Collectors.joining(" ")).trim();
        String back = Arrays.stream(sbe.method_49854().method_49877(false)).map(class_2561::getString).collect(Collectors.joining(" ")).trim();
        return this.blacklisted.stream().anyMatch(line -> front.toLowerCase().contains(line.trim().toLowerCase()) || back.toLowerCase().contains(line.trim().toLowerCase()));
    }

    private void getSignsToESP() {
        for (class_2586 be : Utils.blockEntities()) {
            class_2625 sbe;
            if (!(be instanceof class_2625) || (sbe = (class_2625)be).method_49855() || this.isSignEmpty(sbe) || ((Boolean)this.contentBlacklist.get()).booleanValue() && this.containsBlacklistedText(sbe)) continue;
            this.signsToESP.add(sbe.method_11016());
        }
    }

    private void getSignsToWax() {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null || this.mc.field_1755 != null) {
            return;
        }
        for (class_2338 pos : class_2338.method_25996((class_2338)this.mc.field_1724.method_24515(), (int)5, (int)5, (int)5)) {
            class_2625 sbe;
            class_2586 class_25862 = this.mc.field_1687.method_8321(pos);
            if (!(class_25862 instanceof class_2625) || (sbe = (class_2625)class_25862).method_49855() || this.isSignEmpty(sbe) || ((Boolean)this.contentBlacklist.get()).booleanValue() && this.containsBlacklistedText(sbe)) continue;
            this.signsToWax.add(sbe);
        }
    }

    private void waxSign(class_2625 sbe) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        class_2338 pos = sbe.method_11016();
        class_243 hitVec = class_243.method_24953((class_2382)pos);
        class_3965 hit = new class_3965(hitVec, this.mc.field_1724.method_5735().method_10153(), pos, false);
        class_1799 current = this.mc.field_1724.method_31548().method_7391();
        if (current.method_7909() != class_1802.field_20414) {
            int end = (Boolean)this.hotbarOnly.get() != false ? 9 : this.mc.field_1724.method_31548().field_7547.size();
            for (int n = 0; n < end; ++n) {
                class_1799 stack = this.mc.field_1724.method_31548().method_5438(n);
                if (stack.method_7909() != class_1802.field_20414) continue;
                this.combSlot = n;
                this.timer = Math.max(0, (Integer)this.tickRate.get() - 5);
                if (n < 9) {
                    InvUtils.swap((int)n, (boolean)true);
                } else {
                    InvUtils.move().from(n).to(this.mc.field_1724.method_31548().field_7545);
                }
                return;
            }
        } else {
            Rotations.rotate((double)Rotations.getYaw((class_2338)pos), (double)Rotations.getPitch((class_2338)pos), (int)this.rotPriority, () -> this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, hit));
            ++this.rotPriority;
            this.currentSign = null;
            if (((Boolean)this.swapBack.get()).booleanValue()) {
                this.timer = -1;
            }
        }
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            this.toggle();
            return;
        }
        if (((Boolean)this.contentBlacklist.get()).booleanValue() && StardustUtil.checkOrCreateFile(this.mc, "meteor-client/waxaura-blacklist.txt")) {
            this.initBlacklistText();
        }
    }

    public void onDeactivate() {
        this.timer = 0;
        this.combSlot = -1;
        this.currentSign = null;
        this.signsToWax.clear();
        this.signsToESP.clear();
        this.rotPriority = 69420;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onTick(TickEvent.Pre event) {
        class_243 vel;
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        this.getSignsToESP();
        if (((Boolean)this.standingStill.get()).booleanValue() && (vel = this.mc.field_1724.method_18798()).method_1033() >= 0.08) {
            return;
        }
        if (this.timer % 2 == 0) {
            this.getSignsToWax();
        }
        ++this.timer;
        class_1799 active = this.mc.field_1724.method_6030();
        if ((active.method_57826(class_9334.field_50075) || Utils.isThrowable((class_1792)active.method_7909())) && this.mc.field_1724.method_6048() > 0) {
            return;
        }
        if (this.timer >= (Integer)this.tickRate.get()) {
            this.timer = 0;
            if (this.currentSign != null) {
                this.waxSign(this.currentSign);
            } else {
                HashSet<class_2625> hashSet = this.signsToWax;
                synchronized (hashSet) {
                    this.signsToWax.removeIf(this::isSignEmpty);
                    this.signsToWax.removeIf(class_2625::method_49855);
                    this.signsToWax.removeIf(sbe -> (Boolean)this.contentBlacklist.get() != false && this.containsBlacklistedText((class_2625)sbe));
                    this.signsToWax.removeIf(sbe -> (Boolean)this.hangingSigns.get() == false && sbe instanceof class_7717);
                    this.signsToWax.removeIf(sbe -> !sbe.method_11016().method_19771((class_2382)this.mc.field_1724.method_24515(), 6.0));
                    if (this.signsToWax.isEmpty()) {
                        if (((Boolean)this.swapBack.get()).booleanValue() && this.combSlot != -1) {
                            if (this.combSlot < 9) {
                                InvUtils.swapBack();
                            } else {
                                InvUtils.move().from(this.mc.field_1724.method_31548().field_7545).to(this.combSlot);
                            }
                            this.combSlot = -1;
                        }
                        return;
                    }
                    this.currentSign = (class_2625)this.signsToWax.stream().toList().get(0);
                    this.waxSign(this.currentSign);
                }
            }
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null || !((Boolean)this.espNonWaxed.get()).booleanValue()) {
            return;
        }
        List<class_2338> valid = this.signsToESP.stream().filter(pos -> pos.method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.espRange.get()).intValue())).filter(pos -> {
            class_2625 sbe;
            class_2586 patt0$temp = this.mc.field_1687.method_8321(pos);
            return patt0$temp instanceof class_2625 && !(sbe = (class_2625)patt0$temp).method_49855();
        }).filter(pos -> (Boolean)this.hangingSigns.get() != false || !(this.mc.field_1687.method_8321(pos) instanceof class_7717)).toList();
        ESPBlockData esp = (ESPBlockData)this.espSettings.get();
        for (class_2338 pos2 : valid) {
            class_2680 state = this.mc.field_1687.method_8320(pos2);
            class_265 shape = state.method_26218((class_1922)this.mc.field_1687, pos2);
            double x1 = (double)pos2.method_10263() + shape.method_1091(class_2350.class_2351.field_11048);
            double y1 = (double)pos2.method_10264() + shape.method_1091(class_2350.class_2351.field_11052);
            double z1 = (double)pos2.method_10260() + shape.method_1091(class_2350.class_2351.field_11051);
            double x2 = (double)pos2.method_10263() + shape.method_1105(class_2350.class_2351.field_11048);
            double y2 = (double)pos2.method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
            double z2 = (double)pos2.method_10260() + shape.method_1105(class_2350.class_2351.field_11051);
            event.renderer.box(x1, y1, z1, x2, y2, z2, (Color)esp.sideColor, (Color)esp.lineColor, esp.shapeMode, 0);
            if (!esp.tracer) continue;
            try {
                double offsetZ;
                double offsetY;
                double offsetX;
                if (state.method_26204() instanceof class_2508 || state.method_26204() instanceof class_7713) {
                    offsetX = (double)pos2.method_10263() + 0.5;
                    offsetY = (double)pos2.method_10264() + 0.5;
                    offsetZ = (double)pos2.method_10260() + 0.5;
                } else if (state.method_26204() instanceof class_2551 || state.method_26204() instanceof class_7715) {
                    class_2350 facing = state.method_26204() instanceof class_2551 ? (class_2350)state.method_11654((class_2769)class_2551.field_11726) : (class_2350)state.method_11654((class_2769)class_7715.field_40319);
                    switch (facing) {
                        case field_11043: {
                            offsetX = (double)pos2.method_10263() + 0.5;
                            offsetY = (double)pos2.method_10264() + 0.5;
                            offsetZ = (double)pos2.method_10260() + 0.937;
                            break;
                        }
                        case field_11034: {
                            offsetX = (double)pos2.method_10263() + 0.1337;
                            offsetY = (double)pos2.method_10264() + 0.5;
                            offsetZ = (double)pos2.method_10260() + 0.5;
                            break;
                        }
                        case field_11035: {
                            offsetX = (double)pos2.method_10263() + 0.5;
                            offsetY = (double)pos2.method_10264() + 0.5;
                            offsetZ = (double)pos2.method_10260() + 0.1337;
                            break;
                        }
                        case field_11039: {
                            offsetX = (double)pos2.method_10263() + 0.937;
                            offsetY = (double)pos2.method_10264() + 0.5;
                            offsetZ = (double)pos2.method_10260() + 0.5;
                            break;
                        }
                        default: {
                            offsetX = (double)pos2.method_10263() + 0.5;
                            offsetY = (double)pos2.method_10264() + 0.5;
                            offsetZ = (double)pos2.method_10260() + 0.5;
                            break;
                        }
                    }
                } else {
                    offsetX = (double)pos2.method_10263() + 0.5;
                    offsetY = (double)pos2.method_10264() + 0.5;
                    offsetZ = (double)pos2.method_10260() + 0.5;
                }
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, offsetX, offsetY, offsetZ, (Color)esp.tracerColor);
            }
            catch (Exception err) {
                LogUtil.error(err.toString(), this.name);
            }
        }
    }
}

