/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.util;

import dev.stardust.util.LogUtil;
import dev.stardust.util.StardustUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.map.mods.SupportMods;

public class MapUtil {
    public static void addWaypoint(class_2338 pos, String name, String initials, Purpose purpose, WpColor color, boolean temp) {
        if (!StardustUtil.XAERO_AVAILABLE) {
            return;
        }
        XaeroIntegration.addWaypoint(pos, name, initials, purpose, color, temp);
    }

    public static void removeWaypoints(String name, Predicate<class_2338> posPredicate, Optional<Integer> yOverride) {
        if (!StardustUtil.XAERO_AVAILABLE) {
            return;
        }
        XaeroIntegration.removeWaypoints(name, posPredicate, yOverride);
    }

    private static class XaeroIntegration {
        private XaeroIntegration() {
        }

        static void addWaypoint(class_2338 pos, String name, String initials, Purpose purpose, WpColor color, boolean temp) {
            try {
                if (XaeroIntegration.getWaypointByCoordinate(pos.method_10263(), pos.method_10260()) != null) {
                    LogUtil.warn("Cancelling duplicate waypoint with name: \"" + name + "\"..!", "MapUtil");
                    return;
                }
                WaypointSet set = XaeroIntegration.getWaypointSet();
                if (set == null) {
                    LogUtil.warn("Cancelling waypoint with name \"" + name + "\" because the waypoint set is null..!", "MapUtil");
                    return;
                }
                Waypoint waypoint = new Waypoint(pos.method_10263(), pos.method_10264(), pos.method_10260(), name, initials, XaeroIntegration.getColor(color), XaeroIntegration.getPurpose(purpose), temp);
                set.add(waypoint);
                SupportMods.xaeroMinimap.requestWaypointsRefresh();
                XaeroIntegration.saveWaypoints();
            }
            catch (Exception err) {
                LogUtil.error("Error while trying to add waypoint to Xaero map! Why - " + String.valueOf(err), "MapUtil");
            }
        }

        @Nullable
        static MinimapSession getMinimapSession() {
            return (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        }

        @Nullable
        static MinimapWorld getWaypointWorld() {
            MinimapSession session = XaeroIntegration.getMinimapSession();
            if (session == null) {
                return null;
            }
            return session.getWorldManager().getCurrentWorld();
        }

        @Nullable
        static WaypointSet getWaypointSet() {
            MinimapWorld currentWorld = XaeroIntegration.getWaypointWorld();
            if (currentWorld == null) {
                return null;
            }
            return currentWorld.getCurrentWaypointSet();
        }

        @Nullable
        static Waypoint getWaypointByCoordinate(int x, int z) {
            WaypointSet waypointSet = XaeroIntegration.getWaypointSet();
            if (waypointSet == null) {
                return null;
            }
            for (Waypoint waypoint : waypointSet.getWaypoints()) {
                if (waypoint.getX() != x || waypoint.getZ() != z) continue;
                return waypoint;
            }
            return null;
        }

        static void removeWaypoints(String name, Predicate<class_2338> posPredicate, Optional<Integer> yOverride) {
            try {
                WaypointSet set = XaeroIntegration.getWaypointSet();
                if (set == null) {
                    return;
                }
                class_2338.class_2339 mPos = new class_2338.class_2339();
                ObjectArrayList toRemove = new ObjectArrayList();
                for (Waypoint wp : set.getWaypoints()) {
                    if (!wp.getName().trim().startsWith(name.trim())) continue;
                    int y = yOverride.orElseGet(() -> ((Waypoint)wp).getY());
                    mPos.method_10103(wp.getX(), y, wp.getZ());
                    if (!posPredicate.test((class_2338)mPos)) continue;
                    toRemove.add(wp);
                }
                for (Waypoint wp : toRemove) {
                    set.remove(wp);
                }
                XaeroIntegration.saveWaypoints();
            }
            catch (Exception err) {
                LogUtil.error("Error while trying to remove waypoints from Xaero map! Why - " + String.valueOf(err), "MapUtil");
            }
        }

        static void saveWaypoints() {
            try {
                MinimapSession session = XaeroIntegration.getMinimapSession();
                MinimapWorld world = XaeroIntegration.getWaypointWorld();
                if (world != null) {
                    session.getWorldManagerIO().saveWorld(world);
                }
            }
            catch (Exception err) {
                LogUtil.error("Failed saving minimap waypoints! Why: " + String.valueOf(err), "MapUtil");
            }
        }

        static WaypointPurpose getPurpose(Purpose purpose) {
            return switch (purpose.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> WaypointPurpose.NORMAL;
                case 1 -> WaypointPurpose.DESTINATION;
            };
        }

        static WaypointColor getColor(WpColor color) {
            return switch (color.ordinal()) {
                default -> throw new MatchException(null, null);
                case 16 -> WaypointColor.getRandom();
                case 0 -> WaypointColor.BLACK;
                case 1 -> WaypointColor.DARK_BLUE;
                case 2 -> WaypointColor.DARK_GREEN;
                case 3 -> WaypointColor.DARK_AQUA;
                case 4 -> WaypointColor.DARK_RED;
                case 5 -> WaypointColor.DARK_PURPLE;
                case 6 -> WaypointColor.GOLD;
                case 7 -> WaypointColor.GRAY;
                case 8 -> WaypointColor.DARK_GRAY;
                case 9 -> WaypointColor.BLUE;
                case 10 -> WaypointColor.GREEN;
                case 11 -> WaypointColor.AQUA;
                case 12 -> WaypointColor.RED;
                case 13 -> WaypointColor.PURPLE;
                case 14 -> WaypointColor.YELLOW;
                case 15 -> WaypointColor.WHITE;
            };
        }
    }

    public static enum Purpose {
        Normal,
        Destination;

    }

    public static enum WpColor {
        Black,
        Dark_Blue,
        Dark_Green,
        Dark_Aqua,
        Dark_Red,
        Dark_Purple,
        Gold,
        Gray,
        Dark_Gray,
        Blue,
        Green,
        Aqua,
        Red,
        Purple,
        Yellow,
        White,
        Random;

    }
}

