/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class TextUtil {
    public static class_2561 modifyWithStyle(class_2561 original, UnaryOperator<String> modifier) {
        ArrayList<StyledChar> chars = new ArrayList<StyledChar>();
        TextUtil.collectStyledChars(original, original.method_10866(), chars);
        String modifiedContent = (String)modifier.apply(original.getString());
        ArrayList<StyledChar> modifiedChars = new ArrayList<StyledChar>();
        for (int n = 0; n < chars.size(); ++n) {
            modifiedChars.add(new StyledChar(modifiedContent.charAt(n), ((StyledChar)chars.get((int)n)).style));
        }
        return TextUtil.rebuildFromStyledChars(modifiedChars);
    }

    private static void collectStyledChars(class_2561 original, class_2583 inherited, List<StyledChar> out) {
        class_2583 style = original.method_10866().method_27702(inherited);
        String content = original.method_10851().method_27659(Optional::of).orElse("");
        for (char c : content.toCharArray()) {
            out.add(new StyledChar(c, style));
        }
        Object object = original.method_10855().iterator();
        while (object.hasNext()) {
            class_2561 sibling = (class_2561)object.next();
            TextUtil.collectStyledChars(sibling, style, out);
        }
    }

    private static class_2561 rebuildFromStyledChars(List<StyledChar> chars) {
        if (chars.isEmpty()) {
            return class_2561.method_43470((String)"");
        }
        class_5250 root = null;
        StringBuilder sb = new StringBuilder();
        class_2583 currentStyle = chars.getFirst().style();
        for (StyledChar sc : chars) {
            if (!sc.style.equals((Object)currentStyle)) {
                if (!sb.isEmpty()) {
                    class_5250 chunk = class_2561.method_43470((String)sb.toString()).method_10862(currentStyle);
                    if (root == null) {
                        root = chunk;
                    } else {
                        root.method_10852((class_2561)chunk);
                    }
                    sb.setLength(0);
                }
                currentStyle = sc.style();
            }
            sb.append(sc.c());
        }
        if (!sb.isEmpty()) {
            class_5250 chunk = class_2561.method_43470((String)sb.toString()).method_10862(currentStyle);
            if (root == null) {
                root = chunk;
            } else {
                root.method_10852((class_2561)chunk);
            }
        }
        return root;
    }

    record StyledChar(char c, class_2583 style) {
    }
}

