/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.util.commands;

import dev.stardust.util.LogUtil;
import dev.stardust.util.StardustUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ApiHandler {
    public static final String API_2B2T_URL = "https://api.2b2t.vc";

    public static void sendErrorResponse() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353(class_2561.method_30163((String)("\u00a78<" + StardustUtil.rCC() + "\u00a7o\u2728\u00a7r\u00a78> \u00a74An error occurred\u00a77, \u00a74please try again later or check \u00a77latest.log \u00a74for more info\u00a77..")), false);
        }
    }

    @Nullable
    public String fetchResponse(String requestString) {
        HttpRequest req;
        HttpClient client = HttpClient.newHttpClient();
        try {
            req = HttpRequest.newBuilder().uri(new URI(requestString)).header("Accept", "*/*").method("GET", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(30L)).build();
        }
        catch (URISyntaxException err) {
            ApiHandler.sendErrorResponse();
            LogUtil.error(err.toString(), "ApiHandler");
            return null;
        }
        if (req == null) {
            ApiHandler.sendErrorResponse();
            return null;
        }
        HttpResponse<String> res = null;
        try {
            res = client.sendAsync(req, HttpResponse.BodyHandlers.ofString()).get();
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), "ApiHandler");
        }
        if (res == null) {
            ApiHandler.sendErrorResponse();
            return null;
        }
        if (res.statusCode() == 200) {
            return res.body();
        }
        if (res.statusCode() == 204) {
            return "204 Undocumented";
        }
        ApiHandler.sendErrorResponse();
        LogUtil.warn("Received unexpected response from api.2b2t.vc: \"" + String.valueOf(res) + "\"", "ApiHandler");
        return null;
    }
}

