/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.managers.network;

import com.genyo.events.network.ConnectScreenEvent;
import com.genyo.events.network.DisconnectEvent;
import com.genyo.imixins.IClientPlayNetworkHandler;
import com.genyo.mixin.accessor.AccessorClientWorld;
import com.genyo.utils.math.PerSecondCounter;
import java.util.HashSet;
import java.util.Set;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2596;
import net.minecraft.class_2896;
import net.minecraft.class_635;
import net.minecraft.class_639;
import net.minecraft.class_640;
import net.minecraft.class_642;
import net.minecraft.class_7202;
import net.minecraft.class_7204;

public class NetworkManager {
    private static final Set<class_2596<?>> PACKET_CACHE = new HashSet();
    private class_639 address;
    private class_642 info;
    private final PerSecondCounter outgoingCounter = new PerSecondCounter();
    private final PerSecondCounter incomingCounter = new PerSecondCounter();

    @EventHandler
    public void onConnectScreen(ConnectScreenEvent event) {
        this.address = event.address;
        this.info = event.info;
    }

    @EventHandler
    public void onDisconnect(DisconnectEvent event) {
        PACKET_CACHE.clear();
    }

    @EventHandler
    public void onPacketSend(PacketEvent.Send event) {
        this.outgoingCounter.updateCounter();
    }

    @EventHandler
    public void onPacketReceive(PacketEvent.Receive event) {
        this.incomingCounter.updateCounter();
    }

    public void connect(class_639 address, class_642 info) {
        if (MeteorClient.mc.method_1562() == null) {
            return;
        }
        MeteorClient.mc.method_1562().method_48296().method_52902(address.method_2952(), address.method_2954(), (class_2896)new class_635(MeteorClient.mc.method_1562().method_48296(), MeteorClient.mc, info, null, false, null, null, null));
    }

    public void sendQuietPacket(class_2596<?> p) {
        if (MeteorClient.mc.method_1562() != null) {
            PACKET_CACHE.add(p);
            ((IClientPlayNetworkHandler)MeteorClient.mc.method_1562()).sendQuietPacket(p);
        }
    }

    public void sendPacket(class_2596<?> p) {
        if (MeteorClient.mc.method_1562() != null) {
            PACKET_CACHE.add(p);
            MeteorClient.mc.method_1562().method_52787(p);
        }
    }

    public void sendSequencedPacket(class_7204 p) {
        if (MeteorClient.mc.field_1687 != null) {
            class_7202 updater = ((AccessorClientWorld)MeteorClient.mc.field_1687).hookGetPendingUpdateManager().method_41937();
            try {
                int i = updater.method_41942();
                class_2596 packet = p.predict(i);
                this.sendPacket(packet);
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (updater != null) {
                    try {
                        updater.close();
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                        e.addSuppressed(e1);
                    }
                }
                throw e;
            }
            if (updater != null) {
                updater.close();
            }
        }
    }

    public int getClientLatency() {
        class_640 playerEntry;
        if (MeteorClient.mc.method_1562() != null && (playerEntry = MeteorClient.mc.method_1562().method_2871(MeteorClient.mc.field_1724.method_7334().getId())) != null) {
            return playerEntry.method_2959();
        }
        return 0;
    }

    public class_639 getAddress() {
        return this.address;
    }

    public void setAddress(class_639 address) {
        this.address = address;
    }

    public class_642 getInfo() {
        return this.info;
    }

    public void setInfo(class_642 info) {
        this.info = info;
    }

    public boolean isCrystalPvpCC() {
        return this.getServerIp().contains("crystalpvp.cc");
    }

    public boolean is2b2t() {
        return this.getServerIp().contains("2b2t.org");
    }

    public int getOutgoingPPS() {
        return this.outgoingCounter.getPerSecond();
    }

    public int getIncomingPPS() {
        return this.incomingCounter.getPerSecond();
    }

    public String getServerIp() {
        if (this.info != null) {
            return this.info.field_3761;
        }
        return "Singleplayer";
    }

    public boolean isCached(class_2596<?> p) {
        return PACKET_CACHE.contains(p);
    }
}

