/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.managers.player.rotation;

import com.genyo.events.StageEvent;
import com.genyo.events.network.MovementPacketsEvent;
import com.genyo.events.network.PlayerTickEvent;
import com.genyo.events.network.PlayerUpdateEvent;
import com.genyo.imixins.IClientPlayerEntity;
import com.genyo.managers.Managers;
import com.genyo.managers.player.rotation.Rotation;
import com.genyo.utils.player.PlayerUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_3532;

public class RotationManager {
    private final List<Rotation> requests = new CopyOnWriteArrayList<Rotation>();
    private float serverYaw;
    private float serverPitch;
    private float lastServerYaw;
    private float lastServerPitch;
    private float prevJumpYaw;
    private float prevYaw;
    private float prevPitch;
    boolean rotate;
    private Rotation rotation;
    private int rotateTicks;
    private boolean webJumpFix;
    private boolean preJumpFix;

    @EventHandler
    public void onPacketSend(PacketEvent.Send event) {
        class_2828 packet;
        if (MeteorClient.mc.field_1724 == null || MeteorClient.mc.field_1687 == null) {
            return;
        }
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2828 && (packet = (class_2828)class_25962).method_36172()) {
            float packetYaw = packet.method_12271(0.0f);
            float packetPitch = packet.method_12270(0.0f);
            this.serverYaw = packetYaw;
            this.serverPitch = packetPitch;
        }
    }

    @EventHandler(priority=-2147483648)
    public void onPlayerTick(PlayerTickEvent event) {
        Rotation request;
        this.webJumpFix = PlayerUtil.inWeb(1.0);
        if (this.requests.isEmpty()) {
            this.rotation = null;
            return;
        }
        this.rotation = request = this.getRotationRequest();
        if (this.rotation == null) {
            return;
        }
        this.rotateTicks = 0;
        this.rotate = true;
    }

    @EventHandler
    public void onMovementPackets(MovementPacketsEvent event) {
        if (this.rotation != null) {
            if (this.rotate) {
                this.removeRotation(this.rotation);
                event.cancel();
                event.yaw = this.rotation.getYaw();
                event.pitch = this.rotation.getPitch();
                this.rotate = false;
            }
            if (this.rotation.isSnap()) {
                this.rotation = null;
            }
        }
    }

    @EventHandler
    public void onPlayerUpdate(PlayerUpdateEvent event) {
        if (event.getStage() == StageEvent.EventStage.POST) {
            this.lastServerYaw = ((IClientPlayerEntity)MeteorClient.mc.field_1724).genyo_addon$getLastSpoofedYaw();
            this.lastServerPitch = ((IClientPlayerEntity)MeteorClient.mc.field_1724).genyo_addon$getLastSpoofedPitch();
        }
    }

    public void setRotation(Rotation rotation) {
        Rotation request;
        if (rotation.getPriority() == Integer.MAX_VALUE) {
            this.rotation = rotation;
        }
        if ((request = (Rotation)this.requests.stream().filter(r -> rotation.getPriority() == r.getPriority()).findFirst().orElse(null)) == null) {
            this.requests.add(rotation);
        } else {
            request.setYaw(rotation.getYaw());
            request.setPitch(rotation.getPitch());
        }
    }

    public void setRotationClient(float yaw, float pitch) {
        if (MeteorClient.mc.field_1724 == null) {
            return;
        }
        MeteorClient.mc.field_1724.method_36456(yaw);
        MeteorClient.mc.field_1724.method_36457(class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f));
    }

    public void setRotationSilent(float yaw, float pitch) {
        this.setRotation(new Rotation(Integer.MAX_VALUE, yaw, pitch, true));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2828.class_2830(MeteorClient.mc.field_1724.method_23317(), MeteorClient.mc.field_1724.method_23318(), MeteorClient.mc.field_1724.method_23321(), yaw, pitch, MeteorClient.mc.field_1724.method_24828(), MeteorClient.mc.field_1724.field_5976));
    }

    public void setRotationSilentSync() {
        float yaw = MeteorClient.mc.field_1724.method_36454();
        float pitch = MeteorClient.mc.field_1724.method_36455();
        this.setRotation(new Rotation(Integer.MAX_VALUE, yaw, pitch, true));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2828.class_2830(MeteorClient.mc.field_1724.method_23317(), MeteorClient.mc.field_1724.method_23318(), MeteorClient.mc.field_1724.method_23321(), yaw, pitch, MeteorClient.mc.field_1724.method_24828(), MeteorClient.mc.field_1724.field_5976));
    }

    public boolean removeRotation(Rotation request) {
        return this.requests.remove(request);
    }

    public boolean isRotationBlocked(int priority) {
        return this.rotation != null && priority < this.rotation.getPriority();
    }

    public boolean isRotating() {
        return this.rotation != null;
    }

    public float getRotationYaw() {
        return this.rotation.getYaw();
    }

    public float getRotationPitch() {
        return this.rotation.getPitch();
    }

    public float getServerYaw() {
        return this.serverYaw;
    }

    public float getWrappedYaw() {
        return class_3532.method_15393((float)this.serverYaw);
    }

    public float getServerPitch() {
        return this.serverPitch;
    }

    private class_243 movementInputToVelocity(float yaw, class_243 movementInput, float speed) {
        double d = movementInput.method_1027();
        if (d < 1.0E-7) {
            return class_243.field_1353;
        }
        class_243 vec3d = (d > 1.0 ? movementInput.method_1029() : movementInput).method_1021((double)speed);
        float f = class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        float g = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        return new class_243(vec3d.field_1352 * (double)g - vec3d.field_1350 * (double)f, vec3d.field_1351, vec3d.field_1350 * (double)g + vec3d.field_1352 * (double)f);
    }

    private Rotation getRotationRequest() {
        Rotation rotationRequest = null;
        int priority = 0;
        for (Rotation request : this.requests) {
            if (request.getPriority() <= priority) continue;
            rotationRequest = request;
            priority = request.getPriority();
        }
        return rotationRequest;
    }
}

