/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.managers.world.tick;

import com.genyo.events.network.DisconnectEvent;
import com.genyo.events.render.TickCounterEvent;
import com.genyo.managers.world.tick.TickSync;
import com.genyo.utils.collection.EvictingQueue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2761;

public class TickManager {
    private final Deque<Float> ticks = new EvictingQueue<Float>(20);
    private long time;
    private float clientTick = 1.0f;

    @EventHandler
    public void onDisconnect(DisconnectEvent event) {
        this.ticks.clear();
    }

    @EventHandler
    public void onPacketReceive(PacketEvent.Receive event) {
        if (MeteorClient.mc.field_1724 == null || MeteorClient.mc.field_1687 == null) {
            return;
        }
        if (event.packet instanceof class_2761) {
            float last = 20000.0f / (float)(System.currentTimeMillis() - this.time);
            this.ticks.addFirst(Float.valueOf(last));
            this.time = System.currentTimeMillis();
        }
    }

    public void setClientTick(float ticks) {
        this.clientTick = ticks;
    }

    @EventHandler
    public void onTickCounter(TickCounterEvent event) {
        if (this.clientTick != 1.0f) {
            event.cancel();
            event.ticks = this.clientTick;
        }
    }

    public Queue<Float> getTicks() {
        return this.ticks;
    }

    public float getTpsAverage() {
        float avg = 0.0f;
        try {
            ArrayList ticksCopy = Lists.newArrayList(this.ticks);
            if (!ticksCopy.isEmpty()) {
                Iterator iterator = ticksCopy.iterator();
                while (iterator.hasNext()) {
                    float t = ((Float)iterator.next()).floatValue();
                    avg += t;
                }
                avg /= Math.max((float)ticksCopy.size(), 1.0f);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Math.min(100.0f, avg);
    }

    public float getTpsCurrent() {
        try {
            if (!this.ticks.isEmpty()) {
                return Math.min(100.0f, this.ticks.getFirst().floatValue());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 20.0f;
    }

    public float getTpsMin() {
        float min = 20.0f;
        try {
            for (float t : this.ticks) {
                if (!(t < min)) continue;
                min = t;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return min;
    }

    public boolean isTicksFilled() {
        return this.ticks.size() >= 20;
    }

    public float getTickSync(TickSync tps) {
        return switch (tps) {
            default -> throw new MatchException(null, null);
            case TickSync.AVERAGE -> this.getTpsAverage();
            case TickSync.CURRENT -> this.getTpsCurrent();
            case TickSync.MINIMAL -> this.getTpsMin();
            case TickSync.NONE -> 20.0f;
        };
    }
}

