/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.render;

import com.genyo.render.Render2DEngine;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class Render3DEngine {
    public static List<FillAction> FILLED_QUEUE = new ArrayList<FillAction>();
    public static List<OutlineAction> OUTLINE_QUEUE = new ArrayList<OutlineAction>();
    public static List<FadeAction> FADE_QUEUE = new ArrayList<FadeAction>();
    public static List<FillSideAction> FILLED_SIDE_QUEUE = new ArrayList<FillSideAction>();
    public static List<OutlineSideAction> OUTLINE_SIDE_QUEUE = new ArrayList<OutlineSideAction>();
    public static List<DebugLineAction> DEBUG_LINE_QUEUE = new ArrayList<DebugLineAction>();
    public static List<LineAction> LINE_QUEUE = new ArrayList<LineAction>();
    public static final Matrix4f lastProjMat = new Matrix4f();
    public static final Matrix4f lastModMat = new Matrix4f();
    public static final Matrix4f lastWorldSpaceMatrix = new Matrix4f();
    private static float prevCircleStep;
    private static float circleStep;

    @EventHandler
    public void onRender3D(Render3DEvent event) {
        class_287 buffer;
        class_289 tessellator;
        class_4587 stack = event.matrices;
        class_4184 camera = MeteorClient.mc.method_1561().field_4686;
        if (!(FILLED_QUEUE.isEmpty() && FADE_QUEUE.isEmpty() && FILLED_SIDE_QUEUE.isEmpty())) {
            tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            RenderSystem.disableDepthTest();
            Render3DEngine.setupRender();
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            FILLED_QUEUE.forEach(action -> Render3DEngine.setFilledBoxVertexes(bufferBuilder, stack.method_23760().method_23761(), action.box(), action.color()));
            FADE_QUEUE.forEach(action -> Render3DEngine.setFilledFadePoints(action.box(), bufferBuilder, stack.method_23760().method_23761(), action.color(), action.color2()));
            FILLED_SIDE_QUEUE.forEach(action -> Render3DEngine.setFilledSidePoints(bufferBuilder, stack.method_23760().method_23761(), action.box, action.color(), action.side()));
            Render2DEngine.endBuilding(bufferBuilder);
            Render3DEngine.endRender();
            RenderSystem.enableDepthTest();
            FADE_QUEUE.clear();
            FILLED_SIDE_QUEUE.clear();
            FILLED_QUEUE.clear();
        }
        if (!OUTLINE_QUEUE.isEmpty() || !OUTLINE_SIDE_QUEUE.isEmpty()) {
            Render3DEngine.setupRender();
            tessellator = class_289.method_1348();
            buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.setShader((class_10156)class_10142.field_53864);
            RenderSystem.lineWidth((float)2.0f);
            OUTLINE_QUEUE.forEach(action -> {
                stack.method_22903();
                stack.method_22904(action.box().field_1323 - camera.method_19326().field_1352, action.box().field_1322 - camera.method_19326().field_1351, action.box().field_1321 - camera.method_19326().field_1350);
                Render3DEngine.setOutlinePoints(action.box(), stack, buffer, action.color());
                stack.method_22909();
            });
            OUTLINE_SIDE_QUEUE.forEach(action -> {
                stack.method_22903();
                stack.method_22904(action.box.field_1323 - camera.method_19326().field_1352, action.box.field_1322 - camera.method_19326().field_1351, action.box.field_1321 - camera.method_19326().field_1350);
                Render3DEngine.setSideOutlinePoints(action.box, stack, buffer, action.color(), action.side());
                stack.method_22909();
            });
            Render2DEngine.endBuilding(buffer);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            Render3DEngine.endRender();
            OUTLINE_QUEUE.clear();
            OUTLINE_SIDE_QUEUE.clear();
        }
        if (!DEBUG_LINE_QUEUE.isEmpty()) {
            Render3DEngine.setupRender();
            RenderSystem.disableDepthTest();
            tessellator = class_289.method_1348();
            buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_29337);
            RenderSystem.disableCull();
            RenderSystem.setShader((class_10156)class_10142.field_53864);
            DEBUG_LINE_QUEUE.forEach(action -> {
                stack.method_22903();
                stack.method_22904(action.start.method_10216() - camera.method_19326().field_1352, action.start.method_10214() - camera.method_19326().field_1351, action.start.method_10215() - camera.method_19326().field_1350);
                Render3DEngine.vertexLine(stack, (class_4588)buffer, 0.0f, 0.0f, 0.0f, (float)(action.end.method_10216() - action.start.method_10216()), (float)(action.end.method_10214() - action.start.method_10214()), (float)(action.end.method_10215() - action.start.method_10215()), action.color);
                stack.method_22909();
            });
            Render2DEngine.endBuilding(buffer);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            Render3DEngine.endRender();
            DEBUG_LINE_QUEUE.clear();
        }
        if (!LINE_QUEUE.isEmpty()) {
            Render3DEngine.setupRender();
            tessellator = class_289.method_1348();
            RenderSystem.disableCull();
            RenderSystem.setShader((class_10156)class_10142.field_53864);
            RenderSystem.lineWidth((float)2.0f);
            RenderSystem.disableDepthTest();
            buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
            LINE_QUEUE.forEach(action -> {
                stack.method_22903();
                stack.method_22904(action.start.method_10216() - camera.method_19326().field_1352, action.start.method_10214() - camera.method_19326().field_1351, action.start.method_10215() - camera.method_19326().field_1350);
                Render3DEngine.vertexLine(stack, (class_4588)buffer, 0.0f, 0.0f, 0.0f, (float)(action.end.method_10216() - action.start.method_10216()), (float)(action.end.method_10214() - action.start.method_10214()), (float)(action.end.method_10215() - action.start.method_10215()), action.color);
                stack.method_22909();
            });
            Render2DEngine.endBuilding(buffer);
            RenderSystem.enableCull();
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableDepthTest();
            Render3DEngine.endRender();
            LINE_QUEUE.clear();
        }
    }

    @Deprecated
    public static void drawFilledBox(class_4587 stack, class_238 box, Color c) {
        FILLED_QUEUE.add(new FillAction(box, c));
    }

    public static void setFilledBoxVertexes(@NotNull class_287 bufferBuilder, Matrix4f m, @NotNull class_238 box, @NotNull Color c) {
        float minX = (float)(box.field_1323 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216());
        float minY = (float)(box.field_1322 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214());
        float minZ = (float)(box.field_1321 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215());
        float maxX = (float)(box.field_1320 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216());
        float maxY = (float)(box.field_1325 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214());
        float maxZ = (float)(box.field_1324 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215());
        bufferBuilder.method_22918(m, minX, minY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, minY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, minY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, minY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, minY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, maxY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, maxY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, minY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, minY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, maxY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, maxY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, minY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, minY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, minY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, maxY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, maxY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, minY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, minY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, maxY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, maxY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, maxY, minZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, minX, maxY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, maxY, maxZ).method_39415(c.getPacked());
        bufferBuilder.method_22918(m, maxX, maxY, minZ).method_39415(c.getPacked());
    }

    @NotNull
    public static class_238 interpolateBox(@NotNull class_238 from, @NotNull class_238 to, float delta) {
        double X = Render2DEngine.interpolate(from.field_1320, to.field_1320, delta);
        double Y = Render2DEngine.interpolate(from.field_1325, to.field_1325, delta);
        double Z = Render2DEngine.interpolate(from.field_1324, to.field_1324, delta);
        double X1 = Render2DEngine.interpolate(from.field_1323, to.field_1323, delta);
        double Y1 = Render2DEngine.interpolate(from.field_1322, to.field_1322, delta);
        double Z1 = Render2DEngine.interpolate(from.field_1321, to.field_1321, delta);
        return new class_238(X1, Y1, Z1, X, Y, Z);
    }

    @Deprecated
    public static void drawFilledSide(class_4587 stack, @NotNull class_238 box, Color c, class_2350 dir) {
        FILLED_SIDE_QUEUE.add(new FillSideAction(box, c, dir));
    }

    public static void setFilledSidePoints(class_287 buffer, Matrix4f matrix, class_238 box, Color c, class_2350 dir) {
        float minX = (float)(box.field_1323 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216());
        float minY = (float)(box.field_1322 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214());
        float minZ = (float)(box.field_1321 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215());
        float maxX = (float)(box.field_1320 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216());
        float maxY = (float)(box.field_1325 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214());
        float maxZ = (float)(box.field_1324 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215());
        if (dir == class_2350.field_11033) {
            buffer.method_22918(matrix, minX, minY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, minY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, minY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, minX, minY, maxZ).method_39415(c.getPacked());
        }
        if (dir == class_2350.field_11043) {
            buffer.method_22918(matrix, minX, minY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, minX, maxY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, maxY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, minY, minZ).method_39415(c.getPacked());
        }
        if (dir == class_2350.field_11034) {
            buffer.method_22918(matrix, maxX, minY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, maxY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, maxY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, minY, maxZ).method_39415(c.getPacked());
        }
        if (dir == class_2350.field_11035) {
            buffer.method_22918(matrix, minX, minY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, minY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, maxY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, minX, maxY, maxZ).method_39415(c.getPacked());
        }
        if (dir == class_2350.field_11039) {
            buffer.method_22918(matrix, minX, minY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, minX, minY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, minX, maxY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, minX, maxY, minZ).method_39415(c.getPacked());
        }
        if (dir == class_2350.field_11036) {
            buffer.method_22918(matrix, minX, maxY, minZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, minX, maxY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, maxY, maxZ).method_39415(c.getPacked());
            buffer.method_22918(matrix, maxX, maxY, minZ).method_39415(c.getPacked());
        }
    }

    public static void drawTextIn3D(String text, @NotNull class_243 pos, double offX, double offY, double textOffset, @NotNull Color color) {
        class_4587 matrices = new class_4587();
        class_4184 camera = MeteorClient.mc.field_1773.method_19418();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        matrices.method_22904(pos.method_10216() - camera.method_19326().field_1352, pos.method_10214() - camera.method_19326().field_1351, pos.method_10215() - camera.method_19326().field_1350);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        Render3DEngine.setupRender();
        matrices.method_22904(offX, offY - 0.1, -0.01);
        matrices.method_22905(-0.025f, -0.025f, 0.0f);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        Render3DEngine.endRender();
    }

    @NotNull
    public static class_243 worldSpaceToScreenSpace(@NotNull class_243 pos) {
        class_4184 camera = MeteorClient.mc.method_1561().field_4686;
        int displayHeight = MeteorClient.mc.method_22683().method_4507();
        int[] viewport = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewport);
        Vector3f target = new Vector3f();
        double deltaX = pos.field_1352 - camera.method_19326().field_1352;
        double deltaY = pos.field_1351 - camera.method_19326().field_1351;
        double deltaZ = pos.field_1350 - camera.method_19326().field_1350;
        Vector4f transformedCoordinates = new Vector4f((float)deltaX, (float)deltaY, (float)deltaZ, 1.0f).mul((Matrix4fc)lastWorldSpaceMatrix);
        Matrix4f matrixProj = new Matrix4f((Matrix4fc)lastProjMat);
        Matrix4f matrixModel = new Matrix4f((Matrix4fc)lastModMat);
        matrixProj.mul((Matrix4fc)matrixModel).project(transformedCoordinates.x(), transformedCoordinates.y(), transformedCoordinates.z(), viewport, target);
        return new class_243((double)target.x / Render3DEngine.getScaleFactor(), (double)((float)displayHeight - target.y) / Render3DEngine.getScaleFactor(), (double)target.z);
    }

    public static double getScaleFactor() {
        return MeteorClient.mc.method_22683().method_4495();
    }

    @Deprecated
    public static void drawFilledFadeBox(@NotNull class_4587 stack, @NotNull class_238 box, @NotNull Color c, @NotNull Color c1) {
        FADE_QUEUE.add(new FadeAction(box, c, c1));
    }

    public static void setFilledFadePoints(class_238 box, class_287 buffer, Matrix4f posMatrix, Color c, Color c1) {
        float minX = (float)(box.field_1323 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216());
        float minY = (float)(box.field_1322 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214());
        float minZ = (float)(box.field_1321 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215());
        float maxX = (float)(box.field_1320 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216());
        float maxY = (float)(box.field_1325 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214());
        float maxZ = (float)(box.field_1324 - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215());
        buffer.method_22918(posMatrix, minX, minY, minZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, minX, maxY, minZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, maxX, maxY, minZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, maxX, minY, minZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, maxX, minY, minZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, maxX, maxY, minZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, maxX, maxY, maxZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, maxX, minY, maxZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, minX, minY, maxZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, maxX, minY, maxZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, maxX, maxY, maxZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, minX, maxY, maxZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, minX, minY, minZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, minX, minY, maxZ).method_39415(c.getPacked());
        buffer.method_22918(posMatrix, minX, maxY, maxZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, minX, maxY, minZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, minX, maxY, minZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, minX, maxY, maxZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, maxX, maxY, maxZ).method_39415(c1.getPacked());
        buffer.method_22918(posMatrix, maxX, maxY, minZ).method_39415(c1.getPacked());
    }

    public static void drawLine(@NotNull class_243 start, @NotNull class_243 end, @NotNull Color color) {
        LINE_QUEUE.add(new LineAction(start, end, color));
    }

    @Deprecated
    public static void drawBoxOutline(@NotNull class_238 box, Color color, float lineWidth) {
        OUTLINE_QUEUE.add(new OutlineAction(box, color, lineWidth));
    }

    public static void setOutlinePoints(class_238 box, class_4587 matrices, class_287 buffer, Color color) {
        box = box.method_997(new class_243(box.field_1323, box.field_1322, box.field_1321).method_22882());
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z1, x2, y1, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x2, y1, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x1, y1, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y1, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y2, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z1, x1, y2, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x2, y2, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x2, y2, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y2, z1, x2, y2, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y2, z1, x2, y2, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y2, z2, x1, y2, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y2, z2, x1, y2, z1, color);
    }

    @Deprecated
    public static void drawSideOutline(@NotNull class_238 box, Color color, float lineWidth, class_2350 dir) {
        OUTLINE_SIDE_QUEUE.add(new OutlineSideAction(box, color, lineWidth, dir));
    }

    public static void setSideOutlinePoints(class_238 box, class_4587 matrices, class_287 buffer, Color color, class_2350 dir) {
        box = box.method_997(new class_243(box.field_1323, box.field_1322, box.field_1321).method_22882());
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        switch (dir) {
            case field_11036: {
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y2, z1, x2, y2, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y2, z1, x2, y2, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y2, z2, x1, y2, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y2, z2, x1, y2, z1, color);
                break;
            }
            case field_11033: {
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z1, x2, y1, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x2, y1, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x1, y1, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y1, z1, color);
                break;
            }
            case field_11034: {
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x2, y2, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x2, y2, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y2, z2, x2, y2, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x2, y1, z1, color);
                break;
            }
            case field_11039: {
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z1, x1, y2, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y2, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y2, z2, x1, y2, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y1, z1, color);
                break;
            }
            case field_11043: {
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x2, y2, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z1, x1, y2, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x1, y1, z1, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y2, z1, x1, y2, z1, color);
                break;
            }
            case field_11035: {
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y2, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x2, y2, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x2, y1, z2, color);
                Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y2, z2, x2, y2, z2, color);
            }
        }
    }

    public static void drawHoleOutline(@NotNull class_238 box, Color color, float lineWidth) {
        Render3DEngine.setupRender();
        class_4587 matrices = Render3DEngine.matrixFrom(box.field_1323, box.field_1322, box.field_1321);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        RenderSystem.disableCull();
        RenderSystem.setShader((class_10156)class_10142.field_53864);
        RenderSystem.lineWidth((float)lineWidth);
        box = box.method_997(new class_243(box.field_1323, box.field_1322, box.field_1321).method_22882());
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float y2 = (float)box.field_1325;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float z2 = (float)box.field_1324;
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z1, x2, y1, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x2, y1, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x1, y1, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y1, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z1, x1, y2, z1, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z2, x2, y2, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x1, y1, z2, x1, y2, z2, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, x2, y1, z1, x2, y2, z1, color);
        Render2DEngine.endBuilding(buffer);
        RenderSystem.enableCull();
        Render3DEngine.endRender();
    }

    public static void vertexLine(@NotNull class_4587 matrices, @NotNull class_4588 buffer, float x1, float y1, float z1, float x2, float y2, float z2, @NotNull Color lineColor) {
        Matrix4f model = matrices.method_23760().method_23761();
        class_4587.class_4665 entry = matrices.method_23760();
        Vector3f normalVec = Render3DEngine.getNormal(x1, y1, z1, x2, y2, z2);
        buffer.method_22918(model, x1, y1, z1).method_1336(lineColor.r, lineColor.g, lineColor.b, lineColor.a).method_60831(entry, normalVec.x(), normalVec.y(), normalVec.z());
        buffer.method_22918(model, x2, y2, z2).method_1336(lineColor.r, lineColor.g, lineColor.b, lineColor.a).method_60831(entry, normalVec.x(), normalVec.y(), normalVec.z());
    }

    @NotNull
    public static Vector3f getNormal(float x1, float y1, float z1, float x2, float y2, float z2) {
        float xNormal = x2 - x1;
        float yNormal = y2 - y1;
        float zNormal = z2 - z1;
        float normalSqrt = class_3532.method_15355((float)(xNormal * xNormal + yNormal * yNormal + zNormal * zNormal));
        return new Vector3f(xNormal / normalSqrt, yNormal / normalSqrt, zNormal / normalSqrt);
    }

    @NotNull
    public static class_4587 matrixFrom(double x, double y, double z) {
        class_4587 matrices = new class_4587();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        matrices.method_22904(x - camera.method_19326().field_1352, y - camera.method_19326().field_1351, z - camera.method_19326().field_1350);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        return matrices;
    }

    public static void setupRender() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void endRender() {
        RenderSystem.disableBlend();
    }

    public static void drawTargetEsp(class_4587 stack, @NotNull class_1297 target) {
        int j;
        ArrayList<class_243> vecs = new ArrayList<class_243>();
        ArrayList<class_243> vecs1 = new ArrayList<class_243>();
        ArrayList<class_243> vecs2 = new ArrayList<class_243>();
        double x = target.field_6014 + (target.method_23317() - target.field_6014) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216();
        double y = target.field_6036 + (target.method_23318() - target.field_6036) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214();
        double z = target.field_5969 + (target.method_23321() - target.field_5969) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215();
        double height = target.method_17682();
        for (int i = 0; i <= 361; ++i) {
            double v = Math.sin(Math.toRadians(i));
            double u = Math.cos(Math.toRadians(i));
            class_243 vec = new class_243((double)((float)(u * 0.5)), height, (double)((float)(v * 0.5)));
            vecs.add(vec);
            double v1 = Math.sin(Math.toRadians((i + 120) % 360));
            double u1 = Math.cos(Math.toRadians(i + 120) % 360.0);
            class_243 vec1 = new class_243((double)((float)(u1 * 0.5)), height, (double)((float)(v1 * 0.5)));
            vecs1.add(vec1);
            double v2 = Math.sin(Math.toRadians((i + 240) % 360));
            double u2 = Math.cos(Math.toRadians((i + 240) % 360));
            class_243 vec2 = new class_243((double)((float)(u2 * 0.5)), height, (double)((float)(v2 * 0.5)));
            vecs2.add(vec2);
            height -= (double)0.004f;
        }
        stack.method_22903();
        stack.method_22904(x, y, z);
        Render3DEngine.setupRender();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        Matrix4f matrix = stack.method_23760().method_23761();
        for (j = 0; j < vecs.size() - 1; ++j) {
            float alpha = 1.0f - ((float)j + (float)(System.currentTimeMillis() - System.currentTimeMillis()) / 5.0f) % 360.0f / 60.0f;
            bufferBuilder.method_22918(matrix, (float)((class_243)vecs.get((int)j)).field_1352, (float)((class_243)vecs.get((int)j)).field_1351, (float)((class_243)vecs.get((int)j)).field_1350).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a((int)(alpha * 255.0f)).getPacked());
            bufferBuilder.method_22918(matrix, (float)((class_243)vecs.get((int)(j + 1))).field_1352, (float)((class_243)vecs.get((int)(j + 1))).field_1351 + 0.1f, (float)((class_243)vecs.get((int)(j + 1))).field_1350).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a((int)(alpha * 255.0f)).getPacked());
        }
        Render2DEngine.endBuilding(bufferBuilder);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        for (j = 0; j < vecs1.size() - 1; ++j) {
            float alpha = 1.0f - ((float)j + (float)(System.currentTimeMillis() - System.currentTimeMillis()) / 5.0f) % 360.0f / 60.0f;
            bufferBuilder.method_22918(matrix, (float)((class_243)vecs1.get((int)j)).field_1352, (float)((class_243)vecs1.get((int)j)).field_1351, (float)((class_243)vecs1.get((int)j)).field_1350).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a((int)(alpha * 255.0f)).getPacked());
            bufferBuilder.method_22918(matrix, (float)((class_243)vecs1.get((int)(j + 1))).field_1352, (float)((class_243)vecs1.get((int)(j + 1))).field_1351 + 0.1f, (float)((class_243)vecs1.get((int)(j + 1))).field_1350).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a((int)(alpha * 255.0f)).getPacked());
        }
        Render2DEngine.endBuilding(bufferBuilder);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        for (j = 0; j < vecs2.size() - 1; ++j) {
            float alpha = 1.0f - ((float)j + (float)(System.currentTimeMillis() - System.currentTimeMillis()) / 5.0f) % 360.0f / 60.0f;
            bufferBuilder.method_22918(matrix, (float)((class_243)vecs2.get((int)j)).field_1352, (float)((class_243)vecs2.get((int)j)).field_1351, (float)((class_243)vecs2.get((int)j)).field_1350).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a((int)(alpha * 255.0f)).getPacked());
            bufferBuilder.method_22918(matrix, (float)((class_243)vecs2.get((int)(j + 1))).field_1352, (float)((class_243)vecs2.get((int)(j + 1))).field_1351 + 0.1f, (float)((class_243)vecs2.get((int)(j + 1))).field_1350).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a((int)(alpha * 255.0f)).getPacked());
        }
        Render2DEngine.endBuilding(bufferBuilder);
        RenderSystem.enableCull();
        stack.method_22904(-x, -y, -z);
        Render3DEngine.endRender();
        RenderSystem.enableDepthTest();
        stack.method_22909();
    }

    public static void renderCrosses(@NotNull class_238 box, Color color, float lineWidth) {
        Render3DEngine.setupRender();
        class_4587 matrices = Render3DEngine.matrixFrom(box.field_1323, box.field_1322, box.field_1321);
        RenderSystem.disableCull();
        RenderSystem.setShader((class_10156)class_10142.field_53864);
        RenderSystem.lineWidth((float)lineWidth);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        box = box.method_997(new class_243(box.field_1323, box.field_1322, box.field_1321).method_22882());
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, color);
        Render3DEngine.vertexLine(matrices, (class_4588)buffer, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, color);
        Render2DEngine.endBuilding(buffer);
        RenderSystem.enableCull();
        Render3DEngine.endRender();
    }

    public static void drawSphere(class_4587 matrix, float radius, int slices, int stacks, int color) {
        float z;
        float y;
        float x;
        float theta;
        int j;
        class_287 buffer;
        float rho;
        int i;
        float drho = (float)Math.PI / (float)stacks;
        float dtheta = (float)Math.PI * 2 / ((float)slices - 1.0f);
        Render3DEngine.setupRender();
        for (i = 1; i < stacks; ++i) {
            rho = (float)i * drho;
            buffer = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            for (j = 0; j < slices; ++j) {
                theta = (float)j * dtheta;
                x = (float)(Math.cos(theta) * Math.sin(rho));
                y = (float)(Math.sin(theta) * Math.sin(rho));
                z = (float)Math.cos(rho);
                buffer.method_22918(matrix.method_23760().method_23761(), x * radius, y * radius, z * radius).method_39415(color);
            }
            Render2DEngine.endBuilding(buffer);
        }
        for (j = 0; j < slices; ++j) {
            theta = (float)j * dtheta;
            buffer = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            for (i = 0; i <= stacks; ++i) {
                rho = (float)i * drho;
                x = (float)(Math.cos(theta) * Math.sin(rho));
                y = (float)(Math.sin(theta) * Math.sin(rho));
                z = (float)Math.cos(rho);
                buffer.method_22918(matrix.method_23760().method_23761(), x * radius, y * radius, z * radius).method_39415(color);
            }
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        Render3DEngine.endRender();
    }

    public static void drawCylinder(class_4587 stack, float radius, float height, int slices, int stacks, int color) {
        float da = (float)(Math.PI * 2 / (double)slices);
        float dz = height / (float)stacks;
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        float y = 0.0f;
        for (int j = 0; j <= stacks; ++j) {
            for (int i = 0; i <= slices; ++i) {
                float x = (float)Math.cos((float)i * da);
                float z = (float)Math.sin((float)i * da);
                buffer.method_22918(stack.method_23760().method_23761(), x * radius, y, z * radius).method_39415(color);
            }
            y += dz;
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        buffer = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        for (int i = 0; i <= slices; ++i) {
            float x = (float)Math.cos((float)i * da);
            float z = (float)Math.sin((float)i * da);
            buffer.method_22918(stack.method_23760().method_23761(), x * radius, 0.0f, z * radius).method_39415(color);
            buffer.method_22918(stack.method_23760().method_23761(), x * radius, height, z * radius).method_39415(color);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawCircle3D(class_4587 stack, class_1297 ent, float radius, int color, int points, boolean hudColor, int colorOffset) {
        Render3DEngine.setupRender();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        double x = ent.field_6014 + (ent.method_23317() - ent.field_6014) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216();
        double y = ent.field_6036 + (ent.method_23318() - ent.field_6036) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214();
        double z = ent.field_5969 + (ent.method_23321() - ent.field_5969) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215();
        stack.method_22903();
        stack.method_22904(x, y, z);
        Matrix4f matrix = stack.method_23760().method_23761();
        for (int i = 0; i <= points; ++i) {
            if (hudColor) {
                color = ((SettingColor)((List)Hud.get().textColors.get()).getFirst()).getPacked();
            }
            bufferBuilder.method_22918(matrix, (float)((double)radius * Math.cos((double)i * 6.28 / (double)points)), 0.0f, (float)((double)radius * Math.sin((double)i * 6.28 / (double)points))).method_39415(color);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        Render3DEngine.endRender();
        stack.method_22904(-x, -y, -z);
        stack.method_22909();
    }

    public static void drawOldTargetEsp(class_4587 stack, class_1297 target) {
        double cs = prevCircleStep + (circleStep - prevCircleStep) * Render3DEngine.getTickDelta();
        double prevSinAnim = Render3DEngine.absSinAnimation(cs - (double)0.45f);
        double sinAnim = Render3DEngine.absSinAnimation(cs);
        double x = target.field_6014 + (target.method_23317() - target.field_6014) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216();
        double y = target.field_6036 + (target.method_23318() - target.field_6036) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214() + prevSinAnim * (double)target.method_17682();
        double z = target.field_5969 + (target.method_23321() - target.field_5969) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215();
        double nextY = target.field_6036 + (target.method_23318() - target.field_6036) * (double)Render3DEngine.getTickDelta() - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214() + sinAnim * (double)target.method_17682();
        stack.method_22903();
        Render3DEngine.setupRender();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        for (int i = 0; i <= 30; ++i) {
            float cos = (float)(x + Math.cos((double)i * 6.28 / 30.0) * (double)target.method_17681() * 0.8);
            float sin = (float)(z + Math.sin((double)i * 6.28 / 30.0) * (double)target.method_17681() * 0.8);
            bufferBuilder.method_22918(stack.method_23760().method_23761(), cos, (float)nextY, sin).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a(170).getPacked());
            bufferBuilder.method_22918(stack.method_23760().method_23761(), cos, (float)y, sin).method_39415(((SettingColor)((List)Hud.get().textColors.get()).getFirst()).a(0).getPacked());
        }
        Render2DEngine.endBuilding(bufferBuilder);
        RenderSystem.enableCull();
        Render3DEngine.endRender();
        RenderSystem.enableDepthTest();
        stack.method_22909();
    }

    public static void renderGhosts(int espLength, int factor, float shaking, float amplitude, class_1297 target) {
        class_4184 camera = MeteorClient.mc.field_1773.method_19418();
        double tPosX = Render2DEngine.interpolate(target.field_6014, target.method_23317(), Render3DEngine.getTickDelta()) - camera.method_19326().field_1352;
        double tPosY = Render2DEngine.interpolate(target.field_6036, target.method_23318(), Render3DEngine.getTickDelta()) - camera.method_19326().field_1351;
        double tPosZ = Render2DEngine.interpolate(target.field_5969, target.method_23321(), Render3DEngine.getTickDelta()) - camera.method_19326().field_1350;
        float iAge = (float)Render2DEngine.interpolate(target.field_6012 - 1, target.field_6012, Render3DEngine.getTickDelta());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        boolean canSee = MeteorClient.mc.field_1724.method_6057(target);
        if (canSee) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
        } else {
            RenderSystem.disableDepthTest();
        }
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i <= espLength; ++i) {
                double radians = Math.toRadians((((float)i / 1.5f + iAge) * (float)factor + (float)(j * 120)) % (float)(factor * 360));
                double sinQuad = Math.sin(Math.toRadians(iAge * 2.5f + (float)(i * (j + 1))) * (double)amplitude) / (double)shaking;
                float offset = (float)i / (float)espLength;
                class_4587 matrices = new class_4587();
                matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
                matrices.method_22904(tPosX + Math.cos(radians) * (double)target.method_17681(), tPosY + 1.0 + sinQuad, tPosZ + Math.sin(radians) * (double)target.method_17681());
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                Matrix4f matrix = matrices.method_23760().method_23761();
                int color = ((SettingColor)((List)Hud.get().textColors.get()).getFirst()).getPacked();
                float scale = Math.max(0.24f * offset, 0.2f);
                buffer.method_22918(matrix, -scale, scale, 0.0f).method_22913(0.0f, 1.0f).method_39415(color);
                buffer.method_22918(matrix, scale, scale, 0.0f).method_22913(1.0f, 1.0f).method_39415(color);
                buffer.method_22918(matrix, scale, -scale, 0.0f).method_22913(1.0f, 0.0f).method_39415(color);
                buffer.method_22918(matrix, -scale, -scale, 0.0f).method_22913(0.0f, 0.0f).method_39415(color);
            }
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        if (canSee) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableDepthTest();
        } else {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.disableBlend();
    }

    public static void updateTargetESP() {
        prevCircleStep = circleStep;
        circleStep += 0.15f;
    }

    public static double absSinAnimation(double input) {
        return Math.abs(1.0 + Math.sin(input)) / 2.0;
    }

    public static class_243 interpolatePos(float prevposX, float prevposY, float prevposZ, float posX, float posY, float posZ) {
        double x = (double)(prevposX + (posX - prevposX) * Render3DEngine.getTickDelta()) - MeteorClient.mc.method_1561().field_4686.method_19326().method_10216();
        double y = (double)(prevposY + (posY - prevposY) * Render3DEngine.getTickDelta()) - MeteorClient.mc.method_1561().field_4686.method_19326().method_10214();
        double z = (double)(prevposZ + (posZ - prevposZ) * Render3DEngine.getTickDelta()) - MeteorClient.mc.method_1561().field_4686.method_19326().method_10215();
        return new class_243(x, y, z);
    }

    public static void drawLineDebug(class_243 start, class_243 end, Color color) {
        DEBUG_LINE_QUEUE.add(new DebugLineAction(start, end, color));
    }

    public static float getTickDelta() {
        return MeteorClient.mc.method_61966().method_60637(true);
    }

    public record FillAction(class_238 box, Color color) {
    }

    public record FillSideAction(class_238 box, Color color, class_2350 side) {
    }

    public record FadeAction(class_238 box, Color color, Color color2) {
    }

    public record LineAction(class_243 start, class_243 end, Color color) {
    }

    public record OutlineAction(class_238 box, Color color, float lineWidth) {
    }

    public record OutlineSideAction(class_238 box, Color color, float lineWidth, class_2350 side) {
    }

    public record DebugLineAction(class_243 start, class_243 end, Color color) {
    }
}

