/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.enemies;

import com.genyo.GenyoAddon;
import com.genyo.systems.enemies.Enemy;
import com.mojang.util.UndashedUuid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.Settings;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.System;
import meteordevelopment.meteorclient.systems.Systems;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.misc.NbtUtils;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;

public class Enemies
extends System<Enemies>
implements Iterable<Enemy> {
    private final List<Enemy> enemies = new ArrayList<Enemy>();
    public final Settings settings = new Settings();
    private final SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final SettingGroup sgMessage = this.settings.createGroup("Message");
    private final Setting<SettingColor> enemyColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Brasil")).defaultValue(new SettingColor(255, 100, 89, 255)).build());
    private final Setting<Keybind> keybind = this.sgGeneral.add((Setting)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("Keybind")).description("Ecuad\u00f3r")).defaultValue((Object)Keybind.fromKey((int)88))).action(this::genyo).build());
    private final Setting<Boolean> message = this.sgMessage.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("send-message")).description("Meg\u00fczeni a kiv\u00e1lasztott emberpajt\u00e1sunknak, hogy mi a t\u00e9ma.")).defaultValue((Object)false)).build());
    private final Setting<MessageMode> messageMode = this.sgMessage.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("message-mode")).description("Shabala babala /whisper oder /msg")).defaultValue((Object)MessageMode.Whisper)).build());
    private final Setting<String> customMessage = this.sgMessage.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("custom-message")).description("Hajr\u00e1 Mez\u0151k\u00f6vesd! :D :D :D")).defaultValue((Object)"shabala babala niger biger.")).build());

    public Enemies() {
        super("enemies");
    }

    public static Enemies get() {
        return (Enemies)Systems.get(Enemies.class);
    }

    public boolean add(Enemy enemy) {
        if (enemy.name.isEmpty() || enemy.name.contains(" ")) {
            return false;
        }
        if (!this.enemies.contains(enemy)) {
            if (Friends.get().get(enemy.getName()) != null) {
                Friends.get().remove(Friends.get().get(enemy.getName()));
            }
            this.enemies.add(enemy);
            this.save();
            return true;
        }
        return false;
    }

    public boolean remove(Enemy enemy) {
        if (this.enemies.remove(enemy)) {
            this.save();
            return true;
        }
        return false;
    }

    public Enemy get(String name) {
        for (Enemy enemy : this.enemies) {
            if (!enemy.name.equalsIgnoreCase(name)) continue;
            return enemy;
        }
        return null;
    }

    public Enemy get(class_1657 player) {
        return this.get(player.method_5477().getString());
    }

    public Enemy get(class_640 player) {
        return this.get(player.method_2966().getName());
    }

    public boolean isEnemy(class_1657 player) {
        return player != null && this.get(player) != null;
    }

    public boolean isEnemy(class_640 player) {
        return this.get(player) != null;
    }

    public boolean shouldAttack(class_1657 player) {
        return this.isEnemy(player);
    }

    public int count() {
        return this.enemies.size();
    }

    public boolean isEmpty() {
        return this.enemies.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Enemy> iterator() {
        return this.enemies.iterator();
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10566("enemies", (class_2520)NbtUtils.listToTag(this.enemies));
        tag.method_10566("settings", (class_2520)this.settings.toTag());
        return tag;
    }

    public Enemies fromTag(class_2487 tag) {
        this.enemies.clear();
        if (tag.method_10545("settings")) {
            this.settings.fromTag(tag.method_10562("settings"));
        }
        for (class_2520 itemTag : tag.method_10554("enemies", 10)) {
            String name;
            class_2487 enemyTag = (class_2487)itemTag;
            if (!enemyTag.method_10545("name") || this.get(name = enemyTag.method_10558("name")) != null) continue;
            String uuid = enemyTag.method_10558("id");
            Enemy enemy = !uuid.isBlank() ? new Enemy(name, UndashedUuid.fromStringLenient((String)uuid)) : new Enemy(name);
            this.enemies.add(enemy);
        }
        Collections.sort(this.enemies);
        MeteorExecutor.execute(() -> this.enemies.forEach(Enemy::updateInfo));
        return this;
    }

    private void genyo() {
        if (MeteorClient.mc.field_1692 == null) {
            return;
        }
        class_1297 class_12972 = MeteorClient.mc.field_1692;
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        if (!this.isEnemy(player)) {
            this.add(new Enemy(player));
            ChatUtils.info((String)"Added %s to enemies", (Object[])new Object[]{player.method_5477().getString()});
            if (this.getMessageBool()) {
                String message = this.getCustomMessage();
                switch (this.getMessageMode().ordinal()) {
                    case 0: {
                        ChatUtils.sendPlayerMsg((String)("/whisper " + player.method_5477().getString() + " " + message));
                        GenyoAddon.LOG.info("/whisper " + player.method_5477().getString() + " " + message);
                    }
                    case 1: {
                        ChatUtils.sendPlayerMsg((String)("/msg " + player.method_5477().getString() + " " + message));
                    }
                }
            }
        } else {
            this.remove(this.get(player));
            ChatUtils.info((String)"Removed %s from opps.", (Object[])new Object[]{player.method_5477().getString()});
        }
    }

    public Color getEnemyColor() {
        return (Color)this.enemyColor.get();
    }

    public Keybind getKeybind() {
        return (Keybind)this.keybind.get();
    }

    public boolean getMessageBool() {
        return (Boolean)this.message.get();
    }

    public String getCustomMessage() {
        return (String)this.customMessage.get();
    }

    public MessageMode getMessageMode() {
        return (MessageMode)((Object)this.messageMode.get());
    }

    public static enum MessageMode {
        Whisper,
        Msg;

    }
}

