/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.enemies;

import com.genyo.systems.enemies.Enemies;
import com.genyo.systems.enemies.Enemy;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.tabs.Tab;
import meteordevelopment.meteorclient.gui.tabs.TabScreen;
import meteordevelopment.meteorclient.gui.tabs.WindowTabScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.gui.widgets.pressable.WPlus;
import meteordevelopment.meteorclient.renderer.Texture;
import meteordevelopment.meteorclient.settings.Settings;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import meteordevelopment.meteorclient.utils.misc.NbtUtils;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import net.minecraft.class_437;

public class EnemiesTab
extends Tab {
    public EnemiesTab() {
        super("Enemies");
    }

    public TabScreen createScreen(GuiTheme theme) {
        return new EnemiesScreen(theme, this);
    }

    public boolean isScreen(class_437 screen) {
        return screen instanceof EnemiesScreen;
    }

    private static class EnemiesScreen
    extends WindowTabScreen {
        private final Settings settings;

        public EnemiesScreen(GuiTheme theme, Tab tab) {
            super(theme, tab);
            this.settings = Enemies.get().settings;
        }

        public void initWidgets() {
            WTable table = (WTable)this.add((WWidget)this.theme.table()).expandX().minWidth(400.0).widget();
            this.add(this.theme.settings(this.settings)).expandX();
            this.add((WWidget)this.theme.horizontalSeparator()).expandX();
            this.initTable(table);
            WHorizontalList list = (WHorizontalList)this.add((WWidget)this.theme.horizontalList()).expandX().widget();
            WTextBox nameW = (WTextBox)list.add((WWidget)this.theme.textBox("", (text, c) -> c != ' ')).expandX().widget();
            nameW.setFocused(true);
            WPlus add = (WPlus)list.add((WWidget)this.theme.plus()).widget();
            this.enterAction = add.action = () -> {
                String name = nameW.get().trim();
                Enemy enemy = new Enemy(name);
                if (Enemies.get().add(enemy)) {
                    nameW.set("");
                    this.reload();
                    MeteorExecutor.execute(() -> {
                        enemy.updateInfo();
                        this.reload();
                    });
                }
            };
        }

        private void initTable(WTable table) {
            table.clear();
            if (Enemies.get().isEmpty()) {
                return;
            }
            Enemies.get().forEach(enemy -> MeteorExecutor.execute(() -> {
                if (enemy.headTextureNeedsUpdate()) {
                    enemy.updateInfo();
                    this.reload();
                }
            }));
            for (Enemy enemy2 : Enemies.get()) {
                table.add((WWidget)this.theme.texture(32.0, 32.0, enemy2.getHead().needsRotate() ? 90.0 : 0.0, (Texture)enemy2.getHead()));
                table.add((WWidget)this.theme.label(enemy2.getName()));
                WMinus remove = (WMinus)table.add((WWidget)this.theme.minus()).expandCellX().right().widget();
                remove.action = () -> {
                    Enemies.get().remove(enemy2);
                    this.reload();
                };
                table.row();
            }
        }

        public void method_25393() {
            super.method_25393();
            this.settings.tick((WContainer)this.window, this.theme);
        }

        public boolean toClipboard() {
            return NbtUtils.toClipboard((ISerializable)Enemies.get());
        }

        public boolean fromClipboard() {
            return NbtUtils.fromClipboard((ISerializable)Enemies.get());
        }
    }
}

