/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.hud;

import com.genyo.GenyoAddon;
import com.genyo.systems.modules.GenyoModule;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Alignment;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;

public class ActiveGenyoHud
extends HudElement {
    public static final HudElementInfo<ActiveGenyoHud> INFO = new HudElementInfo(GenyoAddon.HUD_GROUP, "active-genyo", "Displays your active GENYO modules.", ActiveGenyoHud::new);
    private static final meteordevelopment.meteorclient.utils.render.color.Color WHITE = new meteordevelopment.meteorclient.utils.render.color.Color();
    private final SettingGroup sgGeneral;
    private final SettingGroup sgColor;
    private final SettingGroup sgScale;
    private final SettingGroup sgBackground;
    private final Setting<Sort> sort;
    private final Setting<Boolean> activeInfo;
    private final Setting<Boolean> showKeybind;
    private final Setting<Boolean> shadow;
    private final Setting<Boolean> outlines;
    private final Setting<Integer> outlineWidth;
    private final Setting<Alignment> alignment;
    private final Setting<ColorMode> colorMode;
    private final Setting<SettingColor> flatColor;
    private final Setting<Double> rainbowSpeed;
    private final Setting<Double> rainbowSpread;
    private final Setting<Double> rainbowSaturation;
    private final Setting<Double> rainbowBrightness;
    private final Setting<SettingColor> moduleInfoColor;
    private final Setting<Boolean> customScale;
    private final Setting<Double> scale;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;
    private final List<Module> modules;
    private final meteordevelopment.meteorclient.utils.render.color.Color rainbow;
    private double rainbowHue1;
    private double rainbowHue2;
    private double lastX;
    private double emptySpace;
    private double prevTextLength;
    private meteordevelopment.meteorclient.utils.render.color.Color prevColor;

    public ActiveGenyoHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgColor = this.settings.createGroup("Color");
        this.sgScale = this.settings.createGroup("Scale");
        this.sgBackground = this.settings.createGroup("Background");
        this.sort = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sort")).description("How to sort active modules.")).defaultValue((Object)Sort.Biggest)).build());
        this.activeInfo = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("module-info")).description("Shows info from the module next to the name in the active modules list.")).defaultValue((Object)true)).build());
        this.showKeybind = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-keybind")).description("Shows the module's keybind next to its name.")).defaultValue((Object)true)).build());
        this.shadow = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shadow")).description("Renders shadow behind text.")).defaultValue((Object)true)).build());
        this.outlines = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("outlines")).description("Whether or not to render outlines")).defaultValue((Object)false)).build());
        this.outlineWidth = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("outline-width")).description("Outline width")).defaultValue((Object)2)).min(1).sliderMin(1).visible(() -> this.outlines.get())).build());
        this.alignment = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("alignment")).description("Horizontal alignment.")).defaultValue((Object)Alignment.Auto)).build());
        this.colorMode = this.sgColor.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("color-mode")).description("What color to use for active modules.")).defaultValue((Object)ColorMode.Rainbow)).build());
        this.flatColor = this.sgColor.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("flat-color")).description("Color for flat color mode.")).defaultValue(new SettingColor(225, 25, 25)).visible(() -> this.colorMode.get() == ColorMode.Flat)).build());
        this.rainbowSpeed = this.sgColor.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rainbow-speed")).description("Rainbow speed of rainbow color mode.")).defaultValue(0.05).sliderMin(0.01).sliderMax(0.2).decimalPlaces(4).visible(() -> this.colorMode.get() == ColorMode.Rainbow)).build());
        this.rainbowSpread = this.sgColor.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rainbow-spread")).description("Rainbow spread of rainbow color mode.")).defaultValue(0.01).sliderMin(0.001).sliderMax(0.05).decimalPlaces(4).visible(() -> this.colorMode.get() == ColorMode.Rainbow)).build());
        this.rainbowSaturation = this.sgColor.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rainbow-saturation")).defaultValue(1.0).sliderRange(0.0, 1.0).visible(() -> this.colorMode.get() == ColorMode.Rainbow)).build());
        this.rainbowBrightness = this.sgColor.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rainbow-brightness")).defaultValue(1.0).sliderRange(0.0, 1.0).visible(() -> this.colorMode.get() == ColorMode.Rainbow)).build());
        this.moduleInfoColor = this.sgColor.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("module-info-color")).description("Color of module info text.")).defaultValue(new SettingColor(175, 175, 175)).visible(() -> this.activeInfo.get())).build());
        this.customScale = this.sgScale.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue((Object)false)).build());
        this.scale = this.sgScale.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(() -> this.customScale.get())).defaultValue(1.0).min(0.5).sliderRange(0.5, 3.0).build());
        this.background = this.sgBackground.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue((Object)false)).build());
        this.backgroundColor = this.sgBackground.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(() -> this.background.get())).defaultValue(new SettingColor(25, 25, 25, 50)).build());
        this.modules = new ArrayList<Module>();
        this.rainbow = new meteordevelopment.meteorclient.utils.render.color.Color(255, 255, 255);
        this.prevColor = new meteordevelopment.meteorclient.utils.render.color.Color();
    }

    public void tick(HudRenderer renderer) {
        this.modules.clear();
        for (Module module : Modules.get().getActive()) {
            if (!(module instanceof GenyoModule)) continue;
            this.modules.add(module);
        }
        if (this.modules.isEmpty()) {
            if (this.isInEditor()) {
                this.setSize(renderer.textWidth("Active Modules", ((Boolean)this.shadow.get()).booleanValue(), this.getScale()), renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale()));
            }
            return;
        }
        this.modules.sort((e1, e2) -> switch (((Sort)((Object)((Object)this.sort.get()))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> e1.title.compareTo(e2.title);
            case 1 -> Double.compare(this.getModuleWidth(renderer, (Module)e2), this.getModuleWidth(renderer, (Module)e1));
            case 2 -> Double.compare(this.getModuleWidth(renderer, (Module)e1), this.getModuleWidth(renderer, (Module)e2));
        });
        double width = 0.0;
        double height = 0.0;
        for (Module module : this.modules) {
            width = Math.max(width, this.getModuleWidth(renderer, module));
            height += renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        }
        this.setSize(width, height);
    }

    public void render(HudRenderer renderer) {
        double x = this.x;
        double y = this.y;
        if (this.modules.isEmpty()) {
            if (this.isInEditor()) {
                renderer.text("Active Modules", x, y, WHITE, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            }
            return;
        }
        this.rainbowHue1 += (Double)this.rainbowSpeed.get() * renderer.delta;
        if (this.rainbowHue1 > 1.0) {
            this.rainbowHue1 -= 1.0;
        } else if (this.rainbowHue1 < -1.0) {
            this.rainbowHue1 += 1.0;
        }
        this.rainbowHue2 = this.rainbowHue1;
        this.lastX = x;
        this.emptySpace = renderer.textWidth(" ", ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        for (int i = 0; i < this.modules.size(); ++i) {
            double offset = this.alignX(this.getModuleWidth(renderer, this.modules.get(i)), (Alignment)this.alignment.get());
            this.renderModule(renderer, i, x + offset, y);
            this.lastX = x + offset;
            y += renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        }
    }

    private void renderModule(HudRenderer renderer, int index, double x, double y) {
        String info;
        Module module = this.modules.get(index);
        meteordevelopment.meteorclient.utils.render.color.Color color = (meteordevelopment.meteorclient.utils.render.color.Color)this.flatColor.get();
        switch (((ColorMode)((Object)this.colorMode.get())).ordinal()) {
            case 1: {
                color = module.color;
                break;
            }
            case 2: {
                this.rainbowHue2 += ((Double)this.rainbowSpread.get()).doubleValue();
                int c = Color.HSBtoRGB((float)this.rainbowHue2, ((Double)this.rainbowSaturation.get()).floatValue(), ((Double)this.rainbowBrightness.get()).floatValue());
                this.rainbow.r = meteordevelopment.meteorclient.utils.render.color.Color.toRGBAR((int)c);
                this.rainbow.g = meteordevelopment.meteorclient.utils.render.color.Color.toRGBAG((int)c);
                this.rainbow.b = meteordevelopment.meteorclient.utils.render.color.Color.toRGBAB((int)c);
                color = this.rainbow;
            }
        }
        renderer.text(module.title, x, y, color, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        double textHeight = renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        double textLength = renderer.textWidth(module.title, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        if (((Boolean)this.showKeybind.get()).booleanValue() && module.keybind.isSet()) {
            String keybindStr = " [" + String.valueOf(module.keybind) + "]";
            renderer.text(keybindStr, x + textLength, y, (meteordevelopment.meteorclient.utils.render.color.Color)this.moduleInfoColor.get(), ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            textLength += renderer.textWidth(keybindStr, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        }
        if (((Boolean)this.activeInfo.get()).booleanValue() && (info = module.getInfoString()) != null) {
            renderer.text(info, x + textLength + this.emptySpace, y, (meteordevelopment.meteorclient.utils.render.color.Color)this.moduleInfoColor.get(), ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            textLength += this.emptySpace + renderer.textWidth(info, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        }
        double lineStartY = y;
        double lineHeight = textHeight;
        if (((Boolean)this.outlines.get()).booleanValue()) {
            if (index == 0) {
                lineHeight += 2.0;
                renderer.quad(x - 2.0 - (double)((Integer)this.outlineWidth.get()).intValue(), (lineStartY -= 2.0) - (double)((Integer)this.outlineWidth.get()).intValue(), textLength + 4.0 + (double)(2 * (Integer)this.outlineWidth.get()), (double)((Integer)this.outlineWidth.get()).intValue(), this.prevColor, this.prevColor, color, color);
            } else {
                renderer.quad(Math.min(this.lastX, x) - 2.0 - (double)((Integer)this.outlineWidth.get()).intValue(), Math.max(this.lastX, x) == x ? y : y - (double)((Integer)this.outlineWidth.get()).intValue(), Math.max(this.lastX, x) - 2.0 - (Math.min(this.lastX, x) - 2.0 - (double)((Integer)this.outlineWidth.get()).intValue()), (double)((Integer)this.outlineWidth.get()).intValue(), this.prevColor, this.prevColor, color, color);
                renderer.quad(Math.min(this.lastX + this.prevTextLength, x + textLength) + 2.0, Math.min(this.lastX + this.prevTextLength, x + textLength) == x + textLength ? y : y - (double)((Integer)this.outlineWidth.get()).intValue(), Math.max(this.lastX + this.prevTextLength, x + textLength) + 2.0 + (double)((Integer)this.outlineWidth.get()).intValue() - (Math.min(this.lastX + this.prevTextLength, x + textLength) + 2.0), (double)((Integer)this.outlineWidth.get()).intValue(), this.prevColor, this.prevColor, color, color);
            }
            if (index == this.modules.size() - 1) {
                renderer.quad(x - 2.0 - (double)((Integer)this.outlineWidth.get()).intValue(), lineStartY + (lineHeight += 2.0), textLength + 4.0 + (double)(2 * (Integer)this.outlineWidth.get()), (double)((Integer)this.outlineWidth.get()).intValue(), this.prevColor, this.prevColor, color, color);
            }
            renderer.quad(x - 2.0 - (double)((Integer)this.outlineWidth.get()).intValue(), lineStartY, (double)((Integer)this.outlineWidth.get()).intValue(), lineHeight, this.prevColor, this.prevColor, color, color);
            renderer.quad(x + textLength + 2.0, lineStartY, (double)((Integer)this.outlineWidth.get()).intValue(), lineHeight, this.prevColor, this.prevColor, color, color);
        }
        if (((Boolean)this.background.get()).booleanValue()) {
            renderer.quad(x - 2.0, lineStartY, textLength + 4.0, lineHeight, (meteordevelopment.meteorclient.utils.render.color.Color)this.backgroundColor.get());
        }
        this.prevTextLength = textLength;
        this.prevColor = color;
    }

    private double getModuleWidth(HudRenderer renderer, Module module) {
        String info;
        double width = renderer.textWidth(module.title, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        if (((Boolean)this.showKeybind.get()).booleanValue() && module.keybind.isSet()) {
            width += renderer.textWidth(" [" + String.valueOf(module.keybind) + "]", ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        }
        if (((Boolean)this.activeInfo.get()).booleanValue() && (info = module.getInfoString()) != null) {
            width += renderer.textWidth(" ", ((Boolean)this.shadow.get()).booleanValue(), this.getScale()) + renderer.textWidth(info, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        }
        return width;
    }

    private double getScale() {
        return (Boolean)this.customScale.get() != false ? ((Double)this.scale.get()).doubleValue() : Hud.get().getTextScale();
    }

    public static enum Sort {
        Alphabetical,
        Biggest,
        Smallest;

    }

    public static enum ColorMode {
        Flat,
        Random,
        Rainbow;

    }

    public static enum Background {
        None,
        Block,
        Text;

    }
}

