/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.hud;

import com.genyo.GenyoAddon;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.hud.Alignment;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.entity.EntityUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_332;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_7532;
import net.minecraft.class_8685;

public class BetterPlayerRadarHud
extends HudElement {
    public static final HudElementInfo<BetterPlayerRadarHud> INFO = new HudElementInfo(GenyoAddon.HUD_GROUP, "better-player-radar", "Displays players in your visual range.", BetterPlayerRadarHud::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgFeatures;
    private final SettingGroup sgScale;
    private final SettingGroup sgBackground;
    private final Setting<Integer> limit;
    private final Setting<Boolean> friends;
    private final Setting<Boolean> shadow;
    private final Setting<SettingColor> primaryColor;
    private final Setting<SettingColor> secondaryColor;
    private final Setting<Alignment> alignment;
    private final Setting<Integer> border;
    private final Setting<Boolean> heads;
    private final Setting<Boolean> distance;
    private final Setting<Boolean> health;
    private final Setting<Boolean> ping;
    private final Setting<Boolean> customScale;
    private final Setting<Double> scale;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;
    private final List<class_742> players;
    private final Color WHITE;
    private final Color RED;
    private final Color AMBER;
    private final Color GREEN;
    private final Color GOLD;

    public BetterPlayerRadarHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgFeatures = this.settings.createGroup("Features");
        this.sgScale = this.settings.createGroup("Scale");
        this.sgBackground = this.settings.createGroup("Background");
        this.limit = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("limit")).description("The max number of players to show.")).defaultValue((Object)10)).min(1).sliderRange(1, 20).build());
        this.friends = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("display-friends")).description("Whether to show friends or not.")).defaultValue((Object)true)).build());
        this.shadow = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shadow")).description("Renders shadow behind text.")).defaultValue((Object)true)).build());
        this.primaryColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("primary-color")).description("Primary color.")).defaultValue(new SettingColor()).build());
        this.secondaryColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("secondary-color")).description("Secondary color.")).defaultValue(new SettingColor(175, 175, 175)).build());
        this.alignment = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("alignment")).description("Horizontal alignment.")).defaultValue((Object)Alignment.Auto)).build());
        this.border = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("border")).description("How much space to add around the element.")).defaultValue((Object)0)).build());
        this.heads = this.sgFeatures.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Heads")).description("Display head icons")).defaultValue((Object)true)).build());
        this.distance = this.sgFeatures.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("distance")).description("Shows the distance to the player next to their name.")).defaultValue((Object)true)).build());
        this.health = this.sgFeatures.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Health")).description("Display health")).defaultValue((Object)true)).build());
        this.ping = this.sgFeatures.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Ping")).description("Display ping")).defaultValue((Object)true)).build());
        this.customScale = this.sgScale.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue((Object)false)).visible(() -> false)).build());
        this.scale = this.sgScale.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(() -> this.customScale.get())).defaultValue(1.0).min(0.5).sliderRange(0.5, 3.0).build());
        this.background = this.sgBackground.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue((Object)false)).build());
        this.backgroundColor = this.sgBackground.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(() -> this.background.get())).defaultValue(new SettingColor(25, 25, 25, 50)).build());
        this.players = new ArrayList<class_742>();
        this.WHITE = new Color(255, 255, 255);
        this.RED = new Color(255, 25, 25);
        this.AMBER = new Color(255, 105, 25);
        this.GREEN = new Color(25, 252, 25);
        this.GOLD = new Color(232, 185, 35);
    }

    public void setSize(double width, double height) {
        super.setSize(width + (double)((Integer)this.border.get() * 2), height + (double)((Integer)this.border.get() * 2));
    }

    protected double alignX(double width, Alignment alignment) {
        return this.box.alignX((double)(this.getWidth() - (Integer)this.border.get() * 2), width, alignment);
    }

    public void tick(HudRenderer renderer) {
        double width = renderer.textWidth("Players:", ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        double height = renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        if (MeteorClient.mc.field_1687 == null) {
            this.setSize(width, height);
            return;
        }
        for (class_1657 class_16572 : this.getPlayers()) {
            if (class_16572.equals((Object)MeteorClient.mc.field_1724) || !((Boolean)this.friends.get()).booleanValue() && Friends.get().isFriend(class_16572)) continue;
            Object text = class_16572.method_5477().getString();
            if (((Boolean)this.heads.get()).booleanValue()) {
                text = (String)text + "as";
            }
            if (((Boolean)this.distance.get()).booleanValue()) {
                text = (String)text + String.format("| %sm", (double)Math.round(PlayerUtils.distanceToCamera((class_1297)class_16572) * 10.0) / 10.0);
            }
            if (((Boolean)this.ping.get()).booleanValue()) {
                text = (String)text + String.format("| %sms", EntityUtils.getPing((class_1657)class_16572));
            }
            float absorption = class_16572.method_6067();
            int healthInt = Math.round(class_16572.method_6032() + absorption);
            String healthText = String.format("| %s", healthInt);
            if (((Boolean)this.health.get()).booleanValue()) {
                text = (String)text + healthText;
            }
            width = Math.max(width, renderer.textWidth((String)text, ((Boolean)this.shadow.get()).booleanValue(), this.getScale()));
            height += renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale()) + 2.0;
        }
        this.setSize(width, height);
    }

    public void render(HudRenderer renderer) {
        double y = this.y + (Integer)this.border.get();
        if (((Boolean)this.background.get()).booleanValue()) {
            renderer.quad((double)this.x, (double)this.y, (double)this.getWidth(), (double)this.getHeight(), (Color)this.backgroundColor.get());
        }
        renderer.text("Players:", (double)(this.x + (Integer)this.border.get()) + this.alignX(renderer.textWidth("Players:", ((Boolean)this.shadow.get()).booleanValue(), this.getScale()), (Alignment)this.alignment.get()), y, (Color)this.secondaryColor.get(), ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        if (MeteorClient.mc.field_1687 == null) {
            return;
        }
        double spaceWidth = renderer.textWidth(" ", ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        for (class_1657 class_16572 : this.getPlayers()) {
            if (class_16572.equals((Object)MeteorClient.mc.field_1724) || !((Boolean)this.friends.get()).booleanValue() && Friends.get().isFriend(class_16572)) continue;
            String text = class_16572.method_5477().getString();
            Color color = PlayerUtils.getPlayerColor((class_1657)class_16572, (Color)((Color)this.primaryColor.get()));
            String distanceText = null;
            String healthText = null;
            String fullHealthText = null;
            String pingText = null;
            Color healthColor = null;
            double width = renderer.textWidth(text, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            if (((Boolean)this.distance.get()).booleanValue()) {
                width += spaceWidth;
                distanceText = String.format("(%.1fm)", Float.valueOf(MeteorClient.mc.method_1560().method_5739((class_1297)class_16572)));
                width += renderer.textWidth(distanceText, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            }
            double x = (double)(this.x + (Integer)this.border.get()) + this.alignX(width, (Alignment)this.alignment.get());
            y += renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale()) + 2.0;
            if (((Boolean)this.heads.get()).booleanValue()) {
                x += 16.0 + spaceWidth;
                class_640 entry = MeteorClient.mc.method_1562().method_2871(class_16572.method_5667());
                if (entry != null) {
                    class_7532.method_52722((class_332)renderer.drawContext, (class_8685)entry.method_52810(), (int)(this.x + (Integer)this.border.get()), (int)((int)y), (int)16);
                }
            }
            if (((Boolean)this.ping.get()).booleanValue()) {
                int ping = EntityUtils.getPing((class_1657)class_16572);
                width += spaceWidth;
                pingText = "| " + ping + "ms";
                width += renderer.textWidth(pingText, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            }
            if (((Boolean)this.health.get()).booleanValue()) {
                float absorption = class_16572.method_6067();
                int healthInt = Math.round(class_16572.method_6032() + absorption);
                double healthPercentage = (float)healthInt / (class_16572.method_6063() + absorption);
                healthColor = healthPercentage <= 0.333 ? this.RED : (healthPercentage <= 0.666 ? this.AMBER : this.GREEN);
                width += spaceWidth;
                healthText = String.format("%s", healthInt);
                fullHealthText = "| " + healthText;
                width += renderer.textWidth(fullHealthText, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            }
            x = renderer.text(text, x, y, color, ((Boolean)this.shadow.get()).booleanValue());
            if (((Boolean)this.distance.get()).booleanValue()) {
                renderer.text(distanceText, x + spaceWidth, y, (Color)this.secondaryColor.get(), ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
                x += spaceWidth + renderer.textWidth(distanceText, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            }
            if (((Boolean)this.ping.get()).booleanValue()) {
                renderer.text(pingText, x + spaceWidth, y, (Color)this.secondaryColor.get(), ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
                x += spaceWidth + renderer.textWidth(pingText, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            }
            if (!((Boolean)this.health.get()).booleanValue()) continue;
            renderer.text("|", x + spaceWidth, y, (Color)this.secondaryColor.get(), ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            renderer.text(healthText, (x += spaceWidth) + spaceWidth + spaceWidth, y, healthColor, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
            x += spaceWidth;
        }
    }

    private List<class_742> getPlayers() {
        this.players.clear();
        this.players.addAll(MeteorClient.mc.field_1687.method_18456());
        if (this.players.size() > (Integer)this.limit.get()) {
            this.players.subList((Integer)this.limit.get() - 1, this.players.size() - 1).clear();
        }
        this.players.sort(Comparator.comparingDouble(e -> e.method_5858(MeteorClient.mc.method_1560())));
        return this.players;
    }

    private double getScale() {
        return (Boolean)this.customScale.get() != false ? ((Double)this.scale.get()).doubleValue() : Hud.get().getTextScale();
    }
}

