/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.hud;

import com.genyo.GenyoAddon;
import com.genyo.systems.incombat.CombatPerson;
import com.genyo.systems.incombat.InCombatSystem;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Alignment;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;

public class InCombatHud
extends HudElement {
    public static final HudElementInfo<InCombatHud> INFO = new HudElementInfo(GenyoAddon.HUD_GROUP, "combat-stats", "Fasz fasz fasz fasz fasz fasz.", InCombatHud::new);
    private static final InCombatSystem inCombatSystem = InCombatSystem.get();
    Color white = new Color(255, 255, 255, 255);
    String outOfCombat = "Out of combat!";
    String combatDisabled = "Combat is disabled";
    private final SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final SettingGroup sgBackground = this.settings.createGroup("Background");
    private final SettingGroup sgScale = this.settings.createGroup("Scale");
    private final Setting<SettingColor> personColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("person-color")).description("jjjjjjjjjjjjjjjjjjjjjjjjjj")).defaultValue(new SettingColor()).build());
    private final Setting<Boolean> textShadow = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("text-shadow")).description("asdasdasdsad fogyat\u00e9k")).defaultValue((Object)true)).build());
    private final Setting<Alignment> alignment = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("alignment")).description("Horizontal alignment.")).defaultValue((Object)Alignment.Auto)).build());
    private final Setting<Integer> border = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("border")).description("How much space to add around the element.")).defaultValue((Object)0)).build());
    private final Setting<Boolean> customScale = this.sgScale.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue((Object)false)).build());
    private final Setting<Double> scale = this.sgScale.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(() -> this.customScale.get())).defaultValue(1.0).min(0.5).sliderRange(0.5, 3.0).build());
    public final Setting<Boolean> background = this.sgBackground.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue((Object)false)).build());
    public final Setting<SettingColor> backgroundColor = this.sgBackground.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(() -> this.background.get())).defaultValue(new SettingColor(25, 25, 25, 50)).build());

    private InCombatHud() {
        super(INFO);
    }

    public void setSize(double width, double height) {
        super.setSize(width + (double)((Integer)this.border.get() * 2), height + (double)((Integer)this.border.get() * 2));
    }

    protected double alignX(double width, Alignment alignment) {
        return this.box.alignX((double)(this.getWidth() - (Integer)this.border.get() * 2), width, alignment);
    }

    public void tick(HudRenderer renderer) {
        if (!inCombatSystem.isEnabled()) {
            this.setSize(renderer.textWidth(this.combatDisabled, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale()), renderer.textHeight(((Boolean)this.textShadow.get()).booleanValue(), this.getScale()));
            return;
        }
        if (inCombatSystem.empty()) {
            this.setSize(renderer.textWidth(this.outOfCombat, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale()), renderer.textHeight(((Boolean)this.textShadow.get()).booleanValue(), this.getScale()));
            return;
        }
        String remaining = String.format("(%ss)", inCombatSystem.getRemainingCooldown());
        double width = renderer.textWidth("In Combat: " + remaining, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
        double height = renderer.textHeight(((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
        if (MeteorClient.mc.field_1687 == null) {
            this.setSize(width, height);
            return;
        }
        for (CombatPerson person : inCombatSystem.getInCombat()) {
            String text = person.getName();
            width = Math.max(width, renderer.textWidth(text, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale()));
            height += renderer.textHeight(((Boolean)this.textShadow.get()).booleanValue(), this.getScale()) + 2.0;
        }
        this.setSize(width, height);
    }

    public void render(HudRenderer renderer) {
        if (MeteorClient.mc.field_1687 == null) {
            return;
        }
        double y = this.y + (Integer)this.border.get();
        if (!inCombatSystem.isEnabled()) {
            renderer.text(this.combatDisabled, (double)this.x, y, this.white, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
            return;
        }
        if (inCombatSystem.empty()) {
            renderer.text(this.outOfCombat, (double)this.x, y, this.white, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
            return;
        }
        String cooldownText = String.format("(%ss)", inCombatSystem.getRemainingCooldown());
        double alap = renderer.textWidth("In Combat: " + cooldownText, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
        double permX = (double)(this.x + (Integer)this.border.get()) + this.alignX(alap, (Alignment)this.alignment.get());
        renderer.text("In Combat: ", permX, y, this.white, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
        renderer.text(cooldownText, permX + renderer.textWidth("In Combat: ", ((Boolean)this.textShadow.get()).booleanValue(), this.getScale()), y, (Color)this.personColor.get(), ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
        for (CombatPerson person : inCombatSystem.getInCombat()) {
            String text = person.getName();
            double width = renderer.textWidth(text, ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
            double x = (double)(this.x + (Integer)this.border.get()) + this.alignX(width, (Alignment)this.alignment.get());
            renderer.text(text, x, y += renderer.textHeight(((Boolean)this.textShadow.get()).booleanValue(), this.getScale()) + 2.0, (Color)this.personColor.get(), ((Boolean)this.textShadow.get()).booleanValue(), this.getScale());
        }
        if (((Boolean)this.background.get()).booleanValue()) {
            renderer.quad((double)this.x, (double)this.y, (double)this.getWidth(), (double)this.getHeight(), (Color)this.backgroundColor.get());
        }
    }

    private double getScale() {
        return (Boolean)this.customScale.get() != false ? ((Double)this.scale.get()).doubleValue() : Hud.get().getTextScale();
    }
}

