/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.hud;

import com.genyo.GenyoAddon;
import com.genyo.managers.Managers;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;

public class PacketsHud
extends HudElement {
    public static final HudElementInfo<PacketsHud> INFO = new HudElementInfo(GenyoAddon.HUD_GROUP, "packets", "Displays the amount of incoming and outgoing packets. (out <- in)", PacketsHud::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgScale;
    private final SettingGroup sgBackground;
    private double originalWidth;
    private double originalHeight;
    public final Setting<Boolean> shadow;
    public final Setting<Integer> border;
    private final Setting<Boolean> invertColors;
    private final Setting<Boolean> customScale;
    private final Setting<Double> scale;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;

    public PacketsHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgScale = this.settings.createGroup("Scale");
        this.sgBackground = this.settings.createGroup("Background");
        this.shadow = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shadow")).description("Renders shadow behind text.")).defaultValue((Object)true)).build());
        this.border = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("border")).description("How much space to add around the text.")).defaultValue((Object)0)).onChanged(integer -> super.setSize(this.originalWidth + (double)(integer * 2), this.originalHeight + (double)(integer * 2)))).build());
        this.invertColors = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Invert Colors")).description("Invert the colors")).defaultValue((Object)true)).build());
        this.customScale = this.sgScale.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue((Object)false)).build());
        this.scale = this.sgScale.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(() -> this.customScale.get())).defaultValue(1.0).min(0.5).sliderRange(0.5, 3.0).build());
        this.background = this.sgBackground.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue((Object)false)).build());
        this.backgroundColor = this.sgBackground.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(() -> this.background.get())).defaultValue(new SettingColor(25, 25, 25, 50)).build());
    }

    private double getScale() {
        return (Boolean)this.customScale.get() != false ? ((Double)this.scale.get()).doubleValue() : Hud.get().getTextScale();
    }

    public void setSize(double width, double height) {
        this.originalWidth = width;
        this.originalHeight = height;
        super.setSize(width + (double)((Integer)this.border.get() * 2), height + (double)((Integer)this.border.get() * 2));
    }

    public void render(HudRenderer renderer) {
        if (this.isInEditor() && !this.isActive()) {
            renderer.line((double)this.x, (double)this.y, (double)(this.x + this.getWidth()), (double)(this.y + this.getHeight()), Color.GRAY);
            renderer.line((double)this.x, (double)(this.y + this.getHeight()), (double)(this.x + this.getWidth()), (double)this.y, Color.GRAY);
        }
        double x = this.x + (Integer)this.border.get();
        double y = this.y + (Integer)this.border.get();
        String packetsString = "Packets: ";
        renderer.text(packetsString, x, y, (Boolean)this.invertColors.get() != false ? Color.GRAY : Color.WHITE, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        String thing = String.format("%s <- %s", Managers.NETWORK.getOutgoingPPS(), Managers.NETWORK.getIncomingPPS());
        renderer.text(thing, x + renderer.textWidth(packetsString, ((Boolean)this.shadow.get()).booleanValue(), this.getScale()) + renderer.textWidth(" ") * this.getScale(), y, (Boolean)this.invertColors.get() != false ? Color.WHITE : Color.GRAY, ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
        this.setSize(renderer.textWidth(packetsString + thing), renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale()));
        if (((Boolean)this.background.get()).booleanValue()) {
            renderer.quad((double)this.x, y, (double)this.getWidth(), (double)this.getHeight(), (Color)this.backgroundColor.get());
        }
    }
}

