/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.hud;

import com.genyo.GenyoAddon;
import com.genyo.utils.HudUtils;
import java.util.List;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public class PvPNeccessaryHud
extends HudElement {
    public static final HudElementInfo<PvPNeccessaryHud> INFO = new HudElementInfo(GenyoAddon.HUD_GROUP, "pvp-neccessary", "Fasz fasz fasz fasz fasz fasz.", PvPNeccessaryHud::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgScale;
    private final SettingGroup sgBackground;
    private final Setting<List<class_1792>> items;
    private final Setting<SettingColor> textColor;
    public final Setting<Integer> margin;
    public final Setting<Boolean> customScale;
    public final Setting<Double> scale;
    public final Setting<Boolean> background;
    public final Setting<SettingColor> backgroundColor;

    private PvPNeccessaryHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgScale = this.settings.createGroup("Scale");
        this.sgBackground = this.settings.createGroup("Background");
        this.items = this.sgGeneral.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("items")).description("Itemek amiket ki\u00edr.")).defaultValue(new class_1792[]{class_1802.field_8288, class_1802.field_8634, class_1802.field_8301, class_1802.field_8281}).build());
        this.textColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("text-color")).description("Brasil")).defaultValue(new SettingColor(255, 255, 255, 255)).build());
        this.margin = this.sgScale.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("margin")).description("K\u00e9t dolog k\u00f6z\u00f6tti hely")).defaultValue((Object)0)).onChanged(aInt -> this.calculateSize())).min(0).sliderRange(0, 10).build());
        this.customScale = this.sgScale.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue((Object)false)).onChanged(aBoolean -> this.calculateSize())).build());
        this.scale = this.sgScale.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(() -> this.customScale.get())).defaultValue(2.0).onChanged(aDouble -> this.calculateSize())).min(0.5).sliderRange(0.5, 3.0).build());
        this.background = this.sgBackground.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue((Object)false)).build());
        this.backgroundColor = this.sgBackground.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(() -> this.background.get())).defaultValue(new SettingColor(25, 25, 25, 50)).build());
        this.calculateSize();
    }

    private void calculateSize() {
        int offset = ((List)this.items.get()).size();
        this.setSize(23.0f * this.getScale() * (float)offset, 17.0f * this.getScale() + 20.0f);
    }

    public void render(HudRenderer renderer) {
        this.calculateSize();
        int itemsLength = ((List)this.items.get()).size();
        for (int i = 0; i < itemsLength; ++i) {
            class_1792 item = (class_1792)((List)this.items.get()).get(i);
            class_1799 itemStack = new class_1799((class_1935)item, InvUtils.find((class_1792[])new class_1792[]{item}).count());
            int scaleOffset = (int)(this.getScale() * 10.0f);
            int intScale = (int)this.getScale();
            int offset = i + 1 != 1 ? i * 50 * scaleOffset / (20 - (Integer)this.margin.get()) : 0;
            int textXOffset = 6 * intScale;
            int textYOffset = 17 * intScale;
            if (itemStack.method_7947() > 100) {
                textXOffset -= 6 * intScale;
            } else if (itemStack.method_7947() > 10) {
                textXOffset -= 2 * intScale;
            }
            int finalTextXOffset = textXOffset;
            renderer.post(() -> {
                this.render(renderer, itemStack, this.x + offset, this.y);
                this.renderText(renderer, itemStack, this.x + offset + finalTextXOffset, this.y + textYOffset);
            });
        }
        if (((Boolean)this.background.get()).booleanValue()) {
            renderer.quad((double)this.x, (double)this.y, (double)this.getWidth(), (double)this.getHeight(), (Color)this.backgroundColor.get());
        }
    }

    private void render(HudRenderer renderer, class_1799 itemStack, int x, int y) {
        boolean resetToZero = false;
        if (itemStack.method_7960()) {
            itemStack.method_7939(1);
            resetToZero = true;
        }
        HudUtils.drawItem(renderer.drawContext, itemStack, x, y, this.getScale());
        if (resetToZero) {
            itemStack.method_7939(0);
        }
    }

    private void renderText(HudRenderer renderer, class_1799 itemStack, int x, int y) {
        String count = String.valueOf(itemStack.method_7947());
        if (itemStack.method_7947() == 1) {
            count = "1";
        }
        boolean resetToZero = false;
        if (itemStack.method_7960()) {
            itemStack.method_7939(1);
            resetToZero = true;
        }
        renderer.text(count, (double)x, (double)y, (Color)this.textColor.get(), true, (double)(this.getScale() / 2.0f));
        if (resetToZero) {
            itemStack.method_7939(0);
        }
    }

    private float getScale() {
        return (Boolean)this.customScale.get() != false ? ((Double)this.scale.get()).floatValue() : ((Double)this.scale.getDefaultValue()).floatValue();
    }
}

