/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.hud;

import com.genyo.GenyoAddon;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;

public class WatermarkHud
extends HudElement {
    public static final HudElementInfo<WatermarkHud> INFO = new HudElementInfo(GenyoAddon.HUD_GROUP, "watermark", "The best thing in the entire addon.", WatermarkHud::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgScale;
    private final Setting<Boolean> version;
    private final Setting<Boolean> shadow;
    private final Setting<SettingColor> color;
    private final Setting<Boolean> customScale;
    private final Setting<Double> scale;
    private String renderText;

    public WatermarkHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgScale = this.settings.createGroup("Scale");
        this.version = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Version")).description("Render the current Genyo version")).defaultValue((Object)false)).onChanged(this::updateRenderText)).build());
        this.shadow = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shadow")).description("Renders shadow behind text.")).defaultValue((Object)true)).build());
        this.color = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Color")).description("The")).defaultValue(Color.WHITE).build());
        this.customScale = this.sgScale.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue((Object)false)).build());
        this.scale = this.sgScale.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(() -> this.customScale.get())).defaultValue(1.0).min(0.5).sliderRange(0.5, 3.0).build());
        this.renderText = "Genyo";
    }

    private void updateRenderText(boolean version) {
        this.renderText = version ? "Genyo " + String.valueOf(GenyoAddon.VERSION) : "Genyo";
    }

    private double getScale() {
        return (Boolean)this.customScale.get() != false ? ((Double)this.scale.get()).doubleValue() : Hud.get().getTextScale();
    }

    public void tick(HudRenderer renderer) {
        this.setSize(renderer.textWidth(this.renderText, ((Boolean)this.shadow.get()).booleanValue(), this.getScale()), renderer.textHeight(((Boolean)this.shadow.get()).booleanValue(), this.getScale()));
    }

    public void render(HudRenderer renderer) {
        renderer.text(this.renderText, (double)this.x, (double)this.y, (Color)this.color.get(), ((Boolean)this.shadow.get()).booleanValue(), this.getScale());
    }
}

