/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.incombat;

import com.genyo.events.UnderCombatEvent;
import com.genyo.systems.incombat.CombatPerson;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.Settings;
import meteordevelopment.meteorclient.systems.System;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;

public class InCombatSystem
extends System<InCombatSystem>
implements Iterable<CombatPerson> {
    private static final InCombatSystem INSTANCE = new InCombatSystem();
    private final List<CombatPerson> inCombat = new ArrayList<CombatPerson>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Object lock = new Object();
    public final Settings settings = new Settings();
    private final SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final Setting<Boolean> enabled = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enabled")).description("tyu")).defaultValue((Object)false)).build());
    private final Setting<Integer> combatCooldown = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Cooldown")).description("mikor resetelje")).defaultValue((Object)30)).sliderRange(15, 60).visible(() -> this.enabled.get())).build());
    private final Setting<Boolean> autoUnfriend = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Auto Unfriend")).description("ut\u00e1na visszaaddolja")).defaultValue((Object)true)).visible(() -> this.enabled.get())).build());
    private int cooldown = 0;

    private void countdown() {
        this.scheduler.scheduleAtFixedRate(() -> {
            Object object = lock;
            synchronized (object) {
                if (this.cooldown > 0) {
                    --this.cooldown;
                } else {
                    this.clear();
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public InCombatSystem() {
        super("incombat");
    }

    public void init() {
        this.clear();
    }

    @Override
    @NotNull
    public Iterator<CombatPerson> iterator() {
        return this.inCombat.iterator();
    }

    public boolean add(CombatPerson person) {
        if (!this.inCombat.contains(person)) {
            this.inCombat.add(person);
            if (((Boolean)this.autoUnfriend.get()).booleanValue()) {
                Friends.get().remove(Friends.get().get(person.getPlayer()));
            }
            this.resetCooldown();
            this.save();
            return true;
        }
        return false;
    }

    public int getRemainingCooldown() {
        return this.cooldown;
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public boolean contains(CombatPerson person) {
        return this.get(person.getName()) != null;
    }

    public boolean contains(class_1657 entity) {
        return this.get(entity.method_5477().getString()) != null;
    }

    public CombatPerson get(String name) {
        for (CombatPerson person : this.inCombat) {
            if (!person.getName().equals(name)) continue;
            return person;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCooldown() {
        Object object = lock;
        synchronized (object) {
            if (this.cooldown == 0) {
                this.cooldown = (Integer)this.combatCooldown.get();
                this.countdown();
            } else {
                this.cooldown = (Integer)this.combatCooldown.get();
            }
        }
    }

    public boolean empty() {
        return this.inCombat.isEmpty();
    }

    public List<CombatPerson> getInCombat() {
        return this.inCombat;
    }

    public int size() {
        return this.inCombat.size();
    }

    public void clear() {
        MeteorExecutor.execute(() -> this.inCombat.forEach(person -> {
            if (((Boolean)this.autoUnfriend.get()).booleanValue() && person.wasFriendB()) {
                Friends.get().add(person.getFriend());
            }
        }));
        InCombatSystem.get().getInCombat().clear();
        this.save();
    }

    public static InCombatSystem get() {
        return INSTANCE;
    }

    @EventHandler
    private void onUnderAttack(UnderCombatEvent event) {
        if (MeteorClient.mc.field_1687 == null) {
            return;
        }
        CombatPerson person = new CombatPerson(event.entity);
        if (!InCombatSystem.get().contains(person)) {
            InCombatSystem.get().add(person);
        }
        if (!this.empty()) {
            this.resetCooldown();
        }
    }
}

