/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.combat;

import com.genyo.GenyoAddon;
import com.genyo.events.network.PlayerTickEvent;
import com.genyo.managers.Managers;
import com.genyo.systems.modules.GenyoModule;
import com.genyo.systems.settings.FloatSetting;
import java.util.PriorityQueue;
import java.util.Queue;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10192;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_490;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class GenyoAutoArmor
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final Setting<Priority> priorityConfig;
    private final Setting<Float> minDurabilityConfig;
    private final Setting<Boolean> elytraPriorityConfig;
    private final Setting<Boolean> blastLeggingsConfig;
    private final Setting<Boolean> noBindingConfig;
    private final Setting<Boolean> inventoryConfig;
    private final Queue<ArmorSlot> helmet;
    private final Queue<ArmorSlot> chestplate;
    private final Queue<ArmorSlot> leggings;
    private final Queue<ArmorSlot> boots;

    public GenyoAutoArmor() {
        super(GenyoAddon.COMBAT, "genyo-auto-armor", "Automatically replaces armor pieces.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.priorityConfig = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Priority")).description("Armor enchantment priority")).defaultValue((Object)Priority.BLAST_PROTECTION)).build());
        this.minDurabilityConfig = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Min Durability"))).description("Durability percent to replace armor"))).min(0.0f).defaultValue(0.0f).max(20.0f).build());
        this.elytraPriorityConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Elytra Priority")).description("Prioritizes existing elytras in the chestplate armor slot")).defaultValue((Object)true)).build());
        this.blastLeggingsConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Leggings - Blast Priority")).description("Prioritizes Blast Protection leggings")).defaultValue((Object)true)).build());
        this.noBindingConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("No Binding")).description("Avoids armor with the Curse of Binding enchantment")).defaultValue((Object)true)).build());
        this.inventoryConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Allow Inventory")).description("Allows armor to be swapped while in the inventory menu")).defaultValue((Object)false)).build());
        this.helmet = new PriorityQueue<ArmorSlot>();
        this.chestplate = new PriorityQueue<ArmorSlot>();
        this.leggings = new PriorityQueue<ArmorSlot>();
        this.boots = new PriorityQueue<ArmorSlot>();
    }

    @EventHandler
    public void onTick(PlayerTickEvent event) {
        if (!(this.mc.field_1755 == null || this.mc.field_1755 instanceof class_490 && ((Boolean)this.inventoryConfig.get()).booleanValue())) {
            return;
        }
        this.helmet.clear();
        this.chestplate.clear();
        this.leggings.clear();
        this.boots.clear();
        block12: for (int j = 0; j < 36; ++j) {
            class_1792 class_17922;
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(j);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1738)) continue;
            class_1738 armor = (class_1738)class_17922;
            if (((Boolean)this.noBindingConfig.get()).booleanValue() && this.hasEnchantment(stack, (class_5321<class_1887>)class_1893.field_9113)) continue;
            int index = ((class_10192)stack.method_57824(class_9334.field_54196)).comp_3174().method_5927();
            float dura = (float)(stack.method_7936() - stack.method_7919()) / (float)stack.method_7936();
            if (dura < ((Float)this.minDurabilityConfig.get()).floatValue()) continue;
            ArmorSlot data = new ArmorSlot(index, j, stack);
            switch (index) {
                case 0: {
                    this.helmet.add(data);
                    continue block12;
                }
                case 1: {
                    this.chestplate.add(data);
                    continue block12;
                }
                case 2: {
                    this.leggings.add(data);
                    continue block12;
                }
                case 3: {
                    this.boots.add(data);
                }
            }
        }
        block13: for (int i = 0; i < 4; ++i) {
            class_1799 armorStack = this.mc.field_1724.method_31548().method_7372(i);
            if (((Boolean)this.elytraPriorityConfig.get()).booleanValue() && armorStack.method_7909() == class_1802.field_8833) continue;
            float armorDura = (float)(armorStack.method_7936() - armorStack.method_7919()) / (float)armorStack.method_7936();
            if (!armorStack.method_7960() || armorDura >= ((Float)this.minDurabilityConfig.get()).floatValue()) continue;
            switch (i) {
                case 0: {
                    if (this.helmet.isEmpty()) continue block13;
                    ArmorSlot helmetSlot = this.helmet.poll();
                    this.swapArmor(helmetSlot.getType(), helmetSlot.getSlot());
                    continue block13;
                }
                case 1: {
                    if (this.chestplate.isEmpty()) continue block13;
                    ArmorSlot chestSlot = this.chestplate.poll();
                    this.swapArmor(chestSlot.getType(), chestSlot.getSlot());
                    continue block13;
                }
                case 2: {
                    if (this.leggings.isEmpty()) continue block13;
                    ArmorSlot leggingsSlot = this.leggings.poll();
                    this.swapArmor(leggingsSlot.getType(), leggingsSlot.getSlot());
                    continue block13;
                }
                case 3: {
                    if (this.boots.isEmpty()) continue block13;
                    ArmorSlot bootsSlot = this.boots.poll();
                    this.swapArmor(bootsSlot.getType(), bootsSlot.getSlot());
                }
            }
        }
    }

    public void swapArmor(int armorSlot, int slot) {
        class_1799 stack = this.mc.field_1724.method_31548().method_7372(armorSlot);
        armorSlot = 8 - armorSlot;
        Managers.INVENTORY.pickupSlot(slot < 9 ? slot + 36 : slot);
        boolean rt = !stack.method_7960();
        Managers.INVENTORY.pickupSlot(armorSlot);
        if (rt) {
            Managers.INVENTORY.pickupSlot(slot < 9 ? slot + 36 : slot);
        }
    }

    public boolean hasEnchantment(class_1799 armorStack, class_5321<class_1887> enchantment) {
        if (armorStack.method_57353().method_57832(class_9334.field_49633)) {
            for (class_6880 entry : ((class_9304)armorStack.method_57353().method_57829(class_9334.field_49633)).method_57534()) {
                if (!entry.method_40230().isPresent() || !((class_5321)entry.method_40230().get()).equals(enchantment)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Priority {
        BLAST_PROTECTION((class_5321<class_1887>)class_1893.field_9107),
        PROTECTION((class_5321<class_1887>)class_1893.field_9111),
        PROJECTILE_PROTECTION((class_5321<class_1887>)class_1893.field_9096);

        private final class_5321<class_1887> enchant;

        private Priority(class_5321<class_1887> enchant) {
            this.enchant = enchant;
        }

        public class_5321<class_1887> getEnchantment() {
            return this.enchant;
        }
    }

    public class ArmorSlot
    implements Comparable<ArmorSlot> {
        private final int armorType;
        private final int slot;
        private final class_1799 armorStack;

        public ArmorSlot(int armorType, int slot, class_1799 armorStack) {
            this.armorType = armorType;
            this.slot = slot;
            this.armorStack = armorStack;
        }

        @Override
        public int compareTo(ArmorSlot other) {
            int otherDura;
            if (this.armorType != other.armorType) {
                return 0;
            }
            class_1799 otherStack = other.getArmorStack();
            int armorDura = this.armorStack.method_7936() - this.armorStack.method_7919();
            int durabilityDiff = armorDura - (otherDura = other.armorStack.method_7936() - other.armorStack.method_7919());
            if (durabilityDiff != 0) {
                return durabilityDiff;
            }
            class_5321<class_1887> enchantment = ((Priority)((Object)GenyoAutoArmor.this.priorityConfig.get())).getEnchantment();
            if (((Boolean)GenyoAutoArmor.this.blastLeggingsConfig.get()).booleanValue() && this.armorType == 2 && GenyoAutoArmor.this.hasEnchantment(this.armorStack, (class_5321<class_1887>)class_1893.field_9107)) {
                return -1;
            }
            if (GenyoAutoArmor.this.hasEnchantment(this.armorStack, enchantment)) {
                return GenyoAutoArmor.this.hasEnchantment(otherStack, enchantment) ? 0 : -1;
            }
            return GenyoAutoArmor.this.hasEnchantment(otherStack, enchantment) ? 1 : 0;
        }

        public class_1799 getArmorStack() {
            return this.armorStack;
        }

        public int getType() {
            return this.armorType;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

