/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.misc;

import com.genyo.GenyoAddon;
import com.genyo.systems.modules.GenyoModule;
import com.genyo.utils.GenyoChatUtils;
import com.genyo.utils.math.timer.CacheTimer;
import com.genyo.utils.math.timer.Timer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class Einstein
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> interval;
    private final Setting<Mode> mode;
    private final Setting<Boolean> goodbye;
    private final class_2960 file;
    private final List<Entry> entries;
    private final Random random;
    private int cooldown;
    private final Timer timer;
    private final Timer answerTimer;
    private Entry currentEntry;
    private boolean inGame;
    private int remainingTime;

    public Einstein() {
        super(GenyoAddon.MISC, "einstein", "natural selection of society");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.interval = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Time Interval")).description("The time between the executions of the Final Solution (in minutes)")).min(1).defaultValue((Object)5)).max(20).sliderRange(1, 20).onChanged(this::changeCooldown)).build());
        this.mode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Difficulty")).description("You can be honest here (beta only includes easy questions)")).defaultValue((Object)Mode.Sigma)).build());
        this.goodbye = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Say goodbye")).description("If you enter an incorrect answer you say something before you can't.")).defaultValue((Object)true)).build());
        this.file = class_2960.method_60655((String)"genyo", (String)"einstein/einstein.yml");
        this.entries = new ArrayList<Entry>();
        this.random = new Random();
        this.cooldown = (Integer)this.interval.get();
        this.timer = new CacheTimer();
        this.answerTimer = new CacheTimer();
        this.inGame = false;
        this.remainingTime = 15;
        this.readEinstein();
    }

    public void onActivate() {
        this.resetDefaults();
    }

    public void onDeactivate() {
        this.resetDefaults();
    }

    @EventHandler
    public void onTick(TickEvent.Pre event) {
        if (this.mc.field_1687 == null && this.mc.field_1724 == null) {
            return;
        }
        if (this.timer.passed(this.cooldown * 60000) && !this.inGame) {
            this.startGame();
            this.resetGame();
        }
        if (this.inGame) {
            if (this.answerTimer.passed(15000)) {
                this.endGame(false);
            } else if (this.answerTimer.getElapsedTime() - (long)(15 - this.remainingTime) * 1000L >= 1000L) {
                --this.remainingTime;
                GenyoChatUtils.sendMessage(String.valueOf(this.remainingTime), "genyo-einstein-remaining");
            }
        }
    }

    private void startGame() {
        this.inGame = true;
        if (this.mode.get() == Mode.Beta) {
            List<Entry> easyEntries = this.entries.stream().filter(e -> e.difficulty.equals((Object)Entry.Difficulty.Easy)).toList();
            GenyoAddon.LOG.info(easyEntries.toString());
            this.currentEntry = easyEntries.get(this.random.nextInt(easyEntries.size()));
        } else {
            this.currentEntry = this.entries.get(this.random.nextInt(this.entries.size()));
        }
        if (this.currentEntry == null) {
            return;
        }
        String question = this.currentEntry.question;
        ArrayList<String> answers = this.currentEntry.answers;
        String output = Einstein.getOutput(question, answers);
        GenyoChatUtils.sendMessage(output);
        this.answerTimer.reset();
    }

    @NotNull
    private static String getOutput(String question, List<String> answers) {
        Object output = "";
        output = (String)output + String.valueOf(class_124.field_1080) + "Answer or crash :D" + String.valueOf(class_124.field_1070) + "\n\n";
        output = (String)output + String.valueOf(class_124.field_1060) + String.valueOf(class_124.field_1067) + question + "\n";
        output = (String)output + String.valueOf(class_124.field_1063) + "(A) " + String.valueOf(class_124.field_1080) + answers.get(0) + " ";
        output = (String)output + String.valueOf(class_124.field_1063) + "(B) " + String.valueOf(class_124.field_1080) + answers.get(1) + " ";
        output = (String)output + String.valueOf(class_124.field_1063) + "(C) " + String.valueOf(class_124.field_1080) + answers.get(2) + " ";
        output = (String)output + String.valueOf(class_124.field_1063) + "(D) " + String.valueOf(class_124.field_1080) + answers.get(3) + "\n\n";
        output = (String)output + String.valueOf(class_124.field_1070) + String.valueOf(class_124.field_1080) + "Answer with the correct letter in chat!\nYou have 15 seconds.";
        return output;
    }

    public void endGame(boolean correct) {
        if (correct) {
            this.inGame = false;
            Object output = "";
            output = (String)output + String.valueOf(class_124.field_1060) + "Correct :D";
            GenyoChatUtils.sendMessage((String)output);
        } else {
            this.inGame = false;
            this.resetDefaults();
            if (((Boolean)this.goodbye.get()).booleanValue()) {
                ChatUtils.sendPlayerMsg((String)"I feel like leaving.");
            }
            this.mc.close();
        }
    }

    public String getCorrectChoice() {
        return this.currentEntry.correctChoice.toString();
    }

    private void readEinstein() {
        Yaml yaml = new Yaml();
        try {
            class_3298 resource = (class_3298)this.mc.method_1478().method_14486(this.file).orElseThrow();
            InputStream inputStream = resource.method_14482();
            HashMap yamlMap = (HashMap)yaml.load(inputStream);
            List keys = yamlMap.keySet().stream().toList();
            for (Object o : keys) {
                HashMap value = (HashMap)yamlMap.get(o);
                String question = value.get("question").toString();
                HashMap entryAnswers = (HashMap)value.get("answers");
                String answerA = entryAnswers.get("A").toString();
                String answerB = entryAnswers.get("B").toString();
                String answerC = entryAnswers.get("C").toString();
                String answerD = entryAnswers.get("D").toString();
                List<String> answers = List.of(answerA, answerB, answerC, answerD);
                String correctAnswer = value.get("correct").toString();
                Entry.Difficulty difficulty = Entry.Difficulty.valueOf(value.get("difficulty").toString());
                Entry entry = new Entry(question, answers, correctAnswer, difficulty);
                this.entries.add(entry);
            }
        }
        catch (Exception exception) {
            GenyoAddon.LOG.error(exception.getMessage());
            this.sendError("Couldn't read file. Send logs to wuritz pls.");
        }
    }

    public boolean isInGame() {
        return this.inGame;
    }

    private void resetGame() {
        this.timer.reset();
    }

    private void resetDefaults() {
        this.timer.reset();
        this.answerTimer.reset();
        this.currentEntry = null;
        this.inGame = false;
        this.remainingTime = 15;
    }

    private void changeCooldown(int newValue) {
        this.cooldown = newValue;
    }

    private static enum Mode {
        Beta,
        Sigma;

    }

    private static class Entry {
        private final String question;
        private final ArrayList<String> answers;
        private final Choices correctChoice;
        private final String correctAnswer;
        private final Difficulty difficulty;

        public Entry(String question, List<String> answers, String correctAnswer, Difficulty difficulty) {
            this.question = question;
            this.answers = new ArrayList<String>(answers);
            this.correctAnswer = correctAnswer;
            this.correctChoice = switch (answers.indexOf(correctAnswer)) {
                case 0 -> Choices.A;
                case 1 -> Choices.B;
                case 2 -> Choices.C;
                case 3 -> Choices.D;
                default -> null;
            };
            this.difficulty = difficulty;
        }

        private static enum Choices {
            A,
            B,
            C,
            D;

        }

        private static enum Difficulty {
            Easy,
            Hard;

        }
    }
}

