/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.misc;

import com.genyo.GenyoAddon;
import com.genyo.events.render.TickCounterEvent;
import com.genyo.managers.Managers;
import com.genyo.systems.modules.GenyoModule;
import com.genyo.systems.settings.FloatSetting;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.orbit.EventHandler;

public class GenyoTimer
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final Setting<Float> ticksConfig;
    private final Setting<Boolean> tpsSyncConfig;
    private float prevTimer;
    private float timer;

    public GenyoTimer() {
        super(GenyoAddon.MISC, "genyo-timer", "Changes the change to the change and change.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.ticksConfig = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Ticks"))).description("The of the if the of if the."))).min(0.1f).defaultValue(4.4f).max(50.0f).sliderRange(0.1f, 50.0f).build());
        this.tpsSyncConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("TPS Sync")).description("Syncs game tick speed to server tick speed")).defaultValue((Object)false)).build());
        this.prevTimer = -1.0f;
        this.timer = 1.0f;
    }

    public String getInfoString() {
        return String.format("%s", Float.valueOf(this.timer));
    }

    public void onDeactivate() {
        Managers.TICK.setClientTick(1.0f);
    }

    @EventHandler
    public void onTick(TickEvent.Pre event) {
        if (((Boolean)this.tpsSyncConfig.get()).booleanValue()) {
            this.timer = Math.max(Managers.TICK.getTpsCurrent() / 20.0f, 0.1f);
            return;
        }
        this.timer = ((Float)this.ticksConfig.get()).floatValue();
    }

    @EventHandler
    public void onTickCounter(TickCounterEvent event) {
        if (this.timer != 1.0f) {
            event.cancel();
            event.ticks = this.timer;
        }
    }

    public float getTimer() {
        return this.timer;
    }

    public void setTimer(float timer) {
        this.prevTimer = this.timer;
        this.timer = timer;
    }

    public void resetTimer() {
        if (this.prevTimer > 0.0f) {
            this.timer = this.prevTimer;
            this.prevTimer = -1.0f;
        }
    }
}

