/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.misc;

import com.genyo.GenyoAddon;
import com.genyo.systems.modules.GenyoModule;
import java.util.HashSet;
import java.util.Set;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.PacketListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.utils.network.PacketUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2596;

public class PacketDebug
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final Setting<Set<Class<? extends class_2596<?>>>> blacklist;
    private final Setting<Boolean> toChat;
    private final Setting<Integer> threshold;
    private final Setting<Integer> logTicks;
    private int currentAmount;
    private int tickTimer;
    private Set<String> queue;

    public PacketDebug() {
        super(GenyoAddon.MISC, "packet-debug", "yweoikfjwekfjhewkfjwehfkjefhwehjkfhwehfkew.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.blacklist = this.sgGeneral.add((Setting)((PacketListSetting.Builder)((PacketListSetting.Builder)new PacketListSetting.Builder().name("Blacklisted Packets")).description("black >:(")).filter(aClass -> PacketUtils.getC2SPackets().contains(aClass)).build());
        this.toChat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Send in Chat")).description("sends the logs to chat (only client side)")).defaultValue((Object)true)).build());
        this.threshold = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Threshold")).description("Minimum amount to reach for packets to be logged in a single tick")).min(0).defaultValue((Object)10)).max(30).build());
        this.logTicks = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Tick Amount")).description("how many ticks to wait to log all the packets")).min(1).defaultValue((Object)10)).max(20).visible(() -> (Integer)this.threshold.get() > 0)).build());
        this.queue = new HashSet<String>();
    }

    public void onActivate() {
        this.currentAmount = 0;
        this.tickTimer = 0;
        this.queue.clear();
    }

    public void onDeactivate() {
        this.currentAmount = 0;
        this.tickTimer = 0;
        this.queue.clear();
    }

    @EventHandler
    public void onTick(TickEvent.Post event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        if ((Integer)this.threshold.get() == 0) {
            return;
        }
        if ((Integer)this.logTicks.get() != 0) {
            ++this.tickTimer;
        }
        if (this.currentAmount >= (Integer)this.threshold.get()) {
            if ((Integer)this.logTicks.get() != 0) {
                if (this.tickTimer <= (Integer)this.logTicks.get()) {
                    return;
                }
                if (((Boolean)this.toChat.get()).booleanValue()) {
                    this.sendInfo("Sent packets (" + this.currentAmount + ") in the last " + ((Integer)this.logTicks.get()).toString() + " ticks: " + this.queue.toString());
                } else {
                    GenyoAddon.LOG.info("Sent packets (" + this.currentAmount + ") in the last " + ((Integer)this.logTicks.get()).toString() + " ticks: " + this.queue.toString());
                }
                this.tickTimer = 0;
            } else if (((Boolean)this.toChat.get()).booleanValue()) {
                this.sendInfo("Sent packets (" + this.currentAmount + ") in the last tick: " + this.queue.toString());
            } else {
                GenyoAddon.LOG.info("Sent packets (" + this.currentAmount + ") in the last tick: " + this.queue.toString());
            }
            this.currentAmount = 0;
            this.queue.clear();
        }
    }

    @EventHandler
    public void onPacketSent(PacketEvent.Sent event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        if (!((Set)this.blacklist.get()).contains(event.packet.getClass()) && PacketUtils.getC2SPackets().contains(event.packet.getClass())) {
            if ((Integer)this.threshold.get() > 0) {
                ++this.currentAmount;
                this.queue.add(event.packet.getClass().getSimpleName());
            } else if (((Boolean)this.toChat.get()).booleanValue()) {
                this.sendInfo("Sent packet: " + event.packet.getClass().getSimpleName());
            } else {
                GenyoAddon.LOG.info("Sent packet: " + event.packet.getClass().getSimpleName());
            }
        }
    }
}

