/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.movement;

import com.genyo.GenyoAddon;
import com.genyo.events.network.PlayerUpdateEvent;
import com.genyo.events.network.PushOutOfBlocksEvent;
import com.genyo.events.world.BlockCollisionEvent;
import com.genyo.managers.Managers;
import com.genyo.systems.modules.PlacerModule;
import com.genyo.utils.player.RaycastUtil;
import com.genyo.utils.player.RotationUtil;
import com.genyo.utils.string.EnumFormatter;
import java.util.LinkedList;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1776;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2824;
import net.minecraft.class_2846;
import net.minecraft.class_2879;
import net.minecraft.class_2886;
import net.minecraft.class_3532;
import net.minecraft.class_3736;
import net.minecraft.class_3965;

public class GenyoPhase
extends PlacerModule {
    private static final List<class_2248> RESISTANT_BLOCKS = new LinkedList<class_2248>(){
        {
            this.add(class_2246.field_10540);
            this.add(class_2246.field_22423);
            this.add(class_2246.field_10443);
        }
    };
    private final SettingGroup sgGeneral;
    private final SettingGroup sgBlocks;
    private final Setting<PhaseMode> modeConfig;
    private final Setting<Integer> pitchConfig;
    private final Setting<Boolean> swapAltConfig;
    private final Setting<Boolean> attackConfig;
    private final Setting<Boolean> raytraceConfig;
    private final Setting<Boolean> swingConfig;
    private final Setting<Boolean> selfFillConfig;
    private final Setting<Double> blocksConfig;
    private final Setting<Double> distanceConfig;
    private final Setting<Boolean> autoClipConfig;

    public GenyoPhase() {
        super(GenyoAddon.MOVEMENT, "genyo-phase", "asd");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgBlocks = this.settings.createGroup("Blocks");
        this.modeConfig = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Mode")).description("The phase mode for clipping into blocks")).defaultValue((Object)PhaseMode.NORMAL)).build());
        this.pitchConfig = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Pitch")).description("The pitch to throw pearls")).min(70).defaultValue((Object)85)).max(90).sliderMin(70).sliderMax(90).sliderRange(70, 90).visible(() -> this.modeConfig.get() == PhaseMode.PEARL)).build());
        this.swapAltConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Swap Alternative")).description("Uses inventory swap for swapping to pearls")).defaultValue((Object)true)).visible(() -> this.modeConfig.get() == PhaseMode.PEARL)).build());
        this.attackConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Attack")).description("Attacks entities in the way of the pearl phase")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == PhaseMode.PEARL)).build());
        this.raytraceConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Raytrace")).description("Checks the landing position of the pearl")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == PhaseMode.PEARL)).build());
        this.swingConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Swing")).description("Swings the hand when throwing pearls")).defaultValue((Object)true)).visible(() -> this.modeConfig.get() == PhaseMode.PEARL)).build());
        this.selfFillConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Self Fill")).description("Automatically fills blocks you are phasing on")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == PhaseMode.PEARL)).build());
        this.blocksConfig = this.sgBlocks.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("Blocks")).description("The blocks distance to phase clip")).min(0.001).defaultValue(0.003).max(10.0).visible(() -> this.modeConfig.get() != PhaseMode.PEARL && this.modeConfig.get() != PhaseMode.CLIP)).build());
        this.distanceConfig = this.sgBlocks.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("Distance")).description("The distance to phase")).min(0.0).defaultValue((double)0.2f).max(10.0).visible(() -> this.modeConfig.get() != PhaseMode.PEARL && this.modeConfig.get() != PhaseMode.CLIP)).build());
        this.autoClipConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Auto Clip")).description("Automatically clips into the block")).defaultValue((Object)true)).visible(() -> this.modeConfig.get() != PhaseMode.PEARL && this.modeConfig.get() != PhaseMode.CLIP)).build());
    }

    public String getInfoString() {
        return EnumFormatter.formatEnum((Enum)this.modeConfig.get());
    }

    public void onActivate() {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.modeConfig.get() == PhaseMode.PEARL) {
            int pearlSlot = -1;
            for (int i = 0; i < 45; ++i) {
                class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
                if (!(stack.method_7909() instanceof class_1776)) continue;
                pearlSlot = i;
                break;
            }
            if (pearlSlot == -1 || this.mc.field_1724.method_7357().method_7904(class_1802.field_8634.method_7854())) {
                this.toggle();
                return;
            }
            float prevYaw = this.mc.field_1724.method_36454();
            float prevPitch = this.mc.field_1724.method_36455();
            class_243 pearlTargetVec = new class_243(Math.floor(this.mc.field_1724.method_23317()) + 0.5, 0.0, Math.floor(this.mc.field_1724.method_23321()) + 0.5);
            float[] rotations = RotationUtil.getRotationsTo(this.mc.field_1724.method_33571(), pearlTargetVec);
            float yaw = rotations[0] + 180.0f;
            if (((Boolean)this.attackConfig.get()).booleanValue()) {
                class_3965 hitResult = (class_3965)RaycastUtil.rayCast(3.0, new float[]{yaw, 60.0f});
                for (class_1297 entity : this.mc.field_1687.method_8335(null, new class_238(hitResult.method_17777()).method_1014(0.2))) {
                    if (!(entity instanceof class_1533)) continue;
                    class_1533 itemFrameEntity = (class_1533)entity;
                    if (!itemFrameEntity.method_6940().method_7960()) {
                        Managers.NETWORK.sendPacket((class_2596<?>)class_2824.method_34206((class_1297)entity, (boolean)this.mc.field_1724.method_5715()));
                    }
                    Managers.NETWORK.sendPacket((class_2596<?>)class_2824.method_34206((class_1297)entity, (boolean)this.mc.field_1724.method_5715()));
                    Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
                }
                class_2680 state2 = this.mc.field_1687.method_8320(this.mc.field_1724.method_24515());
                if (state2.method_26204() instanceof class_3736) {
                    Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, this.mc.field_1724.method_24515(), class_2350.field_11036));
                    Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, this.mc.field_1724.method_24515(), class_2350.field_11036));
                }
            }
            if (((Boolean)this.selfFillConfig.get()).booleanValue()) {
                float yaw1 = yaw % 360.0f;
                if (yaw1 < 0.0f) {
                    yaw1 += 360.0f;
                }
                class_2338 blockPos = this.mc.field_1724.method_24515();
                blockPos = (double)yaw1 >= 22.5 && (double)yaw1 < 67.5 ? blockPos.method_10072().method_10067() : ((double)yaw1 >= 67.5 && (double)yaw1 < 112.5 ? blockPos.method_10067() : ((double)yaw1 >= 112.5 && (double)yaw1 < 157.5 ? blockPos.method_10095().method_10067() : ((double)yaw1 >= 157.5 && (double)yaw1 < 202.5 ? blockPos.method_10095() : ((double)yaw1 >= 202.5 && (double)yaw1 < 247.5 ? blockPos.method_10095().method_10078() : ((double)yaw1 >= 247.5 && (double)yaw1 < 292.5 ? blockPos.method_10078() : ((double)yaw1 >= 292.5 && (double)yaw1 < 337.5 ? blockPos.method_10072().method_10078() : blockPos.method_10072()))))));
                int slot = this.getResistantBlockItem();
                if (slot != -1 && blockPos != null && !this.mc.field_1687.method_8320(blockPos.method_10074()).method_45474()) {
                    Managers.INTERACT.placeBlock(blockPos, slot, (boolean)((Boolean)this.strictDirectionConfig.get()), false, true, (state, angles) -> {
                        if (state) {
                            Managers.ROTATION.setRotationSilent(angles[0], angles[1]);
                        } else {
                            Managers.ROTATION.setRotationSilentSync();
                        }
                    });
                }
            }
            this.setRotationClient(yaw, ((Integer)this.pitchConfig.get()).intValue());
            if (((Boolean)this.swapAltConfig.get()).booleanValue()) {
                this.mc.field_1761.method_2906(0, pearlSlot < 9 ? pearlSlot + 36 : pearlSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                this.mc.field_1761.method_2906(0, this.mc.field_1724.method_31548().field_7545 + 36, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                this.mc.field_1761.method_2906(0, pearlSlot < 9 ? pearlSlot + 36 : pearlSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            } else if (pearlSlot < 9) {
                Managers.INVENTORY.setSlot(pearlSlot);
            }
            this.setRotationSilent(yaw, ((Integer)this.pitchConfig.get()).intValue());
            Managers.NETWORK.sendSequencedPacket(id -> new class_2886(class_1268.field_5808, id, yaw, (float)((Integer)this.pitchConfig.get()).intValue()));
            Managers.PEARL.setLastThrownAngles(new float[]{yaw, ((Integer)this.pitchConfig.get()).intValue()});
            if (((Boolean)this.swingConfig.get()).booleanValue()) {
                this.mc.field_1724.method_6104(class_1268.field_5808);
            } else {
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
            }
            if (((Boolean)this.swapAltConfig.get()).booleanValue()) {
                this.mc.field_1761.method_2906(0, pearlSlot < 9 ? pearlSlot + 36 : pearlSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                this.mc.field_1761.method_2906(0, this.mc.field_1724.method_31548().field_7545 + 36, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                this.mc.field_1761.method_2906(0, pearlSlot < 9 ? pearlSlot + 36 : pearlSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            } else if (pearlSlot < 9) {
                Managers.INVENTORY.syncToClient();
            }
            Managers.ROTATION.setRotationSilentSync();
            this.setRotationClient(prevYaw, prevPitch);
            this.toggle();
        } else if (((Boolean)this.autoClipConfig.get()).booleanValue()) {
            double cos = Math.cos(Math.toRadians(this.mc.field_1724.method_36454() + 90.0f));
            double sin = Math.sin(Math.toRadians(this.mc.field_1724.method_36454() + 90.0f));
            this.mc.field_1724.method_5814(this.mc.field_1724.method_23317() + (1.0 * (Double)this.blocksConfig.get() * cos + 0.0 * (Double)this.blocksConfig.get() * sin), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321() + (1.0 * (Double)this.blocksConfig.get() * sin - 0.0 * (Double)this.blocksConfig.get() * cos));
        }
    }

    @EventHandler
    public void onTick(TickEvent.Pre event) {
        if (this.modeConfig.get() != PhaseMode.CLIP || !this.mc.field_1724.method_24828() || this.mc.field_1724.method_3144()) {
            return;
        }
        class_243 vec3d = this.mc.field_1724.method_24515().method_46558();
        boolean flagX = vec3d.field_1352 - this.mc.field_1724.method_23317() > 0.0;
        boolean flagZ = vec3d.field_1350 - this.mc.field_1724.method_23321() > 0.0;
        double x = vec3d.field_1352 + 0.20000000009497754 * (double)(flagX ? -1 : 1);
        double z = vec3d.field_1350 + 0.2000000000949811 * (double)(flagZ ? -1 : 1);
        this.mc.field_1724.method_5814(x, this.mc.field_1724.method_23318(), z);
        this.toggle();
    }

    @EventHandler
    public void onBlockCollision(BlockCollisionEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        switch (((PhaseMode)((Object)this.modeConfig.get())).ordinal()) {
            case 0: {
                if (event.shape == class_259.method_1073() || !(event.shape.method_1107().field_1325 > this.mc.field_1724.method_5829().field_1322) || !this.mc.field_1724.method_5715()) break;
                event.cancel();
                event.setVoxelShape(class_259.method_1073());
                break;
            }
            case 1: {
                event.cancel();
                event.setVoxelShape(class_259.method_1073());
                this.mc.field_1724.field_5960 = true;
                break;
            }
            case 2: {
                if (this.mc.field_1724.field_5976) {
                    event.cancel();
                    event.setVoxelShape(class_259.method_1073());
                }
                if (!this.mc.field_1724.field_3913.field_54155.comp_3164() && (!this.mc.field_1724.field_3913.field_54155.comp_3163() || !((double)event.pos.method_10264() > this.mc.field_1724.method_23318()))) break;
                event.cancel();
            }
        }
    }

    @EventHandler
    public void onPlayerUpdate(PlayerUpdateEvent event) {
        switch (((PhaseMode)((Object)this.modeConfig.get())).ordinal()) {
            case 0: {
                if (!this.mc.field_1724.method_5715() || !this.isPhasing()) break;
                float yaw = this.mc.field_1724.method_36454();
                this.mc.field_1724.method_5857(this.mc.field_1724.method_5829().method_989((Double)this.distanceConfig.get() * Math.cos(Math.toRadians(yaw + 90.0f)), 0.0, (Double)this.distanceConfig.get() * Math.sin(Math.toRadians(yaw + 90.0f))));
                break;
            }
            case 1: {
                Managers.MOVEMENT.setMotionY(0.0);
                if (this.mc.method_1569()) {
                    if (this.mc.field_1724.field_3913.field_54155.comp_3163()) {
                        Managers.MOVEMENT.setMotionY(this.mc.field_1724.method_18798().field_1351 + 0.3);
                    }
                    if (this.mc.field_1724.field_3913.field_54155.comp_3164()) {
                        Managers.MOVEMENT.setMotionY(this.mc.field_1724.method_18798().field_1351 - 0.3);
                    }
                }
                this.mc.field_1724.field_5960 = true;
            }
        }
    }

    @EventHandler
    public void onPushOutOfBlocks(PushOutOfBlocksEvent event) {
        event.cancel();
    }

    public boolean isPhasing() {
        class_238 bb = this.mc.field_1724.method_5829();
        for (int x = class_3532.method_15357((double)bb.field_1323); x < class_3532.method_15357((double)bb.field_1320) + 1; ++x) {
            for (int y = class_3532.method_15357((double)bb.field_1322); y < class_3532.method_15357((double)bb.field_1325) + 1; ++y) {
                for (int z = class_3532.method_15357((double)bb.field_1321); z < class_3532.method_15357((double)bb.field_1324) + 1; ++z) {
                    if (!this.mc.field_1687.method_8320(new class_2338(x, y, z)).method_51366() || !bb.method_994(new class_238((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean shouldRaytrace() {
        return (Boolean)this.raytraceConfig.get();
    }

    public static enum PhaseMode {
        NORMAL,
        SAND,
        CLIMB,
        PEARL,
        CLIP;

    }
}

