/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.movement;

import com.genyo.GenyoAddon;
import com.genyo.events.entity.player.PushEntityEvent;
import com.genyo.events.entity.player.PushFluidsEvent;
import com.genyo.events.network.PlayerTickEvent;
import com.genyo.events.network.PushOutOfBlocksEvent;
import com.genyo.managers.Managers;
import com.genyo.mixin.accessor.AccessorBundlePacket;
import com.genyo.mixin.accessor.AccessorClientWorld;
import com.genyo.mixin.accessor.AccessorEntityVelocityUpdateS2CPacket;
import com.genyo.systems.modules.GenyoModule;
import com.genyo.systems.modules.world.GenyoSurroundV2;
import com.genyo.systems.settings.FloatSetting;
import com.genyo.utils.math.GPositionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2663;
import net.minecraft.class_2664;
import net.minecraft.class_2708;
import net.minecraft.class_2743;
import net.minecraft.class_2828;
import net.minecraft.class_2846;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8042;
import net.minecraft.class_8143;

public class GenyoVelocity
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> knockbackConfig;
    public final Setting<Boolean> explosionConfig;
    public final Setting<Double> explosionsHorizontal;
    public final Setting<Double> explosionsVertical;
    private final Setting<VelocityMode> modeConfig;
    private final Setting<Float> horizontalConfig;
    private final Setting<Float> verticalConfig;
    private final Setting<Boolean> concealConfig;
    private final Setting<Boolean> wallsAirConfig;
    private final Setting<Boolean> wallsTrappedConfig;
    private final Setting<Boolean> pushEntitiesConfig;
    private final Setting<Boolean> pushBlocksConfig;
    private final Setting<Boolean> pushLiquidsConfig;
    private final Setting<Boolean> pushFishhookConfig;
    private boolean cancelVelocity;
    private boolean concealVelocity;

    public GenyoVelocity() {
        super(GenyoAddon.MOVEMENT, "genyo-velocity", "efhewhfjkhewfjhkewfh jekw");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.knockbackConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Knockback")).description("Removes player knockback velocity")).defaultValue((Object)true)).build());
        this.explosionConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Explosion")).description("Removes player explosion velocity")).defaultValue((Object)true)).build());
        this.explosionsHorizontal = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("explosions-horizontal")).description("How much velocity you will take from explosions horizontally.")).defaultValue(0.0).sliderMax(1.0).visible(() -> this.explosionConfig.get())).build());
        this.explosionsVertical = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("explosions-vertical")).description("How much velocity you will take from explosions vertically.")).defaultValue(0.0).sliderMax(1.0).visible(() -> this.explosionConfig.get())).build());
        this.modeConfig = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Mode")).description("The mode for velocity")).defaultValue((Object)VelocityMode.NORMAL)).build());
        this.horizontalConfig = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Horizontal"))).description("How much horizontal knock-back to take"))).min(0.0f).defaultValue(0.0f).max(100.0f).visible(() -> this.modeConfig.get() == VelocityMode.NORMAL || this.modeConfig.get() == VelocityMode.WALLS))).build());
        this.verticalConfig = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Vertical"))).description("How much vertical knock-back to take"))).min(0.0f).defaultValue(0.0f).max(100.0f).visible(() -> this.modeConfig.get() == VelocityMode.NORMAL || this.modeConfig.get() == VelocityMode.WALLS))).build());
        this.concealConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Conceal")).description("Fixes velocity on servers with excessive setbacks")).defaultValue((Object)false)).build());
        this.wallsAirConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Ground Only")).description("Only applies velocity in walls while on ground")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == VelocityMode.WALLS)).build());
        this.wallsTrappedConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Trapped")).description("Applies velocity while player head is trapped")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == VelocityMode.WALLS)).build());
        this.pushEntitiesConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("NoPush-Entities")).description("Prevents being pushed away from entities")).defaultValue((Object)true)).build());
        this.pushBlocksConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("NoPush-Blocks")).description("Prevents being pushed out of blocks")).defaultValue((Object)true)).build());
        this.pushLiquidsConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("NoPush-Liquids")).description("Prevents being pushed by flowing liquids")).defaultValue((Object)true)).build());
        this.pushFishhookConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("NoPush-Fishhook")).description("Prevents being pulled by fishing rod hooks")).defaultValue((Object)true)).build());
    }

    public void onActivate() {
        this.cancelVelocity = false;
    }

    public void onDeactivate() {
        if (this.cancelVelocity) {
            if (this.modeConfig.get() == VelocityMode.GRIM) {
                float yaw = this.mc.field_1724.method_36454();
                float pitch = this.mc.field_1724.method_36455();
                if (Managers.ROTATION.isRotating()) {
                    yaw = Managers.ROTATION.getRotationYaw();
                    pitch = Managers.ROTATION.getRotationPitch();
                }
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2828.class_2830(this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321(), yaw, pitch, this.mc.field_1724.method_24828(), this.mc.field_1724.field_5976));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, this.mc.field_1724.method_20448() ? this.mc.field_1724.method_24515() : this.mc.field_1724.method_24515().method_10084(), class_2350.field_11033));
            }
            this.cancelVelocity = false;
        }
        this.concealVelocity = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public void onPacketReceive(PacketEvent.Receive event) {
        Object allowedBundle;
        class_2596 class_25962;
        if (this.mc.field_1724 == null) return;
        if (this.mc.field_1687 == null) {
            return;
        }
        if (event.packet instanceof class_2708 && ((Boolean)this.concealConfig.get()).booleanValue()) {
            this.concealVelocity = true;
        }
        if ((class_25962 = event.packet) instanceof class_2743) {
            class_2743 packet = (class_2743)class_25962;
            if (((Boolean)this.knockbackConfig.get()).booleanValue()) {
                if (packet.method_11818() != this.mc.field_1724.method_5628()) {
                    return;
                }
                if (this.concealVelocity && packet.method_11815() == 0.0 && packet.method_11819() == 0.0 && packet.method_11819() == 0.0) {
                    this.concealVelocity = false;
                    return;
                }
                if (this.modeConfig.get() == VelocityMode.WALLS) {
                    if (!this.isPhased()) {
                        if ((Boolean)this.wallsTrappedConfig.get() == false) return;
                        if (!this.isWallsTrapped()) {
                            return;
                        }
                    }
                    if (((Boolean)this.wallsAirConfig.get()).booleanValue() && !Managers.POSITION.isOnGround()) {
                        return;
                    }
                }
                switch (((VelocityMode)((Object)this.modeConfig.get())).ordinal()) {
                    case 0: 
                    case 1: {
                        if (((Float)this.horizontalConfig.get()).floatValue() == 0.0f && ((Float)this.verticalConfig.get()).floatValue() == 0.0f) {
                            event.cancel();
                            return;
                        }
                        ((AccessorEntityVelocityUpdateS2CPacket)packet).setVelocityX((int)(packet.method_11815() * (double)(((Float)this.horizontalConfig.get()).floatValue() / 100.0f)));
                        ((AccessorEntityVelocityUpdateS2CPacket)packet).setVelocityY((int)(packet.method_11816() * (double)(((Float)this.verticalConfig.get()).floatValue() / 100.0f)));
                        ((AccessorEntityVelocityUpdateS2CPacket)packet).setVelocityZ((int)(packet.method_11819() * (double)(((Float)this.horizontalConfig.get()).floatValue() / 100.0f)));
                        return;
                    }
                    case 2: {
                        if (!Managers.ANTICHEAT.hasPassed(100L)) {
                            return;
                        }
                        event.cancel();
                        this.cancelVelocity = true;
                        return;
                    }
                    case 3: {
                        event.setCancelled(this.isPhased());
                        return;
                    }
                }
                return;
            }
        }
        if ((class_25962 = event.packet) instanceof class_2664) {
            class_2664 packet = (class_2664)class_25962;
            if (((Boolean)this.explosionConfig.get()).booleanValue()) {
                if (this.modeConfig.get() == VelocityMode.WALLS && !this.isPhased()) {
                    return;
                }
                switch (((VelocityMode)((Object)this.modeConfig.get())).ordinal()) {
                    case 0: 
                    case 1: {
                        if (((Float)this.horizontalConfig.get()).floatValue() != 0.0f || ((Float)this.verticalConfig.get()).floatValue() != 0.0f) break;
                        event.cancel();
                        break;
                    }
                    case 2: {
                        if (!Managers.ANTICHEAT.hasPassed(100L)) {
                            return;
                        }
                        event.cancel();
                        this.cancelVelocity = true;
                        break;
                    }
                    case 3: {
                        event.setCancelled(this.isPhased());
                        break;
                    }
                }
                if (!event.isCancelled()) return;
                this.mc.method_40000(() -> ((AccessorClientWorld)this.mc.field_1687).hookPlaySound(packet.comp_2883().method_10216(), packet.comp_2883().method_10214(), packet.comp_2883().method_10215(), (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.2f) * 0.7f, false, this.RANDOM.nextLong()));
                return;
            }
        }
        if (!((class_25962 = event.packet) instanceof class_8042)) {
            class_8143 packet;
            allowedBundle = event.packet;
            if (allowedBundle instanceof class_8143 && (packet = (class_8143)allowedBundle).comp_1267() == this.mc.field_1724.method_5628() && this.modeConfig.get() == VelocityMode.GRIM_V3 && this.isPhased()) {
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2828.class_5911(false, this.mc.field_1724.field_5976));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2828.class_5911(true, this.mc.field_1724.field_5976));
                return;
            }
            allowedBundle = event.packet;
            if (!(allowedBundle instanceof class_2663)) return;
            class_2663 packet2 = (class_2663)allowedBundle;
            if (packet2.method_11470() != 31) return;
            if ((Boolean)this.pushFishhookConfig.get() == false) return;
            class_1297 entity = packet2.method_11469((class_1937)this.mc.field_1687);
            if (!(entity instanceof class_1536)) return;
            class_1536 hook = (class_1536)entity;
            if (hook.method_26957() != this.mc.field_1724) return;
            event.cancel();
            return;
        }
        class_8042 packet = (class_8042)class_25962;
        allowedBundle = new ArrayList();
        Iterator iterator = packet.method_48324().iterator();
        block20: while (true) {
            class_2596 packet1;
            block52: {
                block51: {
                    if (!iterator.hasNext()) {
                        ((AccessorBundlePacket)packet).setIterable((Iterable<class_2596<?>>)allowedBundle);
                        return;
                    }
                    packet1 = (class_2596)iterator.next();
                    if (!(packet1 instanceof class_2664)) break block51;
                    class_2664 packet2 = (class_2664)packet1;
                    if (!((Boolean)this.explosionConfig.get()).booleanValue()) break block51;
                    this.mc.method_40000(() -> ((AccessorClientWorld)this.mc.field_1687).hookPlaySound(packet2.comp_2883().method_10216(), packet2.comp_2883().method_10214(), packet2.comp_2883().method_10215(), (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.2f) * 0.7f, false, this.RANDOM.nextLong()));
                    if (this.modeConfig.get() == VelocityMode.WALLS && !this.isPhased()) {
                        allowedBundle.add(packet1);
                        continue;
                    }
                    switch (((VelocityMode)((Object)this.modeConfig.get())).ordinal()) {
                        case 0: 
                        case 1: {
                            if (((Float)this.horizontalConfig.get()).floatValue() == 0.0f && ((Float)this.verticalConfig.get()).floatValue() == 0.0f) {
                                continue block20;
                            }
                            break block52;
                        }
                        case 2: {
                            if (Managers.ANTICHEAT.hasPassed(100L)) {
                                allowedBundle.add(packet1);
                                continue block20;
                            }
                            this.cancelVelocity = true;
                            continue block20;
                        }
                        case 3: {
                            if (this.isPhased()) {
                                continue block20;
                            }
                            break block52;
                        }
                    }
                    break block52;
                }
                if (packet1 instanceof class_2743) {
                    class_2743 packet2 = (class_2743)packet1;
                    if (((Boolean)this.knockbackConfig.get()).booleanValue()) {
                        if (packet2.method_11818() != this.mc.field_1724.method_5628()) {
                            allowedBundle.add(packet1);
                            continue;
                        }
                        if (this.modeConfig.get() == VelocityMode.WALLS) {
                            if (!(this.isPhased() || ((Boolean)this.wallsTrappedConfig.get()).booleanValue() && this.isWallsTrapped())) {
                                allowedBundle.add(packet1);
                                return;
                            }
                            if (((Boolean)this.wallsAirConfig.get()).booleanValue() && !Managers.POSITION.isOnGround()) {
                                allowedBundle.add(packet1);
                                continue;
                            }
                        }
                        switch (((VelocityMode)((Object)this.modeConfig.get())).ordinal()) {
                            case 0: 
                            case 1: {
                                if (((Float)this.horizontalConfig.get()).floatValue() == 0.0f && ((Float)this.verticalConfig.get()).floatValue() == 0.0f) continue block20;
                                ((AccessorEntityVelocityUpdateS2CPacket)packet2).setVelocityX((int)(packet2.method_11815() * (double)(((Float)this.horizontalConfig.get()).floatValue() / 100.0f)));
                                ((AccessorEntityVelocityUpdateS2CPacket)packet2).setVelocityY((int)(packet2.method_11816() * (double)(((Float)this.verticalConfig.get()).floatValue() / 100.0f)));
                                ((AccessorEntityVelocityUpdateS2CPacket)packet2).setVelocityZ((int)(packet2.method_11819() * (double)(((Float)this.horizontalConfig.get()).floatValue() / 100.0f)));
                                break;
                            }
                            case 2: {
                                if (!Managers.ANTICHEAT.hasPassed(100L)) {
                                    allowedBundle.add(packet1);
                                    continue block20;
                                }
                                this.cancelVelocity = true;
                                continue block20;
                            }
                            case 3: {
                                if (!this.isPhased()) break;
                                continue block20;
                            }
                        }
                    }
                }
            }
            allowedBundle.add(packet1);
        }
    }

    @EventHandler
    public void onPlayerTick(PlayerTickEvent event) {
        this.concealVelocity = false;
        if (this.cancelVelocity) {
            if (this.modeConfig.get() == VelocityMode.GRIM) {
                float yaw = Managers.ROTATION.getServerYaw();
                float pitch = Managers.ROTATION.getServerPitch();
                if (Managers.ROTATION.isRotating()) {
                    yaw = Managers.ROTATION.getRotationYaw();
                    pitch = Managers.ROTATION.getRotationPitch();
                }
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2828.class_2830(this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321(), yaw, pitch, this.mc.field_1724.method_24828(), this.mc.field_1724.field_5976));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, this.mc.field_1724.method_20448() ? this.mc.field_1724.method_24515() : this.mc.field_1724.method_24515().method_10084(), class_2350.field_11033));
            }
            this.cancelVelocity = false;
        }
    }

    @EventHandler
    public void onPushEntity(PushEntityEvent event) {
        if (((Boolean)this.pushEntitiesConfig.get()).booleanValue() && event.pushed.equals((Object)this.mc.field_1724)) {
            event.cancel();
        }
    }

    @EventHandler
    public void onPushOutOfBlocks(PushOutOfBlocksEvent event) {
        if (((Boolean)this.pushBlocksConfig.get()).booleanValue()) {
            event.cancel();
        }
    }

    @EventHandler
    public void onPushFluid(PushFluidsEvent event) {
        if (((Boolean)this.pushLiquidsConfig.get()).booleanValue()) {
            event.cancel();
        }
    }

    private boolean isWallsTrapped() {
        class_2338 headPos = this.mc.field_1724.method_24515().method_10086(this.mc.field_1724.method_20448() ? 1 : 2);
        if (this.mc.field_1687.method_8320(headPos).method_45474()) {
            return false;
        }
        return ((GenyoSurroundV2)Modules.get().get(GenyoSurroundV2.class)).getSurroundNoDown((class_1657)this.mc.field_1724).stream().noneMatch(blockPos -> this.mc.field_1687.method_8320(this.mc.field_1724.method_20448() ? blockPos : blockPos.method_10084()).method_45474());
    }

    private boolean isPhased() {
        return GPositionUtils.getAllInBox(this.mc.field_1724.method_5829()).stream().anyMatch(blockPos -> !this.mc.field_1687.method_8320(blockPos).method_45474());
    }

    public double getHorizontal(Setting<Double> setting) {
        return this.isActive() ? (Double)setting.get() : 1.0;
    }

    public double getVertical(Setting<Double> setting) {
        return this.isActive() ? (Double)setting.get() : 1.0;
    }

    private static enum VelocityMode {
        NORMAL,
        WALLS,
        GRIM,
        GRIM_V3;

    }
}

