/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.world;

import com.genyo.GenyoAddon;
import com.genyo.events.AttackBlockEvent;
import com.genyo.managers.Managers;
import com.genyo.render.animation.Animation;
import com.genyo.systems.modules.GenyoModule;
import com.genyo.systems.modules.combat.GenyoAutoCrystal;
import com.genyo.systems.modules.world.GenyoAutoTool;
import com.genyo.systems.modules.world.GenyoSpeedmine;
import com.genyo.systems.modules.world.GenyoSurroundV2;
import com.genyo.systems.settings.FloatSetting;
import com.genyo.utils.GEntityUtils;
import com.genyo.utils.math.GPositionUtils;
import com.genyo.utils.math.MathUtil;
import com.genyo.utils.math.timer.CacheTimer;
import com.genyo.utils.math.timer.Timer;
import com.genyo.utils.player.RotationUtil;
import com.genyo.utils.render.ColorUtil;
import com.genyo.utils.world.BlastResistantBlocks;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.Renderer3D;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_2868;
import net.minecraft.class_2879;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;

public class GenyoAutoMine
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgSelection;
    private final SettingGroup sgRender;
    private final Setting<Boolean> multitask;
    private final Setting<Boolean> auto;
    private final Setting<Selection> selection;
    private final Setting<Boolean> avoidSelf;
    private final Setting<List<class_2248>> whitelist;
    private final Setting<List<class_2248>> blacklist;
    private final Setting<Float> enemyRange;
    private final Setting<Boolean> strictDirection;
    private final Setting<Boolean> antiCrawl;
    private final Setting<Boolean> head;
    private final Setting<Boolean> aboveHead;
    private final Setting<Boolean> doubleBreak;
    private final Setting<Integer> mineTicks;
    private final Setting<RemineMode> remine;
    private final Setting<Boolean> packetInstant;
    private final Setting<Float> range;
    private final Setting<Float> speed;
    private final Setting<Swap> swap;
    private final Setting<Boolean> swapBefore;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> switchReset;
    private final Setting<Boolean> grim;
    private final Setting<Boolean> grimNew;
    private final Setting<Boolean> anticheat;
    private final Setting<Boolean> render;
    private final Setting<SettingColor> mineColor;
    private final Setting<SettingColor> colorDone;
    private final Setting<Integer> fadeTime;
    private final Setting<Boolean> smoothColor;
    private class_1657 playerTarget;
    private MineData packetMine;
    private MineData instantMine;
    private boolean packetSwapBack;
    private boolean manualOverride;
    private final Timer remineTimer;
    private boolean changedInstantMine;
    private boolean waitForPacketMine;
    private boolean packetMineStuck;
    private boolean antiCrawlOverride;
    private int antiCrawlTicks;
    private final Queue<MineData> autoMineQueue;
    private int autoMineTickDelay;
    private MineAnimation packetMineAnim;
    private MineAnimation instantMineAnim;

    public GenyoAutoMine() {
        super(GenyoAddon.WORLD, "Genyo AutoMine", "fasz");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgSelection = this.settings.createGroup("Selection");
        this.sgRender = this.settings.createGroup("Render");
        this.multitask = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Allow Multitask")).description("Allows actions while using items")).defaultValue((Object)true)).build());
        this.auto = this.sgSelection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Auto")).description("Automatically mines nearby players feet")).defaultValue((Object)false)).build());
        this.selection = this.sgSelection.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Selection")).description("The selection of blocks mine")).visible(() -> this.auto.get())).defaultValue((Object)Selection.ALL)).build());
        this.avoidSelf = this.sgSelection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Avoid Self")).description("Avoids mining blocks in your surround")).defaultValue((Object)false)).visible(() -> this.auto.get())).build());
        this.whitelist = this.sgSelection.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("Block Whitelist")).description("Valid block whitelist")).defaultValue(new class_2248[]{class_2246.field_10540, class_2246.field_10443}).build());
        this.blacklist = this.sgSelection.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("Block Blacklist")).description("Valid block blacklist")).defaultValue(new class_2248[]{class_2246.field_10603}).build());
        this.enemyRange = this.sgSelection.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Enemy Range"))).description("Only mines on visible faces"))).defaultValue(5.0f).min(1.0f).max(10.0f).visible(() -> this.auto.get()))).build());
        this.strictDirection = this.sgSelection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Strict Direction")).description("Only mines on visible faces")).visible(() -> this.auto.get())).defaultValue((Object)false)).build());
        this.antiCrawl = this.sgSelection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Anti Crawl")).description("Attempts to stop player from crawling")).defaultValue((Object)false)).build());
        this.head = this.sgSelection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Target Body")).description("Attempts to mine players face blocks")).defaultValue((Object)false)).visible(() -> this.auto.get())).build());
        this.aboveHead = this.sgSelection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Target Head")).description("Attempts to mine above players head")).defaultValue((Object)false)).visible(() -> this.auto.get())).build());
        this.doubleBreak = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Double Break")).description("Allows you to mine two blocks at once")).defaultValue((Object)true)).build());
        this.mineTicks = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Mining Ticks")).description("The max number of ticks to hold a pickaxe for the packet mine")).min(5).max(60).defaultValue((Object)20)).visible(() -> this.doubleBreak.get())).build());
        this.remine = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Remine")).description("Remines already mined blocks")).defaultValue((Object)RemineMode.INSTANT)).build());
        this.packetInstant = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Fast")).description("Instant mines on packet")).defaultValue((Object)true)).visible(() -> this.remine.get() == RemineMode.INSTANT)).build());
        this.range = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Range"))).description("The range to mine blocks"))).min(0.1f).defaultValue(6.0f).max(6.0f).build());
        this.speed = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Speed"))).description("The speed to mine blocks (idk what the fuck this is)"))).min(0.1f).defaultValue(1.0f).max(1.0f).build());
        this.swap = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Auto Swap")).description("Swaps to the best tool once the mining is complete")).defaultValue((Object)Swap.SILENT)).build());
        this.swapBefore = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Swap Before")).description("Swaps before fully done mining")).defaultValue((Object)false)).visible(() -> this.swap.get() != Swap.OFF)).build());
        this.rotate = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Rotate")).description("yes")).defaultValue((Object)true)).build());
        this.switchReset = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Switch Reset")).description("Resets mining after switching items")).defaultValue((Object)false)).build());
        this.grim = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Grim")).description("Uses grim block breaking speeds")).defaultValue((Object)false)).build());
        this.grimNew = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Grim V3")).description("Allows mining on new grim servers")).defaultValue((Object)false)).visible(() -> this.grim.get())).build());
        this.anticheat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Anti Cheat")).description("grim anti cheat genyo fasz")).defaultValue((Object)false)).build());
        this.render = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Render")).description("wa")).defaultValue((Object)true)).build());
        this.mineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Mine Color")).description("The mine render color")).defaultValue(new SettingColor(255, 0, 0, 255)).build());
        this.colorDone = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Done Color")).description("The done render color")).defaultValue(new SettingColor(0, 255, 0, 255)).build());
        this.fadeTime = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Fade Time")).description("Time to fade")).min(0).defaultValue((Object)250)).max(1000).visible(() -> false)).build());
        this.smoothColor = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Smooth Color")).description("Interpolates from start to done color")).defaultValue((Object)false)).build());
        this.remineTimer = new CacheTimer();
        this.autoMineQueue = new ArrayDeque<MineData>();
        this.packetMineAnim = new MineAnimation(MineData.empty(), new Animation(true, 200.0f));
        this.instantMineAnim = new MineAnimation(MineData.empty(), new Animation(true, 200.0f));
    }

    public void onDeactivate() {
        this.autoMineQueue.clear();
        this.playerTarget = null;
        this.packetMine = null;
        if (this.instantMine != null) {
            this.abortMining(this.instantMine);
            this.instantMine = null;
        }
        this.packetMineAnim = new MineAnimation(MineData.empty(), new Animation(true, 200.0f));
        this.instantMineAnim = new MineAnimation(MineData.empty(), new Animation(true, 200.0f));
        this.autoMineTickDelay = 0;
        this.antiCrawlTicks = 0;
        this.manualOverride = false;
        this.antiCrawlOverride = false;
        this.waitForPacketMine = false;
        this.packetMineStuck = false;
        if (this.packetSwapBack) {
            Managers.INVENTORY.syncToClient();
            this.packetSwapBack = false;
        }
    }

    @EventHandler
    public void onTick(TickEvent.Pre event) {
        double distance;
        float damageDelta;
        if (this.mc.field_1724.method_7337() || this.mc.field_1724.method_7325()) {
            return;
        }
        class_1657 currentTarget = this.getClosestPlayer(((Float)this.enemyRange.get()).floatValue());
        boolean targetChanged = this.playerTarget != null && this.playerTarget != currentTarget;
        this.playerTarget = currentTarget;
        if (this.isInstantMineComplete()) {
            if (this.changedInstantMine) {
                this.changedInstantMine = false;
            }
            if (this.waitForPacketMine) {
                this.waitForPacketMine = false;
            }
        }
        --this.autoMineTickDelay;
        --this.antiCrawlTicks;
        if (this.packetMine != null && this.packetMine.getTicksMining() > (Integer)this.mineTicks.get()) {
            this.packetMineStuck = true;
            this.packetMineAnim.animation.setState(false);
            if (this.packetSwapBack) {
                Managers.INVENTORY.syncToClient();
                this.packetSwapBack = false;
            }
            this.packetMine = null;
            if (!this.isInstantMineComplete()) {
                this.waitForPacketMine = true;
            }
        }
        if (this.packetMine != null) {
            damageDelta = ((GenyoSpeedmine)Modules.get().get(GenyoSpeedmine.class)).calcBlockBreakingDelta(this.packetMine.getState(), (class_1922)this.mc.field_1687, this.packetMine.getPos());
            this.packetMine.addBlockDamage(damageDelta);
            int slot = this.packetMine.getBestSlot();
            float damageDone = this.packetMine.getBlockDamage() + ((Boolean)this.swapBefore.get() != false || this.packetMineStuck ? damageDelta : 0.0f);
            if (damageDone >= 1.0f && slot != -1 && !this.checkMultitask()) {
                Managers.INVENTORY.setSlot(slot);
                this.packetSwapBack = true;
                if (this.packetMineStuck) {
                    this.packetMineStuck = false;
                }
            }
        }
        if (this.packetSwapBack) {
            if (this.packetMine != null && this.canMine(this.packetMine.getState())) {
                this.packetMine.markAttemptedMine();
            } else {
                Managers.INVENTORY.syncToClient();
                this.packetSwapBack = false;
                this.packetMineAnim.animation.setState(false);
                this.packetMine = null;
                if (!this.isInstantMineComplete()) {
                    this.waitForPacketMine = true;
                }
            }
        }
        if (this.instantMine != null && ((distance = this.mc.field_1724.method_33571().method_1025(this.instantMine.getPos().method_46558())) > (double)MathUtil.squared(((Float)this.range.get()).floatValue()) || this.instantMine.getTicksMining() > (Integer)this.mineTicks.get())) {
            this.abortMining(this.instantMine);
            this.instantMineAnim.animation.setState(false);
            this.instantMine = null;
        }
        if (this.instantMine != null) {
            damageDelta = ((GenyoSpeedmine)Modules.get().get(GenyoSpeedmine.class)).calcBlockBreakingDelta(this.instantMine.getState(), (class_1922)this.mc.field_1687, this.instantMine.getPos());
            this.instantMine.addBlockDamage(damageDelta);
            if (this.instantMine.getBlockDamage() >= ((Float)this.speed.get()).floatValue()) {
                boolean passedRemine;
                boolean canMine = this.canMine(this.instantMine.getState());
                boolean canPlace = this.mc.field_1687.method_8628(this.instantMine.getState(), this.instantMine.getPos(), class_3726.method_16194());
                if (canMine) {
                    this.instantMine.markAttemptedMine();
                } else {
                    this.instantMine.resetMiningTicks();
                    if (this.remine.get() == RemineMode.NORMAL || this.remine.get() == RemineMode.FAST) {
                        this.instantMine.setTotalBlockDamage(0.0f, 0.0f);
                    }
                    if (this.manualOverride) {
                        this.manualOverride = false;
                        this.abortMining(this.instantMine);
                        this.instantMineAnim.animation.setState(false);
                        this.instantMine = null;
                    }
                }
                boolean bl = passedRemine = this.remine.get() == RemineMode.INSTANT || this.remineTimer.passed(500);
                if (this.instantMine != null && (this.remine.get() == RemineMode.INSTANT && ((Boolean)this.packetInstant.get()).booleanValue() && this.packetMine == null && canPlace || canMine && passedRemine) && (!this.checkMultitask() || ((Boolean)this.multitask.get()).booleanValue() || this.swap.get() == Swap.OFF)) {
                    this.stopMining(this.instantMine);
                    this.remineTimer.reset();
                    if (Modules.get().isActive(GenyoAutoCrystal.class) && ((GenyoAutoCrystal)Modules.get().get(GenyoAutoCrystal.class)).shouldPreForcePlace()) {
                        ((GenyoAutoCrystal)Modules.get().get(GenyoAutoCrystal.class)).placeCrystalForTarget(this.playerTarget, this.instantMine.getPos().method_10074());
                    }
                    if (this.remine.get() == RemineMode.FAST) {
                        this.startMining(this.instantMine);
                    }
                }
            }
        }
        if (this.manualOverride && (this.instantMine == null || this.instantMine.getGoal() != MiningGoal.MANUAL)) {
            this.manualOverride = false;
        }
        if (this.antiCrawlOverride && (this.instantMine == null || this.instantMine.getGoal() != MiningGoal.PREVENT_CRAWL)) {
            this.antiCrawlOverride = false;
        }
        if (((Boolean)this.auto.get()).booleanValue()) {
            MineData nextMine;
            if (!this.autoMineQueue.isEmpty() && this.autoMineTickDelay <= 0 && (nextMine = this.autoMineQueue.poll()) != null) {
                this.startMining(nextMine);
                this.autoMineTickDelay = 5;
            }
            class_2338 antiCrawlPos = this.getAntiCrawlPos(this.playerTarget);
            if (this.antiCrawlOverride) {
                if (this.mc.field_1724.method_18376().equals((Object)class_4050.field_18079)) {
                    this.antiCrawlTicks = 10;
                }
                if (this.antiCrawlTicks <= 0 || !this.isInstantMineComplete() && antiCrawlPos != null && !this.instantMine.getPos().equals((Object)antiCrawlPos)) {
                    this.antiCrawlOverride = false;
                }
            }
            if (this.autoMineQueue.isEmpty() && !this.manualOverride && !this.antiCrawlOverride) {
                if (((Boolean)this.antiCrawl.get()).booleanValue() && this.mc.field_1724.method_18376().equals((Object)class_4050.field_18079) && antiCrawlPos != null) {
                    MineData data = new MineData(antiCrawlPos, (Boolean)this.strictDirection.get() != false ? Managers.INTERACT.getInteractDirection(antiCrawlPos, false) : class_2350.field_11036, MiningGoal.PREVENT_CRAWL);
                    if (this.isInstantMineComplete() || !this.instantMine.equals(data)) {
                        this.startAutoMine(data);
                        this.antiCrawlOverride = true;
                    }
                } else if (this.playerTarget != null && !targetChanged) {
                    boolean bedrockPhased;
                    class_2338 targetPos = GEntityUtils.getRoundedBlockPos((class_1297)this.playerTarget);
                    boolean bl = bedrockPhased = GPositionUtils.isBedrock(this.playerTarget.method_5829(), targetPos) && !this.playerTarget.method_20448();
                    if (!this.isInstantMineComplete() && this.checkDataY(this.instantMine, targetPos, bedrockPhased)) {
                        this.abortMining(this.instantMine);
                        this.instantMineAnim.animation.setState(false);
                        this.instantMine = null;
                    } else if (this.packetMine != null && this.checkDataY(this.packetMine, targetPos, bedrockPhased)) {
                        this.packetMineAnim.animation.setState(false);
                        if (this.packetSwapBack) {
                            Managers.INVENTORY.syncToClient();
                            this.packetSwapBack = false;
                        }
                        this.packetMine = null;
                        this.waitForPacketMine = false;
                    } else {
                        List<class_2338> phasedBlocks = this.getPhaseBlocks(this.playerTarget, targetPos, bedrockPhased);
                        if (!phasedBlocks.isEmpty()) {
                            class_2338 pos1 = phasedBlocks.removeFirst();
                            MineData bestMine = new MineData(pos1, (Boolean)this.strictDirection.get() != false ? Managers.INTERACT.getInteractDirection(pos1, false) : class_2350.field_11036);
                            if (this.packetMine == null && ((Boolean)this.doubleBreak.get()).booleanValue() || this.isInstantMineComplete()) {
                                this.startAutoMine(bestMine);
                            }
                        } else {
                            List<class_2338> miningBlocks = this.getMiningBlocks(this.playerTarget, targetPos, bedrockPhased);
                            MineData bestMine = this.getInstantMine(miningBlocks, bedrockPhased);
                            if (bestMine != null && (this.packetMine == null && !this.changedInstantMine && ((Boolean)this.doubleBreak.get()).booleanValue() || this.isInstantMineComplete())) {
                                this.startAutoMine(bestMine);
                            }
                        }
                    }
                } else {
                    if (!this.isInstantMineComplete() && this.instantMine.getGoal() == MiningGoal.MINING_ENEMY) {
                        this.abortMining(this.instantMine);
                        this.instantMineAnim.animation.setState(false);
                        this.instantMine = null;
                    }
                    if (this.packetMine != null && this.packetMine.getGoal() == MiningGoal.MINING_ENEMY) {
                        this.packetMineAnim.animation.setState(false);
                        if (this.packetSwapBack) {
                            Managers.INVENTORY.syncToClient();
                            this.packetSwapBack = false;
                        }
                        this.packetMine = null;
                        this.waitForPacketMine = false;
                    }
                }
            }
        }
    }

    @EventHandler
    public void onAttackBlock(AttackBlockEvent event) {
        if (this.mc.field_1724.method_7337() || this.mc.field_1724.method_7325()) {
            return;
        }
        event.cancel();
        if (event.state.method_26204().method_36555() == -1.0f || !this.canMine(event.state) || this.isMining(event.pos)) {
            return;
        }
        MineData data = new MineData(event.pos, event.direction, MiningGoal.MANUAL);
        if (this.instantMine != null && this.instantMine.getGoal() == MiningGoal.MINING_ENEMY || this.packetMine != null && this.packetMine.getGoal() == MiningGoal.MINING_ENEMY) {
            this.manualOverride = true;
        }
        if (!((Boolean)this.doubleBreak.get()).booleanValue()) {
            this.instantMine = data;
            this.startMining(this.instantMine);
            this.mc.field_1724.method_23667(class_1268.field_5808, false);
            return;
        }
        boolean updateChanged = false;
        if (!this.isInstantMineComplete() && !this.changedInstantMine) {
            if (this.packetMine == null) {
                this.packetMine = this.instantMine.copy();
                this.packetMineAnim = new MineAnimation(this.packetMine, new Animation(true, ((Integer)this.fadeTime.get()).intValue()));
            } else {
                updateChanged = true;
            }
        }
        this.instantMine = data;
        this.startMining(this.instantMine);
        this.mc.field_1724.method_23667(class_1268.field_5808, false);
        if (updateChanged) {
            this.changedInstantMine = true;
        }
    }

    @EventHandler
    public void onPacketSend(PacketEvent.Send event) {
        if (event.packet instanceof class_2868 && ((Boolean)this.switchReset.get()).booleanValue() && this.instantMine != null) {
            this.instantMine.setTotalBlockDamage(0.0f, 0.0f);
        }
    }

    @EventHandler
    public void onPacketReceive(PacketEvent.Receive event) {
        class_2626 packet;
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2626 && this.canMine((packet = (class_2626)class_25962).method_11308()) && this.antiCrawlOverride && packet.method_11309().equals((Object)this.getAntiCrawlPos(this.playerTarget))) {
            this.antiCrawlTicks = 10;
        }
    }

    public void startAutoMine(MineData data) {
        if (!this.canMine(data.getState()) || this.isMining(data.getPos())) {
            return;
        }
        if (!((Boolean)this.doubleBreak.get()).booleanValue()) {
            this.instantMine = data;
            this.autoMineQueue.offer(data);
            return;
        }
        if (this.changedInstantMine && !this.isInstantMineComplete() || this.waitForPacketMine) {
            return;
        }
        boolean updateChanged = false;
        if (!this.isInstantMineComplete() && !this.changedInstantMine) {
            if (this.packetMine == null) {
                this.packetMine = this.instantMine.copy();
                this.packetMineAnim = new MineAnimation(this.packetMine, new Animation(true, ((Integer)this.fadeTime.get()).intValue()));
            } else {
                updateChanged = true;
            }
        }
        this.instantMine = data;
        this.autoMineQueue.offer(data);
        if (updateChanged) {
            this.changedInstantMine = true;
        }
    }

    public MineData getInstantMine(List<class_2338> miningBlocks, boolean bedrockPhased) {
        PriorityQueue<MineData> validInstantMines = new PriorityQueue<MineData>();
        for (class_2338 blockPos : miningBlocks) {
            double dist;
            class_2680 state1 = this.mc.field_1687.method_8320(blockPos);
            if (!this.isAutoMineBlock(state1.method_26204()) || (dist = this.mc.field_1724.method_33571().method_1025(blockPos.method_46558())) > (double)MathUtil.squared(((Float)this.range.get()).floatValue())) continue;
            class_2680 state2 = this.mc.field_1687.method_8320(blockPos.method_10074());
            if (!bedrockPhased && !state2.method_27852(class_2246.field_10540) && !state2.method_27852(class_2246.field_9987)) continue;
            class_2350 direction = (Boolean)this.strictDirection.get() != false ? Managers.INTERACT.getInteractDirection(blockPos, false) : class_2350.field_11036;
            validInstantMines.add(new MineData(blockPos, direction));
        }
        if (validInstantMines.isEmpty()) {
            return null;
        }
        return (MineData)validInstantMines.peek();
    }

    public List<class_2338> getPhaseBlocks(class_1657 player, class_2338 playerPos, boolean targetBedrockPhased) {
        List<class_2338> phaseBlocks = GPositionUtils.getAllInBox(player.method_5829(), targetBedrockPhased && (Boolean)this.head.get() != false ? playerPos.method_10084() : playerPos);
        phaseBlocks.removeIf(p -> {
            class_2680 state = this.mc.field_1687.method_8320(p);
            if (!this.isAutoMineBlock(state.method_26204()) || !this.canMine(state) || this.isMining((class_2338)p)) {
                return true;
            }
            double dist = this.mc.field_1724.method_33571().method_1025(p.method_46558());
            if (dist > (double)MathUtil.squared(((Float)this.range.get()).floatValue())) {
                return true;
            }
            return (Boolean)this.avoidSelf.get() != false && this.intersectsPlayer((class_2338)p);
        });
        if (targetBedrockPhased && ((Boolean)this.aboveHead.get()).booleanValue()) {
            phaseBlocks.add(playerPos.method_10086(2));
        }
        return phaseBlocks;
    }

    public List<class_2338> getMiningBlocks(class_1657 player, class_2338 playerPos, boolean bedrockPhased) {
        List<class_2338> miningBlocks;
        List<class_2338> surroundingBlocks = ((GenyoSurroundV2)Modules.get().get(GenyoSurroundV2.class)).getSurroundNoDown(player, ((Float)this.range.get()).floatValue());
        if (bedrockPhased) {
            class_2680 belowFeet;
            ArrayList<class_2338> facePlaceBlocks = new ArrayList<class_2338>();
            if (((Boolean)this.head.get()).booleanValue()) {
                facePlaceBlocks.addAll(surroundingBlocks.stream().map(class_2338::method_10084).toList());
            }
            if (this.canMine(belowFeet = this.mc.field_1687.method_8320(playerPos.method_10074()))) {
                facePlaceBlocks.add(playerPos.method_10074());
            }
            miningBlocks = facePlaceBlocks;
        } else {
            miningBlocks = surroundingBlocks;
        }
        miningBlocks.removeIf(p -> (Boolean)this.avoidSelf.get() != false && this.intersectsPlayer((class_2338)p));
        return miningBlocks;
    }

    private class_2338 getAntiCrawlPos(class_1657 playerTarget) {
        boolean playerBelow;
        if (!this.mc.field_1724.method_24828()) {
            return null;
        }
        class_2338 crawlingPos = GEntityUtils.getRoundedBlockPos((class_1297)this.mc.field_1724);
        boolean bl = playerBelow = playerTarget != null && GEntityUtils.getRoundedBlockPos((class_1297)playerTarget).method_10264() < crawlingPos.method_10264();
        if (playerBelow) {
            class_2680 state = this.mc.field_1687.method_8320(crawlingPos.method_10074());
            if (this.isAutoMineBlock(state.method_26204()) && this.canMine(state)) {
                return crawlingPos.method_10074();
            }
        } else {
            class_2680 state = this.mc.field_1687.method_8320(crawlingPos.method_10084());
            if (this.isAutoMineBlock(state.method_26204()) && this.canMine(state)) {
                return crawlingPos.method_10084();
            }
        }
        return null;
    }

    private boolean checkDataY(MineData data, class_2338 targetPos, boolean bedrockPhased) {
        return data.getGoal() == MiningGoal.MINING_ENEMY && !bedrockPhased && data.getPos().method_10264() != targetPos.method_10264();
    }

    private boolean intersectsPlayer(class_2338 pos) {
        List<class_2338> playerBlocks = ((GenyoSurroundV2)Modules.get().get(GenyoSurroundV2.class)).getPlayerBlocks((class_1657)this.mc.field_1724);
        List<class_2338> surroundingBlocks = ((GenyoSurroundV2)Modules.get().get(GenyoSurroundV2.class)).getSurroundNoDown((class_1657)this.mc.field_1724);
        return playerBlocks.contains(pos) || surroundingBlocks.contains(pos);
    }

    @EventHandler
    public void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724.method_7337() || this.mc.field_1724.method_7325()) {
            return;
        }
        if (!((Boolean)this.render.get()).booleanValue()) {
            return;
        }
        if (this.instantMineAnim != null && this.instantMineAnim.animation().getFactor() > (double)0.01f) {
            this.renderMiningData(event.renderer, event.tickDelta, this.instantMineAnim, true);
        }
        if (((Boolean)this.doubleBreak.get()).booleanValue() && this.packetMineAnim != null && this.packetMineAnim.animation().getFactor() > (double)0.01f) {
            this.renderMiningData(event.renderer, event.tickDelta, this.packetMineAnim, false);
        }
    }

    public void renderMiningData(Renderer3D renderer, float tickDelta, MineAnimation mineAnimation, boolean instantMine) {
        Color lineColor;
        Color boxColor;
        MineData data = mineAnimation.data();
        Animation animation = mineAnimation.animation();
        int boxAlpha = (int)(40.0 * animation.getFactor());
        int lineAlpha = (int)(100.0 * animation.getFactor());
        if (((Boolean)this.smoothColor.get()).booleanValue()) {
            boxColor = !this.canMine(data.getState()) ? ((SettingColor)this.colorDone.get()).a(boxAlpha) : ColorUtil.interpolateColor(Math.min(data.getBlockDamage(), 1.0f), ((SettingColor)this.colorDone.get()).a(boxAlpha), ((SettingColor)this.mineColor.get()).a(boxAlpha));
            lineColor = !this.canMine(data.getState()) ? ((SettingColor)this.colorDone.get()).a(lineAlpha) : ColorUtil.interpolateColor(Math.min(data.getBlockDamage(), 1.0f), ((SettingColor)this.colorDone.get()).a(lineAlpha), ((SettingColor)this.mineColor.get()).a(lineAlpha));
        } else {
            boxColor = data.getBlockDamage() >= 0.95f || !this.canMine(data.getState()) ? ((SettingColor)this.colorDone.get()).a(boxAlpha) : ((SettingColor)this.mineColor.get()).a(boxAlpha);
            lineColor = data.getBlockDamage() >= 0.95f || !this.canMine(data.getState()) ? ((SettingColor)this.colorDone.get()).a(lineAlpha) : ((SettingColor)this.mineColor.get()).a(lineAlpha);
        }
        class_2338 mining = data.getPos();
        class_265 outlineShape = class_259.method_1077();
        if (!instantMine || data.getBlockDamage() < ((Float)this.speed.get()).floatValue()) {
            outlineShape = data.getState().method_26218((class_1922)this.mc.field_1687, mining);
            outlineShape = outlineShape.method_1110() ? class_259.method_1077() : outlineShape;
        }
        class_238 render1 = outlineShape.method_1107();
        class_243 center = render1.method_996(mining).method_1005();
        float total = instantMine ? ((Float)this.speed.get()).floatValue() : 1.0f;
        float scale = instantMine && data.getBlockDamage() >= ((Float)this.speed.get()).floatValue() || !this.canMine(data.getState()) ? 1.0f : class_3532.method_15363((float)((data.getBlockDamage() + (data.getBlockDamage() - data.getLastDamage()) * tickDelta) / total), (float)0.0f, (float)1.0f);
        double dx = (render1.field_1320 - render1.field_1323) / 2.0;
        double dy = (render1.field_1325 - render1.field_1322) / 2.0;
        double dz = (render1.field_1324 - render1.field_1321) / 2.0;
        class_238 scaled = new class_238(center, center).method_1009(dx * (double)scale, dy * (double)scale, dz * (double)scale);
        renderer.box(scaled, boxColor, lineColor, ShapeMode.Both, 0);
    }

    public void startMining(MineData data) {
        if (((Boolean)this.rotate.get()).booleanValue()) {
            float[] rotations = RotationUtil.getRotationsTo(this.mc.field_1724.method_33571(), data.getPos().method_46558());
            if (((Boolean)this.grim.get()).booleanValue()) {
                this.setRotationSilent(rotations[0], rotations[1]);
            } else {
                this.setRotation(rotations[0], rotations[1]);
            }
        }
        if (((Boolean)this.doubleBreak.get()).booleanValue()) {
            if (((Boolean)this.grimNew.get()).booleanValue()) {
                if (!((Boolean)this.anticheat.get()).booleanValue()) {
                    Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
                    Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
                    Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection()));
                } else {
                    Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
                }
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
            } else {
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
            }
        } else {
            Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
        }
        if (((Boolean)this.rotate.get()).booleanValue() && ((Boolean)this.grim.get()).booleanValue()) {
            Managers.ROTATION.setRotationSilentSync();
        }
        this.instantMineAnim = new MineAnimation(data, new Animation(true, ((Integer)this.fadeTime.get()).intValue()));
    }

    public void abortMining(MineData data) {
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection()));
    }

    public void stopMining(MineData data) {
        int slot;
        if (((Boolean)this.rotate.get()).booleanValue()) {
            float[] rotations = RotationUtil.getRotationsTo(this.mc.field_1724.method_33571(), data.getPos().method_46558());
            if (((Boolean)this.grim.get()).booleanValue()) {
                this.setRotationSilent(rotations[0], rotations[1]);
            } else {
                this.setRotation(rotations[0], rotations[1]);
            }
        }
        if ((slot = data.getBestSlot()) != -1) {
            this.swapTo(slot);
        }
        this.stopMiningInternal(data);
        if (slot != -1) {
            this.swapSync(slot);
        }
        if (((Boolean)this.rotate.get()).booleanValue() && ((Boolean)this.grim.get()).booleanValue()) {
            Managers.ROTATION.setRotationSilentSync();
        }
    }

    private void stopMiningInternal(MineData data) {
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection()));
    }

    public boolean isInstantMineComplete() {
        return this.instantMine == null || this.instantMine.getBlockDamage() >= ((Float)this.speed.get()).floatValue() && !this.canMine(this.instantMine.getState());
    }

    public class_2338 getMiningBlock() {
        double damage;
        if (this.instantMine != null && (damage = (double)(this.instantMine.getBlockDamage() / ((Float)this.speed.get()).floatValue())) > 0.75) {
            return this.instantMine.getPos();
        }
        return null;
    }

    private void swapTo(int slot) {
        switch (((Swap)((Object)this.swap.get())).ordinal()) {
            case 0: {
                Managers.INVENTORY.setClientSlot(slot);
                break;
            }
            case 1: {
                Managers.INVENTORY.setSlot(slot);
                break;
            }
            case 2: {
                Managers.INVENTORY.setSlotAlt(slot);
            }
        }
    }

    private void swapSync(int slot) {
        switch (((Swap)((Object)this.swap.get())).ordinal()) {
            case 1: {
                Managers.INVENTORY.syncToClient();
                break;
            }
            case 2: {
                Managers.INVENTORY.setSlotAlt(slot);
            }
        }
    }

    public boolean isSilentSwapping() {
        return this.packetSwapBack;
    }

    private boolean isMining(class_2338 blockPos) {
        return this.instantMine != null && this.instantMine.getPos().equals((Object)blockPos) || this.packetMine != null && this.packetMine.getPos().equals((Object)blockPos);
    }

    private boolean isAutoMineBlock(class_2248 block) {
        if (BlastResistantBlocks.isUnbreakable(block)) {
            return false;
        }
        return switch (((Selection)((Object)this.selection.get())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ((List)this.whitelist.get()).contains(block);
            case 1 -> {
                if (!((List)this.blacklist.get()).contains(block)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> true;
        };
    }

    public boolean canMine(class_2680 state) {
        return !state.method_26215() && state.method_26227().method_15769();
    }

    public static enum Selection {
        WHITELIST,
        BLACKLIST,
        ALL;

    }

    public static enum RemineMode {
        INSTANT,
        NORMAL,
        FAST;

    }

    public static enum Swap {
        NORMAL,
        SILENT,
        SILENT_ALT,
        OFF;

    }

    public record MineAnimation(MineData data, Animation animation) {
    }

    public static class MineData
    implements Comparable<MineData> {
        private static final class_310 mc = class_310.method_1551();
        private final class_2338 pos;
        private final class_2350 direction;
        private final MiningGoal goal;
        private int ticksMining;
        private float blockDamage;
        private float lastDamage;

        public MineData(class_2338 pos, class_2350 direction) {
            this.pos = pos;
            this.direction = direction;
            this.goal = MiningGoal.MINING_ENEMY;
        }

        public MineData(class_2338 pos, class_2350 direction, MiningGoal goal) {
            this.pos = pos;
            this.direction = direction;
            this.goal = goal;
        }

        private double getPriority() {
            double dist = MineData.mc.field_1724.method_33571().method_1025(this.pos.method_10074().method_46558());
            if (dist <= (double)((GenyoAutoCrystal)Modules.get().get(GenyoAutoCrystal.class)).getPlaceRange()) {
                return 10.0;
            }
            return 0.0;
        }

        @Override
        public int compareTo(@NotNull MineData o) {
            return Double.compare(this.getPriority(), o.getPriority());
        }

        public boolean equals(Object obj) {
            MineData d;
            return obj instanceof MineData && (d = (MineData)obj).getPos().equals((Object)this.pos);
        }

        public void resetMiningTicks() {
            this.ticksMining = 0;
        }

        public void markAttemptedMine() {
            ++this.ticksMining;
        }

        public void addBlockDamage(float blockDamage) {
            this.lastDamage = this.blockDamage;
            this.blockDamage += blockDamage;
        }

        public void setTotalBlockDamage(float blockDamage, float lastDamage) {
            this.blockDamage = blockDamage;
            this.lastDamage = lastDamage;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public class_2350 getDirection() {
            return this.direction;
        }

        public MiningGoal getGoal() {
            return this.goal;
        }

        public int getTicksMining() {
            return this.ticksMining;
        }

        public float getBlockDamage() {
            return this.blockDamage;
        }

        public float getLastDamage() {
            return this.lastDamage;
        }

        public static MineData empty() {
            return new MineData(class_2338.field_10980, class_2350.field_11036);
        }

        public MineData copy() {
            MineData data = new MineData(this.pos, this.direction, this.goal);
            data.setTotalBlockDamage(this.blockDamage, this.lastDamage);
            return data;
        }

        public class_2680 getState() {
            return MineData.mc.field_1687.method_8320(this.pos);
        }

        public int getBestSlot() {
            return ((GenyoAutoTool)Modules.get().get(GenyoAutoTool.class)).getBestToolNoFallback(this.getState());
        }
    }

    public static enum MiningGoal {
        MANUAL,
        MINING_ENEMY,
        PREVENT_CRAWL;

    }
}

