/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.world;

import com.genyo.GenyoAddon;
import com.genyo.events.AttackBlockEvent;
import com.genyo.managers.Managers;
import com.genyo.mixin.accessor.AccessorClientPlayerInteractionManager;
import com.genyo.render.animation.Animation;
import com.genyo.systems.modules.GenyoModule;
import com.genyo.systems.modules.world.GenyoAutoMine;
import com.genyo.systems.modules.world.GenyoAutoTool;
import com.genyo.systems.settings.FloatSetting;
import com.genyo.utils.collection.FirstOutQueue;
import com.genyo.utils.math.MathUtil;
import com.genyo.utils.player.EnchantmentUtil;
import com.genyo.utils.player.RotationUtil;
import com.genyo.utils.render.ColorUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_2868;
import net.minecraft.class_2879;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_8042;

public class GenyoSpeedmine
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgBreak;
    private final SettingGroup sgBehaviour;
    private final SettingGroup sgRender;
    private final Setting<SpeedmineMode> modeConfig;
    private final Setting<Boolean> multitaskConfig;
    private final Setting<Boolean> doubleBreakConfig;
    private final Setting<Float> rangeConfig;
    private final Setting<Float> speedConfig;
    private final Setting<Boolean> instantConfig;
    private final Setting<Swap> swapConfig;
    private final Setting<Boolean> rotateConfig;
    private final Setting<Boolean> switchResetConfig;
    private final Setting<Boolean> ironOnlyConfig;
    private final Setting<Boolean> miningAC;
    private final Setting<Boolean> grimConfig;
    private final Setting<Boolean> grimNewConfig;
    private final Setting<SettingColor> colorConfig;
    private final Setting<SettingColor> colorDoneConfig;
    private final Setting<Integer> fadeTimeConfig;
    private final Setting<Boolean> smoothColorConfig;
    private final Map<MiningData, Animation> fadeList;
    private FirstOutQueue<MiningData> miningQueue;
    private long lastBreak;

    public GenyoSpeedmine() {
        super(GenyoAddon.WORLD, "Genyo Speedmine", "fasz fasz fsaz fasz");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgBreak = this.settings.createGroup("Break");
        this.sgBehaviour = this.settings.createGroup("Behaviour");
        this.sgRender = this.settings.createGroup("Render");
        this.modeConfig = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Mode")).description("The mining mode for speedmine")).defaultValue((Object)SpeedmineMode.PACKET)).build());
        this.multitaskConfig = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Multitask")).description("Allows mining while using items")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET)).build());
        this.doubleBreakConfig = this.sgBreak.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Double Break")).description("Allows you to mine two blocks at once")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET)).onChanged(this::dbChanged)).build());
        this.rangeConfig = this.sgBreak.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Range"))).description("The range to mine blocks"))).min(0.1f).defaultValue(4.0f).max(6.0f).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET))).build());
        this.speedConfig = this.sgBreak.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Speed"))).description("The speed to mine blocks"))).min(0.1f).defaultValue(1.0f).max(1.0f).build());
        this.instantConfig = this.sgBehaviour.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Instant")).description("Instantly mines already broken blocks")).defaultValue((Object)false)).build());
        this.swapConfig = this.sgBehaviour.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Auto Swap")).description("Swaps to the best tool once the mining is complete")).defaultValue((Object)Swap.SILENT)).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET)).build());
        this.rotateConfig = this.sgBehaviour.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Rotate")).description("Rotates when mining the block")).defaultValue((Object)true)).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET)).build());
        this.switchResetConfig = this.sgBehaviour.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Switch Reset")).description("Resets mining after switching items")).defaultValue((Object)false)).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET)).build());
        this.ironOnlyConfig = this.sgBehaviour.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Iron Only")).description("Only uses iron pickaxes for mining")).defaultValue((Object)false)).build());
        this.miningAC = this.sgBehaviour.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Mining AntiCheat")).description("Idk it uses a module from th")).defaultValue((Object)false)).build());
        this.grimConfig = this.sgBehaviour.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Grim")).description("Uses grim block breaking speeds")).defaultValue((Object)false)).build());
        this.grimNewConfig = this.sgBehaviour.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Grim V3")).description("Uses new grim block breaking speeds")).defaultValue((Object)false)).visible(() -> this.grimConfig.get())).build());
        this.colorConfig = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Mine Color")).description("The mine render color")).defaultValue(Color.RED).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET)).build());
        this.colorDoneConfig = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Done Color")).description("The done render color")).defaultValue(Color.GREEN).visible(() -> this.modeConfig.get() == SpeedmineMode.PACKET)).build());
        this.fadeTimeConfig = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Fade Time")).description("Time to fade")).min(0).defaultValue((Object)250)).max(1000).build());
        this.smoothColorConfig = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Smooth Color")).description("Interpolates from start to done color")).defaultValue((Object)false)).build());
        this.fadeList = new HashMap<MiningData, Animation>();
        this.miningQueue = new FirstOutQueue(2);
    }

    public String getInfoString() {
        MiningData miningData;
        if (this.modeConfig.get() == SpeedmineMode.PACKET && (miningData = (MiningData)this.miningQueue.peek()) != null) {
            return String.format("%.1f", Float.valueOf(Math.min(miningData.getBlockDamage(), 1.0f)));
        }
        return super.getInfoString();
    }

    public void onDeactivate() {
        this.miningQueue.clear();
        this.fadeList.clear();
        Managers.INVENTORY.syncToClient();
    }

    public void onActivate() {
        this.miningQueue = (Boolean)this.doubleBreakConfig.get() != false ? new FirstOutQueue(2) : new FirstOutQueue(1);
    }

    @EventHandler
    public void onTickPre(TickEvent.Pre event) {
        if (this.mc.field_1724.method_7337() || this.mc.field_1724.method_7325()) {
            return;
        }
        if (this.modeConfig.get() == SpeedmineMode.DAMAGE) {
            AccessorClientPlayerInteractionManager interactionManager = (AccessorClientPlayerInteractionManager)this.mc.field_1761;
            if (interactionManager.hookGetCurrentBreakingProgress() >= ((Float)this.speedConfig.get()).floatValue()) {
                interactionManager.hookSetCurrentBreakingProgress(1.0f);
            }
            return;
        }
        if (Modules.get().isActive(GenyoAutoMine.class)) {
            return;
        }
        if (this.miningQueue.isEmpty()) {
            return;
        }
        Iterator interactionManager = this.miningQueue.iterator();
        while (interactionManager.hasNext()) {
            MiningData data = (MiningData)interactionManager.next();
            if (data.getState().method_26215()) {
                data.resetBreakTime();
            }
            if (this.isDataPacketMine(data) && (data.getState().method_26215() || data.hasAttemptedBreak() && data.passedAttemptedBreakTime(500L))) {
                Managers.INVENTORY.syncToClient();
                this.miningQueue.remove(data);
                continue;
            }
            float damageDelta = this.calcBlockBreakingDelta(data.getState(), (class_1922)this.mc.field_1687, data.getPos());
            data.damage(damageDelta);
            if (!this.isDataPacketMine(data) || !(data.getBlockDamage() >= 1.0f) || data.getSlot() == -1) continue;
            if (this.mc.field_1724.method_6115() && !((Boolean)this.multitaskConfig.get()).booleanValue()) {
                return;
            }
            if (data.getSlot() != Managers.INVENTORY.getServerSlot()) {
                Managers.INVENTORY.setSlot(data.getSlot());
            }
            if (data.hasAttemptedBreak()) continue;
            data.setAttemptedBreak(true);
        }
        MiningData miningData2 = this.miningQueue.getFirst();
        double distance = this.mc.field_1724.method_33571().method_1025(miningData2.getPos().method_46558());
        if (distance > (double)MathUtil.squared(((Float)this.rangeConfig.get()).floatValue())) {
            this.miningQueue.remove(miningData2);
            return;
        }
        if (miningData2.getState().method_26215()) {
            return;
        }
        if (miningData2.getBlockDamage() >= ((Float)this.speedConfig.get()).floatValue() && miningData2.hasAttemptedBreak() && miningData2.passedAttemptedBreakTime(500L)) {
            this.abortMining(miningData2);
            this.miningQueue.remove(miningData2);
        }
        if (miningData2.getBlockDamage() >= ((Float)this.speedConfig.get()).floatValue()) {
            if (this.mc.field_1724.method_6115() && !((Boolean)this.multitaskConfig.get()).booleanValue()) {
                return;
            }
            this.stopMining(miningData2);
            if (!((Boolean)this.instantConfig.get()).booleanValue()) {
                this.miningQueue.remove(miningData2);
            }
            if (!miningData2.hasAttemptedBreak()) {
                miningData2.setAttemptedBreak(true);
            }
        }
    }

    @EventHandler
    public void onAttackBlock(AttackBlockEvent event) {
        if (this.mc.field_1724.method_7337() || this.mc.field_1724.method_7325() || this.modeConfig.get() != SpeedmineMode.PACKET) {
            return;
        }
        if (Modules.get().isActive(GenyoAutoMine.class)) {
            return;
        }
        event.cancel();
        if (event.state.method_26204().method_36555() == -1.0f || event.state.method_26215()) {
            return;
        }
        this.startManualMine(event.pos, event.direction);
        this.mc.field_1724.method_6104(class_1268.field_5808);
    }

    @EventHandler
    public void onPacketSend(PacketEvent.Send event) {
        class_2846 packet;
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2846 && (packet = (class_2846)class_25962).method_12363() == class_2846.class_2847.field_12973 && this.modeConfig.get() == SpeedmineMode.DAMAGE && ((Boolean)this.grimConfig.get()).booleanValue()) {
            Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, packet.method_12362().method_10086(500), packet.method_12360()));
        }
        if (event.packet instanceof class_2868 && ((Boolean)this.switchResetConfig.get()).booleanValue() && this.modeConfig.get() == SpeedmineMode.PACKET) {
            Iterator iterator = this.miningQueue.iterator();
            while (iterator.hasNext()) {
                MiningData data = (MiningData)iterator.next();
                data.resetDamage();
            }
        }
    }

    @EventHandler
    public void onPacketReceive(PacketEvent.Receive event) {
        if (this.mc.field_1724 == null || this.modeConfig.get() != SpeedmineMode.PACKET) {
            return;
        }
        if (Modules.get().isActive(GenyoAutoMine.class)) {
            return;
        }
        Object object = event.packet;
        if (object instanceof class_2626) {
            class_2626 packet = (class_2626)object;
            this.handleBlockUpdatePacket(packet);
        } else {
            object = event.packet;
            if (object instanceof class_8042) {
                class_8042 packet = (class_8042)object;
                for (class_2596 packet1 : packet.method_48324()) {
                    if (!(packet1 instanceof class_2626)) continue;
                    class_2626 packet2 = (class_2626)packet1;
                    this.handleBlockUpdatePacket(packet2);
                }
            }
        }
    }

    private void handleBlockUpdatePacket(class_2626 packet) {
        if (!packet.method_11308().method_26215()) {
            return;
        }
        Iterator iterator = this.miningQueue.iterator();
        while (iterator.hasNext()) {
            MiningData data = (MiningData)iterator.next();
            if (!data.hasAttemptedBreak() || !data.getPos().equals((Object)packet.method_11309())) continue;
            data.setAttemptedBreak(false);
        }
    }

    private void dbChanged(boolean value) {
        this.miningQueue = value ? new FirstOutQueue(2) : new FirstOutQueue(1);
    }

    @EventHandler
    public void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724.method_7337() || this.modeConfig.get() != SpeedmineMode.PACKET) {
            return;
        }
        if (Modules.get().isActive(GenyoAutoMine.class)) {
            return;
        }
        for (Map.Entry<MiningData, Animation> set : this.fadeList.entrySet()) {
            Color lineColor;
            Color boxColor;
            MiningData data = set.getKey();
            set.getValue().setState(false);
            int boxAlpha = (int)(40.0 * set.getValue().getFactor());
            int lineAlpha = (int)(100.0 * set.getValue().getFactor());
            if (((Boolean)this.smoothColorConfig.get()).booleanValue()) {
                boxColor = data.getState().method_26215() ? ((SettingColor)this.colorDoneConfig.get()).a(boxAlpha) : ColorUtil.interpolateColor(Math.min(data.getBlockDamage(), 1.0f), ((SettingColor)this.colorDoneConfig.get()).a(boxAlpha), ((SettingColor)this.colorConfig.get()).a(boxAlpha));
                lineColor = data.getState().method_26215() ? ((SettingColor)this.colorDoneConfig.get()).a(lineAlpha) : ColorUtil.interpolateColor(Math.min(data.getBlockDamage(), 1.0f), ((SettingColor)this.colorDoneConfig.get()).a(lineAlpha), ((SettingColor)this.colorConfig.get()).a(lineAlpha));
            } else {
                boxColor = data.getBlockDamage() >= 0.95f || data.getState().method_26215() ? ((SettingColor)this.colorDoneConfig.get()).a(boxAlpha) : ((SettingColor)this.colorConfig.get()).a(boxAlpha);
                lineColor = data.getBlockDamage() >= 0.95f || data.getState().method_26215() ? ((SettingColor)this.colorDoneConfig.get()).a(lineAlpha) : ((SettingColor)this.colorConfig.get()).a(lineAlpha);
            }
            class_2338 mining = data.getPos();
            class_265 outlineShape = data.getState().method_26218((class_1922)this.mc.field_1687, mining);
            outlineShape = outlineShape.method_1110() ? class_259.method_1077() : outlineShape;
            class_238 render1 = outlineShape.method_1107();
            class_238 render = new class_238((double)mining.method_10263() + render1.field_1323, (double)mining.method_10264() + render1.field_1322, (double)mining.method_10260() + render1.field_1321, (double)mining.method_10263() + render1.field_1320, (double)mining.method_10264() + render1.field_1325, (double)mining.method_10260() + render1.field_1324);
            class_243 center = render.method_1005();
            float total = this.isDataPacketMine(data) ? 1.0f : ((Float)this.speedConfig.get()).floatValue();
            float scale = data.getState().method_26215() ? 1.0f : class_3532.method_15363((float)((data.getBlockDamage() + (data.getBlockDamage() - data.getLastDamage()) * event.tickDelta) / total), (float)0.0f, (float)1.0f);
            double dx = (render1.field_1320 - render1.field_1323) / 2.0;
            double dy = (render1.field_1325 - render1.field_1322) / 2.0;
            double dz = (render1.field_1324 - render1.field_1321) / 2.0;
            class_238 scaled = new class_238(center, center).method_1009(dx * (double)scale, dy * (double)scale, dz * (double)scale);
            event.renderer.box(scaled, boxColor, lineColor, ShapeMode.Both, 0);
        }
        Iterator iterator = this.miningQueue.iterator();
        while (iterator.hasNext()) {
            MiningData data = (MiningData)iterator.next();
            if (data.getState().method_26215()) continue;
            Animation animation = new Animation(true, ((Integer)this.fadeTimeConfig.get()).intValue());
            this.fadeList.put(data, animation);
        }
        this.fadeList.entrySet().removeIf(e -> ((Animation)e.getValue()).getFactor() == 0.0);
    }

    private void startManualMine(class_2338 pos, class_2350 direction) {
        this.clickMine(new MiningData(pos, direction));
    }

    public void clickMine(MiningData miningData) {
        int queueSize = this.miningQueue.size();
        if (queueSize <= 2) {
            this.queueMiningData(miningData);
        }
    }

    private void queueMiningData(MiningData data) {
        if (data.getState().method_26215()) {
            return;
        }
        if (this.startMining(data)) {
            if (this.miningQueue.stream().anyMatch(p1 -> data.getPos().equals((Object)p1.getPos()))) {
                return;
            }
            this.miningQueue.addFirst(data);
        }
    }

    private boolean startMining(MiningData data) {
        if (data.isStarted()) {
            return false;
        }
        data.setStarted();
        if (((Boolean)this.grimNewConfig.get()).booleanValue()) {
            if (!((Boolean)this.miningAC.get()).booleanValue()) {
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection()));
            } else {
                Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
            }
            Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
            Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
            Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
            Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
            return true;
        }
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12968, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2879(class_1268.field_5808));
        return true;
    }

    private void abortMining(MiningData data) {
        if (!data.isStarted() || data.getState().method_26215()) {
            return;
        }
        Managers.NETWORK.sendSequencedPacket(id -> new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection(), id));
        Managers.INVENTORY.syncToClient();
    }

    private void stopMining(MiningData data) {
        int slot;
        boolean canSwap;
        if (!data.isStarted() || data.getState().method_26215()) {
            return;
        }
        if (((Boolean)this.rotateConfig.get()).booleanValue()) {
            float[] rotations = RotationUtil.getRotationsTo(this.mc.field_1724.method_33571(), data.getPos().method_46558());
            if (((Boolean)this.grimConfig.get()).booleanValue()) {
                this.setRotationSilent(rotations[0], rotations[1]);
            } else {
                this.setRotation(rotations[0], rotations[1]);
            }
        }
        boolean bl = canSwap = (slot = data.getSlot()) != -1 && slot != Managers.INVENTORY.getServerSlot();
        if (canSwap) {
            this.swapTo(slot);
        }
        this.stopMiningInternal(data);
        this.lastBreak = System.currentTimeMillis();
        if (canSwap) {
            this.swapSync(slot);
        }
        if (((Boolean)this.rotateConfig.get()).booleanValue()) {
            Managers.ROTATION.setRotationSilentSync();
        }
    }

    private void swapTo(int slot) {
        switch (((Swap)((Object)this.swapConfig.get())).ordinal()) {
            case 0: {
                Managers.INVENTORY.setClientSlot(slot);
                break;
            }
            case 1: {
                Managers.INVENTORY.setSlot(slot);
                break;
            }
            case 2: {
                Managers.INVENTORY.setSlotAlt(slot);
            }
        }
    }

    private void swapSync(int slot) {
        switch (((Swap)((Object)this.swapConfig.get())).ordinal()) {
            case 1: {
                Managers.INVENTORY.syncToClient();
                break;
            }
            case 2: {
                Managers.INVENTORY.setSlotAlt(slot);
            }
        }
    }

    private void stopMiningInternal(MiningData data) {
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12973, data.getPos(), data.getDirection()));
        Managers.NETWORK.sendPacket((class_2596<?>)new class_2846(class_2846.class_2847.field_12971, data.getPos(), data.getDirection()));
    }

    public boolean isBlockDelayGrim() {
        return System.currentTimeMillis() - this.lastBreak <= 280L && (Boolean)this.grimConfig.get() != false;
    }

    private boolean isDataPacketMine(MiningData data) {
        return this.miningQueue.size() == 2 && data == this.miningQueue.getLast();
    }

    public float calcBlockBreakingDelta(class_2680 state, class_1922 world, class_2338 pos) {
        if (this.swapConfig.get() == Swap.OFF) {
            return state.method_26165((class_1657)this.mc.field_1724, (class_1922)this.mc.field_1687, pos);
        }
        float f = state.method_26214(world, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = this.canHarvest(state) ? 30 : 100;
        return this.getBlockBreakingSpeed(state) / f / (float)i;
    }

    private float getBlockBreakingSpeed(class_2680 block) {
        class_1799 stack;
        int i;
        int tool = ((GenyoAutoTool)Modules.get().get(GenyoAutoTool.class)).getBestTool(block);
        float f = this.mc.field_1724.method_31548().method_5438(tool).method_7924(block);
        if (f > 1.0f && (i = EnchantmentUtil.getLevel(stack = this.mc.field_1724.method_31548().method_5438(tool), (class_5321<class_1887>)class_1893.field_9131)) > 0 && !stack.method_7960()) {
            f += (float)(i * i + 1);
        }
        if (class_1292.method_5576((class_1309)this.mc.field_1724)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)this.mc.field_1724) + 1) * 0.2f;
        }
        if (this.mc.field_1724.method_6059(class_1294.field_5901)) {
            float g = switch (this.mc.field_1724.method_6112(class_1294.field_5901).method_5578()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= g;
        }
        if (!this.mc.field_1724.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }

    private boolean canHarvest(class_2680 state) {
        if (state.method_29291()) {
            int tool = ((GenyoAutoTool)Modules.get().get(GenyoAutoTool.class)).getBestTool(state);
            return this.mc.field_1724.method_31548().method_5438(tool).method_7951(state);
        }
        return true;
    }

    public boolean isMining() {
        return !this.miningQueue.isEmpty();
    }

    public static enum SpeedmineMode {
        PACKET,
        DAMAGE;

    }

    public static enum Swap {
        NORMAL,
        SILENT,
        SILENT_ALT,
        OFF;

    }

    public static class MiningData {
        private static final class_310 mc = class_310.method_1551();
        private boolean attemptedBreak;
        private long breakTime;
        private final class_2338 pos;
        private final class_2350 direction;
        private float lastDamage;
        private float blockDamage;
        private boolean started;

        public MiningData(class_2338 pos, class_2350 direction) {
            this.pos = pos;
            this.direction = direction;
        }

        public void setAttemptedBreak(boolean attemptedBreak) {
            this.attemptedBreak = attemptedBreak;
            if (attemptedBreak) {
                this.resetBreakTime();
            }
        }

        public void resetBreakTime() {
            this.breakTime = System.currentTimeMillis();
        }

        public boolean hasAttemptedBreak() {
            return this.attemptedBreak;
        }

        public boolean passedAttemptedBreakTime(long time) {
            return System.currentTimeMillis() - this.breakTime >= time;
        }

        public float damage(float dmg) {
            this.lastDamage = this.blockDamage;
            this.blockDamage += dmg;
            return this.blockDamage;
        }

        public void setDamage(float blockDamage) {
            this.blockDamage = blockDamage;
        }

        public void resetDamage() {
            this.started = false;
            this.blockDamage = 0.0f;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public class_2350 getDirection() {
            return this.direction;
        }

        public int getSlot() {
            return ((GenyoAutoTool)Modules.get().get(GenyoAutoTool.class)).getBestToolNoFallback(this.getState());
        }

        public class_2680 getState() {
            return MiningData.mc.field_1687.method_8320(this.pos);
        }

        public float getBlockDamage() {
            return this.blockDamage;
        }

        public float getLastDamage() {
            return this.lastDamage;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void setStarted() {
            this.started = true;
        }
    }

    public static enum Selection {
        WHITELIST,
        BLACKLIST,
        ALL;

    }
}

