/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.world;

import com.genyo.GenyoAddon;
import com.genyo.systems.modules.GenyoModule;
import com.genyo.utils.math.GPositionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class GenyoSurround
extends GenyoModule {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<Boolean> disableOnJump;
    private final Setting<Integer> placeDelay;
    private final Setting<Integer> blocksPerTick;
    private final Setting<Boolean> renderEsp;
    private final Setting<SettingColor> lineColor;
    private final Setting<SettingColor> sideColor;
    private final Setting<Integer> espDisplayTime;
    private final Setting<Integer> espFadeTime;
    private int delayTicks;
    private List<class_2338> targetPositions;
    private final Map<class_2338, Long> espBlocks;

    public GenyoSurround() {
        super(GenyoAddon.WORLD, "genyo-surround", "haaaaaaaaaaaaaa");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.disableOnJump = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-on-jump")).description("auto disable on jump waoooo")).defaultValue((Object)true)).build());
        this.placeDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("place-delay")).description("tick delay between placements")).defaultValue((Object)1)).sliderRange(0, 20).build());
        this.blocksPerTick = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("blocks-per-tick")).description("how many blocks to place per tick")).defaultValue((Object)1)).sliderRange(1, 4).build());
        this.renderEsp = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-box")).description("render a box around the placed blocks")).defaultValue((Object)true)).build());
        this.lineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("waooooooooooooo")).visible(() -> this.renderEsp.get())).defaultValue(new Color(255, 0, 0, 150)).build());
        this.sideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("ewfkjmhewhfhewfjhewkjfhewfewhfjkewhfkew")).visible(() -> this.renderEsp.get())).defaultValue(new Color(255, 0, 0, 50)).build());
        this.espDisplayTime = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("esp-display-time")).description("render delay (in ticks) after placement")).defaultValue((Object)40)).visible(() -> this.renderEsp.get())).sliderRange(0, 200).build());
        this.espFadeTime = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("esp-fade-time")).description("esp fade time in ticks")).defaultValue((Object)20)).sliderRange(0, ((Integer)this.espDisplayTime.get()).intValue()).visible(() -> this.renderEsp.get())).build());
        this.delayTicks = 0;
        this.targetPositions = new ArrayList<class_2338>();
        this.espBlocks = new ConcurrentHashMap<class_2338, Long>();
    }

    public void onActivate() {
        super.onActivate();
        this.delayTicks = 0;
        this.espBlocks.clear();
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            class_2338 playerPos = this.mc.field_1724.method_24515();
            List<class_2338> initialTargetPositions = Arrays.asList(playerPos.method_10095(), playerPos.method_10072(), playerPos.method_10078(), playerPos.method_10067());
            for (class_2338 pos : initialTargetPositions) {
                if (this.mc.field_1687.method_8320(pos).method_26204() != class_2246.field_10540) continue;
                this.espBlocks.put(pos, System.currentTimeMillis() + (long)((Integer)this.espDisplayTime.get()).intValue() * 50L);
            }
        }
    }

    public void onDeactivate() {
        super.onDeactivate();
        this.espBlocks.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null && this.mc.field_1687 == null) {
            return;
        }
        if (this.mc.field_1761 == null) {
            return;
        }
        class_2338 playerPos = this.mc.field_1724.method_24515();
        this.targetPositions = Arrays.asList(playerPos.method_10095(), playerPos.method_10072(), playerPos.method_10078(), playerPos.method_10067());
        for (class_2338 pos : this.targetPositions) {
            if (this.mc.field_1687.method_8320(pos).method_26204() == class_2246.field_10540) {
                this.espBlocks.put(pos, System.currentTimeMillis() + (long)((Integer)this.espDisplayTime.get()).intValue() * 50L);
                continue;
            }
            this.espBlocks.remove(pos);
        }
        ++this.delayTicks;
        if (this.delayTicks >= (Integer)this.placeDelay.get()) {
            this.delayTicks = 0;
            if (((Boolean)this.disableOnJump.get()).booleanValue() && this.mc.field_1690.field_1903.method_1434() && this.mc.field_1724.method_24828()) {
                this.sendInfo("Player jumped, disabling.");
                this.toggle();
            } else {
                FindItemResult obsidian = InvUtils.findInHotbar((class_1792[])new class_1792[]{class_1802.field_8281});
                if (!obsidian.found()) {
                    this.sendError("Obsidian not found in hotbar! Disabling.");
                    this.toggle();
                } else {
                    int placedCount = 0;
                    for (class_2338 placePos : this.targetPositions) {
                        if (placedCount >= (Integer)this.blocksPerTick.get()) break;
                        if (!this.canPlaceAt(placePos) || !BlockUtils.place((class_2338)placePos, (FindItemResult)obsidian, (boolean)true, (int)0, (boolean)true)) continue;
                        ++placedCount;
                        this.espBlocks.put(placePos, System.currentTimeMillis() + (long)((Integer)this.espDisplayTime.get()).intValue() * 50L);
                    }
                }
            }
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724 == null && this.mc.field_1687 == null) {
            return;
        }
        if (!((Boolean)this.renderEsp.get()).booleanValue()) {
            return;
        }
        ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
        for (Map.Entry<class_2338, Long> entry : this.espBlocks.entrySet()) {
            long currentTime;
            class_2338 pos = entry.getKey();
            long expirationTime = entry.getValue();
            long timeLeftMs = expirationTime - (currentTime = System.currentTimeMillis());
            if (timeLeftMs <= 0L) {
                toRemove.add(pos);
                continue;
            }
            int originalLineAlpha = ((SettingColor)this.lineColor.get()).a;
            int originalSideAlpha = ((SettingColor)this.sideColor.get()).a;
            double fadeDurationMs = (long)((Integer)this.espFadeTime.get()).intValue() * 50L;
            double displayDurationMs = (long)((Integer)this.espDisplayTime.get()).intValue() * 50L;
            double progress = 1.0;
            if ((double)timeLeftMs <= fadeDurationMs) {
                progress = (double)timeLeftMs / fadeDurationMs;
            }
            progress = Math.max(0.0, Math.min(1.0, progress));
            Color currentLineColor = ((SettingColor)this.lineColor.get()).copy();
            Color currentSideColor = ((SettingColor)this.sideColor.get()).copy();
            currentLineColor.a = (int)((double)originalLineAlpha * progress);
            currentSideColor.a = (int)((double)originalSideAlpha * progress);
            event.renderer.box(pos, currentSideColor, currentLineColor, ShapeMode.Sides, 1);
            event.renderer.box(pos, currentSideColor, currentLineColor, ShapeMode.Lines, 1);
        }
        for (class_2338 pos : toRemove) {
            this.espBlocks.remove(pos);
        }
    }

    public List<class_2338> getSurroundNoDown(class_1657 player, float range) {
        ArrayList<class_2338> surroundBlocks = new ArrayList<class_2338>();
        List<class_2338> playerBlocks = this.getPlayerBlocks(player);
        for (class_2338 pos : playerBlocks) {
            if (range > 0.0f && this.mc.field_1724.method_33571().method_1025(pos.method_46558()) > (double)(range * range)) continue;
            for (class_2350 dir : class_2350.values()) {
                class_2338 pos1;
                if (!dir.method_10166().method_10179() || surroundBlocks.contains(pos1 = pos.method_10093(dir)) || playerBlocks.contains(pos1)) continue;
                surroundBlocks.add(pos1);
            }
        }
        return surroundBlocks;
    }

    public List<class_2338> getSurroundNoDown(class_1657 player) {
        return this.getSurroundNoDown(player, 0.0f);
    }

    public List<class_2338> getPlayerBlocks(class_1657 entity) {
        class_2338 playerPos = GPositionUtils.getRoundedBlockPos(entity.method_23317(), entity.method_23318(), entity.method_23321());
        ArrayList<class_2338> playerBlocks = new ArrayList<class_2338>();
        playerBlocks.add(playerPos);
        return playerBlocks;
    }

    private boolean canPlaceAt(class_2338 pos) {
        return this.mc.field_1687.method_8320(pos).method_26204() == class_2246.field_10124;
    }
}

